/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.render.T3Display;
import org.jpedal.render.T3Renderer;
import org.jpedal.utils.LogWriter;

public class T3Glyph
implements PdfGlyph {
    private boolean lockColours;
    T3Renderer glyphDisplay;
    private int maxWidth;
    private int maxHeight;
    float glyphScale = 1.0f;
    private int glyphNumber = -1;

    public T3Glyph(T3Renderer t3Renderer, int n, int n2, boolean bl) {
        this.glyphDisplay = t3Renderer;
        this.maxWidth = n;
        this.maxHeight = n2;
        this.lockColours = bl;
    }

    public void setScaling(float f) {
        this.glyphScale = f;
    }

    @Override
    public Area getShape() {
        return null;
    }

    @Override
    public void render(int n, Graphics2D graphics2D, float f, boolean bl) {
        this.glyphDisplay.setScalingValues(0.0, 0.0, f);
        float f2 = this.glyphScale;
        if (bl) {
            this.glyphScale = f * this.glyphScale;
        }
        AffineTransform affineTransform = null;
        if (this.glyphScale != 1.0f) {
            affineTransform = graphics2D.getTransform();
            graphics2D.scale(this.glyphScale, this.glyphScale);
        }
        this.glyphDisplay.setG2(graphics2D);
        this.glyphDisplay.paint(null, null, null);
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
        this.glyphScale = f2;
    }

    @Override
    public float getmaxWidth() {
        if (this.maxWidth == 0 && this.glyphScale <= 1.0f) {
            return 1.0f / this.glyphScale;
        }
        return this.maxWidth;
    }

    @Override
    public void setT3Colors(PdfPaint pdfPaint, PdfPaint pdfPaint2, boolean bl) {
        this.glyphDisplay.lockColors(pdfPaint, pdfPaint2, bl);
    }

    @Override
    public boolean ignoreColors() {
        return this.lockColours;
    }

    @Override
    public int getGlyphNumber() {
        return this.glyphNumber;
    }

    @Override
    public void setGlyphNumber(int n) {
        this.glyphNumber = n;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        byte[] byArray = this.glyphDisplay.serializeToByteArray(null);
        objectOutput.writeObject(byArray);
        objectOutput.writeInt(this.maxWidth);
        objectOutput.writeInt(this.maxHeight);
        objectOutput.writeBoolean(this.lockColours);
    }

    public T3Glyph(ObjectInput objectInput) {
        try {
            byte[] byArray = (byte[])objectInput.readObject();
            this.glyphDisplay = new T3Display(byArray, null);
            this.maxWidth = objectInput.readInt();
            this.maxHeight = objectInput.readInt();
            this.lockColours = objectInput.readBoolean();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
    }

    @Override
    public void setWidth(float f) {
    }

    @Override
    public int getFontBB(int n) {
        return 0;
    }

    @Override
    public void setStrokedOnly(boolean bl) {
    }

    @Override
    public boolean containsBrokenData() {
        return false;
    }

    @Override
    public Object getPath() {
        throw new UnsupportedOperationException("getPath Not supported yet.");
    }
}

