/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    protected int[][] glyphIndexToChar;
    private boolean remapType4;
    private boolean hasFormatZero;
    private int[] glyphToIndex;
    private boolean hasSix;
    private boolean hasFormat4;
    private boolean hasFormat6;
    private int lastFormat4Found = -1;
    private int firstCode = -1;
    private int entryCount = -1;
    private int segCount;
    private int fontMapping;
    protected int[] endCode;
    protected int[] startCode;
    protected int[] idDelta;
    protected int[] idRangeOffset;
    protected int[] glyphIdArray;
    private int[] f6glyphIdArray;
    private int[] offset;
    int nGroups;
    private int[] startCharCode;
    private int[] endCharCode;
    private int[] startGlyphCode;
    protected int[] CMAPformats;
    protected int[] CMAPlength;
    protected int[] CMAPlang;
    protected int[] CMAPsegCount;
    protected int[] CMAPsearchRange;
    protected int[] CMAPentrySelector;
    protected int[] CMAPrangeShift;
    protected int[] CMAPreserved;
    protected int[] platformID;
    private static final Map exceptions = new HashMap();
    private int formatToUse;
    protected int id;
    protected int numberSubtables;
    protected int[] CMAPsubtables;
    protected int[] platformSpecificID;
    private int fontEncoding;

    public CMAP(FontFile2 fontFile2, int n) {
        if (n == 0) {
            LogWriter.writeLog("No CMAP table found");
        } else {
            int n2;
            this.id = fontFile2.getNextUint16();
            this.numberSubtables = fontFile2.getNextUint16();
            this.CMAPsubtables = new int[this.numberSubtables];
            this.platformID = new int[this.numberSubtables];
            this.platformSpecificID = new int[this.numberSubtables];
            this.CMAPformats = new int[this.numberSubtables];
            this.CMAPsearchRange = new int[this.numberSubtables];
            this.CMAPentrySelector = new int[this.numberSubtables];
            this.CMAPrangeShift = new int[this.numberSubtables];
            this.CMAPreserved = new int[this.numberSubtables];
            this.CMAPsegCount = new int[this.numberSubtables];
            this.CMAPlength = new int[this.numberSubtables];
            this.CMAPlang = new int[this.numberSubtables];
            this.glyphIndexToChar = new int[this.numberSubtables][256];
            this.glyphToIndex = new int[256];
            for (n2 = 0; n2 < this.numberSubtables; ++n2) {
                this.platformID[n2] = fontFile2.getNextUint16();
                this.platformSpecificID[n2] = fontFile2.getNextUint16();
                this.CMAPsubtables[n2] = fontFile2.getNextUint32();
            }
            for (n2 = 0; n2 < this.numberSubtables; ++n2) {
                fontFile2.selectTable(2);
                fontFile2.skip(this.CMAPsubtables[n2]);
                this.CMAPformats[n2] = fontFile2.getNextUint16();
                this.CMAPlength[n2] = fontFile2.getNextUint16();
                this.CMAPlang[n2] = fontFile2.getNextUint16();
                if (this.CMAPformats[n2] == 6) {
                    this.hasSix = true;
                }
                if (this.CMAPformats[n2] == 0 && this.CMAPlength[n2] == 262) {
                    this.readFormatZeroTable(fontFile2, n2);
                    continue;
                }
                if (this.CMAPformats[n2] == 4) {
                    this.readFormat4Table(n2, fontFile2);
                    continue;
                }
                if (this.CMAPformats[n2] == 6) {
                    this.readFormat6Table(fontFile2);
                    continue;
                }
                if (this.CMAPformats[n2] == 12) {
                    this.readFormat12Table(fontFile2);
                    continue;
                }
                this.CMAPformats[n2] = -1;
            }
        }
    }

    private void readFormat4Table(int n, FontFile2 fontFile2) {
        int n2;
        int n3;
        this.CMAPsegCount[n] = fontFile2.getNextUint16();
        this.segCount = this.CMAPsegCount[n] / 2;
        this.CMAPsearchRange[n] = fontFile2.getNextUint16();
        this.CMAPentrySelector[n] = fontFile2.getNextUint16();
        this.CMAPrangeShift[n] = fontFile2.getNextUint16();
        if (this.hasFormat4) {
            if (this.CMAPlength[this.lastFormat4Found] > this.CMAPlength[n]) {
                this.CMAPlength[n] = this.CMAPlength[this.lastFormat4Found];
                this.CMAPsegCount[n] = this.CMAPsegCount[this.lastFormat4Found];
                this.CMAPsearchRange[n] = this.CMAPsearchRange[this.lastFormat4Found];
                this.CMAPentrySelector[n] = this.CMAPentrySelector[this.lastFormat4Found];
                this.CMAPrangeShift[n] = this.CMAPrangeShift[this.lastFormat4Found];
                return;
            }
            if (this.CMAPlength[this.lastFormat4Found] < this.CMAPlength[n]) {
                this.CMAPlength[this.lastFormat4Found] = this.CMAPlength[n];
                this.CMAPsegCount[this.lastFormat4Found] = this.CMAPsegCount[n];
                this.CMAPsearchRange[this.lastFormat4Found] = this.CMAPsearchRange[n];
                this.CMAPentrySelector[this.lastFormat4Found] = this.CMAPentrySelector[n];
                this.CMAPrangeShift[this.lastFormat4Found] = this.CMAPrangeShift[n];
            }
        }
        this.lastFormat4Found = n;
        this.hasFormat4 = true;
        this.endCode = new int[this.segCount];
        for (n3 = 0; n3 < this.segCount; ++n3) {
            this.endCode[n3] = fontFile2.getNextUint16();
        }
        this.CMAPreserved[n] = fontFile2.getNextUint16();
        this.startCode = new int[this.segCount];
        for (n3 = 0; n3 < this.segCount; ++n3) {
            this.startCode[n3] = fontFile2.getNextUint16();
        }
        this.idDelta = new int[this.segCount];
        for (n3 = 0; n3 < this.segCount; ++n3) {
            this.idDelta[n3] = fontFile2.getNextUint16();
        }
        this.idRangeOffset = new int[this.segCount];
        for (n3 = 0; n3 < this.segCount; ++n3) {
            this.idRangeOffset[n3] = fontFile2.getNextUint16();
        }
        this.offset = new int[this.segCount];
        int n4 = 0;
        for (n2 = 0; n2 < this.segCount; ++n2) {
            if (this.idDelta[n2] != 0) continue;
            this.offset[n2] = n4;
            n3 = 1 + this.endCode[n2] - this.startCode[n2];
            if (this.startCode[n2] == this.endCode[n2] && this.idRangeOffset[n2] == 0) {
                n3 = 0;
            }
            n4 += n3;
        }
        n2 = (this.CMAPlength[n] - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.glyphIdArray[i] = fontFile2.getNextUint16();
        }
    }

    private void readFormat6Table(FontFile2 fontFile2) {
        this.hasFormat6 = true;
        this.firstCode = fontFile2.getNextUint16();
        this.entryCount = fontFile2.getNextUint16();
        this.f6glyphIdArray = new int[this.firstCode + this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.f6glyphIdArray[i + this.firstCode] = fontFile2.getNextUint16();
        }
    }

    private void readFormat12Table(FontFile2 fontFile2) {
        fontFile2.getNextUint16();
        fontFile2.getNextUint32();
        this.nGroups = fontFile2.getNextUint32();
        this.startCharCode = new int[this.nGroups];
        this.endCharCode = new int[this.nGroups];
        this.startGlyphCode = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            this.startCharCode[i] = fontFile2.getNextUint32();
            this.endCharCode[i] = fontFile2.getNextUint32();
            this.startGlyphCode[i] = fontFile2.getNextUint32();
        }
    }

    private void readFormatZeroTable(FontFile2 fontFile2, int n) {
        this.hasFormatZero = true;
        int n2 = 0;
        while (n2 < 256) {
            int n3;
            this.glyphIndexToChar[n][n2] = n3 = fontFile2.getNextUint8();
            this.glyphToIndex[n3] = n2++;
        }
    }

    public CMAP() {
    }

    public int convertIndexToCharacterCode(String string, int n) {
        int n2 = -1;
        int n3 = n;
        int n4 = this.CMAPformats[this.formatToUse];
        if (this.fontMapping == 1 || this.fontMapping == 2 || this.fontMapping == 3 || this.fontMapping == 4 && this.remapType4) {
            if (string != null && !"notdef".equals(string)) {
                n2 = n;
                n = StandardFonts.getAdobeMap(string);
            } else if (exceptions.containsKey(string)) {
                n = (Integer)exceptions.get(string);
            }
        }
        int n5 = -1;
        if (n3 == 128 && this.endCode != null && "Euro".equals(string)) {
            n5 = this.getFormat4Value(8364, n5);
        } else if (n4 == 0) {
            if (n > 255) {
                n = 0;
            }
            if ((n5 = this.glyphIndexToChar[this.formatToUse][n]) == 0 && n2 != -1) {
                n5 = this.glyphIndexToChar[this.formatToUse][n2];
            }
        } else if (n4 == 4) {
            if ((n5 = this.getFormat4Value(n, n5)) == -1) {
                n5 = n > 61440 ? this.getFormat4Value(n - 61440, n5) : this.getFormat4Value(n + 61440, n5);
            }
            if (n5 == -1) {
                n5 = this.getFormat4Value(n3 + 61440, n5);
            }
        } else if (n4 == 12) {
            n5 = this.getFormat12Value(n, false, n5);
        }
        if (n5 == -1 && this.hasSix) {
            n = n3;
            n4 = 6;
        }
        if (n4 == 6) {
            if (this.fontEncoding != 1) {
                n = StandardFonts.lookupCharacterIndex(string, 0);
            }
            n5 = n >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[n];
        }
        return n5;
    }

    private int getFormat12Value(int n, boolean bl, int n2) {
        for (int i = 0; i < this.nGroups; ++i) {
            if (bl) {
                System.out.println("table=" + i + " start=" + this.startCharCode[i] + ' ' + n + " end=" + this.endCharCode[i] + " glypgStartCode[i]=" + this.startGlyphCode[i]);
            }
            if (this.endCharCode[i] < n || this.startCharCode[i] > n) continue;
            n2 = this.startGlyphCode[i] + n - this.startCharCode[i];
            i = this.nGroups;
        }
        return n2;
    }

    private int getFormat4Value(int n, int n2) {
        for (int i = 0; i < this.segCount; ++i) {
            if (this.endCode[i] < n || this.startCode[i] > n) continue;
            if (this.idRangeOffset[i] == 0) {
                n2 = (this.idDelta[i] + n) % 65536;
                i = this.segCount;
                continue;
            }
            int n3 = this.offset[i] + (n - this.startCode[i]);
            if (n3 < this.glyphIdArray.length) {
                n2 = this.glyphIdArray[n3];
            }
            i = this.segCount;
        }
        return n2;
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2) {
        int n2;
        int n3;
        this.fontEncoding = n;
        this.formatToUse = -1;
        int n4 = this.platformID.length;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.platformID[n3] != 3 || this.CMAPformats[n3] != 1 && this.CMAPformats[n3] != 0) continue;
            this.formatToUse = n3;
            this.fontMapping = 1;
            n3 = n4;
        }
        n3 = 0;
        if (this.formatToUse == -1 && this.hasFormatZero && !bl2) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.platformID[n2] != 1 || this.CMAPformats[n2] != 0) continue;
                this.formatToUse = n2;
                int n5 = n3 = this.glyphIndexToChar[this.formatToUse][223] == 0 || this.getFormat4Value(223, 0) != 0 ? 1 : 0;
                if (bl) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else if (n3 == 0 && this.platformSpecificID[this.formatToUse] == 0 && this.platformID[this.formatToUse] == 1) {
                    this.fontMapping = 3;
                    StandardFonts.checkLoaded(2);
                } else {
                    this.fontMapping = -1;
                }
                n2 = n4;
            }
        }
        if (this.formatToUse == -1 || this.fontMapping == 3 || n3 != 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.CMAPformats[n2] != 4) continue;
                this.formatToUse = n2;
                this.fontMapping = 4;
                n2 = n4;
                if (this.platformSpecificID[this.formatToUse] == 3 && this.platformID[this.formatToUse] == 0 && (bl || n == 1)) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 1 && this.platformID[this.formatToUse] == 0 && bl && n == 2) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 0 && this.platformID[this.formatToUse] == 0 && bl && n == 2) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 1 && this.platformID[this.formatToUse] == 3 && bl && n == 2 && (n3 != 0 || this.getFormat4Value(223, 0) == 0)) {
                    this.remapType4 = true;
                    continue;
                }
                if (this.platformSpecificID[this.formatToUse] == 1 && this.platformID[this.formatToUse] == 3 && bl && (n == 0 || n4 == 1 && n == 2)) {
                    this.remapType4 = true;
                    continue;
                }
                if (bl || n == 1) continue;
                this.remapType4 = true;
            }
        }
        if (this.formatToUse == -1) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.CMAPformats[n2] != 6) continue;
                this.formatToUse = n2;
                if (!bl) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 6;
                }
                n2 = n4;
            }
        }
        if (this.formatToUse == -1) {
            for (n2 = 0; n2 < n4; ++n2) {
                if (this.CMAPformats[n2] != 12) continue;
                this.formatToUse = n2;
                if (!bl) {
                    this.fontMapping = 2;
                    StandardFonts.checkLoaded(0);
                } else {
                    this.fontMapping = 12;
                }
                n2 = n4;
            }
        }
        if (n == 5) {
            this.fontMapping = 2;
            StandardFonts.checkLoaded(0);
        }
    }

    public Map buildCharStringTable() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if (this.hasFormat4) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.segCount; ++i) {
                int n = this.endCode[i] - this.startCode[i] + 1;
                for (int j = 0; j < n; ++j) {
                    arrayList.add(this.startCode[i] + j);
                }
            }
            for (Integer n : arrayList) {
                hashMap.put(n, this.getFormat4Value(n, 0));
            }
        } else if (this.hasFormat6) {
            for (int i = 0; i < this.entryCount; ++i) {
                hashMap.put(this.firstCode + i, this.f6glyphIdArray[this.firstCode + i]);
            }
        } else {
            for (int i = 0; i < this.glyphToIndex.length; ++i) {
                if (this.glyphToIndex[i] <= 0) continue;
                hashMap.put(this.glyphToIndex[i], i);
            }
        }
        return hashMap;
    }

    static {
        String[] stringArray = new String[]{"notequal", "infinity", "lessequal", "greaterequal", "partialdiff", "summation", "product", "pi", "integral", "Omega", "radical", "approxequal", "Delta", "lozenge", "Euro", "apple"};
        int[] nArray = new int[]{173, 176, 178, 179, 182, 183, 184, 185, 186, 189, 195, 197, 198, 215, 219, 240};
        for (int i = 0; i < nArray.length; ++i) {
            exceptions.put(stringArray[i], nArray[i]);
        }
        StandardFonts.checkLoaded(2);
    }
}

