/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Glyf
extends Table {
    private final int[] charStrings;
    private final int glyfCount;
    private final boolean[] emptyCharStrings;
    private byte[] glyphTable;

    Glyf(FontFile2 fontFile2, int n, int[] nArray) {
        this.glyfCount = n;
        this.charStrings = new int[n];
        this.emptyCharStrings = new boolean[n];
        int n2 = fontFile2.selectTable(3);
        if (n2 != 0) {
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray[i + 1]) {
                    this.charStrings[i] = -1;
                    this.emptyCharStrings[i] = true;
                    continue;
                }
                this.charStrings[i] = nArray[i];
            }
            this.glyphTable = fontFile2.getTableBytes(4);
        }
    }

    public int getCharString(int n) {
        int n2 = n < 0 || n >= this.glyfCount ? n : this.charStrings[n];
        return n2;
    }

    public byte[] getTableData() {
        return this.glyphTable;
    }

    public int getGlypfCount() {
        return this.glyfCount;
    }

    public Map buildCharStringTable() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.glyfCount; ++i) {
            if (this.emptyCharStrings[i]) continue;
            hashMap.put(i, i);
        }
        return hashMap;
    }
}

