/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Hhea
extends Table {
    public static final int VERSION = 0;
    public static final int ASCENDER = 1;
    public static final int DESCENDER = 2;
    public static final int LINEGAP = 3;
    public static final int ADVANCEWIDTHMAX = 4;
    public static final int MINIMUMLEFTSIDEBEARING = 5;
    public static final int MINIMUMRIGHTSIDEBEARING = 6;
    public static final int XMAXEXTENT = 7;
    public static final int CARETSLOPERISING = 8;
    public static final int CARETSLOPERUN = 9;
    public static final int CARETOFFSET = 10;
    public static final int METRICDATAFORMAT = 11;
    public static final int NUMBEROFMETRICS = 12;
    private int version = 65536;
    private int ascender = 1;
    private int descender = -1;
    private int lineGap;
    private int advancedWidthMax;
    private int minimumLeftSideBearing;
    private int minimumRightSideBearing;
    private int xMaxExtent;
    private int caretSlopeRise;
    private int caretSlopeRun;
    private int caretOffset;
    private int metricDataFormat;
    private int numberOfHMetrics;

    public Hhea(FontFile2 fontFile2) {
        int n = fontFile2.selectTable(5);
        if (n != 0) {
            this.version = fontFile2.getNextUint32();
            this.ascender = fontFile2.getFWord();
            this.descender = fontFile2.getFWord();
            this.lineGap = fontFile2.getFWord();
            this.advancedWidthMax = fontFile2.readUFWord();
            this.minimumLeftSideBearing = fontFile2.getFWord();
            this.minimumRightSideBearing = fontFile2.getFWord();
            this.xMaxExtent = fontFile2.getFWord();
            this.caretSlopeRise = fontFile2.getNextInt16();
            this.caretSlopeRun = fontFile2.getNextInt16();
            this.caretOffset = fontFile2.getFWord();
            for (int i = 0; i < 4; ++i) {
                fontFile2.getNextUint16();
            }
            this.metricDataFormat = fontFile2.getNextInt16();
            this.numberOfHMetrics = fontFile2.getNextUint16();
        }
    }

    public Hhea() {
    }

    public int getNumberOfHMetrics() {
        return this.numberOfHMetrics;
    }

    public int getIntValue(int n) {
        switch (n) {
            case 0: {
                return this.version;
            }
            case 1: {
                return this.ascender;
            }
            case 2: {
                return this.descender;
            }
            case 3: {
                return this.lineGap;
            }
            case 4: {
                return this.advancedWidthMax;
            }
            case 5: {
                return this.minimumLeftSideBearing;
            }
            case 6: {
                return this.minimumRightSideBearing;
            }
            case 7: {
                return this.xMaxExtent;
            }
            case 8: {
                return this.caretSlopeRise;
            }
            case 9: {
                return this.caretSlopeRun;
            }
            case 10: {
                return this.caretOffset;
            }
            case 11: {
                return this.metricDataFormat;
            }
            case 12: {
                return this.numberOfHMetrics;
            }
        }
        return 0;
    }
}

