/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.text.NumberFormat;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Cvt
extends Table {
    final short[] unscaledCvt;
    final int[] cvt;
    double scale;
    private static boolean messageDisplayed;

    Cvt(FontFile2 fontFile2) {
        int n = fontFile2.selectTable(9);
        if (n != 0) {
            int n2 = fontFile2.getOffset(9) / 2;
            this.unscaledCvt = new short[n2];
            this.cvt = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.unscaledCvt[i] = fontFile2.getFWord();
            }
        } else {
            this.unscaledCvt = new short[0];
            this.cvt = new int[0];
        }
    }

    public void scale(double d) {
        this.scale = d;
        for (int i = 0; i < this.unscaledCvt.length; ++i) {
            this.cvt[i] = (int)(d * (double)this.unscaledCvt[i] + 0.5);
        }
    }

    public void putInPixels(int n, int n2) {
        if (n >= 0 && n < this.cvt.length) {
            this.cvt[n] = n2;
        } else if (LogWriter.isRunningFromIDE) {
            System.err.println("Cvt.putInPixels(): Key out of range. (" + n + ')');
        }
    }

    public void putInFUnits(int n, int n2) {
        n2 = (int)((double)n2 * this.scale + 0.5);
        if (n >= 0 && n < this.cvt.length) {
            this.cvt[n] = n2;
        } else if (LogWriter.isRunningFromIDE) {
            System.err.println("Cvt.putInFUnits(): Key out of range. (" + n + ')');
        }
    }

    public int get(int n) {
        if (n >= 0 && n < this.cvt.length) {
            return this.cvt[n];
        }
        if (!messageDisplayed && LogWriter.isRunningFromIDE) {
            System.err.println("Cvt.get(): Key out of range. (" + n + ')');
            messageDisplayed = true;
        }
        return 0;
    }

    String[] getCVTForDebug() {
        String[] stringArray = new String[this.cvt.length];
        for (int i = 0; i < this.cvt.length; ++i) {
            stringArray[i] = i + ": " + this.cvt[i] + "       (" + NumberFormat.getNumberInstance().format((double)this.cvt[i] / 64.0) + ')';
        }
        return stringArray;
    }
}

