/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.hinting.Cvt;
import org.jpedal.fonts.tt.hinting.TTGraphicsState;
import org.jpedal.utils.LogWriter;

public class TTVM
implements Serializable {
    protected static final int TWILIGHT_ZONE = 0;
    protected static final int GLYPH_ZONE = 1;
    protected static final int ORIGINAL = 2;
    private static final boolean showDebugWindow = false;
    private static final boolean printGlyphInstructions = false;
    private static final boolean printCoordsAfterEachInstruction = false;
    private static boolean watchAPoint = true;
    private static final int watchPoint = 53;
    private int watchX;
    private int watchY;
    private int debugPointer;
    private int instructionsExecuted;
    private int functionsLineCount;
    private int[] programToDebug;
    private boolean[] programToDebugIsData;
    private JFrame debugWindow;
    private TTGraphicsState dGS;
    private JComponent stateDisplay;
    private JComponent debugGlyphDisplay;
    private JCheckBox showInterpolatedShadow;
    private boolean stepInto;
    private boolean debuggerRunningInBackground;
    private static JList currentInstructionList;
    private static JList stackList;
    private static JList cvtList;
    private static JList storageList;
    private JLabel currentCode;
    private JLabel debugXLabel;
    private JLabel debugYLabel;
    private final java.util.Stack<int[]> codeStack = new java.util.Stack();
    private final java.util.Stack<Integer> numberStack = new java.util.Stack();
    private boolean printOut;
    private final int[] preProgram;
    private final int[] fontProgram;
    private boolean fontProgramRun;
    private boolean scalerRun;
    private double ptSize;
    private double ppem;
    private double scaler;
    private final int[][] x;
    private final int[][] y;
    private final boolean[][] curve;
    private final boolean[][] contour;
    private boolean[][][] touched;
    final Maxp maxp;
    private boolean useDefaultGS;
    private Stack stack = new Stack();
    private final Cvt cvt;
    private final TTGraphicsState graphicsState;
    private final int[] storage;
    private final HashMap<Integer, int[]> functions;
    private final HashMap<Integer, int[]> instructions;
    private static final int SVTCAy = 0;
    private static final int SVTCAx = 1;
    private static final int SPVTCAy = 2;
    private static final int SPVTCAx = 3;
    private static final int SFVTCAy = 4;
    private static final int SFVTCAx = 5;
    private static final int SPVTL0 = 6;
    private static final int SPVTL1 = 7;
    private static final int SFVTL0 = 8;
    private static final int SFVTL1 = 9;
    private static final int SPVFS = 10;
    private static final int SFVFS = 11;
    private static final int GPV = 12;
    private static final int GFV = 13;
    private static final int SFVTPV = 14;
    private static final int ISECT = 15;
    private static final int SRP0 = 16;
    private static final int SRP1 = 17;
    private static final int SRP2 = 18;
    private static final int SZP0 = 19;
    private static final int SZP1 = 20;
    private static final int SZP2 = 21;
    private static final int SZPS = 22;
    private static final int SLOOP = 23;
    private static final int RTG = 24;
    private static final int RTHG = 25;
    private static final int SMD = 26;
    private static final int ELSE = 27;
    private static final int JMPR = 28;
    private static final int SCVTCI = 29;
    private static final int SSWCI = 30;
    private static final int SSW = 31;
    private static final int DUP = 32;
    private static final int POP = 33;
    private static final int CLEAR = 34;
    private static final int SWAP = 35;
    private static final int DEPTH = 36;
    private static final int CINDEX = 37;
    private static final int MINDEX = 38;
    private static final int ALIGNPTS = 39;
    private static final int UTP = 41;
    private static final int LOOPCALL = 42;
    private static final int CALL = 43;
    private static final int FDEF = 44;
    private static final int ENDF = 45;
    private static final int MDAP0 = 46;
    private static final int MDAP1 = 47;
    private static final int IUPy = 48;
    private static final int IUPx = 49;
    private static final int SHP0 = 50;
    private static final int SHP1 = 51;
    private static final int SHC0 = 52;
    private static final int SHC1 = 53;
    private static final int SHZ0 = 54;
    private static final int SHZ1 = 55;
    private static final int SHPIX = 56;
    private static final int IP = 57;
    private static final int MSIRP0 = 58;
    private static final int MSIRP1 = 59;
    private static final int ALIGNRP = 60;
    private static final int RTDG = 61;
    private static final int MIAP0 = 62;
    private static final int MIAP1 = 63;
    private static final int NPUSHB = 64;
    private static final int NPUSHW = 65;
    private static final int WS = 66;
    private static final int RS = 67;
    private static final int WCVTP = 68;
    private static final int RCVT = 69;
    private static final int GC0 = 70;
    private static final int GC1 = 71;
    private static final int SCFS = 72;
    private static final int MD0 = 73;
    private static final int MD1 = 74;
    private static final int MPPEM = 75;
    private static final int MPS = 76;
    private static final int FLIPON = 77;
    private static final int FLIPOFF = 78;
    private static final int DEBUG = 79;
    private static final int LT = 80;
    private static final int LTEQ = 81;
    private static final int GT = 82;
    private static final int GTEQ = 83;
    private static final int EQ = 84;
    private static final int NEQ = 85;
    private static final int ODD = 86;
    private static final int EVEN = 87;
    private static final int IF = 88;
    private static final int EIF = 89;
    private static final int AND = 90;
    private static final int OR = 91;
    private static final int NOT = 92;
    private static final int DELTAP1 = 93;
    private static final int SDB = 94;
    private static final int SDS = 95;
    private static final int ADD = 96;
    private static final int SUB = 97;
    private static final int DIV = 98;
    private static final int MUL = 99;
    private static final int ABS = 100;
    private static final int NEG = 101;
    private static final int FLOOR = 102;
    private static final int CEILING = 103;
    private static final int ROUND00 = 104;
    private static final int ROUND01 = 105;
    private static final int ROUND10 = 106;
    private static final int ROUND11 = 107;
    private static final int NROUND00 = 108;
    private static final int NROUND01 = 109;
    private static final int NROUND10 = 110;
    private static final int NROUND11 = 111;
    private static final int WCVTF = 112;
    private static final int DELTAP2 = 113;
    private static final int DELTAP3 = 114;
    private static final int DELTAC1 = 115;
    private static final int DELTAC2 = 116;
    private static final int DELTAC3 = 117;
    private static final int SROUND = 118;
    private static final int S45ROUND = 119;
    private static final int JROT = 120;
    private static final int JROF = 121;
    private static final int ROFF = 122;
    private static final int RUTG = 124;
    private static final int RDTG = 125;
    private static final int SANGW = 126;
    private static final int AA = 127;
    private static final int FLIPPT = 128;
    private static final int FLIPRGON = 129;
    private static final int FLIPRGOFF = 130;
    private static final int SCANCTRL = 133;
    private static final int SDPVTL0 = 134;
    private static final int SDPVTL1 = 135;
    private static final int GETINFO = 136;
    private static final int IDEF = 137;
    private static final int ROLL = 138;
    private static final int MAX = 139;
    private static final int MIN = 140;
    private static final int SCANTYPE = 141;
    private static final int INSTCTRL = 142;
    private static final int PUSHB = 176;
    private static final int PUSHW = 184;
    private static final int MDRP = 192;
    private static final int MIRP = 224;
    private static final String[] OPCODE_DESCRIPTIONS;
    private static final int paramRESETRP0 = 16;
    private static final int paramUSEMINDIST = 8;
    private static final int paramROUND = 4;

    public TTVM(FontFile2 fontFile2, Maxp maxp) {
        this.cvt = new Cvt(fontFile2);
        this.graphicsState = new TTGraphicsState();
        this.preProgram = TTVM.readProgramTable(fontFile2, 14);
        this.fontProgram = TTVM.readProgramTable(fontFile2, 10);
        this.storage = new int[maxp.getMaxStorage()];
        this.functions = new HashMap();
        this.instructions = new HashMap();
        this.maxp = maxp;
        int n = maxp.getMaxPoints();
        this.x = new int[4][n];
        this.y = new int[4][n];
        this.curve = new boolean[2][n];
        this.contour = new boolean[2][n];
        this.touched = new boolean[4][n][2];
        this.x[0] = new int[maxp.getMaxTwilightPoints()];
        this.y[0] = new int[maxp.getMaxTwilightPoints()];
    }

    public void setScaleVars(double d, double d2, double d3) {
        this.scalerRun = false;
        this.ppem = (int)(d2 + 0.5);
        this.ptSize = d3;
        if (!this.fontProgramRun) {
            this.execute(this.fontProgram, this.graphicsState);
            this.fontProgramRun = true;
        }
        if (d != this.scaler) {
            this.scaler = d;
            this.cvt.scale(d);
            this.execute(this.preProgram, this.graphicsState);
            this.scalerRun = true;
        }
    }

    public void processGlyph(int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray, boolean[] blArray2) {
        TTGraphicsState tTGraphicsState;
        if (watchAPoint) {
            this.printOut = true;
        }
        this.x[1] = nArray2;
        this.x[3] = new int[nArray2.length];
        System.arraycopy(this.x[1], 0, this.x[3], 0, this.x[1].length);
        this.y[1] = nArray3;
        this.y[3] = new int[nArray3.length];
        System.arraycopy(this.y[1], 0, this.y[3], 0, this.y[1].length);
        this.curve[1] = blArray;
        this.contour[1] = blArray2;
        int n = this.maxp.getMaxTwilightPoints();
        if (nArray2.length > n) {
            n = nArray2.length;
        }
        this.touched = new boolean[4][n][2];
        this.stack = new Stack();
        if (this.useDefaultGS) {
            tTGraphicsState = new TTGraphicsState();
        } else {
            try {
                tTGraphicsState = (TTGraphicsState)this.graphicsState.clone();
                tTGraphicsState.resetForGlyph();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                LogWriter.writeLog("Exception: " + cloneNotSupportedException.getMessage());
                tTGraphicsState = new TTGraphicsState();
            }
        }
        if (tTGraphicsState.instructControl != 0) {
            return;
        }
        if (watchAPoint) {
            this.watchX = this.x[1][53];
            this.watchY = this.y[1][53];
        }
        this.execute(nArray, tTGraphicsState);
        if (watchAPoint) {
            this.printOut = false;
        }
    }

    private void execute(int[] nArray, TTGraphicsState tTGraphicsState) {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.printOut) {
                System.out.print(i + "\t");
            }
            i = this.process(nArray[i], i, nArray, tTGraphicsState);
            if (watchAPoint && (this.watchX != this.x[1][53] || this.watchY != this.y[1][53])) {
                int n = this.x[1][53] - this.watchX;
                int n2 = this.y[1][53] - this.watchY;
                this.watchX = this.x[1][53];
                this.watchY = this.y[1][53];
                System.out.print("Changed point 53 (");
                if (n > 0) {
                    System.out.print("x+" + n);
                } else if (n != 0) {
                    System.out.print("x" + n);
                }
                if (n != 0 && n2 != 0) {
                    System.out.print(", ");
                }
                if (n2 > 0) {
                    System.out.print("y+" + n2);
                } else if (n2 != 0) {
                    System.out.print("y" + n2);
                }
                System.out.println(")");
                this.printCoords();
            }
            if (!BaseTTGlyph.redecodePage) continue;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int process(int n, int n2, int[] nArray, TTGraphicsState tTGraphicsState) {
        int n3 = n2;
        int n4 = 0;
        if (n >= 176 && n <= 191) {
            n4 = n % 8;
            n -= n4;
            ++n4;
        }
        if (this.printOut && n < OPCODE_DESCRIPTIONS.length) {
            System.out.println(OPCODE_DESCRIPTIONS[n]);
        }
        try {
            switch (n) {
                case 0: {
                    tTGraphicsState.freedomVector = 16384;
                    tTGraphicsState.projectionVector = 16384;
                    tTGraphicsState.dualProjectionVector = 16384;
                    return n2;
                }
                case 1: {
                    tTGraphicsState.freedomVector = 0x40000000;
                    tTGraphicsState.projectionVector = 0x40000000;
                    tTGraphicsState.dualProjectionVector = 0x40000000;
                    return n2;
                }
                case 2: {
                    tTGraphicsState.projectionVector = 16384;
                    tTGraphicsState.dualProjectionVector = 16384;
                    return n2;
                }
                case 3: {
                    tTGraphicsState.projectionVector = 0x40000000;
                    tTGraphicsState.dualProjectionVector = 0x40000000;
                    return n2;
                }
                case 4: {
                    tTGraphicsState.freedomVector = 16384;
                    return n2;
                }
                case 5: {
                    tTGraphicsState.freedomVector = 0x40000000;
                    return n2;
                }
                case 6: {
                    int n5 = this.stack.pop();
                    int n6 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n6] - this.x[tTGraphicsState.zp1][n5]);
                    double d2 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n6] - this.y[tTGraphicsState.zp1][n5]);
                    double d3 = Math.sqrt(d * d + d2 * d2);
                    tTGraphicsState.dualProjectionVector = tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d /= d3), TTVM.storeDoubleAsF2Dot14(d2 /= d3));
                    return n2;
                }
                case 7: {
                    int n7 = this.stack.pop();
                    int n8 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n8] - this.x[tTGraphicsState.zp1][n7]);
                    double d4 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n8] - this.y[tTGraphicsState.zp1][n7]);
                    double d5 = Math.sqrt(d * d + d4 * d4);
                    tTGraphicsState.dualProjectionVector = tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(d4 /= d5)), TTVM.storeDoubleAsF2Dot14(d /= d5));
                    return n2;
                }
                case 8: {
                    int n9 = this.stack.pop();
                    int n10 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp1][n10] - this.x[tTGraphicsState.zp2][n9]);
                    double d6 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp1][n10] - this.y[tTGraphicsState.zp2][n9]);
                    double d7 = Math.sqrt(d * d + d6 * d6);
                    tTGraphicsState.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d /= d7), TTVM.storeDoubleAsF2Dot14(d6 /= d7));
                    return n2;
                }
                case 9: {
                    int n11 = this.stack.pop();
                    int n12 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp1][n12] - this.x[tTGraphicsState.zp2][n11]);
                    double d8 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp1][n12] - this.y[tTGraphicsState.zp2][n11]);
                    double d9 = Math.sqrt(d * d + d8 * d8);
                    tTGraphicsState.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(d8 /= d9)), TTVM.storeDoubleAsF2Dot14(d /= d9));
                    return n2;
                }
                case 10: {
                    int n13 = this.stack.pop();
                    int n14 = this.stack.pop();
                    tTGraphicsState.dualProjectionVector = tTGraphicsState.projectionVector = TTGraphicsState.createVector(n14, n13);
                    return n2;
                }
                case 11: {
                    int n15 = this.stack.pop();
                    int n16 = this.stack.pop();
                    tTGraphicsState.freedomVector = TTGraphicsState.createVector(n16, n15);
                    return n2;
                }
                case 12: {
                    int[] nArray2 = TTGraphicsState.getVectorComponents(tTGraphicsState.projectionVector);
                    this.stack.push(nArray2[0]);
                    this.stack.push(nArray2[1]);
                    return n2;
                }
                case 13: {
                    int[] nArray3 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    this.stack.push(nArray3[0]);
                    this.stack.push(nArray3[1]);
                    return n2;
                }
                case 14: {
                    tTGraphicsState.freedomVector = tTGraphicsState.projectionVector;
                    return n2;
                }
                case 15: {
                    double d;
                    int n17;
                    int n18;
                    int n19 = this.stack.pop();
                    int n20 = this.stack.pop();
                    int n21 = this.stack.pop();
                    int n22 = this.stack.pop();
                    int n23 = this.x[tTGraphicsState.zp1][n22];
                    int n24 = this.y[tTGraphicsState.zp1][n22];
                    int n25 = this.x[tTGraphicsState.zp1][n21] - n23;
                    int n26 = this.y[tTGraphicsState.zp1][n21] - n24;
                    int n27 = this.x[tTGraphicsState.zp0][n20];
                    int n28 = this.y[tTGraphicsState.zp0][n20];
                    int n29 = this.x[tTGraphicsState.zp0][n19] - n27;
                    int n30 = this.y[tTGraphicsState.zp0][n19] - n28;
                    if (n25 == 0 && n29 == 0) {
                        n18 = n23 + n27 / 2;
                        n17 = (n24 + n28 + (n24 + n26) + (n28 + n30)) / 4;
                    } else if (n25 == 0) {
                        d = TTVM.getDoubleFromF26Dot6(n30) / TTVM.getDoubleFromF26Dot6(n29);
                        double d10 = TTVM.getDoubleFromF26Dot6(n28) - d * TTVM.getDoubleFromF26Dot6(n27);
                        n18 = n23;
                        n17 = TTVM.storeDoubleAsF26Dot6(d * TTVM.getDoubleFromF26Dot6(n23) + d10);
                    } else if (n29 == 0) {
                        d = TTVM.getDoubleFromF26Dot6(n26) / TTVM.getDoubleFromF26Dot6(n25);
                        double d11 = TTVM.getDoubleFromF26Dot6(n24) - d * TTVM.getDoubleFromF26Dot6(n23);
                        n18 = n27;
                        n17 = TTVM.storeDoubleAsF26Dot6(d * TTVM.getDoubleFromF26Dot6(n27) + d11);
                    } else {
                        d = TTVM.getDoubleFromF26Dot6(n26) / TTVM.getDoubleFromF26Dot6(n25);
                        double d12 = TTVM.getDoubleFromF26Dot6(n24) - d * TTVM.getDoubleFromF26Dot6(n23);
                        double d13 = TTVM.getDoubleFromF26Dot6(n30) / TTVM.getDoubleFromF26Dot6(n29);
                        double d14 = TTVM.getDoubleFromF26Dot6(n28) - d13 * TTVM.getDoubleFromF26Dot6(n27);
                        if (d == d13) {
                            n18 = (n23 + n27 + (n23 + n25) + (n27 + n29)) / 4;
                            n17 = (n24 + n28 + (n24 + n26) + (n28 + n30)) / 4;
                        } else {
                            double d15 = (d14 - d12) / (d - d13);
                            n18 = TTVM.storeDoubleAsF26Dot6(d15);
                            n17 = TTVM.storeDoubleAsF26Dot6(d * d15 + d12);
                        }
                    }
                    int n31 = this.stack.pop();
                    this.x[tTGraphicsState.zp2][n31] = n18;
                    this.y[tTGraphicsState.zp2][n31] = n17;
                    return n2;
                }
                case 16: {
                    tTGraphicsState.rp0 = this.stack.pop();
                    return n2;
                }
                case 17: {
                    tTGraphicsState.rp1 = this.stack.pop();
                    return n2;
                }
                case 18: {
                    tTGraphicsState.rp2 = this.stack.pop();
                    return n2;
                }
                case 19: {
                    tTGraphicsState.zp0 = this.stack.pop();
                    return n2;
                }
                case 20: {
                    int n32 = this.stack.pop();
                    if (n32 > 1 || n32 < 0) {
                        System.out.println("ZP1 set incorrectly!");
                    }
                    tTGraphicsState.zp1 = n32;
                    return n2;
                }
                case 21: {
                    tTGraphicsState.zp2 = this.stack.pop();
                    return n2;
                }
                case 22: {
                    int n33;
                    tTGraphicsState.zp0 = n33 = this.stack.pop();
                    tTGraphicsState.zp1 = n33;
                    tTGraphicsState.zp2 = n33;
                    return n2;
                }
                case 23: {
                    tTGraphicsState.loop = this.stack.pop();
                    return n2;
                }
                case 24: {
                    tTGraphicsState.roundState = 72;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 25: {
                    tTGraphicsState.roundState = 104;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 26: {
                    tTGraphicsState.minimumDistance = this.stack.pop();
                    return n2;
                }
                case 27: {
                    int n34 = 0;
                    int n35 = 0;
                    do {
                        if (n34 == 89 && n35 != 0) {
                            --n35;
                        }
                        if ((n34 = nArray[++n2]) == 88) {
                            ++n35;
                        }
                        if (n34 == 64) {
                            ++n2;
                            n2 += nArray[n2];
                            continue;
                        }
                        if (n34 == 65) {
                            ++n2;
                            n2 += nArray[n2] * 2;
                            continue;
                        }
                        if (n34 >= 176 && n34 <= 183) {
                            n2 += n34 + 1 - 176;
                            continue;
                        }
                        if (n34 < 184 || n34 > 191) continue;
                        n2 += (n34 + 1 - 184) * 2;
                    } while (n34 != 89 || n35 != 0);
                    return n2;
                }
                case 28: {
                    int n36 = this.stack.pop();
                    n2 = n2 + n36 - 1;
                    if (n2 >= 0) return n2;
                    throw new RuntimeException("Jumped back further than the start of the instruction.");
                }
                case 29: {
                    tTGraphicsState.controlValueTableCutIn = this.stack.pop();
                    return n2;
                }
                case 30: {
                    tTGraphicsState.singleWidthCutIn = this.stack.pop();
                    return n2;
                }
                case 31: {
                    tTGraphicsState.singleWidthValue = this.stack.pop();
                    return n2;
                }
                case 32: {
                    int n37 = this.stack.pop();
                    this.stack.push(n37);
                    this.stack.push(n37);
                    return n2;
                }
                case 33: {
                    this.stack.pop();
                    return n2;
                }
                case 34: {
                    this.stack = new Stack();
                    return n2;
                }
                case 35: {
                    int n38 = this.stack.pop();
                    int n39 = this.stack.pop();
                    this.stack.push(n38);
                    this.stack.push(n39);
                    return n2;
                }
                case 36: {
                    this.stack.push(this.stack.size());
                    return n2;
                }
                case 37: {
                    int n40 = this.stack.pop();
                    int n41 = this.stack.elementAt(n40);
                    this.stack.push(n41);
                    return n2;
                }
                case 38: {
                    int n42 = this.stack.pop();
                    int n43 = this.stack.remove(n42);
                    this.stack.push(n43);
                    return n2;
                }
                case 39: {
                    int n44 = this.stack.pop();
                    int n45 = this.stack.pop();
                    int n46 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n44], this.y[tTGraphicsState.zp1][n44]);
                    int n47 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n45], this.y[tTGraphicsState.zp0][n45]);
                    int n48 = (n46 + n47) / 2;
                    int[] nArray4 = tTGraphicsState.getFVMoveforPVDistance(n48 - n46);
                    int[] nArray5 = this.x[tTGraphicsState.zp1];
                    int n49 = n44;
                    nArray5[n49] = nArray5[n49] + nArray4[0];
                    int[] nArray6 = this.y[tTGraphicsState.zp1];
                    int n50 = n44;
                    nArray6[n50] = nArray6[n50] + nArray4[1];
                    int[] nArray7 = this.x[tTGraphicsState.zp0];
                    int n51 = n45;
                    nArray7[n51] = nArray7[n51] - nArray4[0];
                    int[] nArray8 = this.y[tTGraphicsState.zp0];
                    int n52 = n45;
                    nArray8[n52] = nArray8[n52] - nArray4[1];
                    int[] nArray9 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray9[0] != 0) {
                        this.touched[tTGraphicsState.zp1][n44][0] = true;
                        this.touched[tTGraphicsState.zp0][n45][0] = true;
                    }
                    if (nArray9[1] == 0) return n2;
                    this.touched[tTGraphicsState.zp1][n44][1] = true;
                    this.touched[tTGraphicsState.zp0][n45][1] = true;
                    return n2;
                }
                case 41: {
                    int n53 = this.stack.pop();
                    if (tTGraphicsState.freedomVector == 0x40000000) {
                        this.touched[tTGraphicsState.zp0][n53][0] = false;
                        return n2;
                    }
                    if (tTGraphicsState.freedomVector == 16384) {
                        this.touched[tTGraphicsState.zp0][n53][1] = false;
                        return n2;
                    }
                    this.touched[tTGraphicsState.zp0][n53][0] = false;
                    this.touched[tTGraphicsState.zp0][n53][1] = false;
                    return n2;
                }
                case 42: {
                    int n54 = this.stack.pop();
                    int n55 = this.stack.pop();
                    int[] nArray10 = this.functions.get(n54);
                    for (int i = 0; i < n55; ++i) {
                        this.execute(nArray10, tTGraphicsState);
                    }
                    if (!this.printOut) return n2;
                    System.out.println("LOOPCALL finished");
                    return n2;
                }
                case 43: {
                    int n56 = this.stack.pop();
                    int[] nArray11 = this.functions.get(n56);
                    this.execute(nArray11, tTGraphicsState);
                    if (!this.printOut) return n2;
                    System.out.println("CALL finished");
                    return n2;
                }
                case 44: {
                    int n57;
                    int n58 = this.stack.pop();
                    int n59 = n2;
                    do {
                        if ((n57 = nArray[++n2]) == 64) {
                            ++n2;
                            n2 += nArray[n2];
                            continue;
                        }
                        if (n57 == 65) {
                            ++n2;
                            n2 += nArray[n2] * 2;
                            continue;
                        }
                        if (n57 >= 176 && n57 <= 183) {
                            n2 += n57 + 1 - 176;
                            continue;
                        }
                        if (n57 < 184 || n57 > 191) continue;
                        n2 += (n57 + 1 - 184) * 2;
                    } while (n57 != 45);
                    int n60 = n2 - n59 - 1;
                    n2 = n59;
                    int[] nArray12 = new int[n60];
                    for (int i = 0; i < n60; ++i) {
                        nArray12[i] = nArray[++n2];
                    }
                    this.functions.put(n58, nArray12);
                    ++n2;
                    return n2;
                }
                case 45: {
                    return n2;
                }
                case 46: {
                    int n61;
                    tTGraphicsState.rp0 = n61 = this.stack.pop();
                    tTGraphicsState.rp1 = n61;
                    if (tTGraphicsState.freedomVector == 0x40000000) {
                        this.touched[tTGraphicsState.zp0][n61][0] = true;
                        return n2;
                    }
                    if (tTGraphicsState.freedomVector == 16384) {
                        this.touched[tTGraphicsState.zp0][n61][1] = true;
                        return n2;
                    }
                    this.touched[tTGraphicsState.zp0][n61][0] = true;
                    this.touched[tTGraphicsState.zp0][n61][1] = true;
                    return n2;
                }
                case 47: {
                    int n62;
                    tTGraphicsState.rp0 = n62 = this.stack.pop();
                    tTGraphicsState.rp1 = n62;
                    int n63 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n62], this.y[tTGraphicsState.zp0][n62]);
                    n63 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n63))) - n63;
                    int[] nArray13 = tTGraphicsState.getFVMoveforPVDistance(n63);
                    int[] nArray14 = this.x[tTGraphicsState.zp0];
                    int n64 = n62;
                    nArray14[n64] = nArray14[n64] + nArray13[0];
                    int[] nArray15 = this.y[tTGraphicsState.zp0];
                    int n65 = n62;
                    nArray15[n65] = nArray15[n65] + nArray13[1];
                    int[] nArray16 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray16[0] != 0) {
                        this.touched[tTGraphicsState.zp0][n62][0] = true;
                    }
                    if (nArray16[1] == 0) return n2;
                    this.touched[tTGraphicsState.zp0][n62][1] = true;
                    return n2;
                }
                case 48: {
                    this.interpolateUntouchedPoints(48);
                    return n2;
                }
                case 49: {
                    this.interpolateUntouchedPoints(49);
                    return n2;
                }
                case 50: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n66 = this.stack.pop();
                        if (n66 > this.x[tTGraphicsState.zp2].length || tTGraphicsState.rp2 > this.x[tTGraphicsState.zp1].length) {
                            LogWriter.writeLog("Trying to use a point which doesn't exist! (SHP0, zone " + tTGraphicsState.zp2 + ')');
                            break;
                        }
                        int n67 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                        int n68 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]);
                        int n69 = n67 - n68;
                        int[] nArray17 = tTGraphicsState.getFVMoveforPVDistance(n69);
                        int[] nArray18 = this.x[tTGraphicsState.zp2];
                        int n70 = n66;
                        nArray18[n70] = nArray18[n70] + nArray17[0];
                        int[] nArray19 = this.y[tTGraphicsState.zp2];
                        int n71 = n66;
                        nArray19[n71] = nArray19[n71] + nArray17[1];
                        int[] nArray20 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray20[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n66][0] = true;
                        }
                        if (nArray20[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n66][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 51: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n72 = this.stack.pop();
                        int n73 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        int n74 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        int n75 = n73 - n74;
                        int[] nArray21 = tTGraphicsState.getFVMoveforPVDistance(n75);
                        int[] nArray22 = this.x[tTGraphicsState.zp2];
                        int n76 = n72;
                        nArray22[n76] = nArray22[n76] + nArray21[0];
                        int[] nArray23 = this.y[tTGraphicsState.zp2];
                        int n77 = n72;
                        nArray23[n77] = nArray23[n77] + nArray21[1];
                        if (nArray21[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n72][0] = true;
                        }
                        if (nArray21[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n72][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 52: {
                    int n78;
                    int n79 = this.stack.pop();
                    int[] nArray24 = new int[this.contour[1].length];
                    int[] nArray25 = new int[this.contour[1].length];
                    int n80 = 0;
                    int n81 = 0;
                    nArray25[0] = 0;
                    for (n78 = 0; n78 < this.contour[1].length; ++n78) {
                        if (!this.contour[1][n78]) continue;
                        nArray25[n80 + 1] = n78 + 1;
                        nArray24[n80] = n78 + 1 - n81;
                        n81 = n78 + 1;
                        ++n80;
                    }
                    n78 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n82 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n83 = n78 - n82;
                    int[] nArray26 = tTGraphicsState.getFVMoveforPVDistance(n83);
                    int n84 = nArray25[n79];
                    while (n84 < nArray25[n79] + nArray24[n79]) {
                        if (tTGraphicsState.zp1 == tTGraphicsState.zp2 || n84 != tTGraphicsState.rp2) {
                            int[] nArray27 = this.x[tTGraphicsState.zp2];
                            int n85 = n84;
                            nArray27[n85] = nArray27[n85] + nArray26[0];
                            int[] nArray28 = this.y[tTGraphicsState.zp2];
                            int n86 = n84;
                            nArray28[n86] = nArray28[n86] + nArray26[1];
                        }
                        ++n84;
                    }
                    return n2;
                }
                case 53: {
                    int n87;
                    int n88 = this.stack.pop();
                    int[] nArray29 = new int[this.contour[1].length];
                    int[] nArray30 = new int[this.contour[1].length];
                    int n89 = 0;
                    int n90 = 0;
                    nArray30[0] = 0;
                    for (n87 = 0; n87 < this.contour[1].length; ++n87) {
                        if (!this.contour[1][n87]) continue;
                        nArray30[n89 + 1] = n87 + 1;
                        nArray29[n89] = n87 + 1 - n90;
                        n90 = n87 + 1;
                        ++n89;
                    }
                    n87 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n91 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n92 = n87 - n91;
                    int[] nArray31 = tTGraphicsState.getFVMoveforPVDistance(n92);
                    int n93 = nArray30[n88];
                    while (n93 < nArray30[n88] + nArray29[n88]) {
                        if (tTGraphicsState.zp2 != tTGraphicsState.zp0 || n93 != tTGraphicsState.rp1) {
                            int[] nArray32 = this.x[tTGraphicsState.zp2];
                            int n94 = n93;
                            nArray32[n94] = nArray32[n94] + nArray31[0];
                            int[] nArray33 = this.y[tTGraphicsState.zp2];
                            int n95 = n93;
                            nArray33[n95] = nArray33[n95] + nArray31[1];
                        }
                        ++n93;
                    }
                    return n2;
                }
                case 54: {
                    int n96 = this.stack.pop();
                    int n97 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n98 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n99 = n97 - n98;
                    int[] nArray34 = tTGraphicsState.getFVMoveforPVDistance(n99);
                    int n100 = 0;
                    while (n100 < this.x[n96].length) {
                        if (n96 != tTGraphicsState.zp1 || n100 != tTGraphicsState.rp2) {
                            int[] nArray35 = this.x[n96];
                            int n101 = n100;
                            nArray35[n101] = nArray35[n101] + nArray34[0];
                            int[] nArray36 = this.y[n96];
                            int n102 = n100;
                            nArray36[n102] = nArray36[n102] + nArray34[1];
                        }
                        ++n100;
                    }
                    return n2;
                }
                case 55: {
                    int n103 = this.stack.pop();
                    int n104 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n105 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n106 = n104 - n105;
                    int[] nArray37 = tTGraphicsState.getFVMoveforPVDistance(n106);
                    int n107 = 0;
                    while (n107 < this.x[n103].length) {
                        if (n103 != tTGraphicsState.zp0 || n107 != tTGraphicsState.rp1) {
                            int[] nArray38 = this.x[n103];
                            int n108 = n107;
                            nArray38[n108] = nArray38[n108] + nArray37[0];
                            int[] nArray39 = this.y[n103];
                            int n109 = n107;
                            nArray39[n109] = nArray39[n109] + nArray37[1];
                        }
                        ++n107;
                    }
                    return n2;
                }
                case 56: {
                    int n110 = this.stack.pop();
                    int[] nArray40 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n111 = this.stack.pop();
                        int[] nArray41 = this.x[tTGraphicsState.zp2];
                        int n112 = n111;
                        nArray41[n112] = (int)((double)nArray41[n112] + (double)n110 * TTVM.getDoubleFromF2Dot14(nArray40[0]) / 64.0);
                        int[] nArray42 = this.y[tTGraphicsState.zp2];
                        int n113 = n111;
                        nArray42[n113] = (int)((double)nArray42[n113] + (double)n110 * TTVM.getDoubleFromF2Dot14(nArray40[1]) / 64.0);
                        if (nArray40[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n111][0] = true;
                        }
                        if (nArray40[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n111][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 57: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n114;
                        int n115 = this.stack.pop();
                        if (n115 < 0 || n115 > this.x[tTGraphicsState.zp2].length || tTGraphicsState.rp1 > this.x[tTGraphicsState.zp0].length || tTGraphicsState.rp2 > this.x[tTGraphicsState.zp1].length) {
                            LogWriter.writeLog("Trying to use a point which doesn't exist! (IP, zone " + tTGraphicsState.zp2 + ')');
                            break;
                        }
                        int n116 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        if (n116 == (n114 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]))) continue;
                        int n117 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp2][n115], this.y[2 + tTGraphicsState.zp2][n115]);
                        double d = (double)(n117 - n116) / (double)(n114 - n116);
                        int n118 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        int n119 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                        int n120 = (int)(d * (double)(n119 - n118) + (double)n118 + 0.5) - n117;
                        int[] nArray43 = tTGraphicsState.getFVMoveforPVDistance(n120);
                        int[] nArray44 = this.x[tTGraphicsState.zp2];
                        int n121 = n115;
                        nArray44[n121] = nArray44[n121] + nArray43[0];
                        int[] nArray45 = this.y[tTGraphicsState.zp2];
                        int n122 = n115;
                        nArray45[n122] = nArray45[n122] + nArray43[1];
                        int[] nArray46 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray46[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n115][0] = true;
                        }
                        if (nArray46[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n115][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 58: {
                    int n123 = this.stack.pop();
                    int n124 = this.stack.pop();
                    int[] nArray47 = tTGraphicsState.getFVMoveforPVDistance(n123 - (TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n124], this.y[tTGraphicsState.zp1][n124]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0])));
                    int[] nArray48 = this.x[tTGraphicsState.zp1];
                    int n125 = n124;
                    nArray48[n125] = nArray48[n125] + nArray47[0];
                    int[] nArray49 = this.y[tTGraphicsState.zp1];
                    int n126 = n124;
                    nArray49[n126] = nArray49[n126] + nArray47[1];
                    int[] nArray50 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray50[0] != 0) {
                        this.touched[tTGraphicsState.zp1][n124][0] = true;
                    }
                    if (nArray50[1] != 0) {
                        this.touched[tTGraphicsState.zp1][n124][1] = true;
                    }
                    tTGraphicsState.rp1 = tTGraphicsState.rp0;
                    tTGraphicsState.rp2 = n124;
                    return n2;
                }
                case 59: {
                    int n127 = this.stack.pop();
                    int n128 = this.stack.pop();
                    int[] nArray51 = tTGraphicsState.getFVMoveforPVDistance(n127 - (TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n128], this.y[tTGraphicsState.zp1][n128]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0])));
                    int[] nArray52 = this.x[tTGraphicsState.zp1];
                    int n129 = n128;
                    nArray52[n129] = nArray52[n129] + nArray51[0];
                    int[] nArray53 = this.y[tTGraphicsState.zp1];
                    int n130 = n128;
                    nArray53[n130] = nArray53[n130] + nArray51[1];
                    int[] nArray54 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray54[0] != 0) {
                        this.touched[tTGraphicsState.zp1][n128][0] = true;
                    }
                    if (nArray54[1] != 0) {
                        this.touched[tTGraphicsState.zp1][n128][1] = true;
                    }
                    tTGraphicsState.rp1 = tTGraphicsState.rp0;
                    tTGraphicsState.rp2 = n128;
                    tTGraphicsState.rp0 = n128;
                    return n2;
                }
                case 60: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n131 = this.stack.pop();
                        int n132 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0]);
                        int n133 = n132 - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n131], this.y[tTGraphicsState.zp1][n131]);
                        int[] nArray55 = tTGraphicsState.getFVMoveforPVDistance(n133);
                        int[] nArray56 = this.x[tTGraphicsState.zp1];
                        int n134 = n131;
                        nArray56[n134] = nArray56[n134] + nArray55[0];
                        int[] nArray57 = this.y[tTGraphicsState.zp1];
                        int n135 = n131;
                        nArray57[n135] = nArray57[n135] + nArray55[1];
                        int[] nArray58 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray58[0] != 0) {
                            this.touched[tTGraphicsState.zp1][n131][0] = true;
                        }
                        if (nArray58[1] == 0) continue;
                        this.touched[tTGraphicsState.zp1][n131][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 61: {
                    tTGraphicsState.roundState = 8;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 62: {
                    int n136 = this.stack.pop();
                    int n137 = this.stack.pop();
                    int n138 = this.cvt.get(n136);
                    int n139 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n137], this.y[tTGraphicsState.zp0][n137]);
                    int n140 = n138 - n139;
                    int[] nArray59 = tTGraphicsState.getFVMoveforPVDistance(n140);
                    int[] nArray60 = this.x[tTGraphicsState.zp0];
                    int n141 = n137;
                    nArray60[n141] = nArray60[n141] + nArray59[0];
                    int[] nArray61 = this.y[tTGraphicsState.zp0];
                    int n142 = n137;
                    nArray61[n142] = nArray61[n142] + nArray59[1];
                    int[] nArray62 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray62[0] != 0) {
                        this.touched[tTGraphicsState.zp0][n137][0] = true;
                    }
                    if (nArray62[1] != 0) {
                        this.touched[tTGraphicsState.zp0][n137][1] = true;
                    }
                    tTGraphicsState.rp0 = tTGraphicsState.rp1 = n137;
                    return n2;
                }
                case 63: {
                    int n143 = this.stack.pop();
                    int n144 = this.stack.pop();
                    int n145 = this.cvt.get(n143);
                    int n146 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n144], this.y[tTGraphicsState.zp0][n144]);
                    int n147 = n145 - n146;
                    if (Math.abs(n147) > tTGraphicsState.controlValueTableCutIn) {
                        n145 = n146;
                    }
                    n145 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n145)));
                    n147 = n145 - n146;
                    int[] nArray63 = tTGraphicsState.getFVMoveforPVDistance(n147);
                    int[] nArray64 = this.x[tTGraphicsState.zp0];
                    int n148 = n144;
                    nArray64[n148] = nArray64[n148] + nArray63[0];
                    int[] nArray65 = this.y[tTGraphicsState.zp0];
                    int n149 = n144;
                    nArray65[n149] = nArray65[n149] + nArray63[1];
                    int[] nArray66 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray66[0] != 0) {
                        this.touched[tTGraphicsState.zp0][n144][0] = true;
                    }
                    if (nArray66[1] != 0) {
                        this.touched[tTGraphicsState.zp0][n144][1] = true;
                    }
                    tTGraphicsState.rp0 = tTGraphicsState.rp1 = n144;
                    return n2;
                }
                case 64: {
                    ++n2;
                    return this.readFromIS(nArray[n2], false, n2, nArray);
                }
                case 65: {
                    ++n2;
                    return this.readFromIS(nArray[n2], true, n2, nArray);
                }
                case 66: {
                    int n150 = this.stack.pop();
                    int n151 = this.stack.pop();
                    this.storage[n151] = n150;
                    return n2;
                }
                case 67: {
                    int n152 = this.stack.pop();
                    this.stack.push(this.storage[n152]);
                    return n2;
                }
                case 68: {
                    int n153 = this.stack.pop();
                    int n154 = this.stack.pop();
                    this.cvt.putInPixels(n154, n153);
                    return n2;
                }
                case 69: {
                    int n155 = this.stack.pop();
                    this.stack.push(this.cvt.get(n155));
                    return n2;
                }
                case 70: {
                    int n156 = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp2][n156], this.y[tTGraphicsState.zp2][n156]));
                    return n2;
                }
                case 71: {
                    int n157 = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp2][n157], this.y[2 + tTGraphicsState.zp2][n157]));
                    return n2;
                }
                case 72: {
                    int n158 = this.stack.pop();
                    int n159 = this.stack.pop();
                    int n160 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp2][n159], this.y[tTGraphicsState.zp2][n159]);
                    int n161 = n158 - n160;
                    int[] nArray67 = tTGraphicsState.getFVMoveforPVDistance(n161);
                    int[] nArray68 = this.x[tTGraphicsState.zp2];
                    int n162 = n159;
                    nArray68[n162] = nArray68[n162] + nArray67[0];
                    int[] nArray69 = this.y[tTGraphicsState.zp2];
                    int n163 = n159;
                    nArray69[n163] = nArray69[n163] + nArray67[1];
                    int[] nArray70 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray70[0] != 0) {
                        this.touched[tTGraphicsState.zp2][n159][0] = true;
                    }
                    if (nArray70[1] == 0) return n2;
                    this.touched[tTGraphicsState.zp2][n159][1] = true;
                    return n2;
                }
                case 73: {
                    int n164 = this.stack.pop();
                    int n165 = this.stack.pop();
                    int n166 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n165], this.y[tTGraphicsState.zp1][n165]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n164], this.y[tTGraphicsState.zp0][n164]);
                    this.stack.push(n166);
                    return n2;
                }
                case 74: {
                    int n167 = this.stack.pop();
                    int n168 = this.stack.pop();
                    int n169 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][n168], this.y[2 + tTGraphicsState.zp1][n168]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][n167], this.y[2 + tTGraphicsState.zp0][n167]);
                    this.stack.push(n169);
                    return n2;
                }
                case 75: {
                    int n170 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, (int)(this.ppem * 64.0), (int)(this.ppem * 64.0)) / 64;
                    if (n170 < 0) {
                        n170 = -n170;
                    }
                    this.stack.push(n170);
                    return n2;
                }
                case 76: {
                    this.stack.push((int)(this.ptSize * 64.0));
                    return n2;
                }
                case 77: {
                    tTGraphicsState.autoFlip = true;
                    return n2;
                }
                case 78: {
                    tTGraphicsState.autoFlip = false;
                    return n2;
                }
                case 79: {
                    this.stack.pop();
                    return n2;
                }
                case 80: {
                    int n171 = this.stack.pop();
                    int n172 = this.stack.pop();
                    if (n172 < n171) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 81: {
                    int n173 = this.stack.pop();
                    int n174 = this.stack.pop();
                    if (n174 <= n173) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 82: {
                    int n175 = this.stack.pop();
                    int n176 = this.stack.pop();
                    if (n176 > n175) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 83: {
                    int n177 = this.stack.pop();
                    int n178 = this.stack.pop();
                    if (n178 >= n177) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 84: {
                    int n179 = this.stack.pop();
                    int n180 = this.stack.pop();
                    if (n180 == n179) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 85: {
                    int n181 = this.stack.pop();
                    int n182 = this.stack.pop();
                    if (n182 != n181) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 86: {
                    int n183 = this.stack.pop();
                    n183 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n183)));
                    n183 = (n183 >> 6) % 2;
                    this.stack.push(n183);
                    return n2;
                }
                case 87: {
                    int n184 = this.stack.pop();
                    n184 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n184)));
                    n184 = ((n184 >> 6) + 1) % 2;
                    this.stack.push(n184);
                    return n2;
                }
                case 88: {
                    boolean bl = this.stack.pop() != 0;
                    if (bl) return n2;
                    int n185 = 0;
                    int n186 = 0;
                    do {
                        if (n185 == 89 && n186 != 0) {
                            --n186;
                        }
                        if ((n185 = nArray[++n2]) == 88) {
                            ++n186;
                        }
                        if (n185 == 64) {
                            ++n2;
                            n2 += nArray[n2];
                            continue;
                        }
                        if (n185 == 65) {
                            ++n2;
                            n2 += nArray[n2] * 2;
                            continue;
                        }
                        if (n185 >= 176 && n185 <= 183) {
                            n2 += n185 + 1 - 176;
                            continue;
                        }
                        if (n185 < 184 || n185 > 191) continue;
                        n2 += (n185 + 1 - 184) * 2;
                    } while (n185 != 27 && n185 != 89 || n186 != 0);
                    return n2;
                }
                case 89: {
                    return n2;
                }
                case 90: {
                    boolean bl;
                    boolean bl2 = this.stack.pop() != 0;
                    boolean bl3 = bl = this.stack.pop() != 0;
                    if (bl && bl2) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 91: {
                    boolean bl;
                    boolean bl4 = this.stack.pop() != 0;
                    boolean bl5 = bl = this.stack.pop() != 0;
                    if (bl || bl4) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 92: {
                    boolean bl;
                    boolean bl6 = bl = this.stack.pop() != 0;
                    if (!bl) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 93: {
                    int n187 = this.stack.pop();
                    int n188 = 0;
                    while (n188 < n187) {
                        int n189 = this.stack.pop();
                        int n190 = this.stack.pop();
                        int n191 = tTGraphicsState.deltaBase + (n190 >> 4);
                        if ((double)n191 == this.ppem) {
                            int n192 = (n190 & 0xF) - 7;
                            if (n192 <= 0) {
                                --n192;
                            }
                            int n193 = TTVM.storeDoubleAsF26Dot6((double)n192 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int[] nArray71 = tTGraphicsState.getFVMoveforPVDistance(n193);
                            int[] nArray72 = this.x[tTGraphicsState.zp0];
                            int n194 = n189;
                            nArray72[n194] = nArray72[n194] + nArray71[0];
                            int[] nArray73 = this.y[tTGraphicsState.zp0];
                            int n195 = n189;
                            nArray73[n195] = nArray73[n195] + nArray71[1];
                            int[] nArray74 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                            if (nArray74[0] != 0) {
                                this.touched[tTGraphicsState.zp0][n189][0] = true;
                            }
                            if (nArray74[1] != 0) {
                                this.touched[tTGraphicsState.zp0][n189][1] = true;
                            }
                        }
                        ++n188;
                    }
                    return n2;
                }
                case 94: {
                    tTGraphicsState.deltaBase = this.stack.pop();
                    return n2;
                }
                case 95: {
                    tTGraphicsState.deltaShift = this.stack.pop();
                    return n2;
                }
                case 96: {
                    this.stack.push(this.stack.pop() + this.stack.pop());
                    return n2;
                }
                case 97: {
                    int n196 = this.stack.pop();
                    int n197 = this.stack.pop();
                    this.stack.push(n197 - n196);
                    return n2;
                }
                case 98: {
                    int n198 = this.stack.pop();
                    int n199 = this.stack.pop();
                    if (n198 != 0) {
                        this.stack.push(n199 * 64 / n198);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 99: {
                    int n200 = this.stack.pop();
                    int n201 = this.stack.pop();
                    this.stack.push(n200 * n201 / 64);
                    return n2;
                }
                case 100: {
                    int n202 = this.stack.pop();
                    if (n202 < 0) {
                        n202 = -n202;
                    }
                    this.stack.push(n202);
                    return n2;
                }
                case 101: {
                    this.stack.push(-this.stack.pop());
                    return n2;
                }
                case 102: {
                    this.stack.push(this.stack.pop() >> 6 << 6);
                    return n2;
                }
                case 103: {
                    int n203 = this.stack.pop();
                    if ((n203 & 0x3F) != 0) {
                        n203 = (n203 >> 6) + 1 << 6;
                    }
                    this.stack.push(n203);
                    return n2;
                }
                case 104: {
                    int n204 = this.stack.pop();
                    n204 = TTVM.engineCompensation(n204, 0);
                    double d = TTVM.getDoubleFromF26Dot6(n204);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 105: {
                    int n205 = this.stack.pop();
                    n205 = TTVM.engineCompensation(n205, 1);
                    double d = TTVM.getDoubleFromF26Dot6(n205);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 106: {
                    int n206 = this.stack.pop();
                    n206 = TTVM.engineCompensation(n206, 2);
                    double d = TTVM.getDoubleFromF26Dot6(n206);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 107: {
                    int n207 = this.stack.pop();
                    n207 = TTVM.engineCompensation(n207, 3);
                    double d = TTVM.getDoubleFromF26Dot6(n207);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 108: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 0));
                    return n2;
                }
                case 109: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 1));
                    return n2;
                }
                case 110: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 2));
                    return n2;
                }
                case 111: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 3));
                    return n2;
                }
                case 112: {
                    int n208 = this.stack.pop();
                    int n209 = this.stack.pop();
                    this.cvt.putInFUnits(n209, n208);
                    return n2;
                }
                case 113: {
                    int n210 = this.stack.pop();
                    int n211 = 0;
                    while (n211 < n210) {
                        int n212 = this.stack.pop();
                        int n213 = this.stack.pop();
                        int n214 = tTGraphicsState.deltaBase + 16 + (n213 >> 4);
                        if ((double)n214 == this.ppem) {
                            int n215 = (n213 & 0xF) - 7;
                            if (n215 <= 0) {
                                --n215;
                            }
                            int n216 = TTVM.storeDoubleAsF26Dot6((double)n215 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int[] nArray75 = tTGraphicsState.getFVMoveforPVDistance(n216);
                            int[] nArray76 = this.x[tTGraphicsState.zp0];
                            int n217 = n212;
                            nArray76[n217] = nArray76[n217] + nArray75[0];
                            int[] nArray77 = this.y[tTGraphicsState.zp0];
                            int n218 = n212;
                            nArray77[n218] = nArray77[n218] + nArray75[1];
                            int[] nArray78 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                            if (nArray78[0] != 0) {
                                this.touched[tTGraphicsState.zp0][n212][0] = true;
                            }
                            if (nArray78[1] != 0) {
                                this.touched[tTGraphicsState.zp0][n212][1] = true;
                            }
                        }
                        ++n211;
                    }
                    return n2;
                }
                case 114: {
                    int n219 = this.stack.pop();
                    int n220 = 0;
                    while (n220 < n219) {
                        int n221 = this.stack.pop();
                        int n222 = this.stack.pop();
                        int n223 = tTGraphicsState.deltaBase + 32 + (n222 >> 4);
                        if ((double)n223 == this.ppem) {
                            int n224 = (n222 & 0xF) - 7;
                            if (n224 <= 0) {
                                --n224;
                            }
                            int n225 = TTVM.storeDoubleAsF26Dot6((double)n224 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int[] nArray79 = tTGraphicsState.getFVMoveforPVDistance(n225);
                            int[] nArray80 = this.x[tTGraphicsState.zp0];
                            int n226 = n221;
                            nArray80[n226] = nArray80[n226] + nArray79[0];
                            int[] nArray81 = this.y[tTGraphicsState.zp0];
                            int n227 = n221;
                            nArray81[n227] = nArray81[n227] + nArray79[1];
                            int[] nArray82 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                            if (nArray82[0] != 0) {
                                this.touched[tTGraphicsState.zp0][n221][0] = true;
                            }
                            if (nArray82[1] != 0) {
                                this.touched[tTGraphicsState.zp0][n221][1] = true;
                            }
                        }
                        ++n220;
                    }
                    return n2;
                }
                case 115: {
                    int n228 = this.stack.pop();
                    int n229 = 0;
                    while (n229 < n228) {
                        int n230 = this.stack.pop();
                        int n231 = this.stack.pop();
                        int n232 = tTGraphicsState.deltaBase + (n231 >> 4);
                        if ((double)n232 == this.ppem) {
                            int n233 = (n231 & 0xF) - 7;
                            if (n233 <= 0) {
                                --n233;
                            }
                            int n234 = TTVM.storeDoubleAsF26Dot6((double)n233 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int n235 = this.cvt.get(n230);
                            this.cvt.putInPixels(n230, n235 += n234);
                        }
                        ++n229;
                    }
                    return n2;
                }
                case 116: {
                    int n236 = this.stack.pop();
                    int n237 = 0;
                    while (n237 < n236) {
                        int n238 = this.stack.pop();
                        int n239 = this.stack.pop();
                        int n240 = tTGraphicsState.deltaBase + 16 + (n239 >> 4);
                        if ((double)n240 == this.ppem) {
                            int n241 = (n239 & 0xF) - 7;
                            if (n241 <= 0) {
                                --n241;
                            }
                            int n242 = TTVM.storeDoubleAsF26Dot6((double)n241 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int n243 = this.cvt.get(n238);
                            this.cvt.putInPixels(n238, n243 += n242);
                        }
                        ++n237;
                    }
                    return n2;
                }
                case 117: {
                    int n244 = this.stack.pop();
                    int n245 = 0;
                    while (n245 < n244) {
                        int n246 = this.stack.pop();
                        int n247 = this.stack.pop();
                        int n248 = tTGraphicsState.deltaBase + 32 + (n247 >> 4);
                        if ((double)n248 == this.ppem) {
                            int n249 = (n247 & 0xF) - 7;
                            if (n249 <= 0) {
                                --n249;
                            }
                            int n250 = TTVM.storeDoubleAsF26Dot6((double)n249 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int n251 = this.cvt.get(n246);
                            this.cvt.putInPixels(n246, n251 += n250);
                        }
                        ++n245;
                    }
                    return n2;
                }
                case 118: {
                    tTGraphicsState.roundState = this.stack.pop();
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 119: {
                    tTGraphicsState.roundState = this.stack.pop();
                    tTGraphicsState.gridPeriod = 0.7071067811865476;
                    return n2;
                }
                case 120: {
                    boolean bl = this.stack.pop() != 0;
                    int n252 = this.stack.pop();
                    if (!bl) return n2;
                    return n2 + n252 - 1;
                }
                case 121: {
                    boolean bl = this.stack.pop() != 0;
                    int n253 = this.stack.pop();
                    if (bl) return n2;
                    return n2 + n253 - 1;
                }
                case 122: {
                    tTGraphicsState.roundState = -1;
                    return n2;
                }
                case 124: {
                    tTGraphicsState.roundState = 64;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 125: {
                    tTGraphicsState.roundState = 68;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 126: {
                    this.stack.pop();
                    return n2;
                }
                case 127: {
                    this.stack.pop();
                    return n2;
                }
                case 128: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n254 = this.stack.pop();
                        this.curve[tTGraphicsState.zp0][n254] = !this.curve[tTGraphicsState.zp0][n254];
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 129: {
                    int n255;
                    int n256 = this.stack.pop();
                    int n257 = n255 = this.stack.pop();
                    while (n257 <= n256) {
                        this.curve[tTGraphicsState.zp0][n257] = true;
                        ++n257;
                    }
                    return n2;
                }
                case 130: {
                    int n258;
                    int n259 = this.stack.pop();
                    int n260 = n258 = this.stack.pop();
                    while (n260 <= n259) {
                        this.curve[tTGraphicsState.zp0][n260] = false;
                        ++n260;
                    }
                    return n2;
                }
                case 133: {
                    this.stack.pop();
                    return n2;
                }
                case 134: {
                    int n261 = this.stack.pop();
                    int n262 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n261] - this.x[tTGraphicsState.zp1][n262]);
                    double d16 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n261] - this.y[tTGraphicsState.zp1][n262]);
                    double d17 = TTVM.getDoubleFromF26Dot6(this.x[2 + tTGraphicsState.zp2][n261] - this.x[2 + tTGraphicsState.zp1][n262]);
                    double d18 = TTVM.getDoubleFromF26Dot6(this.y[2 + tTGraphicsState.zp2][n261] - this.y[2 + tTGraphicsState.zp1][n262]);
                    double d19 = Math.sqrt(d * d + d16 * d16);
                    double d20 = Math.sqrt(d17 * d17 + d18 * d18);
                    tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d /= d19), TTVM.storeDoubleAsF2Dot14(d16 /= d19));
                    tTGraphicsState.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d17 /= d20), TTVM.storeDoubleAsF2Dot14(d18 /= d20));
                    return n2;
                }
                case 135: {
                    int n263 = this.stack.pop();
                    int n264 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n263] - this.x[tTGraphicsState.zp1][n264]);
                    double d21 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n263] - this.y[tTGraphicsState.zp1][n264]);
                    double d22 = TTVM.getDoubleFromF26Dot6(this.x[2 + tTGraphicsState.zp2][n263] - this.x[2 + tTGraphicsState.zp1][n264]);
                    double d23 = TTVM.getDoubleFromF26Dot6(this.y[2 + tTGraphicsState.zp2][n263] - this.y[2 + tTGraphicsState.zp1][n264]);
                    double d24 = Math.sqrt(d * d + d21 * d21);
                    double d25 = Math.sqrt(d22 * d22 + d23 * d23);
                    tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d21 /= d24), TTVM.storeDoubleAsF2Dot14(-(d /= d24)));
                    tTGraphicsState.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d23 /= d25), TTVM.storeDoubleAsF2Dot14(-(d22 /= d25)));
                    return n2;
                }
                case 136: {
                    int n265 = this.stack.pop();
                    int n266 = 0;
                    if ((n265 & 1) == 1) {
                        n266 += 3;
                    }
                    this.stack.push(n266);
                    return n2;
                }
                case 137: {
                    int n267;
                    int n268 = this.stack.pop();
                    int n269 = n2;
                    while ((n267 = nArray[++n2]) != 45) {
                    }
                    int n270 = n2 - n269 - 1;
                    n2 = n269;
                    int[] nArray83 = new int[n270];
                    for (int i = 0; i < n270; ++i) {
                        nArray83[i] = nArray[++n2];
                    }
                    this.instructions.put(n268, nArray83);
                    ++n2;
                    return n2;
                }
                case 138: {
                    int n271 = this.stack.pop();
                    int n272 = this.stack.pop();
                    int n273 = this.stack.pop();
                    this.stack.push(n272);
                    this.stack.push(n271);
                    this.stack.push(n273);
                    return n2;
                }
                case 139: {
                    int n274 = this.stack.pop();
                    int n275 = this.stack.pop();
                    if (n274 > n275) {
                        this.stack.push(n274);
                        return n2;
                    }
                    this.stack.push(n275);
                    return n2;
                }
                case 140: {
                    int n276 = this.stack.pop();
                    int n277 = this.stack.pop();
                    if (n276 < n277) {
                        this.stack.push(n276);
                        return n2;
                    }
                    this.stack.push(n277);
                    return n2;
                }
                case 141: {
                    this.stack.pop();
                    return n2;
                }
                case 142: {
                    int n278 = this.stack.pop();
                    int n279 = this.stack.pop();
                    if (n278 == 1) {
                        tTGraphicsState.instructControl = n279;
                        return n2;
                    }
                    if (n278 != 2) return n2;
                    this.useDefaultGS = n279 == 2;
                    return n2;
                }
                case 176: {
                    if (!this.printOut) return this.readFromIS(n4, false, n2, nArray);
                    System.out.println("PUSHB1    - Push bytes from IS to stack");
                    return this.readFromIS(n4, false, n2, nArray);
                }
                case 184: {
                    if (!this.printOut) return this.readFromIS(n4, true, n2, nArray);
                    System.out.println("PUSHW1    - Push words from IS to stack");
                    return this.readFromIS(n4, true, n2, nArray);
                }
                default: {
                    if (n >= 192 && n < 224) {
                        int n280 = n - 192;
                        if (this.printOut) {
                            System.out.println("MDRP      - Move direct relative point (" + Integer.toBinaryString(n280) + ')');
                        }
                        boolean bl = false;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        if ((n280 & 0x10) == 16) {
                            bl = true;
                        }
                        if ((n280 & 8) == 8) {
                            bl7 = true;
                        }
                        if ((n280 & 4) == 4) {
                            bl8 = true;
                        }
                        int n281 = n280 & 3;
                        int n282 = this.stack.pop();
                        int n283 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][n282], this.y[2 + tTGraphicsState.zp1][n282]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp0]);
                        if (Math.abs(n283) < tTGraphicsState.singleWidthCutIn) {
                            n283 = n283 > 0 ? tTGraphicsState.singleWidthValue : -tTGraphicsState.singleWidthValue;
                        }
                        n283 = TTVM.engineCompensation(n283, n281);
                        if (bl8) {
                            n283 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n283)));
                        }
                        if (bl7 && Math.abs(n283) < tTGraphicsState.minimumDistance) {
                            n283 = n283 < 0 ? -tTGraphicsState.minimumDistance : tTGraphicsState.minimumDistance;
                        }
                        int n284 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0]) + n283;
                        int n285 = n284 - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n282], this.y[tTGraphicsState.zp1][n282]);
                        int[] nArray84 = tTGraphicsState.getFVMoveforPVDistance(n285);
                        int[] nArray85 = this.x[tTGraphicsState.zp1];
                        int n286 = n282;
                        nArray85[n286] = nArray85[n286] + nArray84[0];
                        int[] nArray86 = this.y[tTGraphicsState.zp1];
                        int n287 = n282;
                        nArray86[n287] = nArray86[n287] + nArray84[1];
                        int[] nArray87 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray87[0] != 0) {
                            this.touched[tTGraphicsState.zp1][n282][0] = true;
                        }
                        if (nArray87[1] != 0) {
                            this.touched[tTGraphicsState.zp1][n282][1] = true;
                        }
                        tTGraphicsState.rp1 = tTGraphicsState.rp0;
                        tTGraphicsState.rp2 = n282;
                        if (!bl) return n2;
                        tTGraphicsState.rp0 = n282;
                        return n2;
                    }
                    if (n >= 224 && n <= 255) {
                        int n288 = n - 224;
                        if (this.printOut) {
                            System.out.println("MIRP      - Move Indirect Relative Point(" + Integer.toBinaryString(n288) + ')');
                        }
                        boolean bl = false;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        if ((n288 & 0x10) == 16) {
                            bl = true;
                        }
                        if ((n288 & 8) == 8) {
                            bl9 = true;
                        }
                        if ((n288 & 4) == 4) {
                            bl10 = true;
                        }
                        int n289 = n288 & 3;
                        int n290 = this.cvt.get(this.stack.pop());
                        int n291 = this.stack.pop();
                        int n292 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][n291], this.y[2 + tTGraphicsState.zp1][n291]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp0]);
                        if (Math.abs(n292 - tTGraphicsState.singleWidthValue) < tTGraphicsState.singleWidthCutIn) {
                            n292 = tTGraphicsState.singleWidthValue;
                        }
                        if (bl10) {
                            if (tTGraphicsState.autoFlip && (n292 < 0 && n290 > 0 || n292 > 0 && n290 < 0)) {
                                n290 = -n290;
                            }
                            if (Math.abs(n292 - n290) < tTGraphicsState.controlValueTableCutIn) {
                                n292 = n290;
                            }
                        }
                        n292 = TTVM.engineCompensation(n292, n289);
                        if (bl10) {
                            n292 = tTGraphicsState.round(n292);
                        }
                        if (bl9 && Math.abs(n292) < tTGraphicsState.minimumDistance) {
                            n292 = n292 > 0 ? tTGraphicsState.minimumDistance : -tTGraphicsState.minimumDistance;
                        }
                        int n293 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0]) + n292;
                        int n294 = n293 - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n291], this.y[tTGraphicsState.zp1][n291]);
                        int[] nArray88 = tTGraphicsState.getFVMoveforPVDistance(n294);
                        int[] nArray89 = this.x[tTGraphicsState.zp1];
                        int n295 = n291;
                        nArray89[n295] = nArray89[n295] + nArray88[0];
                        int[] nArray90 = this.y[tTGraphicsState.zp1];
                        int n296 = n291;
                        nArray90[n296] = nArray90[n296] + nArray88[1];
                        int[] nArray91 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray91[0] != 0) {
                            this.touched[tTGraphicsState.zp1][n291][0] = true;
                        }
                        if (nArray91[1] != 0) {
                            this.touched[tTGraphicsState.zp1][n291][1] = true;
                        }
                        tTGraphicsState.rp1 = tTGraphicsState.rp0;
                        tTGraphicsState.rp2 = n291;
                        if (!bl) return n2;
                        tTGraphicsState.rp0 = n291;
                        return n2;
                    }
                    if (this.instructions.containsKey(n)) {
                        if (this.printOut) {
                            System.out.println("I 0x" + Integer.toHexString(n) + "    - Custom Instruction");
                        }
                        this.execute(this.instructions.get(n), tTGraphicsState);
                        if (!this.printOut) return n2;
                        System.out.println("I 0x" + Integer.toHexString(n) + " finished");
                        return n2;
                    }
                    if (!LogWriter.isRunningFromIDE) return n2;
                    System.out.println("Unknown truetype opcode 0x" + Integer.toHexString(n) + " at line " + n2);
                }
            }
            return n2;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage() + " at line " + n2 + "- hinting turned off");
            BaseTTGlyph.useHinting = false;
            BaseTTGlyph.redecodePage = true;
        }
        return n2;
    }

    private void interpolateUntouchedPoints(int n) {
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2;
        boolean[] blArray = new boolean[this.touched[1].length];
        if (n == 49) {
            nArray2 = this.x[1];
            nArray = this.x[3];
            for (n3 = 0; n3 < this.touched[1].length; ++n3) {
                blArray[n3] = this.touched[1][n3][0];
            }
        } else {
            nArray2 = this.y[1];
            nArray = this.y[3];
            for (n3 = 0; n3 < this.touched[1].length; ++n3) {
                blArray[n3] = this.touched[1][n3][1];
            }
        }
        for (n3 = 0; n3 < nArray2.length; n3 += n2) {
            int n4;
            int[] nArray3 = new int[nArray.length];
            int n5 = 0;
            n2 = 0;
            do {
                if (!blArray[n3 + n2]) continue;
                nArray3[n5] = n3 + n2;
                ++n5;
            } while (!this.contour[1][n3 + ++n2 - 1] && n3 + n2 < this.contour[1].length);
            if (n5 == 1) {
                n4 = nArray2[nArray3[0]] - nArray[nArray3[0]];
                for (int i = n3; i < n3 + n2; ++i) {
                    if (blArray[i]) continue;
                    int n6 = i;
                    nArray2[n6] = nArray2[n6] + n4;
                }
                continue;
            }
            if (n5 <= 1) continue;
            for (n4 = 0; n4 < n5; ++n4) {
                if (n4 + 1 >= n5) {
                    TTVM.interpolateRange(nArray3[n4] + 1, n3 + n2 - 1, nArray3[n4], nArray3[0], nArray2, nArray);
                    TTVM.interpolateRange(n3, nArray3[0] - 1, nArray3[n4], nArray3[0], nArray2, nArray);
                    continue;
                }
                TTVM.interpolateRange(nArray3[n4] + 1, nArray3[n4 + 1] - 1, nArray3[n4], nArray3[n4 + 1], nArray2, nArray);
            }
        }
    }

    private static void interpolateRange(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5;
        int n6;
        if (nArray2[n4] < nArray2[n3]) {
            n6 = n4;
            n5 = n3;
        } else {
            n6 = n3;
            n5 = n4;
        }
        for (int i = n; i <= n2; ++i) {
            if (nArray2[i] < nArray2[n6]) {
                int n7 = i;
                nArray[n7] = nArray[n7] + (nArray[n6] - nArray2[n6]);
                continue;
            }
            if (nArray2[i] > nArray2[n5]) {
                int n8 = i;
                nArray[n8] = nArray[n8] + (nArray[n5] - nArray2[n5]);
                continue;
            }
            double d = (double)(nArray2[i] - nArray2[n6]) / (double)(nArray2[n5] - nArray2[n6]);
            nArray[i] = nArray[n6] + (int)(d * (double)(nArray[n5] - nArray[n6]));
        }
    }

    private static int engineCompensation(int n, int n2) {
        return n;
    }

    private int readFromIS(int n, boolean bl, int n2, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            int n3;
            ++n2;
            if (!bl) {
                n3 = nArray[n2];
            } else {
                int n4 = nArray[n2];
                int n5 = nArray[++n2];
                n3 = TTVM.getIntFrom2Uint8(n4, n5);
            }
            this.stack.push(n3);
        }
        return n2;
    }

    protected static int getIntFrom2Uint8(int n, int n2) {
        return (n << 8) + n2 + (n >> 7 & 1) * -65536;
    }

    protected static double getDoubleFromF26Dot6(int n) {
        return (double)n / 64.0;
    }

    protected static double getDoubleFromF2Dot14(int n) {
        return (double)n / 16384.0;
    }

    protected static int storeDoubleAsF26Dot6(double d) {
        return (int)(d * 64.0 + 0.5);
    }

    protected static int storeDoubleAsF2Dot14(double d) {
        return (int)(d * 16384.0 + 0.5);
    }

    private static int[] readProgramTable(FontFile2 fontFile2, int n) {
        int[] nArray = new int[]{};
        int n2 = fontFile2.selectTable(n);
        if (n2 == 0) {
            LogWriter.writeLog("No program table found: " + n);
        } else {
            int n3 = fontFile2.getOffset(n);
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = fontFile2.getNextUint8();
            }
        }
        return nArray;
    }

    private void runDebugger() {
        if (this.programToDebug == null) {
            JOptionPane.showMessageDialog(this.debugWindow, "No glyph program found to debug!");
            return;
        }
        this.debugWindow = new JFrame("TrueType Hinting Debugger");
        this.debugWindow.setSize(1000, 700);
        this.debugWindow.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JButton jButton = new JButton("Step Over");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTVM.this.advanceDebugger(false);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Step Into");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTVM.this.advanceDebugger(true);
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Step Out");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTVM.this.runDebuggerTo(TTVM.this.programToDebug.length);
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = new JButton("Restart");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTVM.this.restartDebugger();
                TTVM.this.refreshDebugger(true);
            }
        });
        jPanel.add(jButton4);
        JButton jButton5 = new JButton("Back");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTVM.this.runDebuggerTo(TTVM.this.debugPointer - 1);
            }
        });
        jPanel.add(jButton5);
        this.debugWindow.add("North", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new LineBorder(Color.BLACK));
        currentInstructionList = new JList();
        JScrollPane jScrollPane = new JScrollPane(currentInstructionList){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = this.getMinimumSize();
                int n = dimension.width < dimension2.width ? dimension2.width : dimension.width;
                int n2 = dimension.height < dimension2.height ? dimension2.height : dimension.height;
                return new Dimension(n, n2);
            }
        };
        jScrollPane.setMinimumSize(new Dimension(150, 100));
        this.currentCode = new JLabel("Glyph program");
        jPanel2.add("Center", jScrollPane);
        jPanel2.add("South", this.currentCode);
        this.debugWindow.add("West", jPanel2);
        final JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new LineBorder(Color.BLACK));
        this.debugGlyphDisplay = new JComponent(){

            @Override
            public void paint(Graphics graphics) {
                Object object;
                Object object2;
                int n;
                int n2;
                int n3;
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n4 = this.getWidth();
                int n5 = this.getHeight();
                int n6 = Integer.MAX_VALUE;
                int n7 = Integer.MAX_VALUE;
                int n8 = Integer.MIN_VALUE;
                int n9 = Integer.MIN_VALUE;
                for (n3 = 0; n3 < TTVM.this.x[1].length; ++n3) {
                    n2 = TTVM.this.x[1][n3];
                    if (n2 > n8) {
                        n8 = n2;
                    }
                    if (n2 < n6) {
                        n6 = n2;
                    }
                    if ((n2 = TTVM.this.y[1][n3]) > n9) {
                        n9 = n2;
                    }
                    if (n2 >= n7) continue;
                    n7 = n2;
                }
                n3 = n8 - n6;
                double d = (double)n4 / (double)n3;
                n2 = n9 - n7;
                double d2 = (double)n5 / (double)n2;
                double d3 = d < d2 ? d : d2;
                n6 = (int)((double)n6 - 15.0 / d3);
                n8 = (int)((double)n8 + 15.0 / d3);
                n7 = (int)((double)n7 - 15.0 / d3);
                n9 = (int)((double)n9 + 15.0 / d3);
                n3 = n8 - n6;
                n2 = n9 - n7;
                d = (double)n4 / (double)n3;
                d2 = (double)n5 / (double)n2;
                d3 = d < d2 ? d : d2;
                graphics2D.translate(0, n5);
                graphics2D.scale(d3, -d3);
                graphics2D.translate(-n6, -n7);
                graphics2D.setPaint(Color.WHITE);
                graphics2D.fillRect(n6, n7, (int)((double)n4 / d3), (int)((double)n5 / d3));
                graphics2D.setPaint(new Color(180, 180, 255));
                graphics2D.drawLine(0, n7, 0, (int)((double)n5 / d3));
                graphics2D.drawLine(n6, 0, (int)((double)n4 / d3), 0);
                int n10 = (int)(3.0 / d3);
                for (n = 0; n < TTVM.this.x[1].length; ++n) {
                    int n11 = TTVM.this.x[1][n];
                    int n12 = TTVM.this.y[1][n];
                    if (TTVM.this.curve[1][n]) {
                        graphics2D.setPaint(Color.BLACK);
                        object2 = new Ellipse2D.Double((double)n11 - 2.0 / d3, (double)n12 - 2.0 / d3, 4.0 / d3, 4.0 / d3);
                        graphics2D.fill((Shape)object2);
                    } else {
                        graphics2D.setPaint(Color.RED);
                        graphics2D.drawLine(n11 - n10, n12 - n10, n11 + n10, n12 + n10);
                        graphics2D.drawLine(n11 + n10, n12 - n10, n11 - n10, n12 + n10);
                    }
                    object2 = graphics2D.getTransform();
                    graphics2D.translate(n11, n12);
                    graphics2D.scale(1.0 / d3, -1.0 / d3);
                    graphics2D.drawString(String.valueOf(n), 3, -3);
                    graphics2D.setTransform((AffineTransform)object2);
                }
                if (TTVM.this.showInterpolatedShadow.isSelected()) {
                    n = TTVM.this.x[1].length;
                    int[] nArray = new int[n];
                    System.arraycopy(TTVM.this.x[1], 0, nArray, 0, n);
                    int[] nArray2 = new int[n];
                    System.arraycopy(TTVM.this.y[1], 0, nArray2, 0, n);
                    object2 = new boolean[n];
                    System.arraycopy(TTVM.this.curve[1], 0, object2, 0, n);
                    object = new boolean[n];
                    System.arraycopy(TTVM.this.contour[1], 0, object, 0, n);
                    TTVM.this.interpolateUntouchedPoints(48);
                    TTVM.this.interpolateUntouchedPoints(49);
                    GeneralPath generalPath = TTVM.getPathFromPoints(TTVM.this.x[1], TTVM.this.y[1], TTVM.this.curve[1], TTVM.this.contour[1]);
                    graphics2D.setPaint(new Color(255, 0, 0, 100));
                    graphics2D.draw(generalPath);
                    graphics2D.setPaint(new Color(0, 0, 0, 30));
                    graphics2D.fill(generalPath);
                    System.arraycopy(nArray, 0, TTVM.this.x[1], 0, n);
                    System.arraycopy(nArray2, 0, TTVM.this.y[1], 0, n);
                    System.arraycopy(object2, 0, TTVM.this.curve[1], 0, n);
                    System.arraycopy(object, 0, TTVM.this.contour[1], 0, n);
                }
                GeneralPath generalPath = TTVM.getPathFromPoints(TTVM.this.x[1], TTVM.this.y[1], TTVM.this.curve[1], TTVM.this.contour[1]);
                graphics2D.setPaint(new Color(100, 100, 255, 100));
                graphics2D.fill(generalPath);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.draw(generalPath);
                graphics2D.setPaint(Color.BLUE);
                for (int i = 0; i < TTVM.this.x[0].length; ++i) {
                    int n13 = TTVM.this.x[0][i];
                    int n14 = TTVM.this.y[0][i];
                    if (n13 == 0 && n14 == 0) continue;
                    if (TTVM.this.curve[0][i]) {
                        object = new Ellipse2D.Double((double)n13 - 2.0 / d3, (double)n14 - 2.0 / d3, 4.0 / d3, 4.0 / d3);
                        graphics2D.fill((Shape)object);
                    } else {
                        graphics2D.drawLine(n13 - n10, n14 - n10, n13 + n10, n14 + n10);
                        graphics2D.drawLine(n13 + n10, n14 - n10, n13 - n10, n14 + n10);
                    }
                    object = graphics2D.getTransform();
                    graphics2D.translate(n13, n14);
                    graphics2D.scale(1.0 / d3, -1.0 / d3);
                    graphics2D.drawString(String.valueOf(i), 3, -3);
                    graphics2D.setTransform((AffineTransform)object);
                }
            }
        };
        this.debugGlyphDisplay.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n;
                int n2;
                double d = mouseEvent.getX();
                double d2 = mouseEvent.getY();
                int n3 = TTVM.this.debugGlyphDisplay.getWidth();
                int n4 = TTVM.this.debugGlyphDisplay.getHeight();
                int n5 = Integer.MAX_VALUE;
                int n6 = Integer.MAX_VALUE;
                int n7 = Integer.MIN_VALUE;
                int n8 = Integer.MIN_VALUE;
                for (n2 = 0; n2 < TTVM.this.x[1].length; ++n2) {
                    n = TTVM.this.x[1][n2];
                    if (n > n7) {
                        n7 = n;
                    }
                    if (n < n5) {
                        n5 = n;
                    }
                    if ((n = TTVM.this.y[1][n2]) > n8) {
                        n8 = n;
                    }
                    if (n >= n6) continue;
                    n6 = n;
                }
                n2 = n7 - n5;
                double d3 = (double)n3 / (double)n2;
                n = n8 - n6;
                double d4 = (double)n4 / (double)n;
                double d5 = d3 < d4 ? d3 : d4;
                n5 = (int)((double)n5 - 15.0 / d5);
                n7 = (int)((double)n7 + 15.0 / d5);
                n6 = (int)((double)n6 - 15.0 / d5);
                n8 = (int)((double)n8 + 15.0 / d5);
                n2 = n7 - n5;
                n = n8 - n6;
                d3 = (double)n3 / (double)n2;
                d4 = (double)n4 / (double)n;
                d5 = d3 < d4 ? d3 : d4;
                d = d / d5 + (double)n5;
                d2 = (double)n4 - d2;
                d2 = d2 / d5 + (double)n6;
                TTVM.this.debugXLabel.setText("  X: " + d);
                TTVM.this.debugYLabel.setText("  Y: " + d2);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TTVM.this.debugXLabel.setText("  X: ");
                TTVM.this.debugYLabel.setText("  Y: ");
            }
        });
        jPanel3.add("Center", this.debugGlyphDisplay);
        this.showInterpolatedShadow = new JCheckBox("Show Interpolated Shadow");
        this.showInterpolatedShadow.setSelected(true);
        this.showInterpolatedShadow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jPanel3.repaint();
            }
        });
        jPanel3.add("North", this.showInterpolatedShadow);
        this.debugWindow.add("Center", jPanel3);
        JPanel jPanel4 = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = this.getMinimumSize();
                Dimension dimension3 = this.getMaximumSize();
                int n = dimension.width < dimension2.width ? dimension2.width : dimension.width;
                int n2 = dimension.height < dimension2.height ? dimension2.height : dimension.height;
                n = n > dimension3.width ? dimension3.width : n;
                n2 = n2 > dimension3.height ? dimension3.height : n2;
                return new Dimension(n, n2);
            }
        };
        jPanel4.setMinimumSize(new Dimension(200, 100));
        jPanel4.setMaximumSize(new Dimension(200, 1000000));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new LineBorder(Color.BLACK));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        stackList = new JList();
        JScrollPane jScrollPane2 = new JScrollPane(stackList);
        jPanel5.add("North", new JLabel("Stack:"));
        jPanel5.add("Center", jScrollPane2);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        cvtList = new JList<String>(this.cvt.getCVTForDebug());
        JScrollPane jScrollPane3 = new JScrollPane(cvtList);
        jPanel6.add("North", new JLabel("CVT:"));
        jPanel6.add("Center", jScrollPane3);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        storageList = new JList<String>(this.getStorageAsArray());
        JScrollPane jScrollPane4 = new JScrollPane(storageList);
        jPanel7.add("North", new JLabel("Storage:"));
        jPanel7.add("Center", jScrollPane4);
        jPanel4.add("North", jPanel5);
        jPanel4.add("Center", jPanel6);
        jPanel4.add("South", jPanel7);
        this.debugWindow.add("East", jPanel4);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setBorder(new LineBorder(Color.BLACK));
        this.stateDisplay = new JComponent(){

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(Color.WHITE);
                graphics2D.fillRect(0, 0, 81, 81);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.drawRect(0, 0, 81, 81);
                graphics2D.setPaint(Color.GRAY);
                graphics2D.drawOval(0, 0, 81, 81);
                graphics2D.drawLine(0, 40, 5, 40);
                graphics2D.drawLine(81, 40, 76, 40);
                graphics2D.drawLine(40, 0, 40, 5);
                graphics2D.drawLine(40, 81, 40, 76);
                graphics2D.drawLine(12, 12, 15, 15);
                graphics2D.drawLine(69, 12, 66, 15);
                graphics2D.drawLine(12, 69, 15, 66);
                graphics2D.drawLine(69, 69, 66, 66);
                graphics2D.setPaint(new Color(0, 100, 0));
                int[] nArray = TTGraphicsState.getVectorComponents(((TTVM)TTVM.this).dGS.freedomVector);
                graphics2D.drawLine(40, 40, 40 + nArray[0] * 40 / 16384, 40 - nArray[1] * 40 / 16384);
                graphics2D.drawString("Freedom Vector", 84, 13);
                graphics2D.drawString("(" + (double)nArray[0] / 16384.0 + ", " + (double)nArray[1] / 16384.0 + ')', 98, 23);
                graphics2D.setPaint(Color.BLUE);
                nArray = TTGraphicsState.getVectorComponents(((TTVM)TTVM.this).dGS.dualProjectionVector);
                graphics2D.drawLine(41, 41, 41 + nArray[0] * 40 / 16384, 41 - nArray[1] * 40 / 16384);
                graphics2D.drawString("Dual Projection Vector", 84, 65);
                graphics2D.drawString("(" + (double)nArray[0] / 16384.0 + ", " + (double)nArray[1] / 16384.0 + ')', 98, 75);
                graphics2D.setPaint(Color.MAGENTA);
                nArray = TTGraphicsState.getVectorComponents(((TTVM)TTVM.this).dGS.projectionVector);
                graphics2D.drawLine(41, 41, 41 + nArray[0] * 40 / 16384, 41 - nArray[1] * 40 / 16384);
                graphics2D.drawString("Projection Vector", 84, 39);
                graphics2D.drawString("(" + (double)nArray[0] / 16384.0 + ", " + (double)nArray[1] / 16384.0 + ')', 98, 49);
                graphics2D.setPaint(Color.GRAY);
                graphics2D.drawLine(240, 4, 240, 77);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.drawString("zp0: " + ((TTVM)TTVM.this).dGS.zp0 + (((TTVM)TTVM.this).dGS.zp0 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 13);
                graphics2D.drawString("zp1: " + ((TTVM)TTVM.this).dGS.zp1 + (((TTVM)TTVM.this).dGS.zp1 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 25);
                graphics2D.drawString("zp2: " + ((TTVM)TTVM.this).dGS.zp2 + (((TTVM)TTVM.this).dGS.zp2 == 0 ? " (Twilight Zone)" : " (Glyph Zone)"), 250, 37);
                graphics2D.drawString("rp0: " + ((TTVM)TTVM.this).dGS.rp0, 250, 51);
                graphics2D.drawString("rp1: " + ((TTVM)TTVM.this).dGS.rp1, 250, 63);
                graphics2D.drawString("rp2: " + ((TTVM)TTVM.this).dGS.rp2, 250, 75);
                graphics2D.setPaint(Color.GRAY);
                graphics2D.drawLine(404, 4, 404, 77);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.drawString("Instruct Control: " + ((TTVM)TTVM.this).dGS.instructControl, 414, 13);
                graphics2D.drawString("Auto Flip: " + ((TTVM)TTVM.this).dGS.autoFlip, 414, 30);
                graphics2D.drawString("Delta Base: " + ((TTVM)TTVM.this).dGS.deltaBase, 414, 47);
                graphics2D.drawString("Delta Shift: " + ((TTVM)TTVM.this).dGS.deltaShift, 414, 59);
                graphics2D.drawString("Loop: " + ((TTVM)TTVM.this).dGS.loop, 414, 75);
                graphics2D.setPaint(Color.GRAY);
                graphics2D.drawLine(548, 4, 548, 77);
                graphics2D.setPaint(Color.BLACK);
                graphics2D.drawString("Round State: " + TTVM.this.dGS.getRoundStateAsString(), 558, 13);
                graphics2D.drawString("Minimum Distance: " + ((TTVM)TTVM.this).dGS.minimumDistance, 558, 30);
                graphics2D.drawString("CVT Cut In: " + ((TTVM)TTVM.this).dGS.controlValueTableCutIn, 558, 46);
                graphics2D.drawString("Single Width Cut In: " + ((TTVM)TTVM.this).dGS.singleWidthCutIn, 558, 63);
                graphics2D.drawString("Single Width Value: " + ((TTVM)TTVM.this).dGS.singleWidthValue, 558, 75);
            }
        };
        this.stateDisplay.setMinimumSize(new Dimension(700, 81));
        this.stateDisplay.setPreferredSize(new Dimension(700, 81));
        this.stateDisplay.setMaximumSize(new Dimension(700, 81));
        jPanel8.add("West", this.stateDisplay);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(0, 1));
        this.debugXLabel = new JLabel("  X: "){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Dimension dimension2 = this.getMinimumSize();
                int n = dimension.width < dimension2.width ? dimension2.width : dimension.width;
                int n2 = dimension.height < dimension2.height ? dimension2.height : dimension.height;
                return new Dimension(n, n2);
            }
        };
        this.debugXLabel.setBackground(Color.WHITE);
        this.debugXLabel.setOpaque(true);
        this.debugXLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugXLabel.setMinimumSize(new Dimension(200, 20));
        this.debugYLabel = new JLabel("  Y: ");
        this.debugYLabel.setBackground(Color.WHITE);
        this.debugYLabel.setOpaque(true);
        this.debugYLabel.setBorder(new LineBorder(Color.BLACK));
        this.debugYLabel.setMinimumSize(new Dimension(200, 20));
        jPanel9.add(this.debugXLabel);
        jPanel9.add(this.debugYLabel);
        jPanel8.add("East", jPanel9);
        this.debugWindow.add("South", jPanel8);
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LogWriter.writeLog("Exception: " + cloneNotSupportedException.getMessage());
        }
        this.stack = new Stack();
        int n = this.maxp.getMaxTwilightPoints();
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[n];
        this.x[2] = new int[n];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[n];
        this.y[2] = new int[n];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[n][2];
        this.touched[2] = new boolean[n][2];
        this.refreshDebugger(true);
        this.debugWindow.setVisible(true);
    }

    private static int midPt(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    private static GeneralPath getPathFromPoints(int[] nArray, int[] nArray2, boolean[] blArray, boolean[] blArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = nArray.length;
        int[] nArray3 = new int[n6];
        System.arraycopy(nArray, 0, nArray3, 0, n6);
        int[] nArray4 = new int[n6];
        System.arraycopy(nArray2, 0, nArray4, 0, n6);
        boolean[] blArray3 = new boolean[n6];
        System.arraycopy(blArray2, 0, blArray3, 0, n6);
        boolean[] blArray4 = new boolean[n6];
        System.arraycopy(blArray, 0, blArray4, 0, n6);
        int n7 = 0;
        int n8 = -1;
        for (n5 = 0; n5 < n6; ++n5) {
            if (blArray3[n5]) {
                if (!(n8 == -1 || blArray4[n7] && blArray4[n5])) {
                    int n9 = n8 - n7;
                    n4 = nArray3.length;
                    int[] nArray5 = new int[n4];
                    System.arraycopy(nArray3, 0, nArray5, 0, n4);
                    int[] nArray6 = new int[n4];
                    System.arraycopy(nArray4, 0, nArray6, 0, n4);
                    boolean[] blArray5 = new boolean[n4];
                    System.arraycopy(blArray4, 0, blArray5, 0, n4);
                    for (n3 = n7; n3 < n5 + 1; ++n3) {
                        n2 = n3 + n9;
                        if (n2 > n5) {
                            n2 -= n5 - n7 + 1;
                        }
                        nArray3[n3] = nArray5[n2];
                        nArray4[n3] = nArray6[n2];
                        blArray4[n3] = blArray5[n2];
                    }
                }
                n7 = n5 + 1;
                n8 = -1;
                continue;
            }
            if (!blArray4[n5] || n8 != -1) continue;
            n8 = n5;
        }
        n5 = 1;
        GeneralPath generalPath = new GeneralPath(1);
        n2 = nArray3.length;
        n4 = -1;
        for (n = 0; n < n2; ++n) {
            if (!blArray3[n]) continue;
            n4 = n + 1;
            n = n2;
        }
        int n10 = 0;
        n3 = 0;
        int n11 = 0;
        int n12 = 0;
        n = nArray3[0];
        int n13 = nArray4[0];
        generalPath.moveTo(n, n13);
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        boolean bl = false;
        for (int i = 0; i < n6; ++i) {
            int n17;
            int n18 = i % n4;
            int n19 = (i + 1) % n4;
            int n20 = (i + 2) % n4;
            int n21 = (i - 1) % n4;
            if (i == 0) {
                n21 = n4 - 1;
            }
            if (n19 < n16) {
                n19 += n16;
            }
            if (n20 < n16) {
                n20 += n16;
            }
            if (blArray3[i]) {
                bl = true;
                if (blArray4[n4]) {
                    n14 = nArray3[n4];
                    n15 = nArray4[n4];
                } else {
                    n14 = nArray3[i + 1];
                    n15 = nArray4[i + 1];
                }
                n16 = n4;
                for (n17 = i + 1; n17 < n2; ++n17) {
                    if (!blArray3[n17]) continue;
                    n4 = n17 + 1;
                    n17 = n2;
                }
            }
            if (n16 == n4 && blArray4[n18]) {
                i = n2;
                continue;
            }
            if (blArray4[n18] && blArray4[n19]) {
                n11 = nArray3[n19];
                n12 = nArray4[n19];
                generalPath.lineTo(n11, n12);
                n5 = 0;
            } else if (i < n2 - 3 && (n4 - n16 > 1 || n4 == n16)) {
                n17 = 0;
                if (blArray4[n18] && !blArray4[n19] && blArray4[n20]) {
                    n = nArray3[n18];
                    n13 = nArray4[n18];
                    n10 = nArray3[n19];
                    n3 = nArray4[n19];
                    n11 = nArray3[n20];
                    n12 = nArray4[n20];
                    ++i;
                    n17 = 1;
                } else if (blArray4[n18] && !blArray4[n19] && !blArray4[n20]) {
                    n = nArray3[n18];
                    n13 = nArray4[n18];
                    n10 = nArray3[n19];
                    n3 = nArray4[n19];
                    n11 = TTVM.midPt(nArray3[n19], nArray3[n20]);
                    n12 = TTVM.midPt(nArray4[n19], nArray4[n20]);
                    ++i;
                    n17 = 1;
                } else if (!(blArray4[n18] || blArray4[n19] || blArray3[n20] && n4 - n20 != 1)) {
                    n = TTVM.midPt(nArray3[n21], nArray3[n18]);
                    n13 = TTVM.midPt(nArray4[n21], nArray4[n18]);
                    n10 = nArray3[n18];
                    n3 = nArray4[n18];
                    n11 = TTVM.midPt(nArray3[n18], nArray3[n19]);
                    n12 = TTVM.midPt(nArray4[n18], nArray4[n19]);
                } else if (!blArray4[n18] && blArray4[n19]) {
                    n = TTVM.midPt(nArray3[n21], nArray3[n18]);
                    n13 = TTVM.midPt(nArray4[n21], nArray4[n18]);
                    n10 = nArray3[n18];
                    n3 = nArray4[n18];
                    n11 = nArray3[n19];
                    n12 = nArray4[n19];
                }
                if (n5 != 0) {
                    generalPath.moveTo(n, n13);
                    n5 = 0;
                }
                if (!blArray3[n18] || n18 <= 0 || !blArray3[n18 - 1]) {
                    generalPath.curveTo(n, n13, n10, n3, n11, n12);
                }
                if (n17 != 0 && blArray3[i]) {
                    bl = true;
                    n14 = nArray3[n4];
                    n15 = nArray4[n4];
                    n16 = n4;
                    for (int j = i + 1; j < n2; ++j) {
                        if (!blArray3[j]) continue;
                        n4 = j + 1;
                        j = n2;
                    }
                }
            }
            if (blArray3[n18]) {
                generalPath.closePath();
            }
            if (!bl) continue;
            generalPath.moveTo(n14, n15);
            bl = false;
        }
        return generalPath;
    }

    private void runDebuggerTo(int n) {
        int n2;
        if (n == this.debugPointer) {
            return;
        }
        int n3 = n;
        int n4 = -1;
        if (n3 >= 0) {
            n2 = 0;
            if (n3 >= this.programToDebug.length) {
                n2 = n3 - (this.programToDebug.length - 1);
                n3 = this.programToDebug.length - 1;
            }
            while (this.programToDebugIsData[n3]) {
                --n3;
            }
            n4 = n3 - this.debugPointer + n2;
        }
        n2 = this.instructionsExecuted + n4;
        boolean bl = true;
        if (n2 < this.instructionsExecuted) {
            this.restartDebugger();
            bl = false;
        }
        int n5 = this.functionsLineCount;
        this.debuggerRunningInBackground = true;
        while (this.instructionsExecuted < n2 + (bl ? this.functionsLineCount - n5 : 0)) {
            this.stepInto = true;
            this.debugPointer = this.process(this.programToDebug[this.debugPointer], this.debugPointer, this.programToDebug, this.dGS);
            ++this.debugPointer;
            if (this.debugPointer != this.programToDebug.length || this.codeStack.empty()) continue;
            this.setCurrentCodeForDebug(this.codeStack.pop(), this.numberStack.pop() + 1, false);
        }
        this.debuggerRunningInBackground = false;
        this.setCurrentCodeForDebug(this.programToDebug, this.debugPointer, true);
        this.stepInto = false;
        this.instructionsExecuted = n2;
    }

    private void restartDebugger() {
        this.stack = new Stack();
        try {
            this.dGS = (TTGraphicsState)this.graphicsState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LogWriter.writeLog("Exception: " + cloneNotSupportedException.getMessage());
        }
        int n = this.maxp.getMaxTwilightPoints();
        System.arraycopy(this.x[3], 0, this.x[1], 0, this.x[1].length);
        this.x[0] = new int[n];
        this.x[2] = new int[n];
        System.arraycopy(this.y[3], 0, this.y[1], 0, this.y[1].length);
        this.y[0] = new int[n];
        this.y[2] = new int[n];
        System.arraycopy(this.touched[3], 0, this.touched[1], 0, this.touched[1].length);
        this.touched[0] = new boolean[n][2];
        this.touched[2] = new boolean[n][2];
        if (!this.codeStack.isEmpty()) {
            this.programToDebug = (int[])this.codeStack.get(0);
            this.programToDebugIsData = TTVM.getInstructionStreamIsData(this.programToDebug);
        }
        this.codeStack.clear();
        this.numberStack.clear();
        this.functionsLineCount = 0;
        this.debugPointer = 0;
        this.instructionsExecuted = 0;
        this.currentCode.setText("Glyph Program");
    }

    private void advanceDebugger(final boolean bl) {
        if (this.debugPointer < this.programToDebug.length) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    TTVM.this.stepInto = bl;
                    TTVM.this.debugPointer = TTVM.this.process(TTVM.this.programToDebug[TTVM.this.debugPointer], TTVM.this.debugPointer, TTVM.this.programToDebug, TTVM.this.dGS);
                    TTVM.this.stepInto = false;
                    TTVM.this.debugPointer++;
                    TTVM.this.refreshDebugger(false);
                    if (TTVM.this.debugPointer == TTVM.this.programToDebug.length && !TTVM.this.codeStack.empty()) {
                        TTVM.this.setCurrentCodeForDebug((int[])TTVM.this.codeStack.pop(), (Integer)TTVM.this.numberStack.pop() + 1, true);
                    }
                }
            };
            SwingUtilities.invokeLater(thread);
        }
    }

    private String[] getStorageAsArray() {
        String[] stringArray = new String[this.storage.length];
        for (int i = 0; i < this.storage.length; ++i) {
            stringArray[i] = i + ": " + this.storage[i] + "       (" + NumberFormat.getNumberInstance().format((double)this.storage[i] / 64.0) + ')';
        }
        return stringArray;
    }

    private void refreshDebugger(boolean bl) {
        if (bl) {
            currentInstructionList.setListData(TTVM.getInstructionsAsStringArray(this.programToDebug));
        }
        int n = this.debugPointer;
        int n2 = this.debugPointer;
        while (n2 + 1 < this.programToDebug.length && this.programToDebugIsData[n2 + 1]) {
            ++n2;
        }
        currentInstructionList.setSelectionInterval(n, n2);
        if (n != 0) {
            int n3 = n2 + 3;
            if (n3 >= this.programToDebug.length) {
                n3 = this.programToDebug.length - 1;
            }
            currentInstructionList.ensureIndexIsVisible(n3);
            int n4 = n - 2;
            if (n4 < 0) {
                n4 = 0;
            }
            currentInstructionList.ensureIndexIsVisible(n4);
            currentInstructionList.ensureIndexIsVisible(n2);
        }
        currentInstructionList.ensureIndexIsVisible(n);
        stackList.setListData(this.stack.toStringArray());
        cvtList.setListData(this.cvt.getCVTForDebug());
        storageList.setListData(this.getStorageAsArray());
        this.stateDisplay.repaint();
        this.debugGlyphDisplay.repaint();
    }

    private void setCurrentCodeForDebug(int[] nArray, int n, boolean bl) {
        Object[] objectArray;
        this.programToDebug = nArray;
        this.debugPointer = n;
        if (!bl) {
            return;
        }
        this.programToDebugIsData = TTVM.getInstructionStreamIsData(this.programToDebug);
        this.refreshDebugger(true);
        String string = "Glyph program";
        for (Object object : objectArray = this.functions.keySet().toArray()) {
            if (this.functions.get(object) != this.programToDebug) continue;
            string = "Function " + object;
        }
        for (Object object : objectArray = this.instructions.keySet().toArray()) {
            if (this.instructions.get(object) != this.programToDebug) continue;
            string = "Instruction " + object;
        }
        this.currentCode.setText(string);
    }

    private void printCoords() {
        for (int i = 0; i < this.x[1].length; ++i) {
            System.out.print(i + "\t" + this.x[1][i] + '\t' + this.y[1][i] + '\t' + this.x[3][i] + '\t' + this.y[3][i]);
            System.out.println("");
            if (!this.contour[1][i]) continue;
            System.out.println();
        }
        System.out.println("");
        System.out.println("");
    }

    public static void print(int[] nArray) {
        String[] stringArray;
        System.out.println("");
        for (String string : stringArray = TTVM.getInstructionsAsStringArray(nArray)) {
            System.out.println(string);
        }
        System.out.println("");
        System.out.println("");
    }

    public static String[] getInstructionsAsStringArray(int[] nArray) {
        int n;
        if (nArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = new int[65535];
        for (n = 0; n < nArray.length; ++n) {
            boolean bl = false;
            int n2 = nArray[n];
            if (n2 >= 192 && n2 <= 223) {
                n2 = 192;
            }
            if (n2 >= 224 && n2 <= 255) {
                n2 = 224;
            }
            for (Field field : TTVM.class.getDeclaredFields()) {
                if (bl) break;
                try {
                    int n3;
                    int n4;
                    if (Character.isLowerCase(field.getName().charAt(0)) || field.getName().contains("ZONE") || "ORIGINAL".equals(field.getName()) || field.getInt(field) != n2) continue;
                    if ("ENDF".equals(field.getName()) || "ELSE".equals(field.getName()) || "EIF".equals(field.getName())) {
                        stringBuilder.delete(0, 2);
                    }
                    stringArray[n] = n + ": " + stringBuilder + field.getName();
                    if ("NPUSHB".equals(field.getName())) {
                        int n5 = nArray[++n];
                        stringArray[n] = stringBuilder + "  count: " + n5;
                        for (n4 = 0; n4 < n5; ++n4) {
                            stringArray[++n] = stringBuilder + "   " + nArray[n];
                        }
                    } else if ("NPUSHW".equals(field.getName())) {
                        int n6 = nArray[++n];
                        stringArray[n] = stringBuilder + "  count: " + n6;
                        for (n4 = 0; n4 < n6; ++n4) {
                            n3 = TTVM.getIntFrom2Uint8(nArray[++n], nArray[n + 1]);
                            stringArray[n] = stringBuilder + "   (first half of number)";
                            stringArray[++n] = stringBuilder + "   " + n3;
                        }
                    } else if (nArray[n] >= 176 && nArray[n] <= 183) {
                        int n7 = nArray[n] - 175;
                        for (n4 = 0; n4 < n7; ++n4) {
                            stringArray[++n] = stringBuilder + "   " + nArray[n];
                        }
                    } else if (nArray[n] >= 184 && nArray[n] <= 191) {
                        int n8 = nArray[n] - 183;
                        for (n4 = 0; n4 < n8; ++n4) {
                            n3 = TTVM.getIntFrom2Uint8(nArray[++n], nArray[n + 1]);
                            stringArray[n] = stringBuilder + "   (first half of number)";
                            stringArray[++n] = stringBuilder + "   " + n3;
                        }
                    } else if ("FDEF".equals(field.getName()) || "IDEF".equals(field.getName()) || "ELSE".equals(field.getName()) || "IF".equals(field.getName())) {
                        stringBuilder.append("  ");
                    }
                    bl = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    LogWriter.writeLog("Exception: " + illegalAccessException.getMessage());
                }
            }
            if (bl) continue;
            int n9 = nArray[n];
            nArray2[n9] = nArray2[n9] + 1;
            System.out.println(stringBuilder + "0x" + Integer.toHexString(nArray[n]) + "    (Unimplemented)");
        }
        for (n = 0; n < 255; ++n) {
            if (nArray2[n] <= 0) continue;
            System.out.println(Integer.toHexString(n) + " not found " + nArray2[n] + " times.");
        }
        return stringArray;
    }

    public static boolean[] getInstructionStreamIsData(int[] nArray) {
        if (nArray == null) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[nArray.length];
        block2: for (int i = 0; i < nArray.length; ++i) {
            boolean bl = false;
            int n = nArray[i];
            if (n >= 192 && n <= 223) {
                n = 192;
            }
            if (n >= 224 && n <= 255) {
                n = 224;
            }
            for (Field field : TTVM.class.getDeclaredFields()) {
                if (bl) continue block2;
                try {
                    int n2;
                    if (Character.isLowerCase(field.getName().charAt(0)) || field.getName().contains("ZONE") || "ORIGINAL".equals(field.getName()) || field.getInt(field) != n) continue;
                    blArray[i] = false;
                    if ("NPUSHB".equals(field.getName())) {
                        int n3 = nArray[++i];
                        blArray[i] = true;
                        for (n2 = 0; n2 < n3; ++n2) {
                            blArray[++i] = true;
                        }
                    } else if ("NPUSHW".equals(field.getName())) {
                        int n4 = nArray[++i];
                        blArray[i] = true;
                        for (n2 = 0; n2 < n4; ++n2) {
                            blArray[++i] = true;
                            blArray[++i] = true;
                        }
                    } else if (nArray[i] >= 176 && nArray[i] <= 183) {
                        int n5 = nArray[i] - 175;
                        for (n2 = 0; n2 < n5; ++n2) {
                            blArray[++i] = true;
                        }
                    } else if (nArray[i] >= 184 && nArray[i] <= 191) {
                        int n6 = nArray[i] - 183;
                        for (n2 = 0; n2 < n6; ++n2) {
                            blArray[++i] = true;
                            blArray[++i] = true;
                        }
                    }
                    bl = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    LogWriter.writeLog("Exception: " + illegalAccessException.getMessage());
                }
            }
        }
        return blArray;
    }

    static {
        watchAPoint = false;
        OPCODE_DESCRIPTIONS = new String[]{"SVTCAy    - Set both vectors to y", "SVTCAx    - Set both vectors to x", "SPVTCAy   - Sets projection vector to y", "SPVTCAx   - Sets projection vector to x", "SFVTCAy   - Sets freedom vector to y", "SFVTCAx   - Sets freedom vector to x", "SPVTL0    - Set projection vector to line", "SPVTL1    - Set projection vector perpendicular to line", "SFVTL0    - Set freedom vector to line", "SFVTL1    - Set freedom vector perpendicular to line", "SPVFS     - Sets the projection vector from the stack", "SFVFS     - Sets the freedom vector from the stack", "GPV       - Gets the projection vector onto the stack", "GFV       - Gets the freedom vector onto the stack", "SFVTPV    - Sets freedom vector to projection vector", "ISECT     - Set point to intersection of lines", "SRP0      - Set rp0", "SRP1      - Set rp1", "SRP2      - Set rp2", "SZP0      - Sets zp0", "SZP1      - Sets zp1", "SZP2      - Sets zp2", "SZPS      - Sets all zone pointers", "SLOOP     - Sets loop variable", "RTG       - Sets round state to grid", "RTHG      - Sets round state to half grid", "SMD       - Sets minimum distance", "ELSE      - ELSE", "JMPR      - Jump", "SCVTCI    - Set control value table cut in", "SSWCI     - Set single width cut in", "SSW       - Set single width", "DUP       - Duplicate the top stack element", "POP       - Remove the top stack element", "CLEAR     - Clear the stack", "SWAP      - Swap the top two stack elements", "DEPTH     - Returns depth of stack", "CINDEX    - Copy Indexed element to top of stack", "MINDEX    - Move Indexed element to top of stack", "ALIGNPTS  - Move points along fv to average of their pv positions", "", "UTP       - Untouch point", "LOOPCALL  - Call a function many times", "CALL      - Call a function", "FDEF      - Define a function", "ENDF      - End a function definition", "MDAP0     - Sets a point as touched", "MDAP1     - Rounds a point along the pV and marks as touched", "IUPy      - Interpolate untouched points in the y axis", "IUPx      - Interpolate untouched points on the x axis", "SHP0      - Shift point using RP2", "SHP1      - Shift point using RP1", "SHC0      - Shift a contour using RP2", "SHC1      - Shift a contour using RP1", "SHZ0      - Shift a zone using RP2", "SHZ1      - Shift a zone using RP1", "SHPIX     - Move point along freedom vector", "IP        - Interpolate point", "MSIRP0    - Move stack indirect relative point", "MSIRP1    - Move stack indirect relative point", "ALIGNRP   - Align point to RP0", "RTDG      - Sets round state to double grid", "MIAP0     - Move point to CVT value", "MIAP1     - Move point to CVT using cut in and round", "NPUSHB    - Push N bytes from IS to stack", "NPUSHW    - Push N words from IS to stack", "WS        - Write Store", "RS        - Read Store", "WCVTP     - Write Control Value Table in Pixels", "RCVT      - Read Control Value Table", "GC0       - Get coords on the pv", "GC1       - Get original coords on the pv", "SCFS", "MD0       - Measure current distance", "MD1       - Measure original distance", "MPPEM     - Measure pixels per em in the direction of the projection vector", "MPS", "FLIPON    - Sets autoflip to true", "FLIPOFF   - Sets autoflip to false", "DEBUG     - Shouldn't be in live fonts", "LT        - Less Than", "LTEQ      - Less Than or Equal", "GT        - Greater Than", "GTEQ      - Greater Than or Equal", "EQ        - Equal", "NEQ       - Not Equal", "ODD       - Rounds, truncates, and returns if odd.", "EVEN      - Rounds, truncates, and returns if even", "IF        - IF", "EIF       - End IF", "AND       - Logical AND", "OR        - Logical OR", "NOT       - Logical NOT", "DELTAP1   - Delta exception p1", "SDB       - Set delta base", "SDS       - Set delta shift", "ADD       - Add two F26Dot6 numbers", "SUB       - Subtract a number from another", "DIV       - Divide two F26Dot6 numbers", "MUL       - Multiply two F26Dot6 numbers", "ABS       - Return the absolute value of a F26Dot6 number", "NEG       - Negate a number", "FLOOR     - Round a number down if it has a fractional component", "CEILING   - Round a number up if it has a fractional component", "ROUND00   - Round a number", "ROUND01   - Round a number", "ROUND10   - Round a number", "ROUND11   - Round a number", "NROUND00  - Compensate for engine characteristics", "NROUND01  - Compensate for engine characteristics", "NROUND10  - Compensate for engine characteristics", "NROUND11  - Compensate for engine characteristics", "WCVTF", "DELTAP2   - Delta exception p2", "DELTAP3   - Delta exception p3", "DELTAC1   - Delta exception c1", "DELTAC2   - Delta exception c2", "DELTAC3   - Delta exception c3", "SROUND    - Sets the roundState specifically", "S45ROUND  - Sets the round state for working at 45degrees", "JROT      - Jump Relative On True", "JROF      - Jump Relative On False", "ROFF      - Set round state to off", "", "RUTG      - Set round state to up to grid", "RDTG      - Set round state to down to grid", "SANGW     - deprecated", "AA        - deprecated", "FLIPPT    - Flips a number of points on/off the curve", "FLIPRGON  - Flips a range of points onto the curve", "FLIPRGOFF - Flips a range of points off the curve", "", "", "SCANCTRL  - We don't scan convert, so only pops a value", "SDPVTL0   - Sets dual projection vector to line", "SDPVTL1   - Sets dual projection vector perpendicular to line", "GETINFO   - Gets info about current glyph & font engine", "IDEF      - Define an instruction", "ROLL      - Roll the top three stack elements", "MAX       - Returns the maximum of two values", "MIN       - Returns the minimum of two values", "SCANTYPE  - We don't scan convert, so only pops a value", "INSTCTRL  - Allows for setting flags to do with glyph execution"};
    }

    private static class Stack
    implements Serializable {
        private int pointer;
        private int[] stack = new int[10];

        Stack() {
        }

        public void push(int n) {
            if (this.pointer >= this.stack.length) {
                int[] nArray = new int[(int)((double)this.stack.length * 1.5)];
                System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
                this.stack = nArray;
            }
            this.stack[this.pointer] = n;
            ++this.pointer;
        }

        public int pop() {
            --this.pointer;
            if (this.pointer >= 0) {
                return this.stack[this.pointer];
            }
            throw new RuntimeException("Popped an empty stack!");
        }

        public int size() {
            return this.pointer;
        }

        public int elementAt(int n) {
            return this.stack[this.pointer - n];
        }

        public int remove(int n) {
            int n2 = this.pointer - n;
            int n3 = this.stack[n2];
            int[] nArray = new int[this.stack.length];
            System.arraycopy(this.stack, 0, nArray, 0, n2);
            System.arraycopy(this.stack, n2 + 1, nArray, n2, this.stack.length - n2 - 1);
            this.stack = nArray;
            --this.pointer;
            return n3;
        }

        public void print() {
            int n;
            System.out.println("stack: ");
            for (n = this.pointer - 1; n >= 0 && n >= this.pointer - 5; --n) {
                System.out.println(n + ": " + this.stack[n]);
            }
            if (n > 0) {
                System.out.println("...");
            }
            System.out.println("");
        }

        public String[] toStringArray() {
            String[] stringArray = new String[this.pointer];
            for (int i = this.pointer - 1; i >= 0; --i) {
                stringArray[this.pointer - i - 1] = this.pointer - i - 1 + ": " + this.stack[i] + "       (" + NumberFormat.getNumberInstance().format((double)this.stack[i] / 64.0) + ')';
            }
            return stringArray;
        }
    }
}

