/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PostscriptFactory;
import org.jpedal.utils.LogWriter;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    private final PostscriptFactory post;
    private final int n;

    public PDFCalculator(byte[] byArray, float[] fArray, float[] fArray2) {
        super(fArray, fArray2);
        this.post = new PostscriptFactory(byArray);
        this.n = fArray2.length / 2;
    }

    @Override
    public float[] computeStitch(float[] fArray) {
        return this.compute(fArray);
    }

    @Override
    public float[] compute(float[] fArray) {
        float[] fArray2 = new float[this.n];
        try {
            this.post.resetStacks(fArray);
            double[] dArray = this.post.executePostscript();
            for (int i = 0; i < this.n; ++i) {
                fArray2[i] = PDFCalculator.min(PDFCalculator.max((float)dArray[i], this.range[i * 2]), this.range[i * 2 + 1]);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return fArray2;
    }
}

