/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private final int[] size;
    private final int m;
    private final int n;
    private final float[] outputs;
    private final double[] sampleArray;
    private float[] prevInputs;

    public PDFSampled(byte[] byArray, int n, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int[] nArray) {
        super(fArray, fArray2);
        int n2;
        int n3;
        this.size = nArray;
        this.m = fArray.length / 2;
        this.n = fArray2.length / 2;
        int n4 = 1;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n4 *= nArray[n3];
        }
        this.sampleArray = new double[n4 *= fArray2.length / 2];
        n3 = 0;
        int n5 = 0;
        double d = 1.0 / (Math.pow(2.0, n) - 1.0);
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            while (n3 < n) {
                n5 <<= 8;
                n5 |= byArray[n6++] & 0xFF;
                n3 += 8;
            }
            this.sampleArray[n2] = (double)(n5 >> (n3 -= n)) * d;
            n5 = (int)((long)n5 & (1L << n3) - 1L);
        }
        if (fArray3 != null) {
            this.encode = fArray3;
        } else {
            n2 = nArray.length;
            this.encode = new float[n2 * 2];
            for (int i = 0; i < n2; ++i) {
                this.encode[i * 2 + 1] = nArray[i] - 1;
            }
        }
        if (fArray4 != null) {
            this.decode = fArray4;
        } else {
            n2 = fArray2.length;
            this.decode = new float[n2];
            System.arraycopy(fArray2, 0, this.decode, 0, n2);
        }
        this.outputs = new float[this.n];
        this.prevInputs = new float[this.m];
        for (n2 = 0; n2 < this.m; ++n2) {
            this.prevInputs[n2] = Float.MAX_VALUE;
        }
    }

    @Override
    public float[] computeStitch(float[] fArray) {
        return this.compute(fArray);
    }

    private static boolean isSame(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] compute(float[] fArray) {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        if (PDFSampled.isSame(fArray, this.prevInputs)) {
            return this.outputs;
        }
        this.prevInputs = (float[])fArray.clone();
        int n5 = 1 << this.m;
        double[] dArray = new double[n5];
        int[] nArray = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            dArray[n4] = 1.0;
        }
        n4 = this.n;
        int n6 = 1;
        for (n3 = 0; n3 < this.m; ++n3) {
            n2 = 2 * n3;
            n = n2 + 1;
            d = Math.min(Math.max(fArray[n3], this.domain[n2]), this.domain[n]);
            double d2 = PDFSampled.interpolateDouble(d, this.domain[n2], this.domain[n], this.encode[n2], this.encode[n]);
            int n7 = this.size[n3];
            double d3 = (d2 = Math.min(Math.max(d2, 0.0), (double)(n7 - 1))) < (double)(n7 - 1) ? (double)((int)d2) : d2 - 1.0;
            double d4 = d3 + 1.0 - d2;
            double d5 = d2 - d3;
            double d6 = d3 * (double)n4;
            double d7 = d6 + (double)n4;
            for (int i = 0; i < n5; ++i) {
                if ((i & n6) != 0) {
                    int n8 = i;
                    dArray[n8] = dArray[n8] * d5;
                    int n9 = i;
                    nArray[n9] = (int)((double)nArray[n9] + d7);
                    continue;
                }
                int n10 = i;
                dArray[n10] = dArray[n10] * d4;
                int n11 = i;
                nArray[n11] = (int)((double)nArray[n11] + d6);
            }
            n4 *= n7;
            n6 <<= 1;
        }
        for (n3 = 0; n3 < this.n; ++n3) {
            n2 = 2 * n3;
            n = n2 + 1;
            d = 0.0;
            for (int i = 0; i < n5; ++i) {
                d += this.sampleArray[nArray[i] + n3] * dArray[i];
            }
            d = PDFSampled.interpolateDouble(d, 0.0, 1.0, this.decode[n2], this.decode[n]);
            this.outputs[n3] = (float)Math.min(Math.max(d, (double)this.range[n2]), (double)this.range[n]);
        }
        return this.outputs;
    }

    private static double interpolateDouble(double d, double d2, double d3, double d4, double d5) {
        return (d - d2) * (d5 - d4) / (d3 - d2) + d4;
    }
}

