/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PostscriptUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class PostscriptFactory {
    static final int[] scale = new int[]{1, 676, 17576, 456976};
    static final double toBase10 = Math.log(10.0);
    private int level;
    private static final byte START_BRACE = 123;
    private static final byte END_BRACE = 125;
    private final byte[] stream;
    private final int streamLength;
    private int ptr;
    private static final boolean debug = false;
    protected boolean testingFunction;
    protected double[] stack;
    private double[] safeStack;
    protected int[] stackType;
    private int[] safeStackType;
    protected int stkPtr;
    private int safeStkPtr;
    protected int stkTypePtr;
    private int safeStkTypePrt;
    protected int currentType;
    boolean cont;
    static final double radiansToDegrees = 57.29577951308232;
    protected static final double isTrue = 1.0;
    protected static final double isFalse = 0.0;
    protected static final int PS_INTEGER = 1;
    protected static final int PS_REAL = 2;
    protected static final int PS_BOOLEAN = 3;
    protected static final int PS_UNKNOWN = 0;
    protected static final int PS_abs = 317044;
    protected static final int PS_add = 54756;
    protected static final int PS_atan = 5953532;
    protected static final int PS_ceil = 5170050;
    protected static final int PS_cos = 325834;
    protected static final int PS_cvi = 154806;
    protected static final int PS_cvr = 312990;
    protected static final int PS_div = 374507;
    protected static final int PS_exp = 279192;
    protected static final int PS_floo = 6651169;
    protected static final int PS_idiv = 9739140;
    protected static final int PS_ln = 8799;
    protected static final int PS_log = 114931;
    protected static final int PS_mod = 62204;
    protected static final int PS_mul = 206868;
    protected static final int PS_neg = 108173;
    protected static final int PS_sin = 233914;
    protected static final int PS_sqrt = 8992170;
    protected static final int PS_sub = 31114;
    protected static final int PS_roun = 6301689;
    protected static final int PS_trun = 6303719;
    protected static final int PS_and = 61516;
    protected static final int PS_bits = 8564921;
    protected static final int PS_eq = 10820;
    protected static final int PS_fals = 8418909;
    protected static final int PS_ge = 2710;
    protected static final int PS_gt = 12850;
    protected static final int PS_le = 2715;
    protected static final int PS_lt = 12855;
    protected static final int PS_ne = 2717;
    protected static final int PS_not = 343421;
    protected static final int PS_or = 11506;
    protected static final int PS_true = 2190935;
    protected static final int PS_xor = 308279;
    protected static final int PS_if = 3388;
    protected static final int PS_ifel = 5100428;
    protected static final int PS_copy = 11240530;
    protected static final int PS_exch = 3249536;
    protected static final int PS_pop = 273119;
    protected static final int PS_dup = 277163;
    protected static final int PS_inde = 1889428;
    protected static final int PS_roll = 5229553;

    public PostscriptFactory(byte[] byArray) {
        this.stream = byArray;
        this.streamLength = byArray.length;
    }

    protected static int getCommandID(byte[] byArray) {
        int n = -1;
        int n2 = 0;
        int n3 = byArray.length;
        if (n3 > 4) {
            n3 = 4;
        }
        for (int i = 0; i < n3; ++i) {
            n2 += (byArray[i] - 97) * scale[i];
        }
        switch (n2) {
            case 317044: {
                n = 317044;
                break;
            }
            case 54756: {
                n = 54756;
                break;
            }
            case 5953532: {
                n = 5953532;
                break;
            }
            case 5170050: {
                n = 5170050;
                break;
            }
            case 325834: {
                n = 325834;
                break;
            }
            case 154806: {
                n = 154806;
                break;
            }
            case 312990: {
                n = 312990;
                break;
            }
            case 374507: {
                n = 374507;
                break;
            }
            case 279192: {
                n = 279192;
                break;
            }
            case 6651169: {
                n = 6651169;
                break;
            }
            case 9739140: {
                n = 9739140;
                break;
            }
            case 8799: {
                n = 8799;
                break;
            }
            case 114931: {
                n = 114931;
                break;
            }
            case 62204: {
                n = 62204;
                break;
            }
            case 206868: {
                n = 206868;
                break;
            }
            case 108173: {
                n = 108173;
                break;
            }
            case 233914: {
                n = 233914;
                break;
            }
            case 8992170: {
                n = 8992170;
                break;
            }
            case 31114: {
                n = 31114;
                break;
            }
            case 6301689: {
                n = 6301689;
                break;
            }
            case 6303719: {
                n = 6303719;
                break;
            }
            case 61516: {
                n = 61516;
                break;
            }
            case 8564921: {
                n = 8564921;
                break;
            }
            case 10820: {
                n = 10820;
                break;
            }
            case 8418909: {
                n = 8418909;
                break;
            }
            case 2710: {
                n = 2710;
                break;
            }
            case 12850: {
                n = 12850;
                break;
            }
            case 2715: {
                n = 2715;
                break;
            }
            case 12855: {
                n = 12855;
                break;
            }
            case 2717: {
                n = 2717;
                break;
            }
            case 343421: {
                n = 343421;
                break;
            }
            case 11506: {
                n = 11506;
                break;
            }
            case 2190935: {
                n = 2190935;
                break;
            }
            case 308279: {
                n = 308279;
                break;
            }
            case 3388: {
                n = 3388;
                break;
            }
            case 5100428: {
                n = 5100428;
                break;
            }
            case 11240530: {
                n = 11240530;
                break;
            }
            case 3249536: {
                n = 3249536;
                break;
            }
            case 273119: {
                n = 273119;
                break;
            }
            case 277163: {
                n = 277163;
                break;
            }
            case 1889428: {
                n = 1889428;
                break;
            }
            case 5229553: {
                n = 5229553;
            }
        }
        return n;
    }

    protected int execute(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 317044: {
                double d = this.pop();
                if (d < 0.0) {
                    this.push(-d, 1);
                    break;
                }
                this.push(d, 1);
                break;
            }
            case 54756: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("ADD - not enough elements on the stack");
                }
                double d = this.pop();
                n3 = this.currentType;
                double d2 = this.pop();
                n4 = this.currentType;
                if (n3 == 2 || n4 == 2) {
                    this.push(d + d2, 2);
                    break;
                }
                this.push(d + d2, 1);
                break;
            }
            case 61516: {
                double d = this.pop();
                n3 = this.currentType;
                double d3 = this.pop();
                n4 = this.currentType;
                if (n3 == 1 && n4 == 1) {
                    this.push((int)d & (int)d3, 1);
                    break;
                }
                if (n3 == 3 && n4 == 3) {
                    this.push((int)d & (int)d3, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_and");
            }
            case 5953532: {
                this.calculateAtan();
                break;
            }
            case 8564921: {
                int n5 = this.popInt();
                n3 = this.currentType;
                int n6 = this.popInt();
                n4 = this.currentType;
                if ((n3 != 1 || n4 != 1) && LogWriter.isRunningFromIDE) {
                    throw new RuntimeException("Critical error in PS_bits");
                }
                if (n5 > 0) {
                    n6 <<= n5;
                }
                if (n5 < 0) {
                    n6 >>= -n5;
                }
                this.push(n6, 1);
                break;
            }
            case 5170050: {
                double d = this.pop();
                n3 = this.currentType;
                if (d < 0.0) {
                    this.push((int)d, n3);
                    break;
                }
                int n7 = (int)d;
                if (d > (double)n7) {
                    this.push(n7 + 1, n3);
                    break;
                }
                this.push(d, n3);
                break;
            }
            case 11240530: {
                int n8 = this.popInt();
                n3 = this.currentType;
                if (n3 == 1 && n8 > 0) {
                    int n9;
                    double[] dArray = new double[n8];
                    int[] nArray = new int[n8];
                    for (n9 = 0; n9 < dArray.length; ++n9) {
                        dArray[n9] = this.pop();
                        nArray[n9] = this.currentType;
                    }
                    for (n9 = dArray.length; n9 > 0; --n9) {
                        this.push(dArray[n9 - 1], nArray[n9 - 1]);
                    }
                    for (n9 = dArray.length; n9 > 0; --n9) {
                        this.push(dArray[n9 - 1], nArray[n9 - 1]);
                    }
                    break;
                }
                if (n3 == 1 && n8 == 0 || !LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_copy");
            }
            case 325834: {
                double d = this.pop();
                double d4 = d / 57.29577951308232;
                double d5 = Math.cos(d4);
                if (d5 > 0.0 && d5 < 1.0E-7) {
                    d5 = 0.0;
                } else if (d5 < 0.0 && d5 > -1.0E-7) {
                    d5 = 0.0;
                }
                this.push(d5, 2);
                break;
            }
            case 154806: {
                double d = this.pop();
                this.push((int)d, 1);
                break;
            }
            case 312990: {
                double d = this.pop();
                this.push(d, 2);
                break;
            }
            case 374507: {
                double d = this.pop();
                double d6 = this.pop();
                this.push(d6 / d, 2);
                break;
            }
            case 277163: {
                this.calculateDup();
                break;
            }
            case 10820: {
                double d = this.pop();
                double d7 = this.pop();
                if (d == d7) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 3249536: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("EXCH - not enough elements on the stack");
                }
                double d = this.pop();
                n3 = this.currentType;
                double d8 = this.pop();
                n4 = this.currentType;
                this.push(d, n3);
                this.push(d8, n4);
                break;
            }
            case 279192: {
                double d = this.pop();
                double d9 = this.pop();
                this.push(Math.pow(d9, d), 2);
                break;
            }
            case 8418909: {
                this.push(0.0, 3);
                break;
            }
            case 6651169: {
                double d = this.pop();
                n3 = this.currentType;
                if (d > 0.0) {
                    this.push((int)d, n3);
                    break;
                }
                int n10 = (int)d;
                if ((double)n10 > d) {
                    this.push(n10 - 1, n3);
                    break;
                }
                this.push(d, n3);
                break;
            }
            case 2710: {
                double d = this.pop();
                n3 = this.currentType;
                double d10 = this.pop();
                n4 = this.currentType;
                if (!(n3 != 1 && n3 != 2 || n4 != 1 && n4 != 2)) {
                    if (d10 >= d) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_ge");
            }
            case 12850: {
                double d = this.pop();
                n3 = this.currentType;
                double d11 = this.pop();
                n4 = this.currentType;
                if (!(n3 != 1 && n3 != 2 || n4 != 1 && n4 != 2)) {
                    if (d11 > d) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_gt");
            }
            case 9739140: {
                int n11 = this.popInt();
                int n12 = this.popInt();
                this.push(n12 / n11, 1);
                break;
            }
            case 3388: {
                if (!this.cont) {
                    System.arraycopy(this.safeStack, 0, this.stack, 0, 100);
                    System.arraycopy(this.safeStackType, 0, this.stackType, 0, 100);
                    this.stkPtr = this.safeStkPtr;
                    this.stkTypePtr = this.safeStkTypePrt;
                }
                this.cont = false;
                break;
            }
            case 1889428: {
                this.calculateIndex();
                break;
            }
            case 2715: {
                double d = this.pop();
                n3 = this.currentType;
                double d12 = this.pop();
                n4 = this.currentType;
                if (!(n3 != 1 && n3 != 2 || n4 != 1 && n4 != 2)) {
                    if (d12 <= d) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_le");
            }
            case 12855: {
                double d = this.pop();
                n3 = this.currentType;
                double d13 = this.pop();
                n4 = this.currentType;
                if (!(n3 != 1 && n3 != 2 || n4 != 1 && n4 != 2)) {
                    if (d13 < d) {
                        this.push(1.0, 3);
                        break;
                    }
                    this.push(0.0, 3);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_lt");
            }
            case 8799: {
                double d = this.pop();
                this.push(Math.log(d), 2);
                break;
            }
            case 114931: {
                double d = this.pop();
                this.push(Math.log(d) / toBase10, 2);
                break;
            }
            case 62204: {
                if (n3 != 1 || n4 != 1) {
                    System.err.println("PS_mod - both values must be integers!");
                }
                double d = this.pop();
                double d14 = this.pop();
                this.push(d14 % d, 1);
                break;
            }
            case 206868: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("MUL - not enough elements on the stack");
                }
                double d = this.pop();
                double d15 = this.pop();
                this.push(d * d15, 1);
                break;
            }
            case 2717: {
                double d = this.pop();
                double d16 = this.pop();
                if (d != d16) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 108173: {
                double d = this.pop();
                n3 = this.currentType;
                if (d != 0.0) {
                    this.push(-d, n3);
                    break;
                }
                this.push(d, n3);
                break;
            }
            case 343421: {
                double d = this.pop();
                n3 = this.currentType;
                if (d == 0.0 && n3 == 3) {
                    this.push(1.0, 3);
                    break;
                }
                if (d == 1.0 && n3 == 3) {
                    this.push(0.0, 3);
                    break;
                }
                this.push(~((int)d), 1);
                break;
            }
            case 11506: {
                double d = this.pop();
                double d17 = this.pop();
                if (n3 == 3 && n4 == 3) {
                    this.push((int)d | (int)d17, 3);
                    break;
                }
                if (n3 == 1 && n4 == 1) {
                    this.push((int)d | (int)d17, 1);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_or");
            }
            case 273119: {
                this.pop();
                break;
            }
            case 5229553: {
                this.calculateRoll();
                break;
            }
            case 6301689: {
                double d = this.pop();
                n3 = this.currentType;
                d += 0.5;
                if (d > 0.0) {
                    this.push((int)d, n3);
                    break;
                }
                int n13 = (int)d;
                if ((double)n13 > d) {
                    this.push(n13 - 1, n3);
                    break;
                }
                this.push((int)d, n3);
                break;
            }
            case 233914: {
                double d = this.pop();
                this.push(Math.sin(d / 57.29577951308232), 2);
                break;
            }
            case 8992170: {
                double d = this.pop();
                if (d >= 0.0) {
                    this.push(Math.sqrt(d), 2);
                    break;
                }
                System.err.println("SQRT - cant sqrt a negative number!");
                break;
            }
            case 31114: {
                if (this.stack.length < 2) {
                    throw new RuntimeException("SUB - not enough elements on the stack");
                }
                double d = this.pop();
                n3 = this.currentType;
                double d18 = this.pop();
                n4 = this.currentType;
                if (n3 == 2 || n4 == 2) {
                    this.push(d18 - d, 2);
                    break;
                }
                this.push(d18 - d, 1);
                break;
            }
            case 6303719: {
                double d = this.pop();
                n3 = this.currentType;
                this.push((int)d, n3);
                break;
            }
            case 2190935: {
                this.push(1.0, 3);
                break;
            }
            case 308279: {
                int n14 = this.popInt();
                n3 = this.currentType;
                int n15 = this.popInt();
                n4 = this.currentType;
                if (n3 == 3 && n4 == 3) {
                    this.push(n14 ^ n15, 3);
                    break;
                }
                if (n3 == 1 && n4 == 1) {
                    this.push(n14 ^ n15, 1);
                    break;
                }
                if (!LogWriter.isRunningFromIDE) break;
                throw new RuntimeException("Critical error in PS_xor");
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    private void calculateAtan() {
        double d = this.pop();
        double d2 = this.pop();
        if (d == 0.0 && d2 == 0.0) {
            System.err.println("ATAN - invalid parameters");
        }
        double d3 = d2 / d;
        if (d >= 0.0 && d2 >= 0.0) {
            this.push(Math.toDegrees(Math.atan(d3)), 2);
        } else if (d > 0.0 && d2 <= 0.0) {
            double d4 = Math.toDegrees(Math.atan(d3));
            if (d4 < 0.0) {
                d4 = -d4;
            }
            this.push(d4 + 90.0, 2);
        } else if (d <= 0.0 && d2 <= 0.0) {
            double d5 = Math.toDegrees(Math.atan(d3));
            if (d5 < 0.0) {
                d5 = -d5;
            }
            this.push(d5 + 180.0, 2);
        } else if (d <= 0.0 && d2 >= 0.0) {
            double d6 = Math.toDegrees(Math.atan(d3));
            if (d6 < 0.0) {
                d6 = -d6;
            }
            this.push(d6 + 270.0, 2);
        }
    }

    private void calculateDup() {
        double d = this.pop();
        int n = this.currentType;
        this.push(d, n);
        this.push(d, n);
    }

    private void calculateIndex() {
        int n = this.popInt();
        if (n == 0) {
            this.calculateDup();
        } else if (n > 0) {
            double[] dArray = new double[n];
            int[] nArray = new int[n];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.pop();
                nArray[i] = this.currentType;
            }
            double d = this.pop();
            int n2 = this.currentType;
            this.push(d, n2);
            for (int i = dArray.length; i > 0; --i) {
                this.push(dArray[i - 1], nArray[i - 1]);
            }
            this.push(d, n2);
        } else if (n < 0) {
            System.err.println("-> Index : critical error, n has to be nonnegative");
        }
    }

    private void calculateRoll() {
        block12: {
            int n;
            int n2;
            int n3;
            block11: {
                int n4;
                n3 = this.popInt();
                n2 = this.popInt();
                if (n2 < 0 && LogWriter.isRunningFromIDE) {
                    throw new RuntimeException("-> Roll : critical error");
                }
                if (n2 > this.stkPtr) {
                    n2 = this.stkPtr;
                }
                if (n3 <= 0) break block11;
                double[] dArray = new double[n3];
                int[] nArray = new int[n3];
                if (n2 - n3 <= 0) {
                    return;
                }
                double[] dArray2 = new double[n2 - n3];
                int[] nArray2 = new int[n2 - n3];
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    dArray[n4] = this.pop();
                    nArray[n4] = this.currentType;
                }
                for (n4 = 0; n4 < dArray2.length; ++n4) {
                    dArray2[n4] = this.pop();
                    nArray2[n4] = this.currentType;
                }
                for (n4 = dArray.length; n4 > 0; --n4) {
                    this.push(dArray[n4 - 1], nArray[n4 - 1]);
                }
                for (n4 = dArray2.length; n4 > 0; --n4) {
                    this.push(dArray2[n4 - 1], nArray2[n4 - 1]);
                }
                break block12;
            }
            if (n3 >= 0) break block12;
            n3 = -n3;
            double[] dArray = new double[n2 - n3];
            int[] nArray = new int[n2 - n3];
            double[] dArray3 = new double[n3];
            int[] nArray3 = new int[n3];
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = this.pop();
                nArray[n] = this.currentType;
            }
            for (n = 0; n < dArray3.length; ++n) {
                dArray3[n] = this.pop();
                nArray3[n] = this.currentType;
            }
            for (n = dArray.length; n > 0; --n) {
                this.push(dArray[n - 1], nArray[n - 1]);
            }
            for (n = dArray3.length; n > 0; --n) {
                this.push(dArray3[n - 1], nArray3[n - 1]);
            }
        }
    }

    public double[] executePostscript() {
        boolean bl = false;
        this.ptr = 0;
        this.level = 0;
        while (this.ptr < this.streamLength) {
            block14: {
                byte[] byArray = this.getNextValue();
                if (byArray != null) {
                    if (byArray.length == 1 && (byArray[0] == 123 || byArray[0] == 125)) {
                        if (bl && byArray[0] == 123) {
                            double d = this.pop();
                            int n = this.currentType;
                            this.safeStack = new double[100];
                            this.safeStackType = new int[100];
                            System.arraycopy(this.stack, 0, this.safeStack, 0, 100);
                            System.arraycopy(this.stackType, 0, this.safeStackType, 0, 100);
                            this.safeStkPtr = this.stkPtr;
                            this.safeStkTypePrt = this.stkTypePtr;
                            if (n == 3) {
                                if (d > 0.0) {
                                    this.cont = true;
                                }
                            } else {
                                throw new RuntimeException("Possible syntax error in PostScript stream!");
                            }
                        }
                        bl = true;
                    } else {
                        int n = PostscriptFactory.getCommandID(byArray);
                        if (n == -1) {
                            try {
                                double d = PostscriptFactory.convertToDouble(byArray);
                                int n2 = (int)d;
                                if ((double)n2 == d) {
                                    this.push(d, 1);
                                    break block14;
                                }
                                this.push(d, 2);
                            }
                            catch (Exception exception) {
                                LogWriter.writeLog("Exception " + exception);
                            }
                        } else {
                            int n3 = this.execute(n);
                            if (n3 == -1 && LogWriter.isRunningFromIDE) {
                                throw new RuntimeException("Unsupported command with value " + PostscriptUtils.toString(n));
                            }
                        }
                    }
                }
            }
            if (this.level != 0 && this.ptr < this.streamLength) continue;
            break;
        }
        return this.stack;
    }

    private void push(double d, int n) {
        if (this.stkPtr > 99 || this.stkTypePtr > 99) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Stack or stackType overflow");
            }
        } else {
            this.stack[this.stkPtr] = d;
            this.stackType[this.stkTypePtr] = n;
        }
        ++this.stkPtr;
        ++this.stkTypePtr;
    }

    private double pop() {
        double d = 0.0;
        --this.stkPtr;
        --this.stkTypePtr;
        if (this.stkTypePtr < 0) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Stack type underflow");
            }
        } else {
            this.currentType = this.stackType[this.stkTypePtr];
        }
        if (this.stkPtr < 0) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Stack underflow");
            }
        } else {
            d = this.stack[this.stkPtr];
        }
        return d;
    }

    private int popInt() {
        return (int)this.pop();
    }

    private static double convertToDouble(byte[] byArray) {
        double d;
        int n;
        int n2;
        int n3 = n2 = byArray.length;
        int n4 = 0;
        boolean bl = false;
        for (n = n2 - 1; n > -1; --n) {
            if (byArray[0 + n] != 46) continue;
            n3 = n;
            break;
        }
        n = n3;
        if (byArray[0] == 43) {
            --n;
            ++n4;
        } else if (byArray[0] == 45) {
            ++n4;
            bl = true;
        }
        int n5 = n - n4;
        int n6 = n2 - n3;
        if (n5 > 3) {
            bl = false;
            d = Double.parseDouble(new String(byArray));
        } else {
            if (n6 > 6) {
                n6 = 6;
            }
            d = NumberUtils.convertStreamFromDouble(byArray, 0 + n4, 0 + n3, n5, n6);
        }
        if (bl) {
            return -d;
        }
        return d;
    }

    private byte[] getNextValue() {
        byte by;
        byte[] byArray = null;
        while (this.ptr < this.streamLength && (this.stream[this.ptr] == 10 || this.stream[this.ptr] == 13 || this.stream[this.ptr] == 32)) {
            ++this.ptr;
        }
        int n = this.ptr;
        while (this.ptr < this.streamLength && (by = this.stream[this.ptr]) != 123) {
            ++this.ptr;
            if (this.ptr < this.streamLength && (by = this.stream[this.ptr]) != 32 && by != 13 && by != 10 && by != 123 && by != 125) continue;
        }
        if (this.stream[n] == 123) {
            ++this.ptr;
            ++this.level;
        } else if (this.stream[n] == 125) {
            --this.level;
        }
        int n2 = this.ptr;
        if (n2 >= n) {
            int n3 = n2 - n;
            byArray = new byte[n3];
            System.arraycopy(this.stream, n, byArray, n - n, n2 - n);
        }
        return byArray;
    }

    public void resetStacks(float[] fArray) {
        int n;
        this.stack = new double[100];
        this.stackType = new int[100];
        this.stkPtr = 0;
        this.stkTypePtr = 0;
        for (n = 0; n < 100; ++n) {
            this.stack[n] = 0.0;
        }
        for (n = 0; n < 100; ++n) {
            this.stackType[n] = 0;
        }
        for (float f : fArray) {
            this.push(f, 2);
        }
    }
}

