/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.grouping;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.SearchListener;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_String;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class PdfGroupingAlgorithms {
    private boolean includeHTMLtags;
    private static final String SystemSeparator = System.getProperty("line.separator");
    private boolean[] isUsed;
    private float[] f_x1;
    private float[] f_x2;
    private float[] f_y1;
    private float[] f_y2;
    private boolean[] hadSpace;
    private String[] f_colorTag;
    private int[] writingMode;
    private int[] fontSize;
    private float[] spaceWidth;
    private StringBuilder[] content;
    private int[] textLength;
    private final PdfData pdf_data;
    private boolean isXHTML = true;
    private int nextSlot;
    private Vector_Int lineBreaks = new Vector_Int();
    private Vector_Object lines;
    private Vector_Int lineY2;
    private static final String MARKER = PdfData.marker;
    public static final char MARKER2 = MARKER.charAt(0);
    private int max_rows;
    private int master;
    private boolean colorExtracted;
    private int[] line_order;
    private static final int increment = 100;
    public static boolean useUnrotatedCoords;
    private boolean includeTease;
    private String[] teasers;
    private final List multipleTermTeasers = new ArrayList();
    private boolean usingMultipleTerms;
    private boolean isXMLExtraction = true;
    private static final int linkedSearchAreas = -101;

    public PdfGroupingAlgorithms(PdfData pdfData, PdfPageData pdfPageData, boolean bl) {
        this.pdf_data = pdfData;
        this.isXMLExtraction = bl;
        this.colorExtracted = pdfData.isColorExtracted();
    }

    private static String getLineDownSeparator(StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl) {
        StringBuilder stringBuilder3;
        StringBuilder stringBuilder4;
        String string = " ";
        if (bl) {
            stringBuilder4 = Strip.stripXML(stringBuilder, bl);
            stringBuilder3 = Strip.stripXML(stringBuilder2, bl);
        } else {
            stringBuilder4 = Strip.trim(stringBuilder);
            stringBuilder3 = Strip.trim(stringBuilder2);
        }
        int n = stringBuilder4.length();
        int n2 = stringBuilder3.length();
        if (n > 1 && n2 > 1) {
            char c = stringBuilder4.charAt(n - 1);
            char c2 = stringBuilder4.charAt(n - 2);
            char c3 = stringBuilder3.charAt(0);
            char c4 = stringBuilder3.charAt(1);
            if ("".indexOf(c) != -1) {
                string = "";
                if (c2 == ':') {
                    string = "\n";
                }
                if (c == ' ') {
                    string = " ";
                }
            } else if ((c2 == '.' || c == '.') && (Character.isUpperCase(c3) || c3 == '&' || Character.isUpperCase(c4) || c4 == '&')) {
                string = bl ? "<p></p>\n" : "\n";
            }
        }
        return string;
    }

    private void cleanupShadowsAndDrownedObjects(boolean bl) {
        int[] nArray = this.getUnusedFragments();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (this.isUsed[n2]) continue;
            float f = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
            float f2 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            for (int j = i + 1; j < n; ++j) {
                String string;
                boolean bl2;
                float f3;
                int n3 = nArray[j];
                if (this.f_x1[n3] == this.f_x2[n3] || this.isUsed[n3] || this.isUsed[n2]) continue;
                float f4 = this.fontSize[n3] - this.fontSize[n2];
                if (f4 < 0.0f) {
                    f4 = -f4;
                }
                if ((f3 = this.f_x2[n3] - this.f_x1[n3] - (this.f_x2[n2] - this.f_x1[n2])) < 0.0f) {
                    f3 = -f3;
                }
                if (f4 == 0.0f && f > this.f_x1[n3] && f < this.f_x2[n3] && f3 < 10.0f && f2 < this.f_y1[n3] && f2 > this.f_y2[n3]) {
                    this.isUsed[n3] = true;
                    continue;
                }
                boolean bl3 = this.f_x1[n3] > this.f_x1[n2] && this.f_x2[n3] < this.f_x2[n2] && this.f_y1[n3] < this.f_y1[n2] && this.f_y2[n3] > this.f_y2[n2];
                boolean bl4 = bl2 = this.f_x1[n2] > this.f_x1[n3] && this.f_x2[n2] < this.f_x2[n3] && this.f_y1[n2] < this.f_y1[n3] && this.f_y2[n2] > this.f_y2[n3];
                if (!bl3 && !bl2) continue;
                if (this.f_y2[n2] > this.f_y2[n3]) {
                    string = PdfGroupingAlgorithms.getLineDownSeparator(this.content[n2], this.content[n3], this.isXMLExtraction);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n2, n3, string, true);
                    }
                } else {
                    string = PdfGroupingAlgorithms.getLineDownSeparator(this.content[n3], this.content[n2], this.isXMLExtraction);
                    if (!bl || string.indexOf(32) == -1) {
                        this.merge(n3, n2, string, true);
                    }
                }
                f = (this.f_x1[n2] + this.f_x2[n2]) / 2.0f;
                f2 = (this.f_y1[n2] + this.f_y2[n2]) / 2.0f;
            }
        }
    }

    private String isGapASpace(int n, int n2, float f, boolean bl, int n3) {
        int n4;
        String string = "";
        float f2 = this.spaceWidth[n] * (float)this.fontSize[n];
        float f3 = this.spaceWidth[n2] * (float)this.fontSize[n2];
        float f4 = f2 > f3 ? f3 : f2;
        if ((f4 = f / (f4 / 1000.0f)) > 0.51f && f4 < 1.0f) {
            f4 = 1.0f;
        }
        if ((n4 = (int)f4) > 0) {
            string = " ";
        }
        if (n4 > 1 && bl && n3 == 0) {
            string = " <SpaceCount space=\"" + n4 + "\" />";
        }
        return string;
    }

    private void merge(int n, int n2, String string, boolean bl) {
        if (this.f_x1[n] > this.f_x1[n2]) {
            this.f_x1[n] = this.f_x1[n2];
        }
        if (this.f_y1[n] < this.f_y1[n2]) {
            this.f_y1[n] = this.f_y1[n2];
        }
        if (this.f_x2[n] < this.f_x2[n2]) {
            this.f_x2[n] = this.f_x2[n2];
        }
        if (this.f_y2[n] > this.f_y2[n2]) {
            this.f_y2[n] = this.f_y2[n2];
        }
        if (this.isXMLExtraction) {
            String string2 = "</font>";
            if (this.colorExtracted) {
                string2 = "</font></color>";
            }
            if (bl && this.content[n].toString().lastIndexOf(string2) != -1) {
                String string3 = this.content[n].toString();
                this.content[n] = new StringBuilder(string3.substring(0, string3.lastIndexOf(string2)));
                this.content[n].append(string);
                this.content[n].append(string3.substring(string3.lastIndexOf(string2)));
            } else {
                this.content[n].append(string);
            }
            if (this.textLength[n2] > 1 && this.content[n].toString().endsWith(" ")) {
                this.content[n].deleteCharAt(this.content[n].lastIndexOf(" "));
            }
            this.fontSize[n] = this.fontSize[n2];
            if (this.content[n2].indexOf("<color") != -1 && this.content[n].indexOf("<color") != -1 && this.content[n2].toString().startsWith(this.content[n].substring(this.content[n].lastIndexOf("<color"), this.content[n].indexOf(">", this.content[n].lastIndexOf("<color")))) && this.content[n].lastIndexOf("</color>") + 7 == this.content[n].lastIndexOf(">")) {
                this.content[n2].replace(this.content[n2].indexOf("<color"), this.content[n2].indexOf(">") + 1, "");
                this.content[n].replace(this.content[n].lastIndexOf("</color>"), this.content[n].lastIndexOf("</color>") + 8, "");
            }
            if (this.content[n2].indexOf("<font") != -1 && this.content[n].indexOf("<font") != -1 && this.content[n2].toString().startsWith(this.content[n].substring(this.content[n].lastIndexOf("<font"), this.content[n].indexOf(">", this.content[n].lastIndexOf("<font")))) && this.content[n].lastIndexOf("</font>") + 6 == this.content[n].lastIndexOf(">")) {
                this.content[n2].replace(this.content[n2].indexOf("<font"), this.content[n2].indexOf(">") + 1, "");
                this.content[n].replace(this.content[n].lastIndexOf("</font>"), this.content[n].lastIndexOf("</font>") + 7, "");
            }
            this.content[n] = this.content[n].append((CharSequence)this.content[n2]);
            int n3 = n;
            this.textLength[n3] = this.textLength[n3] + this.textLength[n2];
            this.isUsed[n2] = true;
            this.content[n2] = null;
        } else {
            this.fontSize[n] = this.fontSize[n2];
            this.content[n] = this.content[n].append(string).append((CharSequence)this.content[n2]);
            int n4 = n;
            this.textLength[n4] = this.textLength[n4] + this.textLength[n2];
            this.isUsed[n2] = true;
            this.content[n2] = null;
        }
    }

    private void removeEncoding() {
        int[] nArray;
        for (int n : nArray = this.getUnusedFragments()) {
            int n2 = n;
            if (this.isUsed[n2]) continue;
            this.content[n2] = this.removeHiddenMarkers(n2);
        }
    }

    private void copyToArraysPartial(int n, int n2, int n3, int n4) {
        int n5;
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int n6 = this.pdf_data.getRawTextElementCount();
        boolean[] blArray = new boolean[n6];
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        float[] fArray = new float[n6];
        StringBuilder[] stringBuilderArray = new StringBuilder[n6];
        int[] nArray3 = new int[n6];
        float[] fArray2 = new float[n6];
        String[] stringArray = new String[n6];
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[n6];
        float[] fArray5 = new float[n6];
        int n7 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            float f = this.pdf_data.f_x1[n5];
            float f2 = this.pdf_data.f_x2[n5];
            float f3 = this.pdf_data.f_y1[n5];
            float f4 = this.pdf_data.f_y2[n5];
            int n8 = this.pdf_data.f_writingMode[n5];
            boolean bl = false;
            switch (n8) {
                case 0: 
                case 1: {
                    float f5 = f3 - f4;
                    if (!((float)n < f && f < (float)n3 || (float)n < f2 && f2 < (float)n3 || f < (float)n && (float)n < f2) && (!(f < (float)n3) || !((float)n3 < f2)) || !((float)n2 < f4 + f5 / 4.0f) || !((double)f4 + (double)f5 * 0.75 < (double)n4)) break;
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    float f5 = f2 - f;
                    if (!((float)n2 < f3 && f3 < (float)n4 || (float)n2 < f4 && f4 < (float)n4 || f4 < (float)n2 && (float)n2 < f3) && (!(f4 < (float)n4) || !((float)n4 < f3)) || !((float)n < f + f5 / 4.0f) || !((double)f + (double)f5 * 0.75 < (double)n3)) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            stringBuilderArray[n7] = new StringBuilder(this.pdf_data.contents[n5]);
            nArray[n7] = this.pdf_data.f_end_font_size[n5];
            nArray2[n7] = this.pdf_data.f_writingMode[n5];
            fArray2[n7] = this.pdf_data.f_x1[n5];
            stringArray[n7] = this.pdf_data.colorTag[n5];
            fArray3[n7] = this.pdf_data.f_x2[n5];
            fArray4[n7] = this.pdf_data.f_y1[n5];
            fArray5[n7] = this.pdf_data.f_y2[n5];
            fArray[n7] = this.pdf_data.space_width[n5];
            nArray3[n7] = this.pdf_data.text_length[n5];
            StringBuilder stringBuilder = new StringBuilder(stringBuilderArray[n7].toString().substring(0, stringBuilderArray[n7].toString().indexOf(MARKER)));
            String string = stringBuilderArray[n7].toString().substring(stringBuilderArray[n7].toString().indexOf(MARKER), stringBuilderArray[n7].toString().indexOf(60, stringBuilderArray[n7].toString().lastIndexOf(MARKER)));
            String string2 = stringBuilderArray[n7].toString().substring(stringBuilderArray[n7].toString().lastIndexOf(MARKER));
            string2 = string2.substring(string2.indexOf(60));
            StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER);
            boolean bl2 = true;
            float f6 = 0.0f;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                float f7 = Float.parseFloat(string3);
                string3 = stringTokenizer.nextToken();
                f6 = Float.parseFloat(string3);
                String string4 = string3 = stringTokenizer.nextToken();
                if (bl2) {
                    if (n8 == 0 || n8 == 1) {
                        fArray2[n7] = f7;
                    } else {
                        fArray5[n7] = f7;
                    }
                    bl2 = false;
                }
                if (n8 == 0 || n8 == 1) {
                    fArray3[n7] = f7;
                } else {
                    fArray4[n7] = f7;
                }
                boolean bl3 = false;
                if (n8 == 0 || n8 == 1) {
                    if ((float)n < f7 && f7 + f6 < (float)n3) {
                        bl3 = true;
                    }
                } else if ((float)n2 < f7 && f7 + f6 < (float)n4) {
                    bl3 = true;
                }
                if (!bl3) continue;
                stringBuilder.append(MARKER);
                stringBuilder.append(f7);
                stringBuilder.append(MARKER);
                stringBuilder.append(f6);
                stringBuilder.append(MARKER);
                stringBuilder.append(string4);
            }
            stringBuilderArray[n7] = new StringBuilder(stringBuilder.append(string2).toString());
            if (n8 == 0 || n8 == 1) {
                int n9 = n7;
                fArray3[n9] = fArray3[n9] + f6;
            } else {
                int n10 = n7;
                fArray4[n10] = fArray4[n10] + f6;
            }
            ++n7;
        }
        this.isUsed = new boolean[n7];
        this.fontSize = new int[n7];
        this.writingMode = new int[n7];
        this.spaceWidth = new float[n7];
        this.content = new StringBuilder[n7];
        this.textLength = new int[n7];
        this.f_x1 = new float[n7];
        this.f_colorTag = new String[n7];
        this.f_x2 = new float[n7];
        this.f_y1 = new float[n7];
        this.f_y2 = new float[n7];
        for (n5 = 0; n5 != n7; ++n5) {
            this.isUsed[n5] = blArray[n5];
            this.fontSize[n5] = nArray[n5];
            this.writingMode[n5] = nArray2[n5];
            this.spaceWidth[n5] = fArray[n5];
            this.content[n5] = stringBuilderArray[n5];
            this.textLength[n5] = nArray3[n5];
            this.f_x1[n5] = fArray2[n5];
            this.f_colorTag[n5] = stringArray[n5];
            this.f_x2[n5] = fArray3[n5];
            this.f_y1[n5] = fArray4[n5];
            this.f_y2[n5] = fArray5[n5];
        }
    }

    private void copyToArrays() {
        this.colorExtracted = this.pdf_data.isColorExtracted();
        int n = this.pdf_data.getRawTextElementCount();
        this.isUsed = new boolean[n];
        this.fontSize = new int[n];
        this.writingMode = new int[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuilder[n];
        this.textLength = new int[n];
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        for (int i = 0; i < n; ++i) {
            this.content[i] = new StringBuilder(this.pdf_data.contents[i]);
            this.fontSize[i] = this.pdf_data.f_end_font_size[i];
            this.writingMode[i] = this.pdf_data.f_writingMode[i];
            this.f_x1[i] = this.pdf_data.f_x1[i];
            this.f_colorTag[i] = this.pdf_data.colorTag[i];
            this.f_x2[i] = this.pdf_data.f_x2[i];
            this.f_y1[i] = this.pdf_data.f_y1[i];
            this.f_y2[i] = this.pdf_data.f_y2[i];
            this.spaceWidth[i] = this.pdf_data.space_width[i];
            this.textLength[i] = this.pdf_data.text_length[i];
        }
    }

    private int[] getUnusedFragments() {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private StringBuilder removeHiddenMarkers(int n) {
        if (this.content[n].indexOf(MARKER) == -1) {
            return this.content[n];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.content[n].toString(), MARKER, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuilder = stringBuilder.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuilder = stringBuilder.append(string);
        }
        return stringBuilder;
    }

    public void setIncludeHTML(boolean bl) {
        this.includeHTMLtags = bl;
    }

    public static String removeHiddenMarkers(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains(MARKER)) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(MARKER)) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringBuilder = stringBuilder.append(stringTokenizer.nextToken());
                continue;
            }
            stringBuilder = stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private void findVerticalLines(float f, float f2, float f3, float f4, int n) throws PdfException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = 0;
        int n3 = this.pdf_data.getRawTextElementCount();
        for (int i = 0; i < n3; ++i) {
            float f5;
            float f6;
            float f7;
            float f8;
            float f9 = 0.0f;
            String string = this.pdf_data.contents[i];
            if (n == 0) {
                f8 = this.f_x1[i];
                f7 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 1) {
                f7 = this.f_x1[i];
                f8 = this.f_x2[i];
                f6 = this.f_y1[i];
                f5 = this.f_y2[i];
            } else if (n == 3) {
                f8 = this.f_y1[i];
                f7 = this.f_y2[i];
                f6 = this.f_x2[i];
                f5 = this.f_x1[i];
            } else if (n == 2) {
                f8 = this.f_y2[i];
                f7 = this.f_y1[i];
                f5 = this.f_x1[i];
                f6 = this.f_x2[i];
            } else {
                throw new PdfException("Illegal value " + n + "for currentWritingMode");
            }
            if (!((double)f8 > (double)f - 0.5) || !((double)f7 < (double)f3 + 0.5) || !((double)f5 > (double)f2 - 0.5) || !((double)f6 < (double)f4 + 0.5)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, MARKER, true);
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(MARKER)) continue;
                string3 = stringTokenizer.nextToken();
                if (!string3.isEmpty()) {
                    float f10 = f9;
                    f9 = Float.parseFloat(string3);
                    try {
                        if (string2.isEmpty() || string2.indexOf(32) != -1) {
                            int n4;
                            Integer n5 = (int)f9;
                            Object v = hashMap.get(n5);
                            if (v == null) {
                                hashMap.put(n5, 1);
                            } else {
                                n4 = (Integer)v;
                                if (++n4 > n2) {
                                    n2 = n4;
                                }
                                hashMap.put(n5, n4);
                            }
                            n4 = (int)(f10 + (f9 - f10) / 2.0f);
                            if (f10 != 0.0f) {
                                n5 = n4;
                                v = hashMap.get(n5);
                                if (v == null) {
                                    hashMap.put(n5, 1);
                                } else {
                                    int n6 = (Integer)v;
                                    if (++n6 > n2) {
                                        n2 = n6;
                                    }
                                    hashMap.put(n5, n6);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " stripping x values");
                    }
                }
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string2 = string3 = stringTokenizer.nextToken();
            }
        }
        Iterator iterator = hashMap.keySet().iterator();
        int n7 = n2 / 2;
        while (iterator.hasNext()) {
            Integer n8 = (Integer)iterator.next();
            int n9 = (Integer)hashMap.get(n8);
            if (n9 <= n7) continue;
            this.lineBreaks.addElement(n8);
        }
    }

    private boolean isFragmentWithinArea(Fragment fragment, float f, float f2, float f3, float f4) {
        if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
            float f5 = fragment.getY1() - fragment.getY2();
            if ((fragment.getY2() > f2 && fragment.getY1() < f4 || fragment.getY2() > f2 && (double)(f4 - fragment.getY2()) > (double)f5 * 0.5 || fragment.getY1() < f4 && (double)(fragment.getY1() - f2) > (double)f5 * 0.5) && f + f3 > 0.0f && !(fragment.getX2() < f) && !(fragment.getX1() > f3)) {
                return true;
            }
        } else if ((fragment.getWritingMode() == 3 || fragment.getWritingMode() == 2) && fragment.getX1() > f && fragment.getX2() < f3 && fragment.getY1() > f2 && fragment.getY2() < f4) {
            return true;
        }
        return false;
    }

    private void copyToArrays(float f, float f2, float f3, float f4, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) throws PdfException {
        int n = this.pdf_data.getRawTextElementCount() + 100;
        this.initArrays(n);
        boolean bl5 = false;
        n -= 100;
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            float f5;
            float f6;
            float f7;
            float f8;
            Fragment fragment = new Fragment(this.pdf_data, i);
            if (!this.isFragmentWithinArea(fragment, f, f2, f3, f4)) continue;
            if (!bl5 && bl3) {
                this.findVerticalLines(f, f2, f3, f4, fragment.getWritingMode());
                bl5 = true;
            }
            if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
                f8 = fragment.getX1();
                f7 = fragment.getX1();
                f6 = f;
                f5 = f3;
            } else {
                f8 = fragment.getY2();
                f7 = fragment.getY2();
                f6 = f2;
                f5 = f4;
            }
            float f9 = -1.0f;
            char[] cArray = fragment.getRawData().toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            String string3 = "";
            if (!fragment.getRawData().contains(MARKER)) {
                stringBuilder = new StringBuilder(fragment.getRawData());
            }
            boolean bl6 = true;
            boolean bl7 = false;
            while (n3 < n2) {
                int n4;
                int n5;
                int n6;
                String string4;
                do {
                    float f10;
                    int n7;
                    if (cArray[n3] != MARKER2) {
                        n7 = n3;
                        while (n3 < n2 && cArray[n3] != MARKER2) {
                            ++n3;
                        }
                        string4 = fragment.getRawData().substring(n7, n3);
                    } else {
                        while (n3 < n2 && cArray[n3] != MARKER2) {
                            ++n3;
                        }
                        n7 = ++n3;
                        while (n3 < n2 && cArray[n3] != MARKER2) {
                            ++n3;
                        }
                        String string5 = fragment.getRawData().substring(n7, n3);
                        n7 = ++n3;
                        while (n3 < n2 && cArray[n3] != MARKER2) {
                            ++n3;
                        }
                        string2 = fragment.getRawData().substring(n7, n3);
                        n7 = ++n3;
                        while (n3 < n2 && cArray[n3] != MARKER2) {
                            ++n3;
                        }
                        string3 = string4 = fragment.getRawData().substring(n7, n3);
                        if (!string5.isEmpty()) {
                            f7 = f8;
                            f8 = Float.parseFloat(string5);
                            if (bl7) {
                                PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, f8);
                                bl7 = false;
                            }
                        }
                        if (this.isXMLExtraction && f7 < f6 && f8 > f6 && !string4.startsWith("<font ")) {
                            string4 = Fonts.getActiveFontTag(fragment.getRawData(), "") + string4;
                        }
                    }
                    if (!string2.isEmpty() && (f10 = f8 + Float.parseFloat(string2) * 0.3f) > f6 & f10 < f5) {
                        this.setFragmentCoord(fragment, f6, f5, f8);
                        break;
                    }
                    string4 = "";
                    string3 = "";
                } while (n3 < n2);
                if (bl6) {
                    bl6 = false;
                    if (this.isXMLExtraction && bl && !string4.startsWith("<font ") && !string4.startsWith("<color ")) {
                        stringBuilder.append(Fonts.getActiveFontTag(stringBuilder.toString(), fragment.getRawData()));
                    }
                }
                boolean bl8 = false;
                if (bl3 && fragment.getCharacterSpacing() > 0.0f && stringBuilder.toString().endsWith(" ")) {
                    n6 = this.lineBreaks.size();
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = this.lineBreaks.elementAt(n5);
                        if (!(f7 < (float)n4 & f8 > (float)n4)) continue;
                        n5 = n6;
                        bl8 = true;
                    }
                }
                n6 = PdfGroupingAlgorithms.checkForPunctuation(string3, string);
                if (bl8) {
                    stringBuilder = this.writeOutFragment(bl, bl4, false, f7, f8, string2, stringBuilder, fragment, i, n2, string4);
                    continue;
                }
                if (n6 != 0 || bl2 && (string3.indexOf(32) != -1 || string4.endsWith(" ")) || string3.contains("   ")) {
                    f8 = this.writeOut(bl, bl4, false, f8, string2, stringBuilder, fragment, i, string4, string3, n6 != 0);
                    if (!string2.isEmpty()) {
                        n5 = 0;
                        if (string3.indexOf(32) != -1) {
                            n5 = string3.indexOf(32);
                        }
                        if (bl4) {
                            n4 = string3.length();
                            while (n5 < n4 && string3.charAt(n5) == ' ') {
                                ++n5;
                            }
                        }
                        f8 = n5 > 0 ? (f8 += (float)n5 * Float.parseFloat(string2)) : (f8 += Float.parseFloat(string2));
                        bl7 = n5 > 0;
                    }
                    if (bl2 & this.nextSlot > 0) {
                        this.hadSpace[this.nextSlot - 1] = true;
                    }
                    stringBuilder = new StringBuilder(Fonts.getActiveFontTag(stringBuilder.toString(), fragment.getRawData()));
                    PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, f8);
                    continue;
                }
                if (f9 != -1.0f & f8 > f9) {
                    stringBuilder = this.writeOnVerticalLineBreak(bl, bl4, f9, stringBuilder, fragment, i, string4);
                    f9 = -1.0f;
                    continue;
                }
                if (this.isXMLExtraction && string4.endsWith(" </font>")) {
                    string4 = "</font>";
                    string3 = "";
                    PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, f7);
                }
                stringBuilder.append(string4);
            }
            if (bl && this.isXMLExtraction && !stringBuilder.toString().endsWith("</font>") && !stringBuilder.toString().endsWith("</color>")) {
                stringBuilder.append("</font>");
            }
            this.completeLine(bl, bl4, stringBuilder, fragment, i);
            stringBuilder = new StringBuilder();
        }
        this.isUsed = new boolean[this.nextSlot];
    }

    private void completeLine(boolean bl, boolean bl2, StringBuilder stringBuilder, Fragment fragment, int n) {
        if (fragment.getWritingMode() == 0 || fragment.getWritingMode() == 1) {
            if (fragment.getX1() < fragment.getX2()) {
                this.addFragment(n, stringBuilder, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), bl, fragment, bl2);
            } else {
                this.addFragment(n, stringBuilder, fragment.getX2(), fragment.getX1(), fragment.getY1(), fragment.getY2(), bl, fragment, bl2);
            }
        } else if ((fragment.getWritingMode() == 3 || fragment.getWritingMode() == 2) && fragment.getY1() > fragment.getY2()) {
            this.addFragment(n, stringBuilder, fragment.getX1(), fragment.getX2(), fragment.getY1(), fragment.getY2(), bl, fragment, bl2);
        }
    }

    private StringBuilder writeOnVerticalLineBreak(boolean bl, boolean bl2, float f, StringBuilder stringBuilder, Fragment fragment, int n, String string) {
        if (fragment.getWritingMode() == 0) {
            this.addFragment(n, stringBuilder, fragment.getX1(), f, fragment.getY1(), fragment.getY2(), bl, fragment, bl2);
        } else if (fragment.getWritingMode() == 1) {
            this.addFragment(n, stringBuilder, f, fragment.getX2(), fragment.getY1(), fragment.getY2(), bl, fragment, bl2);
        } else if (fragment.getWritingMode() == 3) {
            this.addFragment(n, stringBuilder, fragment.getX1(), fragment.getX2(), f, fragment.getY2(), bl, fragment, bl2);
        } else if (fragment.getWritingMode() == 2) {
            this.addFragment(n, stringBuilder, fragment.getX1(), fragment.getX2(), fragment.getY1(), f, bl, fragment, bl2);
        }
        stringBuilder = new StringBuilder(Fonts.getActiveFontTag(stringBuilder.toString(), fragment.getRawData()));
        stringBuilder.append(string);
        PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, f);
        return stringBuilder;
    }

    private float writeOut(boolean bl, boolean bl2, boolean bl3, float f, String string, StringBuilder stringBuilder, Fragment fragment, int n, String string2, String string3, boolean bl4) {
        int n2;
        if (string3.length() > 1 && string3.indexOf(32) != -1 && (n2 = string3.indexOf(32)) > 0) {
            f = string3.length() == 2 ? (float)((double)f + (double)Float.parseFloat(string) * 0.7) : (f += (float)n2 * (Float.parseFloat(string) / (float)string3.length()));
        }
        if (!bl4) {
            stringBuilder.append(string2.trim());
        }
        if (fragment.getWritingMode() == 0) {
            if (bl3) {
                System.out.println("Add " + fragment.getX1() + ' ' + f + " text=" + stringBuilder + " i=" + n);
            }
            this.addFragment(n, stringBuilder, fragment.getX1(), f, fragment.getY1(), fragment.getY2(), bl, fragment, bl2);
        } else if (fragment.getWritingMode() == 1) {
            if (bl3) {
                System.out.println("b");
            }
            this.addFragment(n, stringBuilder, f, fragment.getX2(), fragment.getY1(), fragment.getY2(), bl, fragment, bl2);
        } else if (fragment.getWritingMode() == 3) {
            if (bl3) {
                System.out.println("c");
            }
            this.addFragment(n, stringBuilder, fragment.getX1(), fragment.getX2(), f, fragment.getY2(), bl, fragment, bl2);
        } else if (fragment.getWritingMode() == 2) {
            if (bl3) {
                System.out.println("d");
            }
            this.addFragment(n, stringBuilder, fragment.getX1(), fragment.getX2(), fragment.getY1(), f, bl, fragment, bl2);
        }
        return f;
    }

    private StringBuilder writeOutFragment(boolean bl, boolean bl2, boolean bl3, float f, float f2, String string, StringBuilder stringBuilder, Fragment fragment, int n, int n2, String string2) {
        if (bl3) {
            System.out.println("Break 1 is_broken");
        }
        Fragment fragment2 = new Fragment(this.pdf_data, n2);
        fragment2.setX1(fragment.getX1());
        fragment2.setY1(fragment.getY1());
        fragment2.setX2(fragment.getX2());
        fragment2.setY2(fragment.getY2());
        PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment2, f + Float.parseFloat(string));
        this.addFragment(n, stringBuilder, fragment2.getX1(), fragment2.getX2(), fragment2.getY1(), fragment2.getY2(), bl, fragment, bl2);
        stringBuilder = new StringBuilder(Fonts.getActiveFontTag(stringBuilder.toString(), fragment.getRawData()));
        stringBuilder.append(string2);
        PdfGroupingAlgorithms.alterCoordsBasedOnWritingMode(fragment, f2);
        return stringBuilder;
    }

    private void setFragmentCoord(Fragment fragment, float f, float f2, float f3) {
        if (fragment.getWritingMode() == 0) {
            if ((fragment.getX1() < f || fragment.getX1() > f2) && f3 >= f) {
                fragment.setX1(f3);
            } else if (fragment.getWritingMode() == 1) {
                if ((fragment.getX2() > f2 || fragment.getX2() < f) && f3 <= f2) {
                    fragment.setX2(f3);
                } else if (fragment.getWritingMode() == 3) {
                    if ((fragment.getY2() < f || fragment.getY2() > f2) && f3 >= f) {
                        fragment.setY2(f3);
                    } else if (fragment.getWritingMode() == 2 && (fragment.getY1() < f || fragment.getY1() > f2) && f3 <= f) {
                        fragment.setY1(f3);
                    }
                }
            }
        }
    }

    static void alterCoordsBasedOnWritingMode(Fragment fragment, float f) {
        if (fragment.getWritingMode() == 0) {
            fragment.setX1(f);
        } else if (fragment.getWritingMode() == 1) {
            fragment.setX2(f);
        } else if (fragment.getWritingMode() == 3) {
            fragment.setY2(f);
        } else if (fragment.getWritingMode() == 2) {
            fragment.setY1(f);
        }
    }

    private void initArrays(int n) {
        this.f_x1 = new float[n];
        this.f_colorTag = new String[n];
        this.hadSpace = new boolean[n];
        this.f_x2 = new float[n];
        this.f_y1 = new float[n];
        this.f_y2 = new float[n];
        this.spaceWidth = new float[n];
        this.content = new StringBuilder[n];
        this.fontSize = new int[n];
        this.textLength = new int[n];
        this.writingMode = new int[n];
        this.isUsed = new boolean[n];
    }

    private static boolean checkForPunctuation(String string, String string2) {
        if (string2 == null || string2 != null && string2.isEmpty()) {
            return false;
        }
        boolean bl = false;
        int n = string.length();
        int n2 = n - 1;
        if (n > 0) {
            char c = string.charAt(n2);
            boolean bl2 = c == '>';
            while ((bl2 | c == ' ') & n2 > 0) {
                if (c == '<') {
                    bl2 = false;
                }
                if ((c = string.charAt(--n2)) != '>') continue;
                bl2 = true;
            }
            if (c == ';') {
                bl = true;
                --n2;
                while (n2 > -1) {
                    c = string.charAt(n2);
                    if (c == '&' || c == '#') {
                        bl = false;
                        n2 = 0;
                    }
                    if (n2 != 0 && c != ' ' && Character.isLetterOrDigit(c)) {
                        --n2;
                        continue;
                    }
                    break;
                }
            } else if (string2.indexOf(c) != -1) {
                bl = true;
            }
        }
        return bl;
    }

    private void addFragment(int n, StringBuilder stringBuilder, float f, float f2, float f3, float f4, boolean bl, Fragment fragment, boolean bl2) {
        StringBuilder stringBuilder2 = stringBuilder;
        String string = stringBuilder2.toString();
        int n2 = fragment.getTextLength();
        String string2 = fragment.getColorTag();
        if (bl2) {
            if (string.contains("&#")) {
                stringBuilder2 = Strip.stripAmpHash(stringBuilder2);
            }
            if (this.isXMLExtraction && (string.contains("&lt;") || string.contains("&gt;"))) {
                stringBuilder2 = Strip.stripXMLArrows(stringBuilder2, true);
            } else if (!(this.isXMLExtraction || string.indexOf(60) == -1 && string.indexOf(62) == -1)) {
                stringBuilder2 = Strip.stripArrows(stringBuilder2);
            }
        }
        if (this.getFirstChar(stringBuilder2) != -1) {
            if (!bl) {
                stringBuilder2 = Strip.stripXML(stringBuilder2, this.isXMLExtraction);
            } else if (this.isXMLExtraction) {
                if (this.pdf_data.isColorExtracted() && !stringBuilder2.toString().endsWith("</color>")) {
                    if (!stringBuilder2.toString().endsWith("</font>")) {
                        stringBuilder2 = stringBuilder2.append("</font>");
                    }
                    stringBuilder2 = stringBuilder2.append("</color>");
                } else if (!this.pdf_data.isColorExtracted() && !stringBuilder2.toString().endsWith("</font>")) {
                    stringBuilder2 = stringBuilder2.append("</font>");
                }
            }
            int n3 = this.f_x1.length;
            if (this.nextSlot < n3) {
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string2;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n];
                this.textLength[this.nextSlot] = n2;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n];
                this.content[this.nextSlot] = stringBuilder2;
                ++this.nextSlot;
            } else {
                float[] fArray = new float[n3 += 100];
                String[] stringArray = new String[n3];
                float[] fArray2 = new float[n3];
                float[] fArray3 = new float[n3];
                float[] fArray4 = new float[n3];
                float[] fArray5 = new float[n3];
                StringBuilder[] stringBuilderArray = new StringBuilder[n3];
                int[] nArray = new int[n3];
                int[] nArray2 = new int[n3];
                int[] nArray3 = new int[n3];
                boolean[] blArray = new boolean[n3];
                boolean[] blArray2 = new boolean[n3];
                for (int i = 0; i < n3 - 100; ++i) {
                    fArray[i] = this.f_x1[i];
                    stringArray[i] = this.f_colorTag[i];
                    fArray2[i] = this.f_x2[i];
                    fArray3[i] = this.f_y1[i];
                    fArray4[i] = this.f_y2[i];
                    blArray2[i] = this.hadSpace[i];
                    fArray5[i] = this.spaceWidth[i];
                    stringBuilderArray[i] = this.content[i];
                    nArray[i] = this.fontSize[i];
                    nArray3[i] = this.writingMode[i];
                    nArray2[i] = this.textLength[i];
                    blArray[i] = this.isUsed[i];
                }
                this.f_x1 = fArray;
                this.f_colorTag = stringArray;
                this.hadSpace = blArray2;
                this.f_x2 = fArray2;
                this.f_y1 = fArray3;
                this.f_y2 = fArray4;
                this.isUsed = blArray;
                this.fontSize = nArray;
                this.writingMode = nArray3;
                this.textLength = nArray2;
                this.spaceWidth = fArray5;
                this.content = stringBuilderArray;
                this.f_x1[this.nextSlot] = f;
                this.f_colorTag[this.nextSlot] = string2;
                this.f_x2[this.nextSlot] = f2;
                this.f_y1[this.nextSlot] = f3;
                this.f_y2[this.nextSlot] = f4;
                this.fontSize[this.nextSlot] = this.pdf_data.f_end_font_size[n];
                this.writingMode[this.nextSlot] = this.pdf_data.f_writingMode[n];
                nArray2[this.nextSlot] = n2;
                this.content[this.nextSlot] = stringBuilder2;
                this.spaceWidth[this.nextSlot] = this.pdf_data.space_width[n];
                ++this.nextSlot;
            }
        }
    }

    private void mergeTableRows(int n) {
        String string = "</tr>\n<tr>";
        if (!this.isXHTML) {
            string = "\n";
        }
        this.master = ((Vector_Int)this.lines.elementAt(this.line_order[0])).elementAt(0);
        for (int i = 1; i < this.max_rows; ++i) {
            int n2 = ((Vector_Int)this.lines.elementAt(this.line_order[i])).elementAt(0);
            if (this.content[this.master] == null) {
                this.master = n2;
                continue;
            }
            if (this.content[n2] == null) continue;
            this.merge(this.master, n2, string, false);
        }
        if (this.isXHTML) {
            if (n == 0) {
                this.content[this.master].insert(0, "<TABLE>\n<tr>");
                this.content[this.master].append("</tr>\n</TABLE>\n");
            } else {
                StringBuilder stringBuilder = new StringBuilder("<TABLE border='");
                stringBuilder.append(n);
                stringBuilder.append("'>\n<tr>");
                stringBuilder.append((CharSequence)this.content[this.master]);
                this.content[this.master] = stringBuilder;
                this.content[this.master].append("</tr>\n</TABLE>\n");
            }
        }
    }

    private int[] getsortedUnusedFragments(boolean bl, boolean bl2) {
        int n = this.isUsed.length;
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.isUsed[i]) continue;
            nArray[n2] = i;
            ++n2;
        }
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray2[i] = n3 = nArray[i];
            nArray3[i] = (int)this.f_x1[n3];
            nArray4[i] = (int)this.f_y1[n3];
            nArray5[i] = (int)this.f_y2[n3];
        }
        int[] nArray6 = !bl ? (bl2 ? Sorts.quicksort(nArray4, nArray3, nArray2) : Sorts.quicksort(nArray5, nArray3, nArray2)) : Sorts.quicksort(nArray3, nArray4, nArray2);
        return nArray6;
    }

    private void createTableRows(boolean bl, boolean bl2, int n) throws PdfException {
        float f;
        boolean bl3;
        int n2;
        int n3;
        float[] fArray;
        float[] fArray2;
        if (n == 0) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
        } else if (n == 1) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
        } else if (n == 3) {
            fArray2 = this.f_y2;
            fArray = this.f_y1;
        } else if (n == 2) {
            fArray2 = this.f_y1;
            fArray = this.f_y2;
            n3 = 0;
            for (float f2 : fArray2) {
                if (!((float)n3 < f2)) continue;
                n3 = (int)f2;
            }
            ++n3;
            for (n2 = 0; n2 < fArray.length; ++n2) {
                fArray2[n2] = (float)n3 - fArray2[n2];
                fArray[n2] = (float)n3 - fArray[n2];
            }
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.max_rows];
        Vector_Int[] vector_IntArray = new Vector_Int[this.max_rows];
        Vector_String vector_String = new Vector_String();
        Vector_Float vector_Float = new Vector_Float();
        Vector_Float vector_Float2 = new Vector_Float();
        String string = "";
        String string2 = "&nbsp;";
        if (!this.isXHTML) {
            string = "\",\"";
            string2 = "";
        }
        int[] nArray2 = new int[this.max_rows];
        for (n2 = 0; n2 < this.max_rows; ++n2) {
            nArray2[n2] = ((Vector_Int)this.lines.elementAt(n2)).size() - 1;
            n4 += nArray2[n2];
            nArray[n2] = 0;
            vector_IntArray[n2] = new Vector_Int(20);
        }
        do {
            float f3;
            float f4;
            float f5 = 9999.0f;
            float f6 = 9999.0f;
            float f7 = 9999.0f;
            float f8 = 0.0f;
            bl3 = true;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            String string3 = "center";
            if (n5 >= n4) continue;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                if (nArray2[n2] <= nArray[n2]) continue;
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f = fArray2[n3];
                float f12 = fArray[n3];
                if (f < f5) {
                    f5 = f;
                }
                if (!(f12 < f6)) continue;
                f6 = f12;
            }
            vector_Float2.addElement(f5);
            float f13 = f6;
            for (n2 = 0; n2 < this.max_rows; ++n2) {
                n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                f4 = fArray2[n3];
                if (f4 >= f5 & f4 < f6 & (f3 = fArray[n3]) > f13) {
                    f13 = f3;
                }
                if (nArray[n2] >= nArray2[n2] || !((f = fArray2[n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2] + 1)]) > f6 & f < f7)) continue;
                f7 = f;
            }
            if (f5 != f13) {
                if (f7 == 9999.0f) {
                    f7 = f13;
                }
                for (n2 = 0; n2 < this.max_rows; ++n2) {
                    n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                    f4 = fArray2[n3];
                    if (!(f4 >= f5 & f4 < f6 & (f3 = fArray[n3]) <= f7)) continue;
                    f9 += f4;
                    f10 += f3;
                    f8 += 1.0f;
                }
                if (n2 == 0) {
                    f11 = f5;
                }
                float f14 = f7 == -1.0f ? 0.0f : (float)((int)((f7 - f13) / 2.0f));
                int n6 = (int)(f13 - f5 + f14 + f11);
                vector_Float.addElement(n6);
                float f15 = f9 / f8 - f5;
                float f16 = f13 - f10 / f8;
                if (f15 < 1.0f) {
                    string3 = "left";
                } else if (f16 < 1.0f) {
                    string3 = "right";
                }
                vector_String.addElement(string3);
                for (n2 = 0; n2 < this.max_rows; ++n2) {
                    this.master = ((Vector_Int)this.lines.elementAt(n2)).elementAt(0);
                    if (nArray2[n2] > nArray[n2]) {
                        n3 = ((Vector_Int)this.lines.elementAt(n2)).elementAt(nArray[n2]);
                        f4 = fArray2[n3];
                        bl3 = false;
                    } else {
                        n3 = -1;
                        f4 = -1.0f;
                    }
                    if (n3 == -1 & n5 <= n4) {
                        vector_IntArray[n2].addElement(-1);
                        continue;
                    }
                    if (f4 >= f5 & f4 < f13) {
                        vector_IntArray[n2].addElement(n3);
                        int n7 = n2;
                        nArray[n7] = nArray[n7] + 1;
                        ++n5;
                        continue;
                    }
                    if (!(f4 > f13)) continue;
                    vector_IntArray[n2].addElement(-1);
                }
            }
            break;
        } while (!bl3);
        for (int i = 0; i < this.max_rows; ++i) {
            StringBuilder stringBuilder = new StringBuilder(100);
            int n8 = vector_IntArray[i].size() - 1;
            this.master = ((Vector_Int)this.lines.elementAt(i)).elementAt(0);
            for (n2 = 0; n2 < n8; ++n2) {
                n3 = vector_IntArray[i].elementAt(n2);
                if (this.isXHTML) {
                    f = vector_Float.elementAt(n2);
                    String string4 = vector_String.elementAt(n2);
                    int n9 = 1;
                    int n10 = n2 + 1;
                    if (n3 != -1) {
                        int n11;
                        while (!((n11 = vector_IntArray[i].elementAt(n2 + 1)) != -1 | n8 == n2 + 1 || nArray2[i] > 1 && vector_Float2.elementAt(n2 + 1) > fArray[n3])) {
                            --n8;
                            vector_IntArray[i].removeElementAt(n2 + 1);
                            ++n9;
                            f += vector_Float.elementAt(n10);
                            ++n10;
                        }
                    }
                    stringBuilder.append("<td");
                    if (bl) {
                        stringBuilder.append(" align='");
                        stringBuilder.append(string4);
                        stringBuilder.append('\'');
                        if (n9 > 1) {
                            stringBuilder.append(" colspan='").append(n9).append('\'');
                        }
                    }
                    if (bl2) {
                        stringBuilder.append(" width='").append((int)f).append('\'');
                    }
                    stringBuilder.append(" nowrap>");
                    if (n3 == -1) {
                        stringBuilder.append(string2);
                    } else {
                        stringBuilder.append((CharSequence)this.content[n3]);
                    }
                    stringBuilder.append("</td>");
                } else if (n3 == -1) {
                    stringBuilder.append("\"\",");
                } else {
                    stringBuilder.append('\"');
                    stringBuilder.append((CharSequence)this.content[n3]);
                    stringBuilder.append("\",");
                }
                if (n3 == -1 || this.master == n3) continue;
                this.merge(this.master, n3, string, false);
            }
            this.content[this.master] = stringBuilder;
        }
    }

    private void createLinesInTable(int n, int[] nArray, boolean bl, int n2) throws PdfException {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        if (n2 == 1) {
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        }
        switch (n2) {
            case 0: {
                fArray4 = this.f_x1;
                fArray3 = this.f_x2;
                fArray2 = this.f_y1;
                fArray = this.f_y2;
                break;
            }
            case 1: {
                fArray3 = this.f_x1;
                fArray4 = this.f_x2;
                fArray2 = this.f_y1;
                fArray = this.f_y2;
                break;
            }
            case 3: {
                fArray4 = this.f_y1;
                fArray3 = this.f_y2;
                fArray2 = this.f_x2;
                fArray = this.f_x1;
                break;
            }
            case 2: {
                fArray4 = this.f_y2;
                fArray3 = this.f_y1;
                fArray = this.f_x1;
                fArray2 = this.f_x2;
                nArray = this.getsortedUnusedFragments(false, true);
                nArray = PdfGroupingAlgorithms.reverse(nArray);
                break;
            }
            default: {
                throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
            }
        }
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            int n4 = -1;
            int n5 = n3;
            float f = -1.0f;
            if (this.isUsed[n3] || this.writingMode[n3] != n2) continue;
            Vector_Int vector_Int = new Vector_Int(20);
            vector_Int.addElement(n3);
            this.lineY2.addElement((int)fArray[n3]);
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f2;
                    int n6 = nArray[j];
                    if (this.isUsed[n6] || n6 == n3 || this.writingMode[n3] != n2 || !(fArray4[n6] > fArray4[n3] && n2 != 2) && (!(fArray4[n6] < fArray4[n3]) || n2 != 2)) continue;
                    float f3 = fArray4[n6] - fArray3[n3];
                    if (n2 == 1 || n2 == 2) {
                        f3 = -f3;
                    }
                    if (f3 < 0.0f && f3 > -2.0f) {
                        f3 = 0.0f;
                    }
                    if (!((f2 = (fArray2[n6] + fArray[n6]) / 2.0f) < fArray2[n3]) || !(f2 > fArray[n3]) || !(f < 0.0f) && !(f3 < f)) continue;
                    f = f3;
                    n4 = n6;
                }
                if (n4 == -1) break;
                float f4 = fArray4[n4] - fArray3[n5];
                float f5 = fArray4[n4] - fArray3[n3];
                float f6 = 1.5f * ((fArray3[n4] - fArray4[n4]) / (float)this.textLength[n4]);
                float f7 = 1.5f * ((fArray3[n5] - fArray4[n5]) / (float)this.textLength[n5]);
                if (n2 == 1 || n2 == 2) {
                    f5 = -f5;
                    f4 = -f4;
                    f6 = -f6;
                    f7 = -f7;
                }
                if (f4 < f6 && f4 < f7) {
                    this.merge(n5, n4, this.isGapASpace(n4, n5, f5, bl, n2), true);
                } else {
                    vector_Int.addElement(n4);
                    n5 = n4;
                }
                this.isUsed[n4] = true;
                n4 = -1;
                f = 1000000.0f;
            }
            this.lines.addElement(vector_Int);
            ++this.max_rows;
        }
    }

    public final Map extractTextAsTable(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n6) throws PdfException {
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        HashMap<String, String> hashMap = new HashMap<String, String>();
        LogWriter.writeLog("extracting Text As Table");
        this.isXHTML = !bl;
        this.lines = new Vector_Object(20);
        this.lineY2 = new Vector_Int(20);
        this.max_rows = 0;
        this.copyToArrays(n, n4, n3, n2, bl2, false, true, null, false);
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n7 = nArray2.length;
        if (n7 == 0) {
            return hashMap;
        }
        int n8 = this.getWritingMode(nArray2, n7);
        String string = "Table Merging algorithm being applied " + n7 + " items";
        LogWriter.writeLog(string);
        if (n7 > 1) {
            this.createLinesInTable(n7, nArray2, this.isXHTML, n8);
            int n9 = 1;
            if (n8 == 0 || n8 == 2) {
                n9 = -1;
            }
            this.line_order = new int[this.max_rows];
            int[] nArray3 = new int[this.max_rows];
            for (int i = 0; i < this.max_rows; ++i) {
                nArray3[i] = n9 * this.lineY2.elementAt(i);
                this.line_order[i] = i;
            }
            this.line_order = Sorts.quicksort(nArray3, this.line_order);
            this.createTableRows(bl4, bl3, n8);
            this.mergeTableRows(n6);
        }
        this.content[this.master] = this.cleanup(this.content[this.master]);
        String string2 = this.content[this.master].toString();
        if (string2 != null) {
            if (!bl) {
                string2 = Fonts.cleanupTokens(string2);
            }
            hashMap.put("content", string2);
            hashMap.put("x1", String.valueOf(n));
            hashMap.put("x2", String.valueOf(n3));
            hashMap.put("y1", String.valueOf(n2));
            hashMap.put("y2", String.valueOf(n4));
        }
        return hashMap;
    }

    private static int[] validateCoordinates(int n, int n2, int n3, int n4) {
        if (n > n3 | n2 < n4) {
            int n5;
            if (n > n3) {
                n5 = n;
                n = n3;
                n3 = n5;
                LogWriter.writeLog("x1 > x2, coordinates were swapped to validate");
            }
            if (n2 < n4) {
                n5 = n2;
                n2 = n4;
                n4 = n5;
                LogWriter.writeLog("y1 < y2, coordinates were swapped to validate");
            }
        }
        return new int[]{n, n2, n3, n4};
    }

    public final List extractTextAsWordlist(int n, int n2, int n3, int n4, int n5, boolean bl, String string) throws PdfException {
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        if (bl) {
            this.copyToArrays(n, n4, n3, n2, true, true, false, string, true);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(true);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n6 = nArray2.length;
        if (n6 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n7 = this.getWritingMode(nArray2, n6);
        this.createLines(n6, nArray2, n7, true, false, false, false);
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        float[] fArray4 = null;
        if (useUnrotatedCoords || n7 == 0) {
            fArray = this.f_x1;
            fArray2 = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 1) {
            fArray2 = this.f_x1;
            fArray = this.f_x2;
            fArray3 = this.f_y1;
            fArray4 = this.f_y2;
        } else if (n7 == 3) {
            fArray = this.f_y2;
            fArray2 = this.f_y1;
            fArray3 = this.f_x2;
            fArray4 = this.f_x1;
        } else if (n7 == 2) {
            fArray = this.f_y1;
            fArray2 = this.f_y2;
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == null) continue;
            if (this.colorExtracted && this.isXMLExtraction) {
                if (!this.content[i].toString().toLowerCase().startsWith("<color ")) {
                    this.content[i].insert(0, this.f_colorTag[this.master]);
                }
                if (!this.content[i].toString().toLowerCase().endsWith("</color>")) {
                    this.content[i].append("</color>");
                }
            }
            if (this.isXMLExtraction) {
                arrayList.add(this.content[i].toString());
            } else {
                arrayList.add(Strip.convertToText(this.content[i].toString(), this.isXMLExtraction));
            }
            if (!useUnrotatedCoords && n7 == 2) {
                arrayList.add(String.valueOf(fArray[i]));
                arrayList.add(String.valueOf(fArray3[i]));
                arrayList.add(String.valueOf(fArray2[i]));
                arrayList.add(String.valueOf(fArray4[i]));
                continue;
            }
            if (!useUnrotatedCoords && n7 == 3) {
                arrayList.add(String.valueOf(fArray[i]));
                arrayList.add(String.valueOf(fArray4[i]));
                arrayList.add(String.valueOf(fArray2[i]));
                arrayList.add(String.valueOf(fArray3[i]));
                continue;
            }
            arrayList.add(String.valueOf(fArray[i]));
            arrayList.add(String.valueOf(fArray3[i]));
            arrayList.add(String.valueOf(fArray2[i]));
            arrayList.add(String.valueOf(fArray4[i]));
        }
        LogWriter.writeLog("Text extraction as wordlist completed");
        return arrayList;
    }

    private void reset() {
        this.isXHTML = true;
        this.nextSlot = 0;
        this.lineBreaks = new Vector_Int();
        this.max_rows = 0;
        this.master = 0;
        this.colorExtracted = false;
    }

    public final String extractTextInRectangle(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) throws PdfException {
        this.reset();
        if (bl2 && !this.pdf_data.IsEmbedded()) {
            throw new PdfException("[PDF] Request to breakfragments and width not added. Please add call to init(true) of PdfDecoder to your code.");
        }
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        if (bl2) {
            this.copyToArrays(n, n4, n3, n2, this.isXMLExtraction, false, false, null, false);
        } else {
            this.copyToArrays();
        }
        this.removeEncoding();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int n6 = nArray2.length;
        if (n6 == 0) {
            LogWriter.writeLog("Less than 1 text item on page");
            return null;
        }
        int n7 = this.getWritingMode(nArray2, n6);
        this.createLines(n6, nArray2, n7, false, this.isXMLExtraction, false, false);
        int n8 = this.mergeLinesTogether(n7, bl, n, n3, n2, n4);
        if (this.isXMLExtraction) {
            this.content[n8] = new StringBuilder(Fonts.cleanupTokens(this.content[n8].toString()));
            this.content[n8].insert(0, "<p>");
            this.content[n8].append("</p>");
        }
        LogWriter.writeLog("Text extraction completed");
        return this.cleanup(this.content[n8]).toString();
    }

    private StringBuilder cleanup(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return stringBuilder;
        }
        if (this.isXMLExtraction) {
            int n;
            String string = stringBuilder.toString();
            string = string.replaceAll("&#", "XX#");
            string = string.replaceAll("&lt", "XXlt");
            string = string.replaceAll("&gt", "XXgt");
            string = string.replaceAll("&", "&amp;");
            string = string.replaceAll("XX#", "&#");
            string = string.replaceAll("XXlt", "&lt");
            string = string.replaceAll("XXgt", "&gt");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (n = 1; n <= 8; ++n) {
                hashMap.put("&#" + n + ';', "");
            }
            for (n = 11; n <= 12; ++n) {
                hashMap.put("&#" + n + ';', "");
            }
            for (n = 14; n <= 31; ++n) {
                hashMap.put("&#" + n + ';', "");
            }
            for (Object k : hashMap.keySet()) {
                String string2 = (String)k;
                String string3 = (String)hashMap.get(string2);
                string = string.replace(string2, string3);
            }
            stringBuilder = new StringBuilder(string);
        }
        return stringBuilder;
    }

    private int getWritingMode(int[] nArray, int n) {
        int n2;
        int n3;
        int[] nArray2 = new int[4];
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            if (this.isUsed[n2]) continue;
            int n4 = this.writingMode[n2];
            nArray2[n4] = nArray2[n4] + 1;
        }
        n3 = 0;
        for (n2 = 1; n2 != nArray2.length; ++n2) {
            if (nArray2[n2] <= nArray2[n3]) continue;
            n3 = n2;
        }
        return n3;
    }

    private int mergeLinesTogether(int n, boolean bl, int n2, int n3, int n4, int n5) throws PdfException {
        int n6;
        int[] nArray;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        if (n == 0) {
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 1) {
            fArray3 = this.f_x1;
            fArray4 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
            nArray = this.getsortedUnusedFragments(false, true);
            n6 = (n2 + n3) / 2;
        } else if (n == 3) {
            fArray4 = this.f_y1;
            fArray3 = this.f_y2;
            fArray2 = this.f_x2;
            fArray = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            nArray = PdfGroupingAlgorithms.reverse(nArray);
            n6 = (n4 + n5) / 2;
        } else if (n == 2) {
            fArray4 = this.f_y2;
            fArray3 = this.f_y1;
            fArray = this.f_x2;
            fArray2 = this.f_x1;
            nArray = this.getsortedUnusedFragments(true, true);
            n6 = (n4 + n5) / 2;
        } else {
            throw new PdfException("Illegal value " + n + "for currentWritingMode");
        }
        int n7 = n6 / 2;
        int n8 = nArray.length;
        int n9 = nArray[n8 - 1];
        for (int i = n8 - 2; i > -1; --i) {
            int n10 = nArray[i];
            StringBuilder stringBuilder = new StringBuilder();
            int n11 = this.getLastChar(this.content[n10]);
            if (n11 == -1) continue;
            this.addAlignmentFormatting(bl, n6, fArray4, fArray3, n7, n10);
            String string = "</p>" + SystemSeparator + "<p>";
            if (this.isXMLExtraction) {
                string = SystemSeparator;
            }
            float f = fArray[n9] - fArray2[n10];
            float f2 = fArray2[n10] - fArray[n10];
            if (f2 < 1.0f) {
                f2 = fArray2[n9] - fArray[n9];
            }
            if (n == 3) {
                f = -f;
                f2 = -f2;
            }
            if (f > f2 & f2 > 0.0f) {
                while (f > f2) {
                    stringBuilder.append(string);
                    f -= f2;
                }
                if (this.isXMLExtraction) {
                    stringBuilder.append("</p>").append(SystemSeparator).append("<p>");
                } else {
                    stringBuilder = new StringBuilder(SystemSeparator);
                }
            } else if (bl) {
                int n12 = this.getFirstChar(this.content[n10]);
                int n13 = this.getLastChar(this.content[n9]);
                if ((n13 == 46 || n13 == 34) && n12 >= 65 && n12 <= 90) {
                    if (this.isXMLExtraction) {
                        stringBuilder.append("</p>").append(SystemSeparator).append("<p>");
                    } else {
                        stringBuilder = new StringBuilder(SystemSeparator);
                    }
                } else if (this.fontSize[n10] > 70 && this.fontSize[n10] == this.fontSize[n9] && f2 > 70.0f && f > 5.0f && f2 > 0.0f) {
                    if (this.isXMLExtraction) {
                        this.content[n10].insert(0, ' ');
                    } else {
                        this.content[n9].append(' ');
                    }
                }
            } else if (this.isXMLExtraction) {
                this.content[n10].insert(0, "</p>" + SystemSeparator + "<p>");
            } else {
                this.content[n9].append(SystemSeparator);
            }
            this.merge(n9, n10, stringBuilder.toString(), false);
        }
        return n9;
    }

    private int getFirstChar(StringBuilder stringBuilder) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuilder.length();
        int n3 = 32;
        for (int i = 0; i < n2; ++i) {
            char c = stringBuilder.charAt(i);
            if (!bl && (c == '<' || this.isXMLExtraction && c == '&')) {
                bl = true;
                n3 = c;
                if (n3 == 38) {
                    if (i + 1 == n2) {
                        n = 38;
                        i = n2;
                    } else {
                        char c2 = stringBuilder.charAt(i + 1);
                        if (c2 != '#' && c2 != 'g' && c2 != 'l') {
                            n = 38;
                            i = n2;
                        }
                    }
                }
            }
            if (!bl && c != ' ') {
                n = c;
                i = n2;
            }
            if (bl && n3 == 38 && c == ' ') {
                n = n3;
                i = n2;
                continue;
            }
            if (!bl || c != '>' && (!this.isXMLExtraction || n3 != 38 || c != ';')) continue;
            if (c == ';' && n3 == 38 && i > 2 && stringBuilder.charAt(i - 1) == 't') {
                if (stringBuilder.charAt(i - 2) == 'l') {
                    n = 60;
                    i = n2;
                } else if (stringBuilder.charAt(i - 2) == 'g') {
                    n = 62;
                    i = n2;
                }
            }
            bl = false;
        }
        return n;
    }

    private int getLastChar(StringBuilder stringBuilder) {
        int n = -1;
        boolean bl = false;
        int n2 = stringBuilder.length();
        int n3 = n2--;
        int n4 = 32;
        while (n2 > -1) {
            char c = stringBuilder.charAt(n2);
            if (bl && n4 == 59 && c == ';') {
                n = 59;
                n2 = -1;
            }
            if (!bl && (c == '>' || this.isXMLExtraction && c == ';')) {
                bl = true;
                int n5 = stringBuilder.lastIndexOf("</");
                if (n5 == -1) {
                    bl = false;
                } else {
                    for (int i = n5; i < n2; ++i) {
                        char c2 = stringBuilder.charAt(i);
                        if (c2 != ' ' && c2 != '>') continue;
                        bl = false;
                        i = n2;
                    }
                }
                if (bl) {
                    n4 = c;
                } else {
                    n = c;
                    n2 = -1;
                }
            }
            if (!bl && c != ' ') {
                n = c;
                n2 = -1;
            }
            if (c == '<' || this.isXMLExtraction && n4 == 59 && c == '&') {
                bl = false;
                if (c == '&' && n2 + 3 < n3 && stringBuilder.charAt(n2 + 2) == 't' && stringBuilder.charAt(n2 + 3) == ';') {
                    if (stringBuilder.charAt(n2 + 1) == 'l') {
                        n = 60;
                        n2 = -1;
                    } else if (stringBuilder.charAt(n2 + 1) == 'g') {
                        n = 62;
                        n2 = -1;
                    }
                }
            }
            if (bl && n4 == 59 && c == ' ') {
                n2 = -1;
                n = 59;
            }
            --n2;
        }
        return n;
    }

    private static int[] reverse(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[n - i - 1];
        }
        return nArray2;
    }

    private void addAlignmentFormatting(boolean bl, int n, float[] fArray, float[] fArray2, int n2, int n3) {
        float f = (float)n - fArray[n3];
        float f2 = fArray2[n3] - (float)n;
        if (!bl && this.isXMLExtraction && f > 0.0f && f2 > 0.0f && fArray[n3] > (float)n2 && fArray[n3] < (float)(n + n2)) {
            float f3 = f / f2;
            if (f3 > 1.0f) {
                f3 = 1.0f / f3;
            }
            if ((double)f3 > 0.95) {
                this.content[n3] = new StringBuilder(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<center>");
                this.content[n3].append("</center>\n");
            } else if (f2 < 10.0f & f > 30.0f) {
                this.content[n3] = new StringBuilder(Fonts.cleanupTokens(this.content[n3].toString()));
                this.content[n3].insert(0, "<right>");
                this.content[n3].append("</right>\n");
            }
        }
    }

    private void createLinesForSearch(int n, int[] nArray, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PdfException {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        if (n2 == 1 || n2 == 2) {
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        }
        if (n2 == 0) {
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
        } else if (n2 == 1) {
            fArray3 = this.f_x1;
            fArray4 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
        } else if (n2 == 3) {
            fArray4 = this.f_y2;
            fArray3 = this.f_y1;
            fArray2 = this.f_x2;
            fArray = this.f_x1;
        } else if (n2 == 2) {
            fArray4 = this.f_y2;
            fArray3 = this.f_y1;
            fArray = this.f_x1;
            fArray2 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
        }
        block0: for (int i = 0; i < n; ++i) {
            int n3 = -1;
            int n4 = nArray[i];
            if (this.isUsed[n4] || this.writingMode[n4] != n2) continue;
            for (int j = 0; j < n && n3 == -1; ++j) {
                float f;
                int n5 = nArray[j];
                if (this.isUsed[n5] || n4 == n5 || this.writingMode[n4] != this.writingMode[n5] || fArray4[n5] == fArray3[n5]) continue;
                float f2 = fArray4[n4] + (fArray3[n4] - fArray4[n4]) / 2.0f;
                float f3 = fArray[n4] + (fArray2[n4] - fArray[n4]) / 2.0f;
                float f4 = fArray4[n5] + (fArray3[n5] - fArray4[n5]) / 2.0f;
                float f5 = fArray[n5] + (fArray2[n5] - fArray[n5]) / 2.0f;
                float f6 = fArray2[n4] - fArray[n4];
                float f7 = fArray2[n5] - fArray[n5] - f6;
                if (f7 < 0.0f) {
                    f6 = fArray2[n5] - fArray[n5];
                }
                if (Math.abs(f7) < f6 * 2.0f && (double)Math.abs(f3 - f5) < (double)f6 * 0.5 && f2 < f4 && (f = fArray4[n5] - fArray3[n4]) <= f6 / 2.0f) {
                    n3 = n5;
                }
                if (n3 == -1) continue;
                f = fArray4[n3] - fArray3[n4];
                if (n2 == 1 || n2 == 2) {
                    f = -f;
                }
                String string = this.isGapASpace(n4, n3, f, bl2, n2);
                if (bl && this.hadSpace != null && (this.hadSpace[n4] || string.startsWith(" "))) continue block0;
                if (bl4 && n5 != n4 && (fArray4[n5] > fArray4[n4] && n2 != 2 || fArray4[n5] < fArray4[n4] && n2 == 2 && this.writingMode[n4] == n2) || !bl4 && n5 != n4 && (fArray4[n5] > fArray4[n4] && n2 != 2 || fArray4[n5] < fArray4[n4] && n2 == 2 && this.writingMode[n4] == n2)) {
                    this.merge(n4, n3, string, true);
                }
                n3 = -1;
            }
        }
    }

    private void createLines(int n, int[] nArray, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PdfException {
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[] fArray4;
        if (n2 == 1 || n2 == 2) {
            nArray = PdfGroupingAlgorithms.reverse(nArray);
        }
        if (n2 == 0) {
            fArray4 = this.f_x1;
            fArray3 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
        } else if (n2 == 1) {
            fArray3 = this.f_x1;
            fArray4 = this.f_x2;
            fArray2 = this.f_y1;
            fArray = this.f_y2;
        } else if (n2 == 3) {
            fArray4 = this.f_y1;
            fArray3 = this.f_y2;
            fArray2 = this.f_x2;
            fArray = this.f_x1;
        } else if (n2 == 2) {
            fArray4 = this.f_y2;
            fArray3 = this.f_y1;
            fArray = this.f_x1;
            fArray2 = this.f_x2;
        } else {
            throw new PdfException("Illegal value " + n2 + "for currentWritingMode");
        }
        block0: for (int i = 0; i < n; ++i) {
            int n3 = -1;
            int n4 = nArray[i];
            float f = -1.0f;
            if (this.isUsed[n4] || this.writingMode[n4] != n2) continue;
            while (true) {
                for (int j = 0; j < n; ++j) {
                    float f2;
                    int n5;
                    int n6;
                    int n7 = nArray[j];
                    if (this.isUsed[n7]) continue;
                    int n8 = (int)(fArray[n7] - fArray[n4]);
                    if (n8 < 0) {
                        n8 = -n8;
                    }
                    if ((n6 = (int)(fArray2[n7] - fArray2[n4])) < 0) {
                        n6 = -n6;
                    }
                    int n9 = (int)(fArray4[n7] - fArray3[n4]);
                    if (!bl4 && n9 > (int)(fArray4[n4] - fArray3[n7])) {
                        n9 = (int)(fArray4[n4] - fArray3[n7]);
                    }
                    if ((n5 = this.fontSize[n4] - this.fontSize[n7]) < 0) {
                        n5 = -n5;
                    }
                    if (bl3 && n9 > this.fontSize[n4] && n9 > 0 || bl3 && n8 > 1 && n9 > 2 * this.fontSize[n4] && this.fontSize[n4] == this.fontSize[n7] || bl3 && n8 > 3 || bl3 && n5 > 2 || !(bl4 && n7 != n4 && n9 <= 2 * this.fontSize[n4] && -n9 <= 2 * this.fontSize[n4] && (fArray4[n7] > fArray4[n4] && n2 != 2 || fArray4[n7] < fArray4[n4] && n2 == 2 && this.writingMode[n4] == n2 && (n5 <= 2 || n5 > 2 && n6 < 3))) && (bl4 || n7 == n4 || !(fArray4[n7] > fArray4[n4] && n2 != 2) && (!(fArray4[n7] < fArray4[n4]) || n2 != 2 || this.writingMode[n4] != n2 || n5 > 2 && (n5 <= 2 || n6 >= 3)))) continue;
                    float f3 = fArray4[n7] - fArray3[n4];
                    if (n2 == 1 || n2 == 2) {
                        f3 = -f3;
                    }
                    if (f3 < 0.0f && f3 > -2.0f) {
                        f3 = 0.0f;
                    }
                    if (!((f2 = (fArray2[n7] + fArray[n7]) / 2.0f) < fArray2[n4]) || !(f2 > fArray[n4]) || !(f < 0.0f) && !(f3 < f)) continue;
                    f = f3;
                    n3 = n7;
                }
                if (n3 == -1) continue block0;
                float f4 = fArray4[n3] - fArray3[n4];
                if (n2 == 1 || n2 == 2) {
                    f4 = -f4;
                } else if (n2 == 3) {
                    f4 = fArray3[n3] - fArray4[n4];
                }
                String string = this.isGapASpace(n4, n3, f4, bl2, n2);
                if (bl && this.hadSpace != null && (this.hadSpace[n4] || string.startsWith(" "))) continue block0;
                this.merge(n4, n3, string, true);
                n3 = -1;
                f = 1000000.0f;
            }
        }
    }

    public SortedMap findMultipleTermsInRectangleWithMatchingTeasers(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, int n7, SearchListener searchListener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        boolean bl = this.includeTease;
        this.includeTease = true;
        List list = this.findMultipleTermsInRectangle(n, n2, n3, n4, n6, stringArray, n7, searchListener);
        TreeMap treeMap = new TreeMap(new ResultsComparatorRectangle(n5));
        for (int i = 0; i < list.size(); ++i) {
            treeMap.put(list.get(i), this.multipleTermTeasers.get(i));
        }
        this.usingMultipleTerms = false;
        this.includeTease = bl;
        return treeMap;
    }

    public SortedMap findTextWithinInAreaWithTeasers(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, int n7, SearchListener searchListener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        boolean bl = this.includeTease;
        this.includeTease = true;
        List list = this.findTextWithinArea(n, n2, n3, n4, stringArray, n7, searchListener);
        TreeMap treeMap = new TreeMap(new ResultsComparator(n5));
        for (int i = 0; i < list.size(); ++i) {
            treeMap.put(list.get(i), this.multipleTermTeasers.get(i));
        }
        this.usingMultipleTerms = false;
        this.includeTease = bl;
        return treeMap;
    }

    public List findMultipleTermsInRectangle(int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray, boolean bl, int n7, SearchListener searchListener) throws PdfException {
        this.usingMultipleTerms = true;
        this.multipleTermTeasers.clear();
        this.teasers = null;
        List list = this.findMultipleTermsInRectangle(n, n2, n3, n4, n6, stringArray, n7, searchListener);
        if (bl) {
            Collections.sort(list, new ResultsComparator(n5));
        }
        this.usingMultipleTerms = false;
        return list;
    }

    private List findMultipleTermsInRectangle(int n, int n2, int n3, int n4, int n5, String[] stringArray, int n6, SearchListener searchListener) throws PdfException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : stringArray) {
            if (searchListener != null && searchListener.isCanceled()) break;
            float[] fArray = this.findText(n, n2, n3, n4, new String[]{string}, n6);
            if (fArray == null) continue;
            int n7 = fArray.length;
            for (int i = 0; i < n7; i += 5) {
                int n8 = (int)fArray[i];
                int n9 = (int)fArray[i + 1];
                int n10 = (int)fArray[i + 2];
                int n11 = (int)fArray[i + 3];
                Rectangle rectangle = new Rectangle(n8, n11, n10 - n8, n9 - n11);
                int n12 = (int)fArray[i + 4];
                if (n12 == -101) {
                    Vector_Rectangle vector_Rectangle = new Vector_Rectangle();
                    vector_Rectangle.addElement(rectangle);
                    while (n12 == -101) {
                        n8 = (int)fArray[i += 5];
                        n9 = (int)fArray[i + 1];
                        n10 = (int)fArray[i + 2];
                        n11 = (int)fArray[i + 3];
                        n12 = (int)fArray[i + 4];
                        rectangle = new Rectangle(n8, n11, n10 - n8, n9 - n11);
                        vector_Rectangle.addElement(rectangle);
                    }
                    vector_Rectangle.trim();
                    arrayList.add(vector_Rectangle.get());
                    continue;
                }
                arrayList.add(rectangle);
            }
        }
        return arrayList;
    }

    private List findTextWithinArea(int n, int n2, int n3, int n4, String[] stringArray, int n5, SearchListener searchListener) throws PdfException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : stringArray) {
            if (searchListener != null && searchListener.isCanceled()) break;
            float[] fArray = this.findText(n, n2, n3, n4, new String[]{string}, n5);
            if (fArray == null) continue;
            int n6 = fArray.length;
            for (int i = 0; i < n6; i += 5) {
                int n7 = (int)fArray[i];
                int n8 = (int)fArray[i + 1];
                int n9 = (int)fArray[i + 2];
                int n10 = (int)fArray[i + 3];
                int[] nArray = new int[]{n7, n10, n9 - n7, n8 - n10};
                int n11 = (int)fArray[i + 4];
                if (n11 == -101) {
                    Vector_Rectangle_Int vector_Rectangle_Int = new Vector_Rectangle_Int();
                    vector_Rectangle_Int.addElement(nArray);
                    while (n11 == -101) {
                        n7 = (int)fArray[i += 5];
                        n8 = (int)fArray[i + 1];
                        n9 = (int)fArray[i + 2];
                        n10 = (int)fArray[i + 3];
                        n11 = (int)fArray[i + 4];
                        nArray = new int[]{n7, n10, n9 - n7, n8 - n10};
                        vector_Rectangle_Int.addElement(nArray);
                    }
                    vector_Rectangle_Int.trim();
                    arrayList.add(vector_Rectangle_Int.get());
                    continue;
                }
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    public final float[] findText(int n, int n2, int n3, int n4, String[] stringArray, int n5) throws PdfException {
        if (stringArray == null) {
            return new float[0];
        }
        Vector_Float vector_Float = new Vector_Float(0);
        Vector_String vector_String = new Vector_String(0);
        int[] nArray = PdfGroupingAlgorithms.validateCoordinates(n, n2, n3, n4);
        n = nArray[0];
        n2 = nArray[1];
        n3 = nArray[2];
        n4 = nArray[3];
        this.copyToArraysPartial(n, n4, n3, n2);
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray2 = this.getsortedUnusedFragments(true, false);
        int[] nArray3 = this.getWritingModeCounts(nArray2);
        int[] nArray4 = PdfGroupingAlgorithms.getWritingModeOrder(nArray3);
        for (int i = 0; i != nArray4.length; ++i) {
            int n6 = nArray4[i];
            if (nArray3[n6] == 0) continue;
            this.searchWritingMode(nArray2, n6, n5, stringArray, vector_Float, vector_String);
        }
        return vector_Float.get();
    }

    public final float[] findText(Rectangle rectangle, int n, String[] stringArray, int n2) throws PdfException {
        return this.findText(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, stringArray, n2);
    }

    public final float[] findText(String[] stringArray, int n) throws PdfException {
        if (stringArray == null) {
            return new float[0];
        }
        Vector_Float vector_Float = new Vector_Float(0);
        Vector_String vector_String = new Vector_String(0);
        this.copyToArrays();
        this.cleanupShadowsAndDrownedObjects(false);
        int[] nArray = this.getsortedUnusedFragments(true, false);
        int[] nArray2 = this.getWritingModeCounts(nArray);
        int[] nArray3 = PdfGroupingAlgorithms.getWritingModeOrder(nArray2);
        for (int i = 0; i != nArray3.length; ++i) {
            int n2 = nArray3[i];
            if (nArray2[n2] == 0) continue;
            this.searchWritingMode(nArray, n2, n, stringArray, vector_Float, vector_String);
        }
        return vector_Float.get();
    }

    private static String removeDuplicateSpaces(String string) {
        if (string.contains("  ")) {
            string = string.replace("  ", " ");
        }
        return string;
    }

    public String[] getTeasers() {
        return this.teasers;
    }

    public void generateTeasers() {
        this.includeTease = true;
    }

    private static int loadSearcherOptions(int n) {
        int n2 = 0;
        if ((n & 2) != 2) {
            n2 |= 2;
        }
        if ((n & 8) == 8) {
            n2 = n2 | 8 | 0x20;
        }
        return n2;
    }

    private int[] getWritingModeCounts(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block6: for (int i = 0; i != nArray.length; ++i) {
            switch (this.writingMode[nArray[i]]) {
                case 0: {
                    ++n;
                    continue block6;
                }
                case 1: {
                    ++n2;
                    continue block6;
                }
                case 2: {
                    ++n3;
                    continue block6;
                }
                case 3: {
                    ++n4;
                }
            }
        }
        return new int[]{n, n2, n3, n4};
    }

    private static int[] getWritingModeOrder(int[] nArray) {
        int[] nArray2 = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
        int[] nArray3 = new int[]{-1, -1, -1, -1};
        Arrays.sort(nArray2);
        for (int i = 0; i != nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                int n = j - 3;
                if (n < 0) {
                    n = -n;
                }
                if (nArray3[n] != -1) continue;
                nArray3[n] = i;
                j = nArray2.length;
            }
        }
        return nArray3;
    }

    private static String alterStringTooDisplayOrder(String string) {
        String string2 = "";
        String string3 = "";
        byte by = Character.getDirectionality(string.charAt(0));
        for (int i = 0; i != string.length(); ++i) {
            byte by2 = Character.getDirectionality(string.charAt(i));
            switch (by2) {
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    by2 = 1;
                    break;
                }
                case 0: 
                case 14: 
                case 15: {
                    by2 = 0;
                    break;
                }
                default: {
                    by2 = by;
                }
            }
            if (by2 != by) {
                string3 = string3 + string2;
                string2 = "";
                by = by2;
            }
            string2 = by2 == 1 ? string.charAt(i) + string2 : string2 + string.charAt(i);
        }
        string3 = string3 + string2;
        return string3;
    }

    private void searchWritingMode(int[] nArray, int n, int n2, String[] stringArray, Vector_Float vector_Float, Vector_String vector_String) throws PdfException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.createLinesForSearch(nArray.length, nArray, n, true, false, true, true);
        int n3 = PdfGroupingAlgorithms.loadSearcherOptions(n2);
        if ((n2 & 4) == 4) {
            bl = true;
        }
        if ((n2 & 1) == 1) {
            bl2 = true;
        }
        if ((n2 & 0x20) == 32) {
            bl4 = true;
        }
        boolean bl5 = n == 3 || n == 2;
        String string = this.buildSearchText(false, n);
        String string2 = this.buildSearchText(true, n);
        for (int i = 0; i != stringArray.length; ++i) {
            String string3 = PdfGroupingAlgorithms.alterStringTooDisplayOrder(stringArray[i]);
            String string4 = " ";
            if ((n2 & 8) == 8) {
                string4 = "[ \\\\n]+";
            }
            if (!bl4) {
                string3 = "\\Q" + string3 + "\\E";
                string4 = "\\\\E" + string4 + "\\\\Q";
            }
            if (!string4.equals(" ")) {
                string3 = string3.replaceAll(" ", string4);
            }
            if (bl2) {
                string3 = "\\b" + string3 + "\\b";
            }
            Pattern pattern = Pattern.compile(string3, n3);
            Pattern pattern2 = Pattern.compile("(?:\\S+\\s)?\\S*(?:\\S+\\s)?\\S*" + string3 + "\\S*(?:\\s\\S+)?\\S*(?:\\s\\S+)?", n3);
            if (string == null) continue;
            Matcher matcher = pattern.matcher(string);
            Matcher matcher2 = pattern2.matcher(string);
            boolean bl6 = true;
            while (matcher.find()) {
                int[] nArray2 = null;
                String string5 = matcher.group();
                int n4 = matcher.start();
                int n5 = matcher.end() - 1;
                if (this.includeTease) {
                    if (this.includeHTMLtags) {
                        string5 = "<b>" + string5 + "</b>";
                    }
                    if (bl6) {
                        this.findTeaser(string5, matcher2, n4, n5, vector_String);
                    }
                }
                this.getResultCoords(string2, n, nArray2, n4, n5, bl5, vector_Float);
                if (!bl) continue;
                bl3 = true;
                break;
            }
            if (bl && bl3) break;
        }
        vector_Float.trim();
        if (this.includeTease) {
            this.storeTeasers(vector_String);
        }
    }

    private String buildSearchText(boolean bl, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i != this.content.length; ++i) {
            if (this.content[i] == null || n != this.writingMode[i]) continue;
            stringBuilder.append((CharSequence)this.content[i]).append('\n');
        }
        String string = PdfGroupingAlgorithms.removeDuplicateSpaces(stringBuilder.toString());
        if (!bl) {
            string = PdfGroupingAlgorithms.removeHiddenMarkers(string);
        }
        string = Strip.stripXML(string, this.isXMLExtraction).toString();
        return string;
    }

    private void getResultCoords(String string, int n, int[] nArray, int n2, int n3, boolean bl, Vector_Float vector_Float) {
        int n4 = -1;
        int n5 = 0;
        while (this.content[n5] == null || n != this.writingMode[n5]) {
            ++n5;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 1; i < string.length(); ++i) {
            int n6;
            int n7 = i;
            while (i < string.length() && string.charAt(i) != MARKER2) {
                ++i;
            }
            float f = Float.parseFloat(string.substring(n7, i));
            n7 = ++i;
            while (i < string.length() && string.charAt(i) != MARKER2) {
                ++i;
            }
            float f2 = Float.parseFloat(string.substring(n7, i));
            n7 = ++i;
            while (i < string.length() && string.charAt(i) != MARKER2) {
                ++i;
            }
            String string2 = string.substring(n7, i);
            if (!bl2 && (n4 += string2.length()) >= n2) {
                n6 = (int)this.f_y1[n5];
                if (bl) {
                    n6 = (int)this.f_x2[n5];
                }
                nArray = new int[]{(int)f, n6};
                bl2 = true;
            }
            if (!bl3 && n4 >= n3) {
                n6 = (int)this.f_y2[n5];
                if (bl) {
                    n6 = (int)this.f_x1[n5];
                }
                PdfGroupingAlgorithms.storeResultsCoords(bl, n, vector_Float, nArray[0], nArray[1], f + f2, n6, 0.0f);
                bl3 = true;
            }
            if (bl2 && !bl3 && string2.contains("\n")) {
                PdfGroupingAlgorithms.storeResultsCoords(bl, n, vector_Float, nArray[0], nArray[1], f + f2, this.f_y2[n5], -101.0f);
                bl2 = false;
                n2 = n4;
            }
            if (!string2.contains("\n")) continue;
            ++n5;
            while (n5 < this.content.length && (this.content[n5] == null || n != this.writingMode[n5])) {
                ++n5;
            }
        }
    }

    private void storeTeasers(Vector_String vector_String) {
        vector_String.trim();
        if (this.usingMultipleTerms) {
            for (int i = 0; i != vector_String.size(); ++i) {
                this.multipleTermTeasers.add(vector_String.elementAt(i));
            }
            vector_String.clear();
        } else {
            this.teasers = vector_String.get();
        }
    }

    private static void storeResultsCoords(boolean bl, int n, Vector_Float vector_Float, float f, float f2, float f3, float f4, float f5) {
        if (bl) {
            if (n == 3) {
                vector_Float.addElement(f4);
                vector_Float.addElement(f3);
                vector_Float.addElement(f2);
                vector_Float.addElement(f);
                vector_Float.addElement(f5);
            } else {
                vector_Float.addElement(f4);
                vector_Float.addElement(f);
                vector_Float.addElement(f2);
                vector_Float.addElement(f3);
                vector_Float.addElement(f5);
            }
        } else {
            vector_Float.addElement(f);
            vector_Float.addElement(f2);
            vector_Float.addElement(f3);
            vector_Float.addElement(f4);
            vector_Float.addElement(f5);
        }
    }

    private void findTeaser(String string, Matcher matcher, int n, int n2, Vector_String vector_String) {
        if (matcher.find() && matcher.start() < n && matcher.end() > n2) {
            string = matcher.group();
            if (this.includeHTMLtags) {
                int n3 = n - matcher.start();
                int n4 = n2 - matcher.start() + 1;
                string = string.substring(0, n3) + "<b>" + string.substring(n3, n4) + "</b>" + string.substring(n4, string.length());
            }
        }
        vector_String.addElement(string);
    }

    private class Fragment {
        float x1;
        float y1;
        float x2;
        float y2;
        float character_spacing;
        String raw;
        String currentColor;
        int text_length;
        int mode;

        Fragment(PdfData pdfData, int n) {
            this.loadData(pdfData, n);
        }

        public void loadData(PdfData pdfData, int n) {
            this.character_spacing = pdfData.f_character_spacing[n];
            this.x1 = pdfData.f_x1[n];
            this.x2 = pdfData.f_x2[n];
            this.y1 = pdfData.f_y1[n];
            this.y2 = pdfData.f_y2[n];
            this.currentColor = pdfData.colorTag[n];
            this.text_length = pdfData.text_length[n];
            this.mode = pdfData.f_writingMode[n];
            this.raw = pdfData.contents[n];
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public float getCharacterSpacing() {
            return this.character_spacing;
        }

        public String getRawData() {
            return this.raw;
        }

        public String getColorTag() {
            return this.currentColor;
        }

        public int getWritingMode() {
            return this.mode;
        }

        public int getTextLength() {
            return this.text_length;
        }

        public void setX1(float f) {
            this.x1 = f;
        }

        public void setY1(float f) {
            this.y1 = f;
        }

        public void setX2(float f) {
            this.x2 = f;
        }

        public void setY2(float f) {
            this.y2 = f;
        }
    }

    static class ResultsComparator
    implements Comparator {
        private final int rotation;

        ResultsComparator(int n) {
            this.rotation = n;
        }

        public int compare(Object object, Object object2) {
            Object object3 = object instanceof int[][] ? (int[][])object : (Object)new int[][]{(int[])object};
            Object object4 = object2 instanceof int[][] ? (int[][])object2 : (Object)new int[][]{(int[])object2};
            for (int i = 0; i != ((int[][])object3).length; ++i) {
                for (int j = 0; j != ((int[][])object4).length; ++j) {
                    int[] nArray = object3[i];
                    int[] nArray2 = object4[j];
                    switch (this.rotation) {
                        case 0: {
                            if (nArray[1] == nArray2[1]) {
                                if (nArray[0] > nArray2[0]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (nArray[1] > nArray2[1]) {
                                return -1;
                            }
                            return 1;
                        }
                        case 90: {
                            if (nArray[0] == nArray2[0]) {
                                if (nArray[1] > nArray2[1]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (nArray[0] > nArray2[0]) {
                                return 1;
                            }
                            return -1;
                        }
                        case 180: {
                            if (nArray[1] == nArray2[1]) {
                                if (nArray[0] > nArray2[0]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (nArray[1] > nArray2[1]) {
                                return -1;
                            }
                            return 1;
                        }
                        case 270: {
                            if (nArray[0] == nArray2[0]) {
                                if (nArray[1] > nArray2[1]) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (nArray[0] < nArray2[0]) {
                                return 1;
                            }
                            return -1;
                        }
                    }
                }
            }
            return -1;
        }
    }

    static class ResultsComparatorRectangle
    implements Comparator {
        private final int rotation;

        ResultsComparatorRectangle(int n) {
            this.rotation = n;
        }

        public int compare(Object object, Object object2) {
            Rectangle rectangle = object instanceof Rectangle[] ? ((Rectangle[])object)[0] : (Rectangle)object;
            Rectangle rectangle2 = object2 instanceof Rectangle[] ? ((Rectangle[])object2)[0] : (Rectangle)object2;
            if (this.rotation == 0 || this.rotation == 180) {
                if (rectangle.y == rectangle2.y) {
                    if (rectangle.x > rectangle2.x) {
                        return 1;
                    }
                    return -1;
                }
                if (rectangle.y > rectangle2.y) {
                    return -1;
                }
                return 1;
            }
            if (rectangle.x == rectangle2.x) {
                if (rectangle.y > rectangle2.y) {
                    return 1;
                }
                return -1;
            }
            if (rectangle.x > rectangle2.x) {
                return 1;
            }
            return -1;
        }
    }
}

