/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.SetSecurity;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ObjectCloneFactory;

public class DecryptionFactory {
    private Map cachedObjects = new HashMap();
    private boolean extractionIsAllowed = true;
    private boolean isInitialised;
    private boolean isMetaDataEncypted = true;
    private boolean isPasswordSupplied;
    private boolean stringsEncoded;
    private boolean isEncrypted;
    private byte[] encryptionKey;
    private int rev;
    private int P;
    private byte[] O;
    private byte[] U;
    private byte[] OE;
    private byte[] Perms;
    private byte[] UE;
    Cipher cipher;
    private boolean isAES;
    private PdfObject StmFObj;
    private PdfObject StrFObj;
    private static boolean alwaysReinitCipher;
    private final String[] pad = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private boolean isAESIdentity;
    private int keyLength = 5;
    private boolean isFileViewable = true;
    private int passwordStatus;
    private final byte[] ID;
    private byte[] encryptionPassword;
    private Certificate certificate;
    private Key key;

    public DecryptionFactory(byte[] byArray, byte[] byArray2) {
        this.ID = byArray;
        this.encryptionPassword = byArray2;
    }

    public DecryptionFactory(byte[] byArray, Certificate certificate, PrivateKey privateKey) {
        this.ID = byArray;
        this.certificate = certificate;
        this.key = privateKey;
    }

    private boolean testPassword() throws PdfSecurityException {
        int n = 32;
        byte[] byArray = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = (byte)Integer.parseInt(this.pad[i], 16);
        }
        byte[] byArray2 = ObjectCloneFactory.cloneArray(byArray);
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byArray2 = this.decrypt(byArray2, "", true, null, false, false);
        } else if (this.rev >= 3) {
            int n2 = this.keyLength;
            n = 16;
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byte[] byArray3 = ObjectCloneFactory.cloneArray(this.encryptionKey);
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " with digest");
            }
            messageDigest.update(byArray2);
            byte[] byArray4 = messageDigest.digest(this.ID);
            byArray4 = this.decrypt(byArray4, "", true, null, true, false);
            byte[] byArray5 = new byte[n2];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < n2; ++j) {
                    byArray5[j] = (byte)(byArray3[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray4 = this.decrypt(byArray4, "", true, null, true, false);
            }
            this.encryptionKey = byArray3;
            byArray2 = new byte[32];
            System.arraycopy(byArray4, 0, byArray2, 0, 16);
            System.arraycopy(byArray, 0, byArray2, 16, 16);
        }
        return DecryptionFactory.compareKeys(this.U, byArray2, n);
    }

    private static boolean compareKeys(byte[] byArray, byte[] byArray2, int n) {
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            bl = false;
            i = byArray.length;
        }
        return bl;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        byte[] byArray = this.getPaddedKey(this.encryptionPassword, this.encryptionPassword);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            this.encryptionKey = messageDigest.digest(byArray);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    this.encryptionKey = messageDigest.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        int n;
        byte[] byArray = this.encryptionPassword;
        byte[] byArray2 = new byte[this.keyLength];
        byte[] byArray3 = ObjectCloneFactory.cloneArray(this.O);
        this.computeEncryptionKey();
        byte[] byArray4 = ObjectCloneFactory.cloneArray(this.encryptionKey);
        if (this.rev == 2) {
            byArray2 = this.decrypt(ObjectCloneFactory.cloneArray(this.O), "", false, null, false, false);
        } else if (this.rev >= 3) {
            n = this.keyLength;
            byArray2 = byArray3;
            byte[] byArray5 = new byte[n];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    byArray5[j] = (byte)(byArray4[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray2 = this.decrypt(byArray2, "", false, null, true, false);
            }
        }
        this.encryptionPassword = byArray2;
        this.computeEncryptionKey();
        n = this.testPassword() ? 1 : 0;
        if (n == 0) {
            this.encryptionPassword = byArray;
            this.computeEncryptionKey();
        }
        return n != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        this.isPasswordSupplied = false;
        this.extractionIsAllowed = false;
        this.passwordStatus = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (this.rev < 5) {
            bl = this.testOwnerPassword();
            bl2 = this.testPassword();
        } else {
            try {
                bl = DecryptionFactory.compareKeys(this.O, this.getV5Key(true, 32), 32);
                if (bl) {
                    this.encryptionKey = DecryptionFactory.v5Decrypt(this.OE, this.getV5Key(true, 32));
                } else {
                    bl2 = DecryptionFactory.compareKeys(this.U, this.getV5Key(false, 32), 32);
                    if (bl2) {
                        this.encryptionKey = DecryptionFactory.v5Decrypt(this.UE, this.getV5Key(false, 40));
                    }
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LogWriter.writeLog("Exception: " + noSuchAlgorithmException.getMessage());
            }
        }
        if (bl) {
            this.passwordStatus = 2;
        }
        if (bl2) {
            ++this.passwordStatus;
        }
        if (!bl) {
            if (!bl2) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword != null && this.encryptionPassword.length > 0) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) != 16) return;
            this.extractionIsAllowed = true;
            return;
        } else {
            LogWriter.writeLog("Correct owner password supplied");
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
        }
    }

    private static byte[] v5Decrypt(byte[] byArray, byte[] byArray2) throws PdfSecurityException {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        try {
            int n2;
            CBCBlockCipher cBCBlockCipher = new CBCBlockCipher((BlockCipher)new AESFastEngine());
            cBCBlockCipher.init(false, (CipherParameters)new KeyParameter(byArray2));
            for (int i = 0; i < n; i += n2) {
                cBCBlockCipher.processBlock(byArray, i, byArray3, i);
                n2 = cBCBlockCipher.getBlockSize();
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception.getMessage() + " with v5 encoding");
        }
        return byArray3;
    }

    private byte[] getV5Key(boolean bl, int n) throws NoSuchAlgorithmException {
        int n2;
        byte[] byArray = this.encryptionPassword;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if ((n2 = byArray.length) > 127) {
            n2 = 127;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(byArray, 0, n2);
        if (bl) {
            messageDigest.update(this.O, n, 8);
            messageDigest.update(this.U, 0, 48);
        } else {
            messageDigest.update(this.U, n, 8);
        }
        return messageDigest.digest();
    }

    private byte[] getPaddedKey(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[32];
        int n = 0;
        if (byArray != null && (n = byArray.length) > 32) {
            n = 32;
        }
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray3, 0, n);
        }
        for (int i = n; i < 32; ++i) {
            byArray3[i] = (byte)Integer.parseInt(this.pad[i - n], 16);
        }
        return byArray3;
    }

    private byte[] calculateKey(byte[] byArray, int n, byte[] byArray2) throws PdfSecurityException {
        byte[] byArray3;
        Object object;
        byte[] byArray4 = this.getPaddedKey(this.encryptionPassword, this.encryptionPassword);
        try {
            object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(byArray4);
            ((MessageDigest)object).update(byArray);
            ((MessageDigest)object).update(new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)});
            if (byArray2 != null) {
                ((MessageDigest)object).update(byArray2);
            }
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                ((MessageDigest)object).update(new byte[]{-1, -1, -1, -1});
            }
            byte[] byArray5 = new byte[this.keyLength];
            System.arraycopy(((MessageDigest)object).digest(), 0, byArray5, 0, this.keyLength);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    System.arraycopy(((MessageDigest)object).digest(byArray5), 0, byArray5, 0, this.keyLength);
                }
            }
            byArray3 = new byte[this.keyLength];
            System.arraycopy(byArray5, 0, byArray3, 0, this.keyLength);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        object = new byte[this.keyLength];
        System.arraycopy(byArray3, 0, object, 0, this.keyLength);
        return object;
    }

    public void readEncryptionObject(PdfObject pdfObject) throws PdfSecurityException {
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        this.StmFObj = null;
        this.StrFObj = null;
        this.isAES = false;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        int n = pdfObject.getInt(38);
        PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
        int n2 = 1467315058;
        if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
            n2 = pdfArrayIterator.getNextValueAsConstant(false);
        }
        if (n == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method");
        }
        if (n > 4 && n2 != 1467315058) {
            throw new PdfSecurityException("Unsupported Encryption method");
        }
        int n3 = pdfObject.getInt(1043816557) >> 3;
        if (n3 != -1) {
            this.keyLength = n3;
        }
        this.rev = pdfObject.getInt(34);
        this.P = pdfObject.getInt(32);
        this.O = pdfObject.getTextStreamValueAsByte(31);
        this.U = pdfObject.getTextStreamValueAsByte(37);
        this.OE = pdfObject.getTextStreamValueAsByte(7957);
        this.UE = pdfObject.getTextStreamValueAsByte(9493);
        this.Perms = pdfObject.getTextStreamValueAsByte(893533539);
        if (n >= 4) {
            String string;
            PdfKeyPairsIterator pdfKeyPairsIterator;
            this.isAES = true;
            PdfObject pdfObject2 = pdfObject.getDictionary(4886);
            if (n == 4) {
                this.isMetaDataEncypted = pdfObject.getBoolean(-1815804199);
            }
            this.isAESIdentity = false;
            String string2 = pdfObject.getName(591675926);
            if (string2 != null) {
                this.isAESIdentity = string2.equals("Identity");
                this.stringsEncoded = true;
                pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
                while (pdfKeyPairsIterator.hasMorePairs()) {
                    string = pdfKeyPairsIterator.getNextKeyAsString();
                    if (string.equals(string2)) {
                        this.StrFObj = pdfKeyPairsIterator.getNextValueAsDictionary();
                    }
                    pdfKeyPairsIterator.nextPair();
                }
            }
            if ((string2 = pdfObject.getName(591674646)) != null) {
                this.isAESIdentity = string2.equals("Identity");
                pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
                while (pdfKeyPairsIterator.hasMorePairs()) {
                    string = pdfKeyPairsIterator.getNextKeyAsString();
                    if (string.equals(string2)) {
                        this.StmFObj = pdfKeyPairsIterator.getNextValueAsDictionary();
                    }
                    pdfKeyPairsIterator.nextPair();
                }
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        LogWriter.writeLog("File has encryption settings");
        if (n2 == 1467315058) {
            try {
                this.verifyAccess();
            }
            catch (PdfSecurityException pdfSecurityException) {
                LogWriter.writeLog("File requires password " + pdfSecurityException);
            }
        } else if (this.certificate != null) {
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
            this.passwordStatus = 2;
        }
        if (this.rev == 5) {
            this.Perms = DecryptionFactory.v5Decrypt(this.Perms, this.encryptionKey);
            this.isMetaDataEncypted = this.Perms[8] == 84;
            this.P = this.Perms[0] & 0xFF | (this.Perms[1] & 0xFF) << 8 | (this.Perms[2] & 0xFF) << 16 | (this.Perms[2] & 0xFF) << 24;
        }
    }

    private void setPasswordFromCertificate(PdfObject pdfObject) {
        byte[] byArray;
        byte[][] byArray2 = pdfObject.getStringArray(1752671921);
        if (byArray2 != null && (byArray = SetSecurity.extractCertificateData(byArray2, this.certificate, this.key)) != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                messageDigest.update(byArray, 0, 20);
                for (byte[] byArray3 : byArray2) {
                    messageDigest.update(byArray3);
                }
                if (!this.isMetaDataEncypted) {
                    messageDigest.update(new byte[]{-1, -1, -1, -1});
                }
                this.encryptionKey = messageDigest.digest();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    public byte[] decrypt(byte[] byArray, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws PdfSecurityException {
        if (this.getBooleanValue(101) || bl) {
            int n;
            int n2;
            byte[] byArray2;
            Object object;
            Object object2;
            BufferedOutputStream bufferedOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            boolean bl4 = false;
            byte[] byArray3 = null;
            if (string2 != null) {
                try {
                    Object object3;
                    if (byArray == null) {
                        byArray3 = new byte[16];
                        object3 = new FileInputStream(string2);
                        ((FileInputStream)object3).read(byArray3);
                        ((FileInputStream)object3).close();
                    }
                    object3 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
                    this.cachedObjects.put(((File)object3).getAbsolutePath(), "x");
                    ObjectStore.copy(string2, ((File)object3).getAbsolutePath());
                    object2 = new File(string2);
                    ((File)object2).delete();
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                    bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object3));
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Exception " + iOException + " in decrypt");
                }
            }
            int n3 = this.keyLength;
            object2 = "RC4";
            String string3 = "RC4";
            IvParameterSpec ivParameterSpec = null;
            PdfObject pdfObject = !bl3 ? this.StmFObj : this.StrFObj;
            if (this.certificate != null) {
                this.setPasswordFromCertificate(pdfObject);
                pdfObject.setIntNumber(1043816557, 16);
            }
            if (!bl2 && pdfObject == null && this.isAESIdentity) {
                return byArray;
            }
            if (pdfObject != null && (object = (Object)pdfObject.getName(1250845)) != null && !bl2 && (((String)object).equals("AESV2") || ((String)object).equals("AESV3"))) {
                this.cipher = null;
                object2 = "AES/CBC/PKCS5Padding";
                string3 = "AES";
                bl4 = true;
                byArray2 = new byte[16];
                if (byArray3 != null) {
                    System.arraycopy(byArray3, 0, byArray2, 0, 16);
                } else {
                    System.arraycopy(byArray, 0, byArray2, 0, 16);
                }
                ivParameterSpec = new IvParameterSpec(byArray2);
                if (byArray == null) {
                    try {
                        bufferedInputStream.skip(16L);
                    }
                    catch (IOException iOException) {
                        LogWriter.writeLog("Exception: " + iOException.getMessage());
                    }
                } else {
                    int n4 = byArray.length;
                    n2 = n4 - 16;
                    byte[] byArray4 = new byte[n2];
                    System.arraycopy(byArray, 16, byArray4, 0, n2);
                    byArray = byArray4;
                    n = byArray.length & 0xF;
                    int n5 = byArray.length;
                    if (n > 0) {
                        n5 = n5 + 16 - n;
                        byArray4 = new byte[n5];
                        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
                        byArray = byArray4;
                    }
                    if (this.rev == 5) {
                        try {
                            byte[] byArray5 = new byte[32];
                            System.arraycopy(this.encryptionKey, 0, byArray5, 0, byArray5.length);
                            return DecryptionFactory.decodeAES(byArray5, byArray, byArray2);
                        }
                        catch (Exception exception) {
                            throw new PdfSecurityException("Exception " + exception + " decrypting content in AES revision 5");
                        }
                    }
                }
            }
            object = new byte[n3];
            if (!string.isEmpty()) {
                object = new byte[n3 + 5];
            }
            System.arraycopy(this.encryptionKey, 0, object, 0, n3);
            try {
                if (this.rev == 5) {
                    byArray2 = new byte[32];
                    System.arraycopy(object, 0, byArray2, 0, byArray2.length);
                } else {
                    if (!string.isEmpty()) {
                        int n6 = string.indexOf(32);
                        n2 = string.indexOf(32, n6 + 1);
                        int n7 = Integer.parseInt(string.substring(0, n6));
                        n = Integer.parseInt(string.substring(n6 + 1, n2));
                        object[n3] = (byte)(n7 & 0xFF);
                        object[n3 + 1] = (byte)(n7 >> 8 & 0xFF);
                        object[n3 + 2] = (byte)(n7 >> 16 & 0xFF);
                        object[n3 + 3] = (byte)(n & 0xFF);
                        object[n3 + 4] = (byte)(n >> 8 & 0xFF);
                    }
                    byArray2 = new byte[Math.min(((Object)object).length, 16)];
                    if (!string.isEmpty()) {
                        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                        messageDigest.update((byte[])object);
                        if (bl4 && n3 >= 16) {
                            byte[] byArray6 = new byte[]{115, 65, 108, 84};
                            messageDigest.update(byArray6);
                        }
                        System.arraycopy(messageDigest.digest(), 0, byArray2, 0, byArray2.length);
                    } else {
                        System.arraycopy(object, 0, byArray2, 0, byArray2.length);
                    }
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance((String)object2);
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, string3);
                if (bl) {
                    this.cipher.init(1, secretKeySpec);
                } else if (ivParameterSpec == null) {
                    this.cipher.init(2, secretKeySpec);
                } else {
                    this.cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                }
                if (bufferedOutputStream != null) {
                    int n8;
                    CipherInputStream cipherInputStream = new CipherInputStream(bufferedInputStream, this.cipher);
                    while ((n8 = cipherInputStream.read()) != -1) {
                        bufferedOutputStream.write(n8);
                    }
                    cipherInputStream.close();
                    bufferedOutputStream.close();
                    bufferedInputStream.close();
                }
                if (byArray != null) {
                    byArray = this.cipher.doFinal(byArray);
                }
            }
            catch (Exception exception) {
                throw new PdfSecurityException("Exception " + exception + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return byArray;
    }

    public boolean getBooleanValue(int n) {
        switch (n) {
            case 100: {
                return this.isFileViewable;
            }
            case 101: {
                return this.isEncrypted;
            }
            case 102: {
                return this.isMetaDataEncypted;
            }
            case 103: {
                return this.extractionIsAllowed;
            }
            case 104: {
                return this.isPasswordSupplied;
            }
        }
        return false;
    }

    public boolean isAES() {
        return this.isAES;
    }

    public byte[] decryptString(byte[] byArray, String string) throws PdfSecurityException {
        try {
            if (!this.isAES || this.stringsEncoded || this.isMetaDataEncypted) {
                byArray = this.decrypt(byArray, string, false, null, false, true);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Unable to decrypt string in Object " + string + ' ' + new String(byArray) + ' ' + exception);
        }
        return byArray;
    }

    public int getPDFflag(Integer n) {
        if (n.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (n.equals(PDFflags.VALID_PASSWORD_SUPPLIED)) {
            return this.passwordStatus;
        }
        return -1;
    }

    public void reset(byte[] byArray) {
        this.encryptionPassword = byArray;
        this.cipher = null;
    }

    public void flush() {
        if (this.cachedObjects != null) {
            for (Object k : this.cachedObjects.keySet()) {
                String string = (String)k;
                File file = new File(string);
                file.delete();
            }
        }
    }

    public void dispose() {
        this.cachedObjects = null;
    }

    public boolean hasPassword() {
        return this.O != null || this.U != null;
    }

    private static byte[] decodeAES(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        KeyParameter keyParameter = new KeyParameter(byArray);
        ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)keyParameter, byArray3);
        PKCS7Padding pKCS7Padding = new PKCS7Padding();
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)pKCS7Padding);
        paddedBufferedBlockCipher.reset();
        paddedBufferedBlockCipher.init(false, (CipherParameters)parametersWithIV);
        byte[] byArray4 = new byte[paddedBufferedBlockCipher.getOutputSize(byArray2.length)];
        int n = paddedBufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray4, 0);
        n += paddedBufferedBlockCipher.doFinal(byArray4, n);
        byte[] byArray5 = new byte[n];
        System.arraycopy(byArray4, 0, byArray5, 0, n);
        return byArray5;
    }

    static {
        String string = System.getProperty("org.jpedal.cipher.reinit");
        if (string != null && string.equalsIgnoreCase("true")) {
            alwaysReinitCipher = true;
        }
    }
}

