/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class LinearizedHintTable {
    private final Map startRefs = new HashMap();
    private final Map endRefs = new HashMap();
    private static final int[] mask = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private static final int[] shift = new int[]{0, 8, 16, 24};
    private int[] pageObjectCount;
    private int[] obj;
    private int[] pageLength;
    private long[] pageStart;
    private final FileChannel fos;
    private boolean finishedReading;

    public LinearizedHintTable(FileChannel fileChannel) {
        this.fos = fileChannel;
    }

    public void readTable(PdfObject pdfObject, PdfObject pdfObject2, int n, long l) {
        byte[] byArray = pdfObject.getDecodedStream();
        int n2 = pdfObject2.getInt(30);
        if (byArray != null && byArray.length > 0) {
            this.parseHintTable(n2, n, l, byArray);
        }
    }

    private void parseHintTable(int n, int n2, long l, byte[] byArray) {
        int n3;
        int n4 = 0;
        this.pageObjectCount = new int[n + 1];
        this.obj = new int[n + 1];
        this.pageStart = new long[n + 1];
        this.pageLength = new int[n + 1];
        int n5 = ((byArray[n4] & 0xFF) << 24) + ((byArray[n4 + 1] & 0xFF) << 16) + ((byArray[n4 + 2] & 0xFF) << 8) + (byArray[n4 + 3] & 0xFF);
        n4 += 4;
        int n6 = ((byArray[n4 += 4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        int n7 = ((byArray[n4 += 2] & 0xFF) << 24) + ((byArray[n4 + 1] & 0xFF) << 16) + ((byArray[n4 + 2] & 0xFF) << 8) + (byArray[n4 + 3] & 0xFF);
        int n8 = ((byArray[n4 += 4] & 0xFF) << 8) + (byArray[n4 + 1] & 0xFF);
        n4 += 2;
        n4 += 4;
        n4 += 2;
        n4 += 4;
        n4 += 2;
        n4 += 2;
        n4 += 2;
        n4 += 2;
        int n9 = (n4 += 2) << 3;
        int n10 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            this.pageObjectCount[n3 + 1] = n5 + LinearizedHintTable.getBitsFromByteStream(n9, n6, byArray);
            n10 += this.pageObjectCount[n3 + 1];
            n9 += n6;
        }
        this.obj[1] = n2;
        if (n > 1) {
            this.obj[2] = 1;
        }
        for (n3 = 3; n3 < n; ++n3) {
            this.obj[n3] = this.obj[n3 - 1] + this.pageObjectCount[n3 - 1];
        }
        n9 = n9 + 7 >> 3 << 3;
        for (n3 = 0; n3 < n; ++n3) {
            this.pageLength[n3 + 1] = n7 + LinearizedHintTable.getBitsFromByteStream(n9, n8, byArray);
            n9 += n8;
        }
        for (n3 = 0; n3 < n; ++n3) {
            this.pageStart[n3 + 1] = n3 == 0 ? l : this.pageStart[n3] + (long)this.pageLength[n3];
        }
    }

    private static int getBitsFromByteStream(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = n >> 3;
        int n5 = n & 7;
        int n6 = (n2 + n5 >> 3) + 1;
        int n7 = (n6 << 3) - n5 - n2;
        if (n5 == 0) {
            n7 = (n6 << 3) - n2 & 7;
        }
        if (n6 > 4) {
            if (LogWriter.isRunningFromIDE) {
                throw new RuntimeException("Example of bits over 32 in Linearized table");
            }
            return 0;
        }
        for (int i = 0; i < n6; ++i) {
            int n8 = byArray[n4 + i] & 0xFF;
            if (i == 0) {
                n8 &= mask[n5];
            }
            n3 += n8 << shift[n6 - (i + 1)];
        }
        return n3 >>= n7;
    }

    public int getPageObjectRef(int n) {
        if (this.obj == null || this.obj.length <= n) {
            return -1;
        }
        return this.obj[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getObjData(int n) {
        byte[] byArray;
        if (this.finishedReading) {
            return null;
        }
        Integer n2 = n;
        if (!this.startRefs.containsKey(n2) || !this.endRefs.containsKey(n2)) {
            return null;
        }
        int n3 = (Integer)this.startRefs.get(n2);
        int n4 = (Integer)this.endRefs.get(n2);
        int n5 = n4 - n3 + 1;
        long l = 0L;
        try {
            if (this.fos.isOpen()) {
                l = this.fos.size() - 200L;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
            l = 0L;
        }
        if (l < (long)n4 || n4 - n3 < 1) {
            return null;
        }
        try {
            FileChannel fileChannel = this.fos;
            synchronized (fileChannel) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
                this.fos.read(byteBuffer, n3);
                byteBuffer.clear();
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
            byArray = null;
        }
        return byArray;
    }

    public void storeOffset(int n, int n2, int n3) {
        this.startRefs.put(n, n2);
        this.endRefs.put(n, n3);
    }

    public void setFinishedReading() {
        this.finishedReading = true;
    }
}

