/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.CompressedObjects;
import org.jpedal.io.types.ObjectReader;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.RefTable;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.EncryptionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;

public class PdfFileReader {
    ObjectReader objectReader;
    private PrivateKey key;
    private Certificate certificate;
    private LinearizedHintTable linHintTable;
    private byte[] lastCompressedStream;
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private PdfObject compressedObj;
    private int lastFirst = -1;
    private int lastCompressedID = -1;
    private RefTable refTable;
    PdfObject encyptionObj;
    private DecryptionFactory decryption;
    private byte[] encryptionPassword;
    private RandomAccessBuffer pdf_datafile;
    private Offsets offset = new Offsets(2000);
    public static int alwaysCacheInMemory = 16384;
    private long eof;
    private int[] ObjLengthTable;

    public PdfObject getInfoObject() {
        return this.refTable.getInfoObject();
    }

    public void setCacheSize(int n) {
        this.objectReader.setCacheSize(n);
    }

    public byte[] getBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    public void init(RandomAccessBuffer randomAccessBuffer) {
        this.pdf_datafile = randomAccessBuffer;
        try {
            this.eof = randomAccessBuffer.length();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
        this.objectReader = new ObjectReader(randomAccessBuffer, this.eof, this);
        this.refTable = new RefTable(randomAccessBuffer, this.eof, this.offset);
    }

    public final void readObject(PdfObject pdfObject) {
        if (pdfObject.isDataExternal() && this.linHintTable != null) {
            this.readExternalObject(pdfObject);
        } else {
            byte[] byArray;
            String string = pdfObject.getObjectRefAsString();
            int n = pdfObject.getObjectRefID();
            boolean bl = this.offset.isCompressed(n);
            pdfObject.setCompressedStream(bl);
            if (bl) {
                byArray = this.readCompressedObject(pdfObject);
            } else {
                this.movePointer(this.offset.elementAt(n));
                if (string.charAt(0) == '<') {
                    byArray = this.objectReader.readObjectData(-1, pdfObject);
                } else if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                    byArray = this.getPointer() == 0L ? new byte[]{} : this.objectReader.readObjectData(-1, pdfObject);
                } else if (n > this.ObjLengthTable.length || this.ObjLengthTable[n] == 0) {
                    LogWriter.writeLog(string + " cannot have offset 0");
                    byArray = new byte[]{};
                } else {
                    byArray = this.objectReader.readObjectData(this.ObjLengthTable[n], pdfObject);
                }
            }
            if (byArray.length > 1) {
                ObjectDecoder objectDecoder = new ObjectDecoder(this);
                objectDecoder.readDictionaryAsObject(pdfObject, 0, byArray);
            }
        }
    }

    private void readExternalObject(PdfObject pdfObject) {
        int n = pdfObject.getObjectRefID();
        int n2 = pdfObject.getObjectRefGeneration();
        byte[] byArray = this.readObjectAsByteArray(pdfObject, this.isCompressed(n, n2), n, n2);
        pdfObject.setStatus(2);
        pdfObject.setUnresolvedData(byArray, 540096309);
        ObjectDecoder.resolveFully(pdfObject, this);
    }

    private byte[] readCompressedObject(PdfObject pdfObject) {
        byte[] byArray;
        int n = pdfObject.getObjectRefID();
        int n2 = this.offset.elementAt(n);
        String string = null;
        int n3 = this.lastFirst;
        boolean bl = true;
        byte[] byArray2 = this.lastCompressedStream;
        HashMap hashMap = this.lastOffsetStart;
        HashMap hashMap2 = this.lastOffsetEnd;
        PdfObject pdfObject2 = null;
        if (this.lastOffsetStart != null && n2 == this.lastCompressedID) {
            string = (String)this.lastOffsetStart.get(String.valueOf(n));
        }
        while (string == null) {
            if (pdfObject2 != null) {
                this.compressedObj = pdfObject2;
            } else if (n2 != this.lastCompressedID) {
                bl = false;
                this.movePointer(this.offset.elementAt(n2));
                byArray = this.objectReader.readObjectData(this.ObjLengthTable[n2], null);
                this.compressedObj = new CompressedObject(n2, 0);
                ObjectDecoder objectDecoder = new ObjectDecoder(this);
                objectDecoder.readDictionaryAsObject(this.compressedObj, 0, byArray);
            }
            hashMap = new HashMap();
            hashMap2 = new HashMap();
            n3 = this.compressedObj.getInt(960643930);
            byArray2 = this.compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(hashMap, hashMap2, n3, byArray2, n2, this.offset);
            string = (String)hashMap.get(String.valueOf(n));
            pdfObject2 = this.compressedObj.getDictionary(894663815);
            if (pdfObject2 != null) continue;
        }
        if (!bl) {
            this.lastCompressedStream = byArray2;
            this.lastCompressedID = n2;
            this.lastOffsetStart = hashMap;
            this.lastOffsetEnd = hashMap2;
            this.lastFirst = n3;
        }
        int n4 = n3 + Integer.parseInt(string);
        int n5 = byArray2.length;
        String string2 = (String)hashMap2.get(String.valueOf(n));
        if (string2 != null) {
            n5 = n3 + Integer.parseInt(string2);
        }
        int n6 = n5 - n4;
        byArray = new byte[n6];
        System.arraycopy(byArray2, n4, byArray, 0, n6);
        pdfObject.setInCompressedStream(true);
        return byArray;
    }

    public final byte[] readStream(PdfObject pdfObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        int n;
        byte[] byArray;
        boolean bl6 = pdfObject.isCached();
        byte[] byArray2 = null;
        if (!bl6) {
            byArray2 = pdfObject.getDecodedStream();
        }
        if (byArray2 == null) {
            int n2;
            byArray = pdfObject.stream;
            if (bl6) {
                try {
                    if (!(this.decryption == null || bl5 || !this.decryption.getBooleanValue(102) && bl4)) {
                        this.decryption.decrypt(null, pdfObject.getObjectRefAsString(), false, string, false, false);
                    }
                }
                catch (Exception exception) {
                    byArray = null;
                    LogWriter.writeLog("Exception " + exception);
                }
            }
            if (byArray != null) {
                try {
                    if (!(this.decryption == null || bl5 || !this.decryption.getBooleanValue(102) && bl4 || pdfObject.getObjectType() == 2087749783 && pdfObject.getObjectRefAsString().startsWith("["))) {
                        byArray = this.decryption.decrypt(byArray, pdfObject.getObjectRefAsString(), false, null, false, false);
                    }
                }
                catch (PdfSecurityException pdfSecurityException) {
                    byArray = null;
                    LogWriter.writeLog("Exception " + pdfSecurityException + " with " + pdfObject.getObjectRefAsString());
                }
            }
            if (bl3) {
                pdfObject.stream = null;
            }
            n = 1;
            if (byArray != null || bl6) {
                int n3;
                int n4;
                n2 = 1;
                int n5 = 1;
                int n6 = pdfObject.getInt(959926393);
                if (n6 != -1) {
                    n2 = n6;
                }
                if ((n4 = pdfObject.getInt(959726687)) != -1) {
                    n5 = n4;
                }
                if ((n3 = pdfObject.getInt(1043816557)) != -1) {
                    n = n3;
                }
                if (n2 * n5 == 1) {
                    n5 = n;
                }
                PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
                int n7 = -1;
                if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                    n7 = pdfArrayIterator.getNextValueAsConstant(false);
                }
                if (pdfArrayIterator != null && n7 != -1 && n7 != 1399277700 && n7 != 1180911742) {
                    try {
                        PdfFilteredReader pdfFilteredReader = new PdfFilteredReader();
                        byArray = pdfFilteredReader.decodeFilters(ObjectUtils.setupDecodeParms(pdfObject, this), byArray, pdfArrayIterator, n5, n2, string);
                        pdfObject.setStreamMayBeCorrupt(pdfFilteredReader.hasError());
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Problem " + exception + " decompressing stream ");
                        byArray = null;
                        bl6 = false;
                    }
                    n = 1;
                } else if (byArray != null && n != -1 && n < byArray.length) {
                    if (byArray.length != n && n > 0) {
                        byte[] byArray3 = new byte[n];
                        System.arraycopy(byArray, 0, byArray3, 0, n);
                        byArray = byArray3;
                    } else if (byArray.length == 1 && n == 0) {
                        byArray = new byte[]{};
                    }
                }
            }
            if (byArray != null && bl) {
                pdfObject.setDecodedStream(byArray);
            }
            if (bl2 && bl6) {
                n2 = (int)new File(string).length();
                byte[] byArray4 = new byte[n2];
                try {
                    new BufferedInputStream(new FileInputStream(string)).read(byArray4);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
                if (n != 1 && n < n2) {
                    byte[] byArray5 = new byte[n];
                    System.arraycopy(byArray4, 0, byArray5, 0, n);
                    byArray4 = byArray5;
                }
                return byArray4;
            }
        } else {
            byArray = byArray2;
        }
        if (byArray == null) {
            return null;
        }
        n = byArray.length;
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray, 0, byArray6, 0, n);
        return byArray6;
    }

    public int getPDFflag(Integer n) {
        if (this.decryption == null) {
            return -1;
        }
        return this.decryption.getPDFflag(n);
    }

    public void spoolStreamDataToDisk(File file, long l, int n) throws Exception {
        this.movePointer(l);
        boolean bl = false;
        boolean bl2 = false;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (n2 < 1) {
            n2 = 128;
        }
        int n5 = 0;
        int n6 = n2;
        byte[] byArray = new byte[n6];
        byte[] byArray2 = null;
        try {
            int n7 = n2 - 1;
            int n8 = -n2;
            while (true) {
                if (++n7 == n2) {
                    long l2 = this.getPointer();
                    if (l == -1L) {
                        l = l2;
                    }
                    if (l2 + (long)n2 > this.eof) {
                        n2 = (int)(this.eof - l2);
                    }
                    byArray2 = new byte[n2 += 6];
                    this.pdf_datafile.read(byArray2);
                    n8 += n7;
                    n7 = 0;
                }
                void var19_17 = byArray2[n7];
                if (bl2 && (bl || var19_17 != 13 && var19_17 != 10)) {
                    bufferedOutputStream.write((int)var19_17);
                    bl = true;
                    ++n4;
                }
                if (n3 < 6 && var19_17 == ObjectReader.startStream[n3]) {
                    if (++n3 == 6) {
                        bl2 = true;
                    }
                } else {
                    n3 = 0;
                }
                if (n4 < n) {
                    byArray[n5] = var19_17;
                    if (++n5 != n6) continue;
                    n6 = n6 < 0x200000 ? (n6 *= 2) : (n6 += 100000);
                    byte[] byArray3 = new byte[n6];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    byArray = byArray3;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading object");
        }
        if (bufferedOutputStream != null) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    public void spoolStreamDataToDisk(File file, long l) throws Exception {
        this.movePointer(l);
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        int n = -1;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = n;
        int n4 = 0;
        boolean bl3 = false;
        if (n < 1) {
            n = 128;
        }
        int n5 = 0;
        int n6 = n;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        byte[] byArray2 = null;
        try {
            int n9 = n - 1;
            int n10 = -n;
            while (true) {
                if (++n9 == n) {
                    long l2 = this.getPointer();
                    if (l == -1L) {
                        l = l2;
                    }
                    if (l2 + (long)n > this.eof) {
                        n = (int)(this.eof - l2);
                    }
                    byArray2 = new byte[n += 6];
                    this.pdf_datafile.read(byArray2);
                    n10 += n9;
                    n9 = 0;
                }
                void var24_22 = byArray2[n9];
                boolean bl4 = false;
                n7 = var24_22 == ObjectDecoder.endPattern[n7] ? ++n7 : 0;
                int n11 = 0;
                if (bl2 && (bl || var24_22 != 13 && var24_22 != 10)) {
                    bufferedOutputStream.write((int)var24_22);
                    bl = true;
                }
                n2 = n2 < 6 && var24_22 == ObjectReader.startStream[n2] ? ++n2 : 0;
                if (!bl2 && n2 == 6) {
                    bl2 = true;
                }
                if (!bl3) {
                    if (n3 != -1 && var24_22 == ObjectReader.lengthString[n8]) {
                        if (++n8 == 6) {
                            bl3 = true;
                        }
                    } else {
                        n8 = 0;
                    }
                }
                if (n7 == 6 || n11 == 4) {
                    if (!bl3) break;
                    n7 = 0;
                }
                if (!bl3 || n4 < n3) {
                    if (!bl4) {
                        byArray[n5] = var24_22;
                        if (++n5 == n6) {
                            n6 = n6 < 0x200000 ? (n6 *= 2) : (n6 += 100000);
                            byte[] byArray3 = new byte[n6];
                            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                            byArray = byArray3;
                        }
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading object");
        }
        if (bufferedOutputStream != null) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    public long getOffset(int n) {
        return this.offset.elementAt(n);
    }

    public byte[] getBytes(long l, int n) {
        byte[] byArray = new byte[n];
        this.movePointer(l);
        try {
            this.pdf_datafile.read(byArray);
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
        return byArray;
    }

    public void storeLinearizedTables(LinearizedHintTable linearizedHintTable) {
        this.linHintTable = linearizedHintTable;
    }

    public void dispose() {
        if (this.decryption != null) {
            this.decryption.flush();
            this.decryption.dispose();
        }
        if (this.decryption != null) {
            this.decryption.cipher = null;
        }
        this.decryption = null;
        this.compressedObj = null;
        if (this.linHintTable != null) {
            this.linHintTable = null;
        }
        this.offset = null;
        try {
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
            }
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
        this.pdf_datafile = null;
        if (this.offset != null) {
            this.offset.dispose();
        }
    }

    public final String getType() {
        String string = "";
        try {
            this.movePointer(0L);
            string = this.pdf_datafile.readLine();
            int n = string.indexOf("%PDF");
            if (n != -1) {
                string = string.substring(n + 5);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " in reading type");
        }
        return string;
    }

    public void movePointer(long l) {
        try {
            if (l > this.pdf_datafile.length()) {
                LogWriter.writeLog("Attempting to access ref outside file");
            } else {
                this.pdf_datafile.seek(l);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " moving pointer to  " + l + " in file.");
        }
    }

    private long getPointer() {
        long l = 0L;
        try {
            l = this.pdf_datafile.getFilePointer();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting pointer in file");
        }
        return l;
    }

    public final boolean isCompressed(int n, int n2) {
        return this.offset.isCompressed(n);
    }

    public DecryptionFactory getDecryptionObject() {
        return this.decryption;
    }

    public void setPassword(String string) {
        this.encryptionPassword = string.getBytes();
        if (this.decryption != null) {
            this.decryption.reset(this.encryptionPassword);
        }
    }

    public byte[] readObjectData(PdfObject pdfObject) {
        byte[] byArray;
        byte[] byArray2;
        String string = pdfObject.getObjectRefAsString();
        int n = pdfObject.getObjectRefID();
        if (pdfObject.isDataExternal() && (byArray2 = this.readObjectAsByteArray(pdfObject, false, n, 0)) == null) {
            pdfObject.setFullyResolved(false);
            LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (15)");
            return byArray2;
        }
        boolean bl = this.offset.isCompressed(n);
        pdfObject.setCompressedStream(bl);
        if (bl) {
            byArray = this.readCompressedObjectData(pdfObject, this.offset);
        } else {
            this.movePointer(this.offset.elementAt(n));
            if (string.charAt(0) == '<') {
                byArray = this.objectReader.readObjectData(-1, pdfObject);
            } else if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                byArray = this.getPointer() == 0L ? new byte[]{} : this.objectReader.readObjectData(-1, pdfObject);
            } else if (n > this.ObjLengthTable.length || this.ObjLengthTable[n] == 0) {
                LogWriter.writeLog(string + " cannot have offset 0");
                byArray = new byte[]{};
            } else {
                byArray = this.objectReader.readObjectData(this.ObjLengthTable[n], pdfObject);
            }
        }
        return byArray;
    }

    private byte[] readCompressedObjectData(PdfObject pdfObject, Offsets offsets) {
        byte[] byArray;
        int n = pdfObject.getObjectRefID();
        int n2 = offsets.elementAt(n);
        String string = null;
        int n3 = this.lastFirst;
        boolean bl = true;
        byte[] byArray2 = this.lastCompressedStream;
        HashMap hashMap = this.lastOffsetStart;
        HashMap hashMap2 = this.lastOffsetEnd;
        PdfObject pdfObject2 = null;
        if (this.lastOffsetStart != null) {
            string = (String)this.lastOffsetStart.get(String.valueOf(n));
        }
        while (string == null) {
            if (pdfObject2 != null) {
                this.compressedObj = pdfObject2;
            } else if (n2 != this.lastCompressedID) {
                bl = false;
                this.movePointer(offsets.elementAt(n2));
                byArray = this.objectReader.readObjectData(this.ObjLengthTable[n2], null);
                this.compressedObj = new CompressedObject(n2, 0);
                ObjectDecoder objectDecoder = new ObjectDecoder(this);
                objectDecoder.readDictionaryAsObject(this.compressedObj, 0, byArray);
            }
            hashMap = new HashMap();
            hashMap2 = new HashMap();
            n3 = this.compressedObj.getInt(960643930);
            byArray2 = this.compressedObj.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(hashMap, hashMap2, n3, byArray2, n2, offsets);
            string = (String)hashMap.get(String.valueOf(n));
            pdfObject2 = this.compressedObj.getDictionary(894663815);
            if (pdfObject2 != null) continue;
        }
        if (!bl) {
            this.lastCompressedStream = byArray2;
            this.lastCompressedID = n2;
            this.lastOffsetStart = hashMap;
            this.lastOffsetEnd = hashMap2;
            this.lastFirst = n3;
        }
        int n4 = n3 + Integer.parseInt(string);
        int n5 = byArray2.length;
        String string2 = (String)hashMap2.get(String.valueOf(n));
        if (string2 != null) {
            n5 = n3 + Integer.parseInt(string2);
        }
        int n6 = n5 - n4;
        byArray = new byte[n6];
        System.arraycopy(byArray2, n4, byArray, 0, n6);
        pdfObject.setInCompressedStream(true);
        return byArray;
    }

    public byte[] readObjectAsByteArray(PdfObject pdfObject, boolean bl, int n, int n2) {
        byte[] byArray = null;
        if (this.linHintTable != null) {
            byArray = this.linHintTable.getObjData(n);
        }
        if (byArray == null) {
            if (bl) {
                byArray = this.readCompressedObjectAsByteArray(pdfObject, n, n2);
            } else {
                this.movePointer(this.offset.elementAt(n));
                if (this.ObjLengthTable == null || this.offset.isRefTableInvalid()) {
                    byArray = this.objectReader.readObjectData(-1, pdfObject);
                } else {
                    if (n > this.ObjLengthTable.length) {
                        return null;
                    }
                    byArray = this.objectReader.readObjectData(this.ObjLengthTable[n], pdfObject);
                }
            }
        }
        int n3 = 0;
        if (byArray.length > 15) {
            for (int i = 0; i < 10 && (byArray[i] != 111 || byArray[i + 1] != 98 || byArray[i + 2] != 106); ++i) {
                if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 111 || byArray[i + 4] != 98 || byArray[i + 5] != 106) continue;
                n3 = i + 6;
                this.objectReader.fileIsBroken = true;
                break;
            }
        }
        while (byArray[n3] == 10 || byArray[n3] == 12 || byArray[n3] == 32) {
            ++n3;
        }
        if (n3 > 0) {
            byte[] byArray2 = byArray;
            int n4 = byArray.length - n3;
            byArray = new byte[n4];
            System.arraycopy(byArray2, n3, byArray, 0, n4);
        }
        return byArray;
    }

    private byte[] readCompressedObjectAsByteArray(PdfObject pdfObject, int n, int n2) {
        byte[] byArray;
        int n3 = this.offset.elementAt(n);
        String string = null;
        HashMap hashMap = this.lastOffsetStart;
        HashMap hashMap2 = this.lastOffsetEnd;
        int n4 = this.lastFirst;
        boolean bl = true;
        byte[] byArray2 = this.lastCompressedStream;
        if (this.lastOffsetStart != null) {
            string = (String)this.lastOffsetStart.get(String.valueOf(n));
        }
        int n5 = -1;
        while (string == null) {
            bl = false;
            if (n5 == n3) {
                throw new RuntimeException("Compressed Object stream corrupted - PDF file broken");
            }
            try {
                this.pdf_datafile.seek(this.offset.elementAt(n3));
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Exception " + iOException + " moving pointer in file.");
            }
            n5 = n3;
            byArray = this.objectReader.readObjectData(this.ObjLengthTable[n3], null);
            String string2 = n3 + " " + n2 + " R";
            CompressedObject compressedObject = new CompressedObject(string2);
            ObjectDecoder objectDecoder = new ObjectDecoder(this);
            objectDecoder.readDictionaryAsObject(compressedObject, 0, byArray);
            hashMap = new HashMap();
            hashMap2 = new HashMap();
            n4 = ((PdfObject)compressedObject).getInt(960643930);
            byArray2 = compressedObject.getDecodedStream();
            CompressedObjects.extractCompressedObjectOffset(hashMap, hashMap2, n4, byArray2, n3, this.offset);
            string = (String)hashMap.get(String.valueOf(n));
            PdfObject pdfObject2 = ((PdfObject)compressedObject).getDictionary(894663815);
            String string3 = pdfObject2 == null ? null : pdfObject2.getObjectRefAsString();
            if (string3 == null) continue;
            n3 = Integer.parseInt(string3.substring(0, string3.indexOf(32)));
        }
        if (!bl) {
            this.lastCompressedStream = byArray2;
            this.lastOffsetStart = hashMap;
            this.lastOffsetEnd = hashMap2;
            this.lastFirst = n4;
        }
        int n6 = n4 + Integer.parseInt(string);
        int n7 = byArray2.length;
        String string4 = (String)hashMap2.get(String.valueOf(n));
        if (string4 != null) {
            n7 = n4 + Integer.parseInt(string4);
        }
        int n8 = n7 - n6;
        byArray = new byte[n8];
        System.arraycopy(byArray2, n6, byArray, 0, n8);
        pdfObject.setInCompressedStream(true);
        return byArray;
    }

    public byte[] readPageIntoStream(PdfObject pdfObject) {
        byte[][] byArray = pdfObject.getKeyArray(1216184967);
        byte[] byArray2 = new byte[]{};
        if (byArray == null || byArray != null && byArray.length > 0 && byArray[0] == null) {
            return byArray2;
        }
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                StreamObject streamObject = new StreamObject(new String(byArray[i]));
                streamObject.isDataExternal(pdfObject.isDataExternal());
                this.readObject(streamObject);
                byte[] byArray3 = streamObject.getDecodedStream();
                byArray2 = i == 0 && byArray3 != null ? byArray3 : PdfFileReader.appendData(byArray2, byArray3);
            }
        }
        return byArray2;
    }

    static byte[] appendData(byte[] byArray, byte[] byArray2) {
        if (byArray2 != null) {
            int n = byArray.length + 1;
            int n2 = byArray2.length;
            if (n2 > 0) {
                while (byArray2[n2 - 1] == 0) {
                    --n2;
                }
                byte[] byArray3 = new byte[n];
                System.arraycopy(byArray, 0, byArray3, 0, n - 1);
                byArray3[n - 1] = 32;
                byArray = new byte[n + n2];
                System.arraycopy(byArray3, 0, byArray, 0, n);
                System.arraycopy(byArray2, 0, byArray, n, n2);
            }
        }
        return byArray;
    }

    public void setCertificate(Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.key = privateKey;
    }

    public final PdfObject readReferenceTable(PdfObject pdfObject) throws PdfException {
        PdfObject pdfObject2 = this.refTable.readReferenceTable(pdfObject, this, this.objectReader);
        PdfObject pdfObject3 = this.refTable.getEncryptionObject();
        if (pdfObject3 != null) {
            this.setupDecryption(pdfObject3);
        }
        this.ObjLengthTable = this.offset.calculateObjectLength((int)this.eof);
        return pdfObject2;
    }

    public void setupDecryption(PdfObject pdfObject) throws PdfSecurityException {
        try {
            byte[] byArray = this.refTable.getID();
            this.decryption = this.certificate != null ? new DecryptionFactory(byArray, this.certificate, this.key) : new DecryptionFactory(byArray, this.encryptionPassword);
            if (this.encyptionObj == null) {
                this.encyptionObj = new EncryptionObject(new String(pdfObject.getUnresolvedData()));
                this.readObject(this.encyptionObj);
            }
            this.decryption.readEncryptionObject(this.encyptionObj);
        }
        catch (Error error) {
            LogWriter.writeLog("No Bouncy castle on classpath " + error);
            throw new RuntimeException("This PDF file is encrypted and JPedal needs an additional library to \ndecode on the classpath (we recommend bouncycastle library).\nThere is additional explanation at http://www.idrsolutions.com/additional-jars\n");
        }
    }
}

