/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.exception.PdfException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.EncryptionUsed;
import org.jpedal.io.ImageInputStreamFileBuffer;
import org.jpedal.io.NameLookup;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.io.RandomAccessMemoryMapBuffer;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfObjectReader {
    private PdfFileReader objectReader = new PdfFileReader();
    final Map pagesReferences = new HashMap();
    private PageLookup pageLookup = new PageLookup();
    private String tempFileName;
    private NameLookup nameLookup;
    RandomAccessBuffer pdf_datafile;
    private Javascript javascript;

    public PdfObjectReader() {
    }

    public PdfObjectReader(String string) {
        if (string == null) {
            string = "";
        }
        this.objectReader.setPassword(string);
    }

    public PdfObjectReader(Certificate certificate, PrivateKey privateKey) {
        this.objectReader.setCertificate(certificate, privateKey);
    }

    public String getReferenceforPage(int n) {
        return (String)this.pagesReferences.get(n);
    }

    public final void closePdfFile() {
        try {
            this.objectReader.closeFile();
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
            }
            if (this.tempFileName != null) {
                File file = new File(this.tempFileName);
                file.delete();
                this.tempFileName = null;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " closing file");
        }
    }

    public PdfObject getPDFObject(int n) {
        if (n == 1113489015) {
            return this.objectReader.encyptionObj;
        }
        throw new RuntimeException("Access to " + n + " not supported");
    }

    public PdfFileReader getObjectReader() {
        return this.objectReader;
    }

    public String convertNameToRef(String string) {
        if (this.nameLookup == null) {
            return null;
        }
        return (String)this.nameLookup.get(string);
    }

    public NameLookup getNamesLookup() {
        if (this.nameLookup == null) {
            return null;
        }
        return this.nameLookup;
    }

    public void readNames(PdfObject pdfObject, Javascript javascript, boolean bl) {
        this.nameLookup = new NameLookup(this.objectReader);
        this.nameLookup.readNames(pdfObject, javascript, bl);
    }

    public int convertObjectToPageNumber(String string) {
        return this.pageLookup.convertObjectToPageNumber(string);
    }

    public void setLookup(String string, int n) {
        this.pageLookup.put(string, n);
        this.pagesReferences.put(n, string);
    }

    public void dispose() {
        this.nameLookup = null;
        if (this.objectReader != null) {
            this.objectReader.dispose();
        }
        this.objectReader = null;
        if (this.pageLookup != null) {
            this.pageLookup.dispose();
        }
        this.pageLookup = null;
    }

    public final void openPdfFile(InputStream inputStream) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessMemoryMapBuffer(inputStream);
            this.objectReader.init(this.pdf_datafile);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(ImageInputStream imageInputStream) throws PdfException {
        try {
            ImageInputStreamFileBuffer imageInputStreamFileBuffer = new ImageInputStreamFileBuffer(imageInputStream);
            this.objectReader.init(imageInputStreamFileBuffer);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public void checkParentForResources(PdfObject pdfObject) {
        String string;
        if (pdfObject.getDictionary(2004251818) == null && (string = pdfObject.getStringKey(1110793845)) != null) {
            PageObject pageObject = new PageObject(string);
            this.readObject(pageObject);
            PdfObject pdfObject2 = ((PdfObject)pageObject).getDictionary(2004251818);
            if (pdfObject2 != null) {
                pdfObject.setDictionary(2004251818, pdfObject2);
            }
        }
    }

    public final void openPdfFile(String string) throws PdfException {
        try {
            RandomAccessFileBuffer randomAccessFileBuffer = new RandomAccessFileBuffer(string, "r");
            this.objectReader.init(randomAccessFileBuffer);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public final void openPdfFile(byte[] byArray) throws PdfException {
        try {
            RandomAccessBuffer randomAccessBuffer;
            if (PdfFileReader.alwaysCacheInMemory == -1 || byArray.length < PdfFileReader.alwaysCacheInMemory) {
                randomAccessBuffer = new RandomAccessDataBuffer(byArray);
            } else {
                try {
                    File file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
                    this.tempFileName = file.getAbsolutePath();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    randomAccessBuffer = new RandomAccessFileBuffer(this.tempFileName, "r");
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to create temporary file in " + ObjectStore.temp_dir + ' ' + exception);
                }
            }
            this.objectReader.init(randomAccessBuffer);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing file");
            throw new PdfException("Exception " + exception + " accessing file");
        }
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    public void checkResolved(PdfObject pdfObject) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(pdfObject);
    }

    public void setJavascriptForObject(FormObject formObject, int n, int n2) {
        PdfObject pdfObject = formObject.getDictionary(n);
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(pdfObject);
        if (pdfObject == null) {
            return;
        }
        PdfObject pdfObject2 = n2 == n ? pdfObject : (n2 == 4866 ? pdfObject.getDictionary(19) : pdfObject.getDictionary(n2));
        if (pdfObject2 != null) {
            String string;
            Object object;
            objectDecoder.checkResolved(pdfObject2);
            PdfObject pdfObject3 = pdfObject2.getDictionary(6691);
            if (pdfObject3 != null) {
                object = pdfObject3.getDecodedStream();
                string = StringUtils.getTextString(object, true);
            } else {
                string = pdfObject2.getTextStreamValue(6691);
            }
            if (string != null) {
                object = formObject.getTextStreamValue(36);
                if (object == null) {
                    object = formObject.getObjectRefAsString();
                }
                this.javascript.storeJavascript((String)object, string, n2);
            }
        }
    }

    public byte[] readStream(PdfObject pdfObject, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        return this.objectReader.readStream(pdfObject, bl, bl2, bl3, bl4, bl5, string);
    }

    public void readObject(PdfObject pdfObject) {
        this.objectReader.readObject(pdfObject);
    }

    public EncryptionUsed getEncryptionType() {
        PdfFileReader pdfFileReader = this.objectReader;
        DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
        if (decryptionFactory == null) {
            return EncryptionUsed.NO_ENCRYPTION;
        }
        if (decryptionFactory.hasPassword()) {
            return EncryptionUsed.PASSWORD;
        }
        return EncryptionUsed.CERTIFICATE;
    }
}

