/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;

public class RandomAccessFileChannelBuffer
implements RandomAccessBuffer {
    private long pointer;
    private int length;
    private ByteBuffer mb;

    public RandomAccessFileChannelBuffer(InputStream inputStream) {
        try {
            int n;
            this.length = inputStream.available();
            this.mb = ByteBuffer.allocate(this.length);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                if (n <= 0) continue;
                for (int i = 0; i < n; ++i) {
                    this.mb.put(byArray[i]);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    @Override
    public void seek(long l) throws IOException {
        if (!this.checkPos(l)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = l;
    }

    @Override
    public void close() throws IOException {
        if (this.mb != null) {
            this.mb = null;
        }
        this.pointer = -1L;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            LogWriter.writeLog("Exception: " + throwable.getMessage());
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
    }

    @Override
    public long length() throws IOException {
        if (this.mb != null) {
            return this.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    @Override
    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.mb.position((int)this.pointer);
            ++this.pointer;
            return this.mb.get();
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.mb.position((int)this.pointer);
            return this.mb.get();
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        int n;
        if (this.pointer >= (long)(this.length - 1)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = this.read()) >= 0) {
            if (n == 10 || n == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == n) break;
                this.read();
                break;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.mb == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.length) {
            return -1;
        }
        int n = this.length - (int)this.pointer;
        if (n > byArray.length) {
            n = byArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.mb.position((int)this.pointer);
            ++this.pointer;
            byArray[i] = this.mb.get();
        }
        return n;
    }

    private boolean checkPos(long l) throws IOException {
        return l >= 0L && l < this.length();
    }

    @Override
    public byte[] getPdfBuffer() {
        byte[] byArray = new byte[this.length];
        this.mb.position(0);
        this.mb.get(byArray);
        return byArray;
    }
}

