/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import javafx.application.Platform;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javax.swing.SwingUtilities;
import org.jpedal.utils.LogWriter;

public class StatusBarFX {
    private static final int debug_level = 0;
    double progress_size;
    String current = "";
    private static final double progress_max_size = 100.0;
    ProgressBar status;
    Text statusText;
    StackPane pane;
    private boolean showMessages;
    public float percentageDone;
    private Color masterColor;
    private boolean reset;

    public StatusBarFX() {
        this.initialiseStatus("");
    }

    public StatusBarFX(Color color) {
        this.masterColor = color;
        this.initialiseStatus("");
    }

    public final void initialiseStatus(String string) {
        this.progress_size = 0.0;
        this.status = new ProgressBar();
        this.statusText = new Text();
        this.pane = new StackPane();
        this.status.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.pane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.pane.getChildren().add((Object)this.status);
        this.pane.getChildren().add((Object)this.statusText);
        if (this.masterColor != null) {
            int n = (int)(255.0 * this.masterColor.getRed());
            int n2 = (int)(255.0 * this.masterColor.getGreen());
            int n3 = (int)(255.0 * this.masterColor.getBlue());
            this.status.setStyle("-fx-background:rgb(" + n + ',' + n2 + ',' + n3 + ");");
        }
        this.updateStatus(string, 4);
    }

    public final void updateStatus(String string, int n) {
        this.current = string;
        if (this.showMessages) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBarFX.this.statusText.setText(StatusBarFX.this.current);
                    StatusBarFX.this.status.setProgress(StatusBarFX.this.progress_size / 100.0);
                }
            });
        }
        if (0 > n) {
            LogWriter.writeLog(string);
        }
    }

    public final Pane getStatusObject() {
        return this.pane;
    }

    public final void setProgress(int n) {
        this.reset = false;
        if (this.status != null) {
            if (n == 0) {
                this.progress_size = 0.0;
            }
            if (this.progress_size < (double)n) {
                this.progress_size = n;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    StatusBarFX.this.status.setProgress(StatusBarFX.this.progress_size / 100.0);
                }
            });
        }
    }

    public final void setProgress(final String string, int n) {
        this.reset = false;
        if (this.status != null) {
            if (n == 0) {
                this.progress_size = 0.0;
            }
            if (this.progress_size < (double)n) {
                this.progress_size = n;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    StatusBarFX.this.statusText.setText(string);
                    StatusBarFX.this.status.setProgress(StatusBarFX.this.progress_size / 100.0);
                }
            });
        }
    }

    public final void resetStatus(String string) {
        this.reset = true;
        this.progress_size = 0.0;
        this.updateStatus(string, 4);
    }

    public final void setClientDisplay() {
        this.showMessages = true;
    }

    public void setVisible(boolean bl) {
        this.pane.setVisible(bl);
    }

    public void setDisable(boolean bl) {
        this.pane.setDisable(bl);
    }

    public boolean isVisible() {
        return this.pane.isVisible();
    }

    public boolean isDisable() {
        return this.pane.isDisabled();
    }

    public boolean isDone() {
        return this.reset || this.progress_size >= 100.0;
    }
}

