/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ASCII85
extends BaseFilter
implements PdfFilter {
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};

    public ASCII85(PdfObject pdfObject) {
        super(pdfObject);
    }

    @Override
    public byte[] decode(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        for (n = 0; n < n4; ++n) {
            if (byArray[n] == 122) {
                ++n2;
                continue;
            }
            if (byArray[n] != 10) continue;
            ++n3;
        }
        if (n3 == 5 && n2 == 0 && (n4 - n3) % 5 == 4) {
            ++n4;
        }
        n = 0;
        byte[] byArray2 = new byte[n4 - n3 + 1 + n2 * 3];
        for (int i = 0; i < n4; ++i) {
            int n5;
            long l = 0L;
            byte by = byArray[i];
            while (by == 10 || by == 13) {
                if (++i == n4) {
                    by = 0;
                    continue;
                }
                by = byArray[i];
            }
            if (by == 122) {
                for (n5 = 0; n5 < 4; ++n5) {
                    byArray2[n] = 0;
                    ++n;
                }
                continue;
            }
            if (n4 - i <= 4 || by <= 32 || by >= 118) continue;
            n5 = 4;
            for (int j = 0; j < 5; ++j) {
                if (i < byArray.length) {
                    by = byArray[i];
                }
                while (by == 10 || by == 13) {
                    if (++i == n4) {
                        by = 0;
                        continue;
                    }
                    by = byArray[i];
                }
                if (by == 126 && byArray[++i] == 62) {
                    n5 = j - 1;
                }
                if ((by <= 32 || by >= 118) && by != 126) continue;
                l += (long)(by - 33) * base_85_indices[j];
            }
            for (int j = 0; j < 4 && j < n5; ++j) {
                byArray2[n] = (byte)(l / hex_indices[j] & 0xFFL);
                ++n;
            }
            --i;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    @Override
    public void decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, String string, Map<String, String> map) {
        this.bis = bufferedInputStream;
        this.streamCache = bufferedOutputStream;
        this.cachedObjects = map;
        try {
            boolean bl = false;
            while (bufferedInputStream.available() > 0) {
                int n;
                long l = 0L;
                int n2 = ASCII85.read(bufferedInputStream);
                if (n2 == 122) {
                    for (n = 0; n < 4; ++n) {
                        bufferedOutputStream.write(0);
                    }
                    continue;
                }
                if (bufferedInputStream.available() < 4 || n2 <= 32 || n2 >= 118) continue;
                l += (long)(n2 - 33) * base_85_indices[0];
                for (n = 1; n < 5; ++n) {
                    n2 = ASCII85.read(bufferedInputStream);
                    if (n2 == -1) {
                        n2 = 0;
                    }
                    if (n2 == -1) {
                        bl = true;
                    }
                    if ((n2 <= 32 || n2 >= 118) && n2 != 126) continue;
                    l += (long)(n2 - 33) * base_85_indices[n];
                }
                if (bl) continue;
                for (n = 0; n < 4; ++n) {
                    byte by = (byte)(l / hex_indices[n] & 0xFFL);
                    bufferedOutputStream.write(by);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing Ascii85Decode filter ");
        }
    }

    private static int read(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        while (n == 13 || n == 10) {
            n = bufferedInputStream.read();
        }
        return n;
    }
}

