/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class BaseFilter {
    final PdfObject decodeParms;
    BufferedInputStream bis;
    BufferedOutputStream streamCache;
    Map<String, String> cachedObjects;

    BaseFilter(PdfObject pdfObject) {
        this.decodeParms = pdfObject;
    }

    public boolean hasError() {
        return false;
    }

    void setupCachedObjectForDecoding(String string) throws IOException {
        File file = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(file.getAbsolutePath(), "x");
        ObjectStore.copy(string, file.getAbsolutePath());
        File file2 = new File(string);
        file2.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(string));
        this.bis = new BufferedInputStream(new FileInputStream(file));
    }

    byte[] applyPredictor(int n, byte[] byArray, int n2, int n3, int n4) throws Exception {
        boolean bl;
        if (n == 1) {
            return byArray;
        }
        boolean bl2 = bl = byArray == null;
        if (bl) {
            BaseFilter.applyPredictorFunction(n, this.bis, this.streamCache, n2, n3, n4);
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        int n5 = BaseFilter.applyPredictorFunction2(n, bufferedInputStream, null, n2, n3, n4);
        byteArrayInputStream.close();
        bufferedInputStream.close();
        byte[] byArray2 = new byte[n5];
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        BaseFilter.applyPredictorFunction2(n, bufferedInputStream, byArray2, n2, n3, n4);
        byteArrayInputStream.close();
        bufferedInputStream.close();
        return byArray2;
    }

    private static void applyPredictorFunction(int n, BufferedInputStream bufferedInputStream, OutputStream outputStream, int n2, int n3, int n4) throws Exception {
        int n5 = bufferedInputStream.available();
        int n6 = (n2 * n3 + 7) / 8;
        int n7 = (n4 * n2 * n3 + 7) / 8 + n6;
        byte[] byArray = new byte[n7];
        byte[] byArray2 = new byte[n7];
        try {
            int n8 = 0;
            while (n5 > n8) {
                int n9;
                int n10 = n;
                int n11 = 0;
                int n12 = n6;
                if (n10 >= 10) {
                    n9 = bufferedInputStream.read();
                    if (n9 == -1) break;
                    n9 += 10;
                } else {
                    n9 = n10;
                }
                while (n12 < n7 && (n11 = bufferedInputStream.read(byArray, n12, n7 - n12)) != -1) {
                    n12 += n11;
                    n8 += n11;
                }
                if (n11 == -1) break;
                switch (n9) {
                    case 2: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n6; n15 < n7; ++n15) {
                            n14 = byArray[n15] & 0xFF;
                            n13 = byArray[n15 - n6] & 0xFF;
                            byArray[n15] = (byte)(n14 + n13 & 0xFF);
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 10: {
                        int n15;
                        for (n15 = n6; n15 < n7; ++n15) {
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 11: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n6; n15 < n7; ++n15) {
                            n14 = byArray[n15] & 0xFF;
                            n13 = byArray[n15 - n6] & 0xFF;
                            byArray[n15] = (byte)(n14 + n13);
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 12: {
                        int n14;
                        int n15;
                        for (n15 = n6; n15 < n7; ++n15) {
                            n14 = (byArray2[n15] & 0xFF) + (byArray[n15] & 0xFF);
                            byArray[n15] = (byte)n14;
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 13: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n6; n15 < n7; ++n15) {
                            n14 = byArray[n15] & 0xFF;
                            n13 = (byArray[n15 - n6] & 0xFF) + (byArray2[n15] & 0xFF) >> 1;
                            byArray[n15] = (byte)(n14 + n13);
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 14: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n6; n15 < n7; ++n15) {
                            n14 = byArray[n15 - n6] & 0xFF;
                            n13 = byArray2[n15] & 0xFF;
                            int n16 = byArray2[n15 - n6] & 0xFF;
                            int n17 = n14 + n13 - n16;
                            int n18 = n17 - n14;
                            int n19 = n17 - n13;
                            int n20 = n17 - n16;
                            if (n18 < 0) {
                                n18 = -n18;
                            }
                            if (n19 < 0) {
                                n19 = -n19;
                            }
                            if (n20 < 0) {
                                n20 = -n20;
                            }
                            byArray[n15] = n18 <= n19 && n18 <= n20 ? (byte)(byArray[n15] + n14) : (n19 <= n20 ? (byte)(byArray[n15] + n13) : (byte)(byArray[n15] + n16));
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                }
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing Predictor");
        }
    }

    private static int applyPredictorFunction2(int n, BufferedInputStream bufferedInputStream, byte[] byArray, int n2, int n3, int n4) throws Exception {
        int n5 = 0;
        int n6 = bufferedInputStream.available();
        int n7 = (n2 * n3 + 7) / 8;
        int n8 = (n4 * n2 * n3 + 7) / 8 + n7;
        byte[] byArray2 = new byte[n8];
        byte[] byArray3 = new byte[n8];
        try {
            int n9 = 0;
            while (n6 > n9) {
                int n10;
                int n11 = n;
                int n12 = 0;
                int n13 = n7;
                if (n11 >= 10) {
                    n10 = bufferedInputStream.read();
                    if (n10 == -1) break;
                    n10 += 10;
                } else {
                    n10 = n11;
                }
                while (n13 < n8 && (n12 = bufferedInputStream.read(byArray2, n13, n8 - n13)) != -1) {
                    n13 += n12;
                    n9 += n12;
                }
                if (n12 != -1) {
                    switch (n10) {
                        case 2: {
                            int n14;
                            int n15;
                            int n16;
                            for (n16 = n7; n16 < n8; ++n16) {
                                n15 = byArray2[n16] & 0xFF;
                                n14 = byArray2[n16 - n7] & 0xFF;
                                byArray2[n16] = (byte)(n15 + n14 & 0xFF);
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n16];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 10: {
                            int n16;
                            for (n16 = n7; n16 < n8; ++n16) {
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n16];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 11: {
                            int n14;
                            int n15;
                            int n16;
                            for (n16 = n7; n16 < n8; ++n16) {
                                n15 = byArray2[n16] & 0xFF;
                                n14 = byArray2[n16 - n7] & 0xFF;
                                byArray2[n16] = (byte)(n15 + n14);
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n16];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 12: {
                            int n15;
                            int n16;
                            for (n16 = n7; n16 < n8; ++n16) {
                                n15 = (byArray3[n16] & 0xFF) + (byArray2[n16] & 0xFF);
                                byArray2[n16] = (byte)n15;
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n16];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 13: {
                            int n14;
                            int n15;
                            int n16;
                            for (n16 = n7; n16 < n8; ++n16) {
                                n15 = byArray2[n16] & 0xFF;
                                n14 = (byArray2[n16 - n7] & 0xFF) + (byArray3[n16] & 0xFF) >> 1;
                                byArray2[n16] = (byte)(n15 + n14);
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n16];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 14: {
                            int n14;
                            int n15;
                            int n16;
                            for (n16 = n7; n16 < n8; ++n16) {
                                n15 = byArray2[n16 - n7] & 0xFF;
                                n14 = byArray3[n16] & 0xFF;
                                int n17 = byArray3[n16 - n7] & 0xFF;
                                int n18 = n15 + n14 - n17;
                                int n19 = n18 - n15;
                                int n20 = n18 - n14;
                                int n21 = n18 - n17;
                                if (n19 < 0) {
                                    n19 = -n19;
                                }
                                if (n20 < 0) {
                                    n20 = -n20;
                                }
                                if (n21 < 0) {
                                    n21 = -n21;
                                }
                                byArray2[n16] = n19 <= n20 && n19 <= n21 ? (byte)(byArray2[n16] + n15) : (n20 <= n21 ? (byte)(byArray2[n16] + n14) : (byte)(byArray2[n16] + n17));
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n16];
                                }
                                ++n5;
                            }
                            break;
                        }
                    }
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing Predictor");
        }
        return n5;
    }
}

