/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.io.filter.ccitt.CCITT1D;
import org.jpedal.io.filter.ccitt.CCITT2D;
import org.jpedal.io.filter.ccitt.CCITTDecoder;
import org.jpedal.io.filter.ccitt.CCITTMix;
import org.jpedal.objects.raw.PdfObject;

public class CCITT
extends BaseFilter
implements PdfFilter {
    private final int width;
    private final int height;

    public CCITT(PdfObject pdfObject, int n, int n2) {
        super(pdfObject);
        this.width = n;
        this.height = n2;
    }

    @Override
    public byte[] decode(byte[] byArray) throws Exception {
        return this.decodeCCITT(byArray);
    }

    public void decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, String string, Map map) throws Exception {
        int n = bufferedInputStream.available();
        byte[] byArray = new byte[n];
        bufferedInputStream.read(byArray);
        byArray = this.decodeCCITT(byArray);
        bufferedOutputStream.write(byArray);
    }

    private byte[] decodeCCITT(byte[] byArray) throws Exception {
        int n = 0;
        if (this.decodeParms != null) {
            n = this.decodeParms.getInt(27);
        }
        CCITTDecoder cCITTDecoder = null;
        if (n == 0) {
            cCITTDecoder = new CCITT1D(byArray, this.width, this.height, this.decodeParms);
        } else if (n < 0) {
            cCITTDecoder = new CCITT2D(byArray, this.width, this.height, this.decodeParms);
        } else if (n > 0) {
            cCITTDecoder = new CCITTMix(byArray, this.width, this.height, this.decodeParms);
        }
        byte[] byArray2 = cCITTDecoder.decode();
        return byArray2;
    }
}

