/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class Flate
extends BaseFilter
implements PdfFilter {
    private int predictor = 1;
    private int colors = 1;
    private int bitsPerComponent = 8;
    private int columns = 1;
    private boolean hasError;

    public Flate(PdfObject pdfObject) {
        super(pdfObject);
        if (pdfObject != null) {
            int n;
            int n2;
            int n3 = pdfObject.getInt(-1344207655);
            if (n3 != -1) {
                this.bitsPerComponent = n3;
            }
            if ((n2 = pdfObject.getInt(1010783618)) != -1) {
                this.colors = n2;
            }
            if ((n = pdfObject.getInt(1162902911)) != -1) {
                this.columns = n;
            }
            this.predictor = pdfObject.getInt(1970893723);
        }
    }

    @Override
    public byte[] decode(byte[] byArray) throws Exception {
        int n = 512000;
        FastByteArrayOutputStream fastByteArrayOutputStream = null;
        boolean bl = true;
        int n2 = byArray.length;
        if (byArray != null) {
            while (bl) {
                Inflater inflater = new Inflater();
                inflater.setInput(byArray);
                int n3 = byArray.length;
                fastByteArrayOutputStream = new FastByteArrayOutputStream(n3);
                if (n3 < n) {
                    n = n3;
                }
                byte[] byArray2 = new byte[n];
                try {
                    while (!inflater.finished()) {
                        int n4 = inflater.inflate(byArray2);
                        fastByteArrayOutputStream.write(byArray2, 0, n4);
                        if (inflater.getRemaining() != 0) continue;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception in Flate " + exception);
                    bl = true;
                    this.hasError = true;
                    if (byArray.length == n2 && byArray.length > 10000) {
                        bl = false;
                        continue;
                    }
                    if (byArray.length > 10) {
                        byte[] byArray3 = new byte[byArray.length - 1];
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length - 1);
                        byArray = byArray3;
                        continue;
                    }
                    bl = false;
                }
            }
            byArray = fastByteArrayOutputStream.toByteArray();
            return this.applyPredictor(this.predictor, byArray, this.colors, this.bitsPerComponent, this.columns);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, String string, Map<String, String> map) throws Exception {
        this.bis = bufferedInputStream;
        this.streamCache = bufferedOutputStream;
        this.cachedObjects = map;
        if (bufferedInputStream != null) {
            try (InflaterInputStream inflaterInputStream = null;){
                inflaterInputStream = new InflaterInputStream(bufferedInputStream);
                while (true) {
                    int n = ((InputStream)inflaterInputStream).read();
                    if (((InputStream)inflaterInputStream).available() == 0 || n == -1) break;
                    bufferedOutputStream.write(n);
                }
                if (this.predictor != 1 && this.predictor != 10) {
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                    if (string != null) {
                        this.setupCachedObjectForDecoding(string);
                    }
                }
            }
        }
        this.applyPredictor(this.predictor, null, this.colors, this.bitsPerComponent, this.columns);
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }
}

