/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.Offsets;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class CompressedObjects {
    public static void extractCompressedObjectOffset(Map map, Map map2, int n, byte[] byArray, int n2, Offsets offsets) {
        String string = null;
        for (int i = 0; i < n; ++i) {
            int n3;
            if (byArray.length == 0) continue;
            while (byArray[i] == 10 || byArray[i] == 13 || byArray[i] == 32) {
                ++i;
            }
            int n4 = i;
            if (n4 == n) continue;
            while (byArray[i] != 32 && byArray[i] != 13 && byArray[i] != 10) {
                ++i;
            }
            int n5 = i - 1;
            int n6 = n5 - n4 + 1;
            char[] cArray = new char[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                cArray[n3] = (char)byArray[n4 + n3];
            }
            String string2 = new String(cArray);
            int n7 = NumberUtils.parseInt(n4, n4 + n6, byArray);
            while (byArray[i] == 32 || byArray[i] == 13 || byArray[i] == 10) {
                ++i;
            }
            int n8 = i;
            while (byArray[i] != 32 && byArray[i] != 13 && byArray[i] != 10 && i < n) {
                ++i;
            }
            int n9 = i - 1;
            n6 = n9 - n8 + 1;
            cArray = new char[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                cArray[n3] = (char)byArray[n8 + n3];
            }
            String string3 = new String(cArray);
            if (n2 != offsets.elementAt(n7)) continue;
            map.put(string2, string3);
            if (string != null) {
                map2.put(string, string3);
            }
            string = string2;
        }
    }

    public static int readCompressedOffsets(int n, int n2, int n3, int[] nArray, byte[] byArray, Offsets offsets, RandomAccessBuffer randomAccessBuffer) throws PdfException {
        int[] nArray2 = new int[]{1, 0, 0};
        boolean bl = false;
        block7: for (int i = 0; i < n3; ++i) {
            int n4;
            int[] nArray3 = new int[3];
            for (n4 = 0; n4 < 3; ++n4) {
                if (nArray[n4] == 0) {
                    nArray3[n4] = nArray2[n4];
                    continue;
                }
                nArray3[n4] = CompressedObjects.getWord(byArray, n, nArray[n4]);
                n += nArray[n4];
            }
            switch (nArray3[0]) {
                case 0: {
                    ++n2;
                    bl = nArray3[1] == 0 && nArray3[2] == 0;
                    continue block7;
                }
                case 1: {
                    n4 = nArray3[1];
                    int n5 = nArray3[2];
                    boolean bl2 = true;
                    if (n2 == n4) {
                        bl2 = false;
                        try {
                            int n6;
                            byte[] byArray2 = new byte[20];
                            randomAccessBuffer.seek(n2);
                            randomAccessBuffer.read(byArray2);
                            int n7 = 0;
                            for (n6 = 0; n6 < 20; ++n6) {
                                if (byArray2[n6] != 32 && byArray2[n6] != 10 && byArray2[n6] != 13) continue;
                                n7 = n6;
                                n6 = 20;
                            }
                            if (n7 > 0 && (n6 = NumberUtils.parseInt(0, n7, byArray2)) == n2) {
                                bl2 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl2 = false;
                            LogWriter.writeLog("Ref is invalid " + exception);
                        }
                    }
                    if (bl2 || !bl) {
                        offsets.storeObjectOffset(n2, n4, n5, false, false);
                    }
                    ++n2;
                    continue block7;
                }
                case 2: {
                    n4 = nArray3[1];
                    offsets.storeObjectOffset(n2, n4, 0, true, false);
                    ++n2;
                    continue block7;
                }
                default: {
                    throw new PdfException("Exception Unsupported Compression mode with value " + nArray3[0]);
                }
            }
        }
        return n;
    }

    static int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }
}

