/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ObjectReader {
    public boolean fileIsBroken;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    public static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    public static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private final RandomAccessBuffer pdf_datafile;
    private int newCacheSize = -1;
    private final long eof;
    final PdfFileReader currentPdfFile;

    public ObjectReader(RandomAccessBuffer randomAccessBuffer, long l, PdfFileReader pdfFileReader) {
        this.pdf_datafile = randomAccessBuffer;
        this.eof = l;
        this.currentPdfFile = pdfFileReader;
    }

    public byte[] readObjectData(int n, PdfObject pdfObject) {
        if (n < 1 || this.newCacheSize != -1 || this.fileIsBroken) {
            return this.readObjectDataXX(n, pdfObject);
        }
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[n += 6];
            try {
                this.pdf_datafile.read(byArray);
            }
            catch (IOException iOException) {
                LogWriter.writeLog("Unable to fill buffer " + iOException);
            }
        }
        return byArray;
    }

    private byte[] readObjectDataXX(int n, PdfObject pdfObject) {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        long l = this.getPointer();
        if (pdfObject != null) {
            n2 = this.newCacheSize;
        }
        int n6 = n;
        int n7 = 0;
        boolean bl4 = false;
        if (n < 1) {
            n = 128;
        }
        if (n2 != -1 && n > n2) {
            n = n2;
        }
        byte[] byArray = null;
        int n8 = n - 1;
        while (bl3) {
            byte by;
            if (++n8 == n) {
                long l2 = this.getPointer();
                if (l2 + (long)n > this.eof) {
                    n = (int)(this.eof - l2);
                }
                if (n == 0) break;
                byte[] byArray2 = new byte[n += 6];
                try {
                    this.pdf_datafile.read(byArray2);
                }
                catch (IOException iOException) {
                    LogWriter.writeLog("Unable to fill buffer " + iOException);
                }
                if (byArray == null) {
                    int n9 = 0;
                    for (int i = 0; i < 10; ++i) {
                        if (byArray2[i] != 101 || byArray2[i + 1] != 110 || byArray2[i + 2] != 100 || byArray2[i + 3] != 111 || byArray2[i + 4] != 98 || byArray2[i + 5] != 106) continue;
                        n9 = i;
                        break;
                    }
                    while (byArray2[n9] == 101 || byArray2[n9] == 110 || byArray2[n9] == 100 || byArray2[n9] == 111 || byArray2[n9] == 98 || byArray2[n9] == 106) {
                        ++n9;
                    }
                    if (n9 > 0) {
                        byte[] byArray3 = byArray2;
                        int n10 = byArray2.length - n9;
                        byArray2 = new byte[n10];
                        System.arraycopy(byArray3, n9, byArray2, 0, n10);
                        n = byArray2.length;
                    }
                    byArray = byArray2;
                } else {
                    byArray = ObjectReader.appendDataBlock(byArray2.length, byArray2, byArray);
                }
                n8 = 0;
            }
            n4 = (by = byArray[n7]) == endPattern[n4] ? ++n4 : 0;
            if (!bl && n2 != -1 && !bl2) {
                if (n3 < 6 && by == startStream[n3]) {
                    if (++n3 == 6) {
                        bl = true;
                    }
                } else {
                    n3 = 0;
                }
            }
            if (bl && byArray != null && byArray.length > n2) {
                pdfObject.setCache(l, this.currentPdfFile);
                bl2 = true;
            }
            if (!bl && !bl4 && n6 != -1) {
                if (by == lengthString[n5]) {
                    if (++n5 == 6) {
                        bl4 = true;
                    }
                } else {
                    n5 = 0;
                }
            }
            ++n7;
            if (n4 == 6) {
                if (!bl4) {
                    bl3 = false;
                }
                n4 = 0;
            }
            if (!bl4 || n7 <= n6) continue;
            bl3 = false;
        }
        if (!bl4) {
            byArray = ObjectUtils.checkEndObject(byArray);
        }
        return byArray;
    }

    static byte[] appendDataBlock(int n, byte[] byArray, byte[] byArray2) {
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n2 + n];
        System.arraycopy(byArray2, 0, byArray3, 0, n2);
        System.arraycopy(byArray, 0, byArray3, n2, n);
        return byArray3;
    }

    private long getPointer() {
        long l = 0L;
        try {
            l = this.pdf_datafile.getFilePointer();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting pointer in file");
        }
        return l;
    }

    public void setCacheSize(int n) {
        this.newCacheSize = n;
    }
}

