/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class TextStream {
    public static int readTextStream(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl, PdfFileReader pdfFileReader) {
        if (n2 == 39 || n2 == 9986) {
            return TextStream.readCIDWidths(pdfObject, n, byArray, n2, bl, pdfFileReader);
        }
        try {
            int n3;
            int n4;
            int n5;
            if (byArray[n] != 60 && byArray[n] != 40) {
                ++n;
            }
            if (byArray[n = ArrayUtils.skipSpaces(byArray, n)] == 47) {
                pdfObject.setTextStreamValue(n2, new byte[1]);
                return --n;
            }
            boolean bl2 = byArray[n] != 60 && byArray[n] != 40;
            int n6 = n;
            byte[] byArray2 = byArray;
            if (bl2) {
                n5 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                n4 = NumberUtils.parseInt(n5, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                    ++n;
                }
                n5 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                n3 = NumberUtils.parseInt(n5, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                    ++n;
                }
                if (byArray[n] != 82) {
                    return byArray.length;
                }
                if (!bl) {
                    byArray2 = pdfFileReader.readObjectAsByteArray(pdfObject, pdfFileReader.isCompressed(n4, n3), n4, n3);
                    if (byArray2 == null) {
                        pdfObject.setFullyResolved(false);
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (7)");
                        return byArray.length;
                    }
                    if (byArray2[0] == 40) {
                        n6 = 0;
                    } else {
                        n6 = 3;
                        while (byArray2[n6 - 1] != 106 && byArray2[n6 - 2] != 98 && byArray2[n6 - 3] != 111) {
                            ++n6;
                        }
                        n6 = ArrayUtils.skipSpaces(byArray2, n6);
                    }
                }
            }
            n5 = 0;
            if (!bl2 || !bl) {
                while (byArray2[n6] != 40 && byArray2[n6] != 60) {
                    ++n6;
                }
                n4 = byArray2[n6];
                n5 = n6;
                n3 = 1;
                while (n6 < byArray2.length) {
                    if (!(n4 != 40 || byArray2[++n6] != 41 && byArray2[n6] != 40 || ObjectUtils.isEscaped(byArray2, n6))) {
                        if (byArray2[n6] == 40) {
                            ++n3;
                        } else if (byArray2[n6] == 41) {
                            --n3;
                        }
                        if (n3 == 0) break;
                    }
                    if (n4 != 60 || byArray2[n6] != 62 && byArray2[n6] != 0) continue;
                }
            }
            if (!bl) {
                byte[] byArray3;
                if (byArray2[n5] == 60) {
                    n3 = n6 - ++n5 >> 1;
                    byArray3 = new byte[n3];
                    int n7 = 0;
                    while (n5 != n6) {
                        int n8 = byArray2[n5 = ArrayUtils.skipSpaces(byArray2, n5)];
                        if (n8 >= 65 && n8 <= 70) {
                            n8 -= 55;
                        } else if (n8 >= 97 && n8 <= 102) {
                            n8 -= 87;
                        } else if (n8 >= 48 && n8 <= 57) {
                            n8 -= 48;
                        }
                        ++n5;
                        n5 = ArrayUtils.skipSpaces(byArray2, n5);
                        int n9 = byArray2[n5];
                        if (n9 >= 65 && n9 <= 70) {
                            n9 -= 55;
                        } else if (n9 >= 97 && n9 <= 102) {
                            n9 -= 87;
                        } else if (n9 >= 48 && n9 <= 57) {
                            n9 -= 48;
                        } else {
                            LogWriter.writeLog("Unexpected number " + (char)byArray2[n5]);
                            return n;
                        }
                        ++n5;
                        int n10 = n9 + (n8 << 4);
                        byArray3[n7] = (byte)n10;
                        ++n7;
                    }
                } else {
                    if (byArray2[n5] == 40) {
                        ++n5;
                    }
                    n3 = 0;
                    switch (n2) {
                        case 6420: {
                            n3 = 1;
                            break;
                        }
                        case 31: 
                        case 37: {
                            n3 = pdfObject.getObjectType() == 1113489015 ? 1 : 0;
                        }
                    }
                    byArray3 = ObjectUtils.readEscapedValue(n6, byArray2, n5, n3 != 0);
                }
                if (pdfObject.getObjectType() != 1113489015) {
                    try {
                        DecryptionFactory decryptionFactory;
                        if (!(pdfObject.isInCompressedStream() && n2 != 506543413 && n2 != 826499443 && n2 != 1618506351 && n2 != 29 || (decryptionFactory = pdfFileReader.getDecryptionObject()) == null)) {
                            byArray3 = decryptionFactory.decryptString(byArray3, pdfObject.getObjectRefAsString());
                        }
                    }
                    catch (PdfSecurityException pdfSecurityException) {
                        LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
                    }
                }
                pdfObject.setTextStreamValue(n2, byArray3);
            }
            if (!bl2) {
                n = n6;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return n;
    }

    private static int readCIDWidths(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl, PdfFileReader pdfFileReader) {
        int n3;
        int n4;
        if (n2 == 9986) {
            ++n;
        }
        boolean bl2 = false;
        while (byArray[n] != 91) {
            if (byArray[n] == 40) {
                bl2 = false;
                break;
            }
            if (byArray[n] >= 48 && byArray[n] <= 57) {
                bl2 = true;
                break;
            }
            ++n;
        }
        byte[] byArray2 = byArray;
        int n5 = n;
        int n6 = n;
        int n7 = 0;
        if (bl2) {
            n4 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            int n8 = NumberUtils.parseInt(n4, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            n4 = n;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
            }
            n3 = NumberUtils.parseInt(n4, n, byArray);
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            if (byArray[n] != 82) {
                throw new RuntimeException("3. Unexpected value in file " + byArray[n] + " - please send to IDRsolutions for analysis");
            }
            if (!bl) {
                byArray2 = pdfFileReader.readObjectAsByteArray(pdfObject, pdfFileReader.isCompressed(n8, n3), n8, n3);
                if (byArray2 == null) {
                    pdfObject.setFullyResolved(false);
                    return byArray.length;
                }
                n6 = 3;
                if (byArray2.length < 3) {
                    n6 = 0;
                } else {
                    while (byArray2[n6 - 1] != 106 && byArray2[n6 - 2] != 98 && byArray2[n6 - 3] != 111) {
                        if (++n6 != byArray2.length) continue;
                        n6 = 0;
                        break;
                    }
                }
                while (byArray2[n6] == 10 || byArray2[n6] == 13 || byArray2[n6] == 32) {
                    ++n6;
                }
                n5 = n6;
            }
        }
        while (n6 < byArray2.length) {
            if (byArray2[n6] == 91 || byArray2[n6] == 40) {
                ++n7;
            } else if (byArray2[n6] == 93 || byArray2[n6] == 41) {
                --n7;
            }
            if (n7 == 0) break;
            ++n6;
        }
        if (!bl) {
            n4 = n6 - n5 + 1;
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, n5, byArray3, 0, n4);
            if (n2 != 6691) {
                for (n3 = 0; n3 < n4; ++n3) {
                    if (byArray3[n3] != 10 && byArray3[n3] != 13) continue;
                    byArray3[n3] = 32;
                }
            }
            pdfObject.setTextStreamValue(n2, byArray3);
        }
        if (!bl2) {
            n = n6;
        }
        return n;
    }

    public static int setTextStreamValue(PdfObject pdfObject, int n, byte[] byArray, boolean bl, int n2, PdfFileReader pdfFileReader) {
        if (byArray[n + 1] == 40 && byArray[n + 2] == 41) {
            pdfObject.setTextStreamValue(n2, new byte[1]);
            if (byArray[n += 3] == 47) {
                --n;
            }
        } else {
            n = TextStream.readTextStream(pdfObject, n, byArray, n2, bl, pdfFileReader);
        }
        return n;
    }
}

