/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.image.JBIG2Bitmap;

public class JBIG2ImageReader
extends ImageReader {
    private JBIG2Decoder decoder;
    private ImageInputStream stream;
    private boolean readFile;

    protected JBIG2ImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object == null) {
            this.stream = null;
            return;
        }
        if (!(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("ImageInputStream expected!");
        }
        this.stream = (ImageInputStream)object;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            int n2 = this.getWidth(n);
            int n3 = this.getHeight(n);
            Rectangle rectangle = JBIG2ImageReader.getSourceRegion(imageReadParam, n2, n3);
            int n4 = 1;
            int n5 = 1;
            Point point = new Point(0, 0);
            if (imageReadParam != null) {
                n4 = imageReadParam.getSourceXSubsampling();
                n5 = imageReadParam.getSourceYSubsampling();
                point = imageReadParam.getDestinationOffset();
            }
            bufferedImage = JBIG2ImageReader.getDestination(imageReadParam, this.getImageTypes(0), n2, n3);
            WritableRaster writableRaster = bufferedImage.getRaster();
            JBIG2Bitmap jBIG2Bitmap = this.decoder.getPageAsJBIG2Bitmap(n).getSlice(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            BufferedImage bufferedImage2 = jBIG2Bitmap.getBufferedImage();
            int n6 = (int)((double)bufferedImage2.getWidth() * (1.0 / (double)n4));
            int n7 = (int)((double)bufferedImage2.getHeight() * (1.0 / (double)n5));
            BufferedImage bufferedImage3 = JBIG2ImageReader.scaleImage(bufferedImage2.getRaster(), n6, n7, 1, 1);
            WritableRaster writableRaster2 = null;
            writableRaster2 = bufferedImage3 != null ? bufferedImage3.getRaster() : bufferedImage2.getRaster();
            writableRaster.setRect(point.x, point.y, writableRaster2);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return bufferedImage;
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.readFile();
        this.checkIndex(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(12));
        return arrayList.iterator();
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        this.readFile();
        return this.decoder.getNumberOfPages();
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.readFile();
        this.checkIndex(n);
        return this.decoder.getPageAsJBIG2Bitmap(n).getHeight();
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.readFile();
        this.checkIndex(n);
        return this.decoder.getPageAsJBIG2Bitmap(n).getWidth();
    }

    private void checkIndex(int n) {
        int n2 = this.decoder.getNumberOfPages();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Bad index!");
        }
    }

    private static BufferedImage scaleImage(Raster raster, int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        int n5;
        int n6;
        int n7 = raster.getWidth();
        int n8 = raster.getHeight();
        byte[] byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
        int n9 = n7;
        int n10 = 1;
        int n11 = n2 << 2;
        int n12 = n << 2;
        for (n6 = n8; n9 > n12 && n6 > n11; n9 >>= 1, n6 >>= 1) {
            n10 <<= 1;
        }
        int n13 = n7 / n;
        if (n13 < 1) {
            n13 = 1;
        }
        if ((n5 = n8 / n2) < 1) {
            n5 = 1;
        }
        if ((n10 = n13) > n5) {
            n10 = n5;
        }
        if (n10 > 1) {
            int n14;
            n9 = n7 / n10;
            n6 = n8 / n10;
            if (n4 == 1) {
                n14 = n9 * n6;
                object2 = new byte[n14];
                object = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
                int n15 = n7 + 7 >> 3;
                for (int i = 0; i < n6; ++i) {
                    for (int j = 0; j < n9; ++j) {
                        int n16;
                        int n17 = 0;
                        int n18 = 0;
                        int n19 = n10;
                        int n20 = n10;
                        int n21 = n7 - j;
                        int n22 = n8 - i;
                        if (n19 > n21) {
                            n19 = n21;
                        }
                        if (n20 > n22) {
                            n20 = n22;
                        }
                        for (n16 = 0; n16 < n20; ++n16) {
                            for (int k = 0; k < n19; ++k) {
                                byte by = byArray[(n16 + i * n10) * n15 + (j * n10 + k >> 3)];
                                int n23 = by & object[7 - (j * n10 + k & 7)];
                                if (n23 != 0) {
                                    ++n17;
                                }
                                ++n18;
                            }
                        }
                        n16 = j + n9 * i;
                        object2[n16] = n18 > 0 ? (int)(255 * n17 / n18) : -1;
                    }
                }
                byArray = object2;
                n8 = n6;
                n7 = n9;
                n4 = 8;
            } else if (n4 == 8) {
                n14 = 0;
                int n24 = 0;
                int n25 = 0;
                int n26 = 0;
                int n27 = 0;
                int n28 = 0;
                try {
                    if (n7 * n8 == byArray.length) {
                        n3 = 1;
                    }
                    byte[] byArray2 = new byte[n9 * n6 * n3];
                    n28 = n7 * n3;
                    for (n24 = 0; n24 < n6; ++n24) {
                        for (n14 = 0; n14 < n9; ++n14) {
                            int n29 = n10;
                            int n30 = n10;
                            int n31 = n7 - n14;
                            int n32 = n8 - n24;
                            if (n29 > n31) {
                                n29 = n31;
                            }
                            if (n30 > n32) {
                                n30 = n32;
                            }
                            for (n27 = 0; n27 < n3; ++n27) {
                                int n33 = 0;
                                int n34 = 0;
                                for (n26 = 0; n26 < n30; ++n26) {
                                    for (n25 = 0; n25 < n29; ++n25) {
                                        n33 += byArray[(n26 + n24 * n10) * n28 + (n14 * n10 * n3 + n25 * n3 + n27)] & 0xFF;
                                        ++n34;
                                    }
                                }
                                if (n34 <= 0) continue;
                                byArray2[n27 + n14 * n3 + n9 * n24 * n3] = (byte)(n33 / n34);
                            }
                        }
                    }
                    byArray = byArray2;
                    n8 = n6;
                    n7 = n9;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        if (n10 > 1) {
            int[] nArray = new int[]{0};
            object2 = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n7, n8, n7, 1, nArray, null);
            object = new BufferedImage(n7, n8, 10);
            ((BufferedImage)object).setData((Raster)object2);
            return object;
        }
        return null;
    }

    private void readFile() {
        if (this.readFile) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("No input stream!");
        }
        this.decoder = new JBIG2Decoder();
        try {
            byte[] byArray;
            int n = (int)this.stream.length();
            if (n == -1) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[8192];
                int n2 = 0;
                while ((n2 = this.stream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n2);
                }
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                byArray = new byte[n];
                this.stream.readFully(byArray);
            }
            this.decoder.decodeJBIG2(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (JBIG2Exception jBIG2Exception) {
            jBIG2Exception.printStackTrace();
        }
        this.readFile = true;
    }
}

