/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.linear;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.FileAccess;
import org.jpedal.exception.PdfException;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.raw.LinearizedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class LinearParser {
    public boolean isLinearizationTested;
    private PageObject linObject;
    private final Map linObjects = new HashMap();
    private int linearPageCount = -1;
    private PdfObject linearObj;
    private LinearizedHintTable linHintTable;
    private int E = -1;
    public LinearThread linearizedBackgroundReaderer;

    public void closePdfFile() {
        this.E = -1;
        this.linearObj = null;
        this.isLinearizationTested = false;
        this.linObjects.clear();
        if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive()) {
            this.linearizedBackgroundReaderer.interrupt();
        }
        while (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && !this.linearizedBackgroundReaderer.isInterrupted()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.linHintTable = null;
    }

    private void testForLinearlized(byte[] byArray, PdfObjectReader pdfObjectReader) {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        this.isLinearizationTested = true;
        int n4 = byArray.length;
        for (n = 0; n < byArray.length; ++n) {
            if (n2 == 0 && n + 2 < n4 && byArray[n] == 111 && byArray[n + 1] == 98 && byArray[n + 2] == 106) {
                n2 = n + 3;
                continue;
            }
            if (n3 == 0 && n + 5 < n4 && byArray[n] == 101 && byArray[n + 1] == 110 && byArray[n + 2] == 100 && byArray[n + 3] == 111 && byArray[n + 4] == 98 && byArray[n + 5] == 106) {
                n3 = n + 7;
                continue;
            }
            if (bl || n + 6 >= n4 || byArray[n] != 47 || byArray[n + 1] != 76 || byArray[n + 2] != 105 || byArray[n + 3] != 110 || byArray[n + 4] != 101 || byArray[n + 5] != 97 || byArray[n + 6] != 114) continue;
            bl = true;
        }
        if (bl) {
            n = n3 - n2;
            byte[] byArray2 = new byte[n + 1];
            System.arraycopy(byArray, n2, byArray2, 0, n);
            this.linearObj = new LinearizedObject("1 0 R");
            this.linearObj.setStatus(2);
            this.linearObj.setUnresolvedData(byArray2, 2004845231);
            pdfObjectReader.checkResolved(this.linearObj);
        } else {
            this.linearObj = null;
        }
    }

    public boolean isPageAvailable(int n, PdfObjectReader pdfObjectReader) {
        boolean bl = true;
        try {
            if (this.linearizedBackgroundReaderer != null && this.linearizedBackgroundReaderer.isAlive() && n > 1 && this.linHintTable != null) {
                Integer n2 = n;
                if (this.linObjects.containsKey(n2)) {
                    this.linObject = (PageObject)this.linObjects.get(n2);
                    return true;
                }
                int n3 = this.linHintTable.getPageObjectRef(n);
                byte[] byArray = this.linHintTable.getObjData(n3);
                if (byArray != null) {
                    this.linObject = new PageObject(n3 + " 0 R");
                    this.linObject.setStatus(2);
                    this.linObject.setUnresolvedData(byArray, 540096309);
                    this.linObject.isDataExternal(true);
                    PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
                    if (!ObjectDecoder.resolveFully(this.linObject, pdfFileReader)) {
                        bl = false;
                    } else {
                        if (this.linObject != null) {
                            byte[] byArray2 = pdfObjectReader.getObjectReader().readPageIntoStream(this.linObject);
                            if (byArray2 == null) {
                                bl = false;
                            } else {
                                PdfObject pdfObject = this.linObject.getDictionary(2004251818);
                                if (pdfObject == null) {
                                    this.linObject = null;
                                    bl = false;
                                } else if (!ObjectDecoder.resolveFully(pdfObject, pdfFileReader)) {
                                    this.linObject = null;
                                    bl = false;
                                } else {
                                    pdfObject.isDataExternal(true);
                                    new PdfStreamDecoder(pdfObjectReader).readResources(pdfObject, true);
                                    if (!pdfObject.isFullyResolved()) {
                                        this.linObject = null;
                                        bl = false;
                                    }
                                }
                            }
                        }
                        if (bl && this.linObject != null) {
                            this.linObjects.put(n2, this.linObject);
                        }
                    }
                } else {
                    bl = false;
                }
            } else {
                this.linObject = null;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLinearData(PdfObjectReader pdfObjectReader, File file, InputStream inputStream, FileAccess fileAccess) throws IOException {
        Object object;
        int n;
        FileChannel fileChannel = new RandomAccessFile(file, "rws").getChannel();
        fileChannel.force(true);
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(8192);
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            if (n > 0) {
                object = fileChannel;
                synchronized (object) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                    fileChannel.write(byteBuffer);
                }
            }
            n2 += n;
            if (this.E != -1) {
                fastByteArrayOutputStream.write(byArray, 0, n);
                if (this.E >= n2) continue;
                object = fastByteArrayOutputStream.toByteArray();
                this.linHintTable = new LinearizedHintTable(fileChannel);
                pdfObjectReader.getObjectReader().storeLinearizedTables(this.linHintTable);
                this.linearizedBackgroundReaderer = new LinearThread(inputStream, fileChannel, file, this.linearObj, (byte[])object, this.linHintTable, fileAccess);
                return object;
            }
            if (this.isLinearizationTested) continue;
            this.testForLinearlized(byArray, pdfObjectReader);
            if (this.linearObj == null) continue;
            this.E = this.linearObj.getInt(21);
            fastByteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        object = fileChannel;
        synchronized (object) {
            fileChannel.close();
        }
        return null;
    }

    public PdfObject readHintTable(PdfObjectReader pdfObjectReader) throws PdfException {
        PdfObject pdfObject;
        long l = -1L;
        this.linearPageCount = -1;
        int n = this.linearObj.getInt(31);
        if (n != -1) {
            this.linearObj.setIntNumber(31, -1);
            pdfObjectReader.getObjectReader().readReferenceTable(this.linearObj);
            pdfObject = new PageObject(n, 0);
            pdfObjectReader.readObject(pdfObject);
            this.linearPageCount = this.linearObj.getInt(30);
            l = pdfObjectReader.getObjectReader().getOffset(n);
        } else {
            pdfObject = pdfObjectReader.getObjectReader().readReferenceTable(null);
        }
        int[] nArray = this.linearObj.getIntArray(24);
        byte[] byArray = pdfObjectReader.getObjectReader().getBytes(nArray[0], nArray[1]);
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = n4;
        while (byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
            if (byArray[n4] < 48 || byArray[n4] > 57) {
                bl = true;
            }
            ++n4;
        }
        if (!bl) {
            int n6 = NumberUtils.parseInt(n5, n4, byArray);
            while (byArray[n4] == 10 || byArray[n4] == 13 || byArray[n4] == 32 || byArray[n4] == 47 || byArray[n4] == 60) {
                ++n4;
            }
            n5 = n4;
            while (n4 < 10 && byArray[n4] != 10 && byArray[n4] != 13 && byArray[n4] != 32 && byArray[n4] != 47 && byArray[n4] != 60 && byArray[n4] != 62) {
                ++n4;
            }
            int n7 = NumberUtils.parseInt(n5, n4, byArray);
            while (n4 < n2 - 1) {
                if (byArray[n4] == 60 && byArray[n4 + 1] == 60) {
                    n3 = n4;
                    n4 = n2;
                }
                ++n4;
            }
            byte[] byArray2 = new byte[n2 - n3];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            LinearizedObject linearizedObject = new LinearizedObject(n6, n7);
            linearizedObject.setStatus(2);
            linearizedObject.setUnresolvedData(byArray2, 2004845231);
            pdfObjectReader.checkResolved(linearizedObject);
            this.linHintTable.readTable(linearizedObject, this.linearObj, n, l);
        }
        return pdfObject;
    }

    public int getPageCount() {
        return this.linearPageCount;
    }

    public boolean hasLinearData() {
        return this.linearObj != null && this.E != -1;
    }

    public PdfObject getLinearPageObject() {
        return this.linObject;
    }

    public PdfObject getLinearObject(boolean bl, PdfObjectReader pdfObjectReader) {
        if (!this.isLinearizationTested && bl) {
            this.testForLinearlized(pdfObjectReader.getObjectReader().getBytes(0L, 400), pdfObjectReader);
        }
        return this.linearObj;
    }
}

