/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.Serializable;
import org.jpedal.objects.PageOrigins;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfPageData
implements Serializable {
    private int lastPage = -1;
    private int pagesRead = -1;
    private int pageCount = 1;
    private int maxPageCount = -1;
    private int rotation;
    private final Vector_Object mediaBoxes = new Vector_Object(500);
    private final Vector_Object cropBoxes = new Vector_Object(500);
    private Vector_Int rotations;
    private float cropBoxX = -99999.0f;
    private float cropBoxY = -1.0f;
    private float cropBoxW = -1.0f;
    private float cropBoxH = -1.0f;
    private float mediaBoxX = -1.0f;
    private float mediaBoxY;
    private float mediaBoxW;
    private float mediaBoxH;
    private boolean hasMultipleSizes;
    private boolean hasMultipleSizesSet;
    private float scalingValue = 1.0f;
    private float[] mediaBox;
    private float[] cropBox;
    private PageOrigins pageOrigin = PageOrigins.BOTTOM_LEFT;

    public void checkSizeSet(int n) {
        if (n > this.pageCount) {
            this.pageCount = n;
        }
        if (this.cropBox != null && (this.cropBox[0] != this.mediaBox[0] || this.cropBox[1] != this.mediaBox[1] || this.cropBox[2] != this.mediaBox[2] || this.cropBox[3] != this.mediaBox[3])) {
            this.mediaBoxes.setElementAt(this.mediaBox, n);
            if (this.cropBox[0] >= this.mediaBox[0] && this.cropBox[1] >= this.mediaBox[1] && this.cropBox[2] - this.cropBox[0] <= this.mediaBox[2] - this.mediaBox[0] && this.cropBox[3] - this.cropBox[1] <= this.mediaBox[3] - this.mediaBox[1]) {
                this.cropBoxes.setElementAt(this.cropBox, n);
            }
        } else if (this.mediaBox != null) {
            this.mediaBoxes.setElementAt(this.mediaBox, n);
        }
        if (this.pagesRead < n) {
            this.pagesRead = n;
        }
        this.lastPage = -1;
        this.mediaBox = null;
        this.cropBox = null;
    }

    public final int getMediaBoxHeight(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.mediaBoxH;
    }

    public final int getMediaBoxY(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.mediaBoxY;
    }

    public final int getMediaBoxX(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.mediaBoxX;
    }

    public void setMediaBox(float[] fArray) {
        this.mediaBox = fArray;
        this.cropBox = null;
    }

    public void setCropBox(float[] fArray) {
        this.cropBox = fArray != null ? fArray : this.mediaBox;
        if (this.mediaBox != null && this.mediaBox.length >= 4) {
            if (this.cropBox[0] < this.mediaBox[0]) {
                this.cropBox[0] = this.mediaBox[0];
            }
            if (this.cropBox[1] < this.mediaBox[1]) {
                this.cropBox[1] = this.mediaBox[1];
            }
            if (this.cropBox[2] > this.mediaBox[2]) {
                this.cropBox[2] = this.mediaBox[2];
            }
            if (this.cropBox[3] > this.mediaBox[3]) {
                this.cropBox[3] = this.mediaBox[3];
            }
        }
    }

    public void setPageRotation(int n, int n2) {
        int n3 = n;
        if (n3 < 0) {
            n3 = 360 + n3;
        }
        if (n3 != 0 || this.rotations != null) {
            if (this.rotations == null) {
                this.rotations = n2 < 2000 ? new Vector_Int(2000) : new Vector_Int(n2 * 2);
            }
            this.rotations.setElementAt(n3, n2);
        }
    }

    public final int getMediaBoxWidth(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.mediaBoxW;
    }

    public String getMediaValue(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        float[] fArray = null;
        if (this.mediaBoxes != null) {
            fArray = (float[])this.mediaBoxes.elementAt(n);
        }
        if (fArray != null) {
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(fArray[i]);
                stringBuilder.append(' ');
            }
        }
        return stringBuilder.toString();
    }

    public String getCropValue(int n) {
        float[] fArray = null;
        if (this.cropBoxes != null) {
            fArray = (float[])this.cropBoxes.elementAt(n);
        }
        if (fArray == null) {
            fArray = (float[])this.mediaBoxes.elementAt(n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            stringBuilder.append(fArray[i]);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public int getScaledCropBoxX(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxX * this.scalingValue);
    }

    public int getScaledCropBoxWidth(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxW * this.scalingValue);
    }

    public int getScaledCropBoxY(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxY * this.scalingValue);
    }

    public int getScaledCropBoxHeight(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.cropBoxH * this.scalingValue);
    }

    public int getCropBoxX(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.cropBoxX;
    }

    public float getCropBoxX2D(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return this.cropBoxX;
    }

    public int getCropBoxWidth(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.cropBoxW;
    }

    public float getCropBoxWidth2D(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return this.cropBoxW;
    }

    public int getCropBoxY(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.cropBoxY;
    }

    public float getCropBoxY2D(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return this.cropBoxY;
    }

    public int getCropBoxHeight(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return (int)this.cropBoxH;
    }

    public float getCropBoxHeight2D(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return this.cropBoxH;
    }

    private synchronized void setSizeForPage(int n) throws Exception {
        if (n == this.lastPage) {
            return;
        }
        if (n > this.pageCount) {
            this.pageCount = n;
        }
        if (n > this.pagesRead) {
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 0.0f;
            this.mediaBoxH = 0.0f;
            this.cropBoxX = 0.0f;
            this.cropBoxY = 0.0f;
            this.cropBoxW = 0.0f;
            this.cropBoxH = 0.0f;
            this.lastPage = n;
        } else if (n > 0 && this.lastPage != n && (this.maxPageCount == -1 || n <= this.maxPageCount)) {
            this.lastPage = n;
            float[] fArray = (float[])this.cropBoxes.elementAt(n);
            float[] fArray2 = (float[])this.mediaBoxes.elementAt(n);
            if (this.rotations != null) {
                this.rotation = this.rotations.elementAt(n);
            }
            while (this.rotation >= 360) {
                this.rotation -= 360;
            }
            this.mediaBoxX = 0.0f;
            this.mediaBoxY = 0.0f;
            this.mediaBoxW = 800.0f;
            this.mediaBoxH = 800.0f;
            if (fArray2 != null) {
                this.mediaBoxX = fArray2[0];
                this.mediaBoxY = fArray2[1];
                this.mediaBoxW = fArray2[2] - this.mediaBoxX;
                this.mediaBoxH = fArray2[3] - this.mediaBoxY;
                if (this.mediaBoxY > 0.0f && this.mediaBoxH == -this.mediaBoxY) {
                    this.mediaBoxH = -this.mediaBoxH;
                    this.mediaBoxY = 0.0f;
                }
            }
            if (fArray != null) {
                float f;
                this.cropBoxX = fArray[0];
                this.cropBoxY = fArray[1];
                this.cropBoxW = fArray[2];
                this.cropBoxH = fArray[3];
                if (this.cropBoxX > this.cropBoxW) {
                    f = this.cropBoxX;
                    this.cropBoxX = this.cropBoxW;
                    this.cropBoxW = f;
                }
                if (this.cropBoxY > this.cropBoxH) {
                    f = this.cropBoxY;
                    this.cropBoxY = this.cropBoxH;
                    this.cropBoxH = f;
                }
                this.cropBoxW -= this.cropBoxX;
                this.cropBoxH -= this.cropBoxY;
                if (this.cropBoxY > 0.0f && this.cropBoxH == -this.cropBoxY) {
                    this.cropBoxH = -this.cropBoxH;
                    this.cropBoxY = 0.0f;
                }
            } else {
                this.cropBoxX = this.mediaBoxX;
                this.cropBoxY = this.mediaBoxY;
                this.cropBoxW = this.mediaBoxW;
                this.cropBoxH = this.mediaBoxH;
            }
            if (this.cropBoxH < 0.0f) {
                this.cropBoxY += this.cropBoxH;
                this.cropBoxH = -this.cropBoxH;
            }
            if (this.cropBoxW < 0.0f) {
                this.cropBoxX += this.cropBoxW;
                this.cropBoxW = -this.cropBoxW;
            }
        } else if (n <= 0 || this.maxPageCount != -1 && n > this.maxPageCount) {
            throw new Exception("Attempted to find page outside of page range 1 - " + this.maxPageCount + "  Page number requested:" + n);
        }
    }

    public float getScalingValue() {
        return this.scalingValue;
    }

    public void setScalingValue(float f) {
        this.scalingValue = f;
    }

    private static int roundFloat(float f) {
        int n = (int)f;
        float f2 = f - (float)n;
        if ((double)f2 > 0.3) {
            ++n;
        }
        return n;
    }

    public final int getPageCount() {
        return this.pageCount;
    }

    public final int getRotation(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return this.rotation;
    }

    public final int getScaledMediaBoxHeight(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxH * this.scalingValue);
    }

    public final int getScaledMediaBoxWidth(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxW * this.scalingValue);
    }

    public final int getScaledMediaBoxX(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxX * this.scalingValue);
    }

    public final int getScaledMediaBoxY(int n) {
        try {
            this.setSizeForPage(n);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return PdfPageData.roundFloat(this.mediaBoxY * this.scalingValue);
    }

    public boolean hasMultipleSizes() {
        if (this.hasMultipleSizesSet) {
            return this.hasMultipleSizes;
        }
        int n = this.pageCount;
        int n2 = this.getCropBoxWidth(1);
        int n3 = this.getCropBoxHeight(1);
        int n4 = this.getRotation(1);
        if (n > 1) {
            for (int i = 2; i < n + 1; ++i) {
                if (n2 == this.getCropBoxWidth(i) && n3 == this.getCropBoxHeight(i) && n4 == this.getRotation(i)) continue;
                i = n;
                this.hasMultipleSizes = true;
            }
        }
        this.hasMultipleSizesSet = true;
        return this.hasMultipleSizes;
    }

    public void setOrigin(PageOrigins pageOrigins) {
        this.pageOrigin = pageOrigins;
    }

    public PageOrigins getOrigin() {
        return this.pageOrigin;
    }

    public void setPageCount(int n) {
        this.maxPageCount = n;
    }
}

