/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.outlines.OutlineData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;

public class PdfResources {
    public static final int AcroFormObj = 1;
    public static final int GlobalResources = 2;
    public static final int StructTreeRootObj = 3;
    public static final int MarkInfoObj = 4;
    PdfLayerList layers;
    private PdfObject metadataObj;
    private PdfObject acroFormObj;
    private PdfObject globalResources;
    private PdfObject PropertiesObj;
    private PdfObject structTreeRootObj;
    private PdfObject OCProperties;
    private PdfObject markInfoObj;
    private PdfObject OutlinesObj;
    private OutlineData outlineData;

    public void setupResources(PdfStreamDecoder pdfStreamDecoder, boolean bl, PdfObject pdfObject, int n, PdfObjectReader pdfObjectReader) throws PdfException {
        PdfObject pdfObject2;
        if (this.globalResources != null) {
            pdfStreamDecoder.readResources(this.globalResources, true);
            pdfObject2 = this.globalResources.getDictionary(-2089186617);
            if (pdfObject2 != null) {
                this.PropertiesObj = pdfObject2;
            }
        }
        if (pdfObject != null) {
            pdfStreamDecoder.readResources(pdfObject, true);
            pdfObject2 = pdfObject.getDictionary(-2089186617);
            if (pdfObject2 != null) {
                this.PropertiesObj = pdfObject2;
            }
        }
        if (this.OCProperties != null && (this.layers == null || n != this.layers.getOCpageNumber() || bl)) {
            pdfObjectReader.checkResolved(this.OCProperties);
            if (this.layers == null) {
                this.layers = new PdfLayerList();
            }
            this.layers.init(this.OCProperties, this.PropertiesObj, pdfObjectReader, n);
        }
        pdfStreamDecoder.setObjectValue(-4, this.layers);
    }

    public PdfObject getPdfObject(int n) {
        PdfObject pdfObject = null;
        switch (n) {
            case 1: {
                pdfObject = this.acroFormObj;
                break;
            }
            case 2: {
                pdfObject = this.globalResources;
                break;
            }
            case 4: {
                pdfObject = this.markInfoObj;
                break;
            }
            case 3: {
                pdfObject = this.structTreeRootObj;
            }
        }
        return pdfObject;
    }

    public void setPdfObject(int n, PdfObject pdfObject) {
        switch (n) {
            case 2: {
                this.globalResources = pdfObject;
            }
        }
    }

    public void flush() {
        this.globalResources = null;
    }

    public void flushObjects() {
        this.metadataObj = null;
        this.acroFormObj = null;
        this.markInfoObj = null;
        this.PropertiesObj = null;
        this.OCProperties = null;
        this.structTreeRootObj = null;
        this.OutlinesObj = null;
        this.layers = null;
    }

    public final boolean hasOutline() {
        return this.OutlinesObj != null;
    }

    public void setValues(PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        pdfObjectReader.checkResolved(pdfObject);
        this.metadataObj = pdfObject.getDictionary(1365674082);
        this.acroFormObj = pdfObject.getDictionary(661816444);
        pdfObjectReader.checkResolved(this.acroFormObj);
        this.markInfoObj = pdfObject.getDictionary(913275002);
        this.structTreeRootObj = pdfObject.getDictionary(-2000237823);
        this.OCProperties = pdfObject.getDictionary(-1567847737);
        this.OutlinesObj = pdfObject.getDictionary(1485011327);
        this.outlineData = null;
    }

    public OutlineData getOutlineData() {
        return this.outlineData;
    }

    public Document getOutlineAsXML(PdfObjectReader pdfObjectReader) {
        if (this.outlineData == null && this.OutlinesObj != null) {
            try {
                pdfObjectReader.checkResolved(this.OutlinesObj);
                this.outlineData = new OutlineData();
                this.outlineData.readOutlineFileMetadata(this.OutlinesObj, pdfObjectReader);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " accessing outline ");
                this.outlineData = null;
            }
        }
        if (this.outlineData != null) {
            return this.outlineData.getList();
        }
        return null;
    }

    public PdfFileInformation getMetaData(PdfObjectReader pdfObjectReader) {
        if (pdfObjectReader != null) {
            return new PdfFileInformation().readPdfFileMetadata(this.metadataObj, pdfObjectReader);
        }
        return null;
    }

    public boolean isForm() {
        return this.acroFormObj != null;
    }

    public PdfLayerList getPdfLayerList() {
        return this.layers;
    }
}

