/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jpedal.DevFlags;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.FormTypes;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.SwingFormCreator;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.FormFlattener;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PrintStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class AcroRenderer {
    FormObject[] Fforms;
    FormObject[] Aforms;
    private PdfObject AcroRes;
    private float dpi = 72.0f;
    private Object[] CO;
    PdfArrayIterator fieldList;
    private PdfArrayIterator[] annotList;
    private boolean ignoreForms;
    private boolean alwaysUseXFA;
    public FormFactory formFactory;
    public GUIData compData;
    private Set<FormObject> sigObject;
    private Map<String, String> sigKeys;
    private PdfPageData pageData;
    private int[] AfieldCount;
    private int ATotalCount;
    private int FfieldCount;
    int pageCount;
    PdfObjectReader currentPdfFile;
    FormStream fDecoder;
    private ActionHandler formsActionHandler;
    private Javascript javascript;
    boolean hasXFA;
    private boolean isContainXFAStream;
    private boolean useXFA;
    Enum PDFformType;
    private SwingFormCreator formCreator;
    private boolean addedMissingPopup;

    public void useXFAIfAvailable(boolean bl) {
        this.useXFA = bl;
    }

    public void resetHandler(ActionHandler actionHandler, float f, Javascript javascript) {
        this.formsActionHandler = actionHandler;
        this.dpi = f;
        this.javascript = javascript;
        if (this.formFactory != null) {
            this.formFactory.reset(this.getFormResources(), actionHandler, this.pageData, this.currentPdfFile);
        }
    }

    public void removeDisplayComponentsFromScreen() {
        if (this.compData != null) {
            this.compData.removeAllComponentsFromScreen();
        }
    }

    public int openFile(int n, int n2, int n3, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader, PdfObject pdfObject) {
        this.pageCount = n;
        this.currentPdfFile = pdfObjectReader;
        this.pageData = pdfPageData;
        this.compData.flushFormData();
        this.sigObject = null;
        this.sigKeys = null;
        this.compData.setPageData(pdfPageData, n2, n3);
        if (pdfObject == null) {
            this.FfieldCount = 0;
            this.fieldList = null;
        } else {
            PdfArrayIterator pdfArrayIterator = null;
            PdfObject pdfObject2 = pdfObject.getDictionary(2627089);
            if (pdfObject2 == null && (pdfArrayIterator = pdfObject.getMixedArray(2627089)) != null && pdfArrayIterator.getTokenCount() == 0) {
                pdfArrayIterator = null;
            }
            this.isContainXFAStream = this.hasXFA = pdfObject2 != null || pdfArrayIterator != null;
            this.fieldList = pdfObject.getMixedArray(893143676);
            this.CO = pdfObject.getObjectArray(4895);
            if (this.fieldList != null) {
                this.FfieldCount = this.fieldList.getTokenCount();
                this.AcroRes = pdfObject.getDictionary(5154);
                if (this.AcroRes != null) {
                    pdfObjectReader.checkResolved(this.AcroRes);
                }
            } else {
                this.FfieldCount = 0;
                this.AcroRes = null;
            }
            if (this.hasXFA && this.useXFA) {
                this.processXFAFields(pdfObject, pdfObjectReader, pdfPageData);
            }
            if (!this.hasXFA) {
                this.resolveIndirectFieldList(false);
            }
        }
        this.resetContainers(true);
        return n;
    }

    void processXFAFields(PdfObject pdfObject, PdfObjectReader pdfObjectReader, PdfPageData pdfPageData) {
        throw new RuntimeException("This code (processXFAFields) should never be called");
    }

    void resolveIndirectFieldList(boolean bl) {
        while (this.FfieldCount == 1) {
            this.fieldList.resetToStart();
            String string = this.fieldList.getNextValueAsString(false);
            FormObject formObject = new FormObject(string);
            this.currentPdfFile.readObject(formObject);
            byte[][] byArray = this.getKid(formObject, bl);
            if (byArray == null) break;
            this.fieldList = new PdfArrayIterator(byArray);
            this.FfieldCount = this.fieldList.getTokenCount();
        }
    }

    public void resetAnnotData(int n, int n2, PdfPageData pdfPageData, int n3, PdfObjectReader pdfObjectReader, byte[][] byArray) {
        this.currentPdfFile = pdfObjectReader;
        this.pageData = pdfPageData;
        boolean bl = true;
        this.addedMissingPopup = false;
        this.compData.setPageData(pdfPageData, n, n2);
        if (byArray == null) {
            this.AfieldCount = null;
            this.ATotalCount = 0;
            if (this.annotList != null) {
                this.annotList[n3] = null;
            }
            this.annotList = null;
        } else {
            int n4;
            int n5 = pdfPageData.getPageCount() + 1;
            if (n5 <= n3) {
                n5 = n3 + 1;
            }
            if (this.annotList == null) {
                this.annotList = new PdfArrayIterator[n5];
                this.AfieldCount = new int[n5];
            } else if (n3 >= this.annotList.length) {
                PdfArrayIterator[] pdfArrayIteratorArray = this.annotList;
                int[] nArray = this.AfieldCount;
                this.AfieldCount = new int[n5];
                this.annotList = new PdfArrayIterator[n5];
                for (int i = 0; i < pdfArrayIteratorArray.length; ++i) {
                    this.AfieldCount[i] = nArray[i];
                    this.annotList[i] = pdfArrayIteratorArray[i];
                }
            } else if (this.AfieldCount == null) {
                this.AfieldCount = new int[n5];
            }
            this.annotList[n3] = new PdfArrayIterator(byArray);
            this.AfieldCount[n3] = n4 = this.annotList[n3].getTokenCount();
            this.ATotalCount += n4;
            bl = false;
            if (this.fDecoder == null) {
                this.PDFformType = FormTypes.NON_XFA;
                this.fDecoder = new FormStream();
            }
        }
        this.resetContainers(bl);
    }

    protected void resetContainers(boolean bl) {
        if (bl) {
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, false);
        } else {
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, true);
        }
        if (this.formFactory == null) {
            this.formFactory = this.formCreator.createFormFactory();
            this.formFactory.reset(this.getFormResources(), this.formsActionHandler, this.pageData, this.currentPdfFile);
        } else {
            this.formFactory.reset(this.getFormResources(), this.formsActionHandler, this.pageData, this.currentPdfFile);
        }
    }

    public void createDisplayComponentsForPage(int n, PdfStreamDecoder pdfStreamDecoder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = System.getProperty("org.jpedal.flattenForm");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.compData.setRasterizeForms(true);
        }
        if (!this.compData.hasformsOnPageDecoded(n) || this.formsRasterizedForDisplay() && pdfStreamDecoder != null) {
            FormObject formObject;
            int n2;
            int n3;
            int n4;
            this.compData.initParametersForPage(this.pageData, n, this.formFactory, this.dpi);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            int n5 = 0;
            if (this.AfieldCount != null && this.AfieldCount.length > n) {
                n5 = this.AfieldCount[n];
            }
            this.Fforms = new FormObject[this.FfieldCount];
            FormObject[] formObjectArray = null;
            this.Aforms = new FormObject[n5];
            if (this.hasXFA && this.useXFA) {
                formObjectArray = this.createXFADisplayComponentsForPage(formObjectArray, n);
            } else {
                for (int i = 0; i < 2; ++i) {
                    Object object;
                    int n6 = 0;
                    if (i == 0) {
                        n4 = 0;
                        if (this.fieldList != null) {
                            this.fieldList.resetToStart();
                            n4 = this.fieldList.getTokenCount() - 1;
                        }
                    } else {
                        if (this.annotList != null && this.annotList.length > n && this.annotList[n] != null && !this.isContainXFAStream) {
                            this.annotList[n].resetToStart();
                            if (this.formFactory.getType() == 3) {
                                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                                n3 = this.annotList[n].getTokenCount();
                                for (n2 = 0; n2 < n3; ++n2) {
                                    object = this.annotList[n].getNextValueAsString(true);
                                    hashMap3.put((String)object, String.valueOf(n2 + 1));
                                }
                                this.formFactory.setAnnotOrder(hashMap3);
                            }
                            this.annotList[n].resetToStart();
                        }
                        n4 = n5 - 1;
                    }
                    for (int j = n4; j > -1; --j) {
                        byte[][] byArray;
                        String string2 = null;
                        if (i == 0) {
                            if (this.fieldList != null) {
                                string2 = this.fieldList.getNextValueAsString(true);
                            }
                        } else if ((!this.addedMissingPopup || this.annotList[n].hasMoreTokens()) && this.annotList.length > n && this.annotList[n] != null) {
                            string2 = this.annotList[n].getNextValueAsString(true);
                        }
                        if (string2 == null || string2 != null && (hashMap2.get(string2) != null || string2.isEmpty())) continue;
                        formObject = this.convertRefToFormObject(string2, n);
                        if (i == 0 && formObject != null && formObject.getFormType() == -1) continue;
                        if (formObject.getParameterConstant(1147962727) == 607471684 && formObject.getDictionary(1061176672) == null) {
                            FormObject formObject2 = new FormObject(1044266837);
                            formObject2.setIntNumber(22, 24);
                            formObject2.setBoolean(524301630, formObject.getBoolean(524301630));
                            formObject2.setConstant(1147962727, 1061176672);
                            object = formObject.getFloatArray(573911876);
                            if (this.pageData.getRotation(n) % 180 != 0) {
                                formObject2.setFloatArray(573911876, new float[]{(float)(object[2] - 160.0f), -100.0f, (float)object[2], 0.0f});
                            } else {
                                formObject2.setFloatArray(573911876, new float[]{this.pageData.getCropBoxWidth(n), (float)(object[3] - 100.0f), this.pageData.getCropBoxWidth(n) + 160, (float)object[3]});
                            }
                            formObject2.setStringKey(1110793845, formObject.getObjectRefAsString().getBytes());
                            formObject2.setParentPdfObj(formObject);
                            formObject2.setPageNumber(n);
                            formObject.setDictionary(1061176672, formObject2);
                            FormObject[] formObjectArray2 = new FormObject[this.Aforms.length + 1];
                            for (int k = 0; k != this.Aforms.length; ++k) {
                                formObjectArray2[k] = this.Aforms[k];
                            }
                            formObjectArray2[this.Aforms.length] = formObject2;
                            this.Aforms = formObjectArray2;
                            int n7 = n;
                            this.AfieldCount[n7] = this.AfieldCount[n7] + 1;
                            this.addedMissingPopup = true;
                        }
                        n6 = (byArray = formObject.getKeyArray(456733763)) != null ? this.flattenKids(n, hashMap2, formObject, n6, i) : this.processFormObject(n, hashMap2, formObject, string2, n6, i);
                    }
                }
            }
            ArrayList<FormObject> arrayList = new ArrayList<FormObject>();
            ArrayList<FormObject> arrayList2 = new ArrayList<FormObject>();
            this.compData.setListForPage(n, arrayList, false);
            this.compData.setListForPage(n, arrayList2, true);
            for (n3 = 0; n3 < 3; ++n3) {
                int n8;
                n4 = 0;
                if (n3 == 0) {
                    if (formObjectArray != null) {
                        n4 = formObjectArray.length;
                    }
                } else if (n3 == 1) {
                    if (this.Fforms == null) {
                        n4 = 0;
                    } else {
                        FormObject[] formObjectArray3 = this.Fforms;
                        n2 = formObjectArray3.length;
                        for (n8 = 0; n8 < n2; ++n8) {
                            FormObject formObject2 = formObjectArray3[n8];
                            if (formObject2 == null) continue;
                            arrayList.add(formObject2);
                        }
                        this.Fforms = FormUtils.sortGroupLargestFirst(this.Fforms);
                        n4 = this.Fforms.length;
                    }
                } else {
                    Object object2 = this.Aforms;
                    n2 = ((FormObject[])object2).length;
                    for (n8 = 0; n8 < n2; ++n8) {
                        FormObject formObject3 = object2[n8];
                        if (formObject3 == null) continue;
                        arrayList.add(formObject3);
                    }
                    if (!this.formsRasterizedForDisplay()) {
                        this.Aforms = FormUtils.sortGroupLargestFirst(this.Aforms);
                    }
                    if (this.isContainXFAStream) {
                        int n9;
                        object2 = new HashMap();
                        double d = 0.0;
                        for (FormObject formObject4 : this.Aforms) {
                            ArrayList arrayList3;
                            if (formObject4 == null) continue;
                            n9 = formObject4.getBoundingRectangle().x;
                            Double d2 = formObject4.getBounding2DRectangleForTabbing().getY();
                            d = Math.max(d2, d);
                            if (((HashMap)object2).containsKey(d2)) {
                                arrayList3 = (ArrayList)((HashMap)object2).get(d2);
                                int n10 = -1;
                                for (int i = 0; i < arrayList3.size(); ++i) {
                                    int n11 = ((FormObject)arrayList3.get((int)i)).getBoundingRectangle().x;
                                    if (n11 >= n9) continue;
                                    n10 = i;
                                }
                                if (n10 == -1) {
                                    arrayList3.add(0, formObject4);
                                    continue;
                                }
                                arrayList3.add(n10 + 1, formObject4);
                                continue;
                            }
                            arrayList3 = new ArrayList();
                            arrayList3.add(formObject4);
                            ((HashMap)object2).put(d2, arrayList3);
                        }
                        FormObject[] formObjectArray2 = new FormObject[this.Aforms.length];
                        int n12 = 0;
                        Object[] objectArray = new Object[((HashMap)object2).size()];
                        int n13 = 0;
                        Object[] objectArray2 = ((HashMap)object2).keySet().toArray();
                        int n14 = objectArray2.length;
                        for (int i = 0; i < n14; ++i) {
                            Object object;
                            objectArray[n13] = object = objectArray2[i];
                            ++n13;
                        }
                        Arrays.sort(objectArray);
                        for (n9 = objectArray.length; n9 > 0; --n9) {
                            ArrayList arrayList4 = (ArrayList)((HashMap)object2).get(objectArray[n9 - 1]);
                            if (arrayList4 == null) continue;
                            Iterator iterator = arrayList4.iterator();
                            while (iterator.hasNext()) {
                                FormObject formObject5;
                                formObjectArray2[n12] = formObject5 = (FormObject)iterator.next();
                                ++n12;
                            }
                        }
                        this.Aforms = formObjectArray2;
                    }
                    n4 = this.Aforms.length;
                }
                boolean bl = true;
                for (n2 = 0; n2 < n4; ++n2) {
                    formObject = n3 == 0 ? formObjectArray[n2] : (n3 == 1 ? this.Fforms[n2] : this.Aforms[n2]);
                    if (formObject == null || hashMap.get(formObject.getObjectRefAsString()) != null || n != formObject.getPageNumber()) continue;
                    if (this.formsRasterizedForDisplay() && pdfStreamDecoder != null) {
                        try {
                            int n15 = this.formFactory.getType();
                            this.getFormFlattener().drawFlattenedForm(pdfStreamDecoder, formObject, n15 == 3 || n15 == 4, (PdfObject)this.getFormResources()[0]);
                        }
                        catch (PdfException pdfException) {
                            LogWriter.writeLog("Exception: " + pdfException.getMessage());
                        }
                        continue;
                    }
                    this.createField(formObject);
                    this.compData.storeRawData(formObject);
                    hashMap.put(formObject.getObjectRefAsString(), "x");
                    if (this.formFactory.getType() == 3 || this.formFactory.getType() == 4 || this.formFactory.getType() == 5) {
                        arrayList2.add(formObject);
                        continue;
                    }
                    if (formObject.getParameterConstant(1147962727) == 1061176672) {
                        if (bl) {
                            arrayList2.add(formObject);
                            bl = false;
                            continue;
                        }
                        arrayList2.add(arrayList2.size() - 1, formObject);
                        continue;
                    }
                    arrayList2.add(0, formObject);
                }
            }
            if (!this.formsRasterizedForDisplay()) {
                try {
                    String string3 = this.currentPdfFile.getReferenceforPage(n);
                    PageObject pageObject = new PageObject(string3);
                    this.currentPdfFile.readObject(pageObject);
                    if (this.javascript != null && this.formsActionHandler != null) {
                        this.formsActionHandler.O(pageObject, 4369);
                        this.formsActionHandler.O(pageObject, 17);
                        this.formsActionHandler.PO(pageObject, 4369);
                        this.formsActionHandler.PO(pageObject, 17);
                    }
                    if (this.formFactory.getType() != 3 && this.formFactory.getType() != 4) {
                        this.initJSonFields(hashMap);
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
    }

    private void storeSignatures(FormObject formObject, int n) {
        if (n == 2308407) {
            if (this.sigObject == null) {
                this.sigObject = new HashSet<FormObject>();
                this.sigKeys = new HashMap<String, String>();
            }
            if (!this.sigKeys.containsKey(formObject.getObjectRefAsString())) {
                this.sigObject.add(formObject);
                this.sigKeys.put(formObject.getObjectRefAsString(), "x");
            }
        }
    }

    private int flattenKids(int n, Map<String, String> map, FormObject formObject, int n2, int n3) {
        FormObject[] formObjectArray;
        int n4;
        byte[][] byArray = formObject.getKeyArray(456733763);
        int n5 = byArray.length;
        if (n3 == 0) {
            n4 = this.Fforms.length;
            formObjectArray = this.Fforms;
            this.Fforms = new FormObject[n4 + n5 - 1];
            System.arraycopy(formObjectArray, 0, this.Fforms, 0, n4);
        } else {
            n4 = this.Aforms.length;
            formObjectArray = this.Aforms;
            this.Aforms = new FormObject[n4 + n5 - 1];
            System.arraycopy(formObjectArray, 0, this.Aforms, 0, n4);
        }
        for (byte[] byArray2 : byArray) {
            String string = new String(byArray2);
            FormObject formObject2 = new FormObject(string);
            if (formObject != null) {
                formObject2.copyInheritedValuesFromParent(formObject);
            }
            this.currentPdfFile.readObject(formObject2);
            formObject2.setRef(string);
            if (formObject2.getKeyArray(456733763) == null) {
                if (!formObject2.isAppearanceUsed()) {
                    new FormStream().createAppearanceString(formObject2, this.currentPdfFile);
                }
                n2 = this.processFormObject(n, map, formObject2, string, n2, n3);
                continue;
            }
            n2 = this.flattenKids(n, map, formObject2, n2, n3);
        }
        return n2;
    }

    private int processFormObject(int n, Map<String, String> map, FormObject formObject, String string, int n2, int n3) {
        Object object;
        Object object2;
        boolean bl = false;
        if (n3 == 0) {
            FormObject formObject2;
            Object object3;
            object2 = formObject.getDictionary(32);
            object = null;
            if (object2 != null) {
                object = ((PdfObject)object2).getUnresolvedData();
            }
            if ((object == null || object2 == null) && (object3 = formObject.getStringKey(1110793845)) != null && (object2 = ((PdfObject)(formObject2 = this.getParent((String)object3))).getDictionary(32)) != null) {
                object = ((PdfObject)object2).getUnresolvedData();
            }
            if (object == null) {
                boolean bl2;
                object3 = this.getKid(formObject, false);
                boolean bl3 = bl2 = object3 != null && ((Object)object3).length > 0;
                if (bl2) {
                    int n4 = ((Object)object3).length;
                    for (int i = 0; i < n4; ++i) {
                        String string2 = new String((byte[])object3[i]);
                        FormObject formObject3 = (FormObject)this.compData.getRawFormData().get(string2);
                        if (formObject3 == null) {
                            formObject3 = new FormObject(string2);
                            this.currentPdfFile.readObject(formObject3);
                            this.compData.storeRawData(formObject3);
                        }
                        if ((object2 = formObject3.getDictionary(32)) != null) {
                            object = ((PdfObject)object2).getUnresolvedData();
                        }
                        if (object == null) continue;
                        i = n4;
                    }
                }
            }
            int n5 = -1;
            if (object != null) {
                n5 = this.currentPdfFile.convertObjectToPageNumber(new String((byte[])object));
            }
            boolean bl4 = bl = n5 == n;
        }
        if (n3 == 1 || bl) {
            formObject.setPageNumber(n);
            object2 = formObject.getStringKey(1110793845);
            if (object2 != null && (object = (Object)this.getParent((String)object2)) != null) {
                formObject.setParent((String)object2, (FormObject)object, true);
            }
            if (!formObject.isAppearanceUsed()) {
                this.fDecoder.createAppearanceString(formObject, this.currentPdfFile);
            }
            if (formObject != null && formObject.getParameterConstant(1147962727) != -1) {
                if (object2 != null) {
                    formObject.setParent((String)object2);
                }
                if (n3 == 0) {
                    this.Fforms[n2++] = formObject;
                } else {
                    this.Aforms[n2++] = formObject;
                }
                if (string != null) {
                    map.put(string, "x");
                }
            }
        }
        return n2;
    }

    private FormObject getParent(String string) {
        FormObject formObject = (FormObject)this.compData.getRawFormData().get(string);
        if (formObject == null && string != null) {
            formObject = new FormObject(string);
            this.currentPdfFile.readObject(formObject);
            formObject.setKeyArray(456733763, null);
            this.compData.storeRawData(formObject);
        }
        return formObject;
    }

    private byte[][] getKid(FormObject formObject, boolean bl) {
        String string;
        FormObject formObject2;
        int n = formObject.getParameterConstant(1147962727);
        if (n == 9288 || n == 1197118) {
            return null;
        }
        byte[][] byArray = formObject.getKeyArray(456733763);
        if (byArray != null && !bl && (formObject2 = this.getFormObject(string = formObject.getStringKey(1110793845))) != null && ((PdfObject)formObject2).getKeyArray(456733763) != null) {
            byArray = null;
        }
        return byArray;
    }

    public void displayComponentsOnscreen(int n, int n2) {
        this.compData.displayComponents(n, ++n2);
        DevFlags.formsLoaded = true;
    }

    private void initJSonFields(Map<String, String> map) {
        for (String string : map.keySet()) {
            FormObject formObject = this.getFormObject(string);
            this.javascript.execute(formObject, 27, 6, ' ');
        }
    }

    private void createField(FormObject formObject) {
        Integer n;
        boolean[] blArray;
        if (ExternalHandlers.isULCPresent() && this.formFactory.getType() == 1) {
            return;
        }
        Object var3_2 = null;
        int n2 = formObject.getParameterConstant(1147962727);
        int n3 = this.formFactory.getType();
        this.storeSignatures(formObject, n2);
        if (formObject.getDictionary(1061176672) != null) {
            formObject.setActionFlag(1);
        }
        if ((blArray = formObject.getFieldFlags()) != null) {
            boolean bl = blArray[1];
            boolean bl2 = blArray[2];
            boolean bl3 = blArray[3];
        }
        if (!(ExternalHandlers.isXFAPresent() || n3 != 3 && n3 != 4)) {
            n = FormFactory.ANNOTATION;
        } else if (n2 == 1197118) {
            boolean bl = false;
            boolean bl4 = false;
            if (blArray != null) {
                bl = blArray[17];
                bl4 = blArray[16];
            }
            n = bl ? FormFactory.PUSHBUTTON : (bl4 ? FormFactory.RADIOBUTTON : FormFactory.CHECKBOXBUTTON);
        } else if (n2 == 9288) {
            boolean bl = false;
            boolean bl5 = false;
            if (blArray != null) {
                bl = blArray[13];
                bl5 = blArray[14];
            }
            n = bl ? (bl5 ? FormFactory.MULTILINEPASSWORD : FormFactory.MULTILINETEXT) : (bl5 ? FormFactory.SINGLELINEPASSWORD : FormFactory.SINGLELINETEXT);
        } else if (n2 == 4920) {
            boolean bl = false;
            if (blArray != null) {
                bl = blArray[18];
            }
            n = bl ? FormFactory.COMBOBOX : FormFactory.LIST;
        } else {
            n = n2 == 2308407 ? FormFactory.SIGNATURE : FormFactory.ANNOTATION;
        }
        formObject.setFormType(n);
        if (this.formFactory.getType() == 3 || this.formFactory.getType() == 4) {
            this.compData.checkGUIObjectResolved(formObject);
        } else if (var3_2 != null && this.formFactory.getType() != 1) {
            formObject.setGUIComponent(var3_2, this.formFactory.getType());
            this.compData.setGUIComp(formObject, var3_2);
        }
    }

    public Object[] getFormComponents(String string, ReturnValues returnValues, int n) {
        if (n == -1) {
            for (int i = 1; i < this.pageCount + 1; ++i) {
                this.createDisplayComponentsForPage(i, null);
            }
        } else {
            this.createDisplayComponentsForPage(n, null);
        }
        return this.compData.getFormComponents(string, returnValues, n).toArray();
    }

    public void setFormFactory(FormFactory formFactory) {
        this.formFactory = formFactory;
        this.compData = this.formFactory.getCustomCompData();
    }

    public GUIData getCompData() {
        return this.compData;
    }

    public Iterator<FormObject> getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }

    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    public void setIgnoreForms(boolean bl) {
        this.ignoreForms = bl;
    }

    public boolean ignoreForms() {
        return this.ignoreForms;
    }

    public void dispose() {
        this.AfieldCount = null;
        this.fDecoder = null;
        this.formsActionHandler = null;
        this.javascript = null;
        this.Fforms = null;
        this.Aforms = null;
        this.fieldList = null;
        this.annotList = null;
        this.formFactory = null;
        this.compData.dispose();
        this.compData = null;
        this.sigObject = null;
        this.sigKeys = null;
        this.pageData = null;
        this.currentPdfFile = null;
        this.fDecoder = null;
    }

    public PdfArrayIterator getAnnotsOnPage(int n) {
        this.createDisplayComponentsForPage(n, null);
        if (this.annotList != null && this.annotList.length > n && this.annotList[n] != null) {
            this.annotList[n].resetToStart();
            return this.annotList[n];
        }
        return null;
    }

    public boolean isXFA() {
        return this.hasXFA;
    }

    public boolean useXFA() {
        return this.useXFA;
    }

    public boolean hasFormsOnPage(int n) {
        boolean bl = this.annotList != null && this.annotList.length > n && this.annotList[n] != null;
        boolean bl2 = this.hasXFA && this.useXFA && this.fDecoder.hasXFADataSet() || this.fieldList != null;
        return bl || bl2;
    }

    public Object[] getFormResources() {
        return new Object[]{this.AcroRes, this.CO};
    }

    public boolean formsRasterizedForDisplay() {
        return this.compData.formsRasterizedForDisplay();
    }

    public FormObject getFormObject(String string) {
        FormObject formObject = (FormObject)this.compData.getRawFormData().get(string);
        if (formObject == null && this.formFactory.getType() != 3 && this.formFactory.getType() != 4) {
            for (int i = 1; i < this.pageCount; ++i) {
                this.createDisplayComponentsForPage(i, null);
                formObject = (FormObject)this.compData.getRawFormData().get(string);
                if (formObject != null) break;
            }
        }
        return formObject;
    }

    public void setInsets(int n, int n2) {
        this.compData.setPageData(this.compData.pageData, n, n2);
    }

    FormObject convertRefToFormObject(String string, int n) {
        FormObject formObject = (FormObject)this.compData.getRawFormData().get(string);
        if (formObject == null) {
            formObject = new FormObject(string);
            if (n != -1) {
                formObject.setPageRotation(this.pageData.getRotation(n));
            }
            if (string.charAt(string.length() - 1) == 'R') {
                this.currentPdfFile.readObject(formObject);
            } else {
                formObject.setStatus(1);
                formObject.setUnresolvedData(StringUtils.toBytes(string), -1);
                this.currentPdfFile.checkResolved(formObject);
            }
            this.compData.storeRawData(formObject);
        }
        return formObject;
    }

    public Enum getPDFformType() {
        return this.PDFformType;
    }

    public void alwaysuseXFA(boolean bl) {
        this.alwaysUseXFA = bl;
    }

    public boolean alwaysuseXFA() {
        return this.alwaysUseXFA;
    }

    public void init(SwingFormCreator swingFormCreator) {
        this.formCreator = swingFormCreator;
        this.compData = swingFormCreator.getData();
    }

    public PdfStreamDecoder getStreamDecoder(PdfObjectReader pdfObjectReader, boolean bl, PdfLayerList pdfLayerList, boolean bl2) {
        if (bl2) {
            return new PdfStreamDecoder(pdfObjectReader);
        }
        return new PdfStreamDecoder(pdfObjectReader, bl, pdfLayerList);
    }

    public boolean showFormWarningMessage(int n) {
        boolean bl = false;
        if (this.hasXFA) {
            bl = true;
            System.out.println("[WARNING] This file contains XFA forms that are not supported by this version of JPDF2HTML5. To convert into functional HTML forms and display non-legacy mode page content, JPDF2HTML5 Forms Edition must be used.");
        } else if (this.hasFormsOnPage(n)) {
            bl = true;
            System.out.println("[WARNING] This file contains form components that have been rasterized. To convert into functional HTML forms, JPDF2HTML5 Forms Edition must be used.");
        }
        return bl;
    }

    FormObject[] createXFADisplayComponentsForPage(FormObject[] formObjectArray, int n) {
        throw new UnsupportedOperationException("createXFADisplayComponentsForPage should never be called");
    }

    public HashMap getPageMapXFA() {
        throw new UnsupportedOperationException("getPageMapXFA should never be called");
    }

    public byte[] getXMLContentAsBytes(int n) {
        return null;
    }

    public void outputJavascriptXFA(String string, String string2) {
        throw new UnsupportedOperationException("outputJavascriptXFA should never be called");
    }

    public PrintStreamDecoder getStreamDecoderForPrinting(PdfObjectReader pdfObjectReader, boolean bl, PdfLayerList pdfLayerList) {
        return null;
    }

    public BufferedImage decode(PdfObject pdfObject, PdfObjectReader pdfObjectReader, PdfObject pdfObject2, int n, int n2, int n3, int n4, float f) {
        return null;
    }

    public FormFlattener getFormFlattener() {
        return new FormFlattener();
    }
}

