/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import java.awt.image.BufferedImage;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXComboListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXControlListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXFormButtonListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXFormsListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXListListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXRadioListener;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.acroforms.javafx.JavaFXData;
import org.jpedal.objects.acroforms.javafx.JavaFXDocumentListener;
import org.jpedal.objects.acroforms.javafx.JavaFXImageIcon;
import org.jpedal.objects.acroforms.javafx.PdfJavaFXPopup;
import org.jpedal.objects.acroforms.utils.FormsCSSHelper;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class JavaFXFormFactory
extends GenericFormFactory
implements FormFactory {
    private Button setupAnnotationButton(FormObject formObject) {
        Button button = new Button();
        StringBuilder stringBuilder = new StringBuilder(200);
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)button);
        stringBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;-fx-border-radius:0;-fx-background-radius:0;");
        this.setupButton((ButtonBase)button, formObject, javaFXControlListener);
        this.setupUniversalFeatures((Control)button, formObject, stringBuilder, javaFXControlListener);
        button.setStyle(stringBuilder.toString());
        return button;
    }

    private Button createAnntoationHighlight(FormObject formObject) {
        Button button = this.setupAnnotationButton(formObject);
        Color color = JavaFXFormFactory.getAnnotationColor(formObject);
        float[] fArray = formObject.getFloatArray(1785890247);
        if (fArray == null) {
            fArray = formObject.getFloatArray(573911876);
        }
        Canvas canvas = new Canvas((double)formObject.getBoundingRectangle().width, (double)formObject.getBoundingRectangle().height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        snapshotParameters.setFill((Paint)Color.TRANSPARENT);
        if (fArray.length >= 8) {
            for (int i = 0; i != fArray.length; i += 8) {
                int n = (int)fArray[i] - formObject.getBoundingRectangle().x;
                int n2 = (int)fArray[i + 5] - formObject.getBoundingRectangle().y;
                n2 = formObject.getBoundingRectangle().height - n2 - (int)(fArray[i + 1] - fArray[i + 5]);
                int n3 = (int)(fArray[i + 2] - fArray[i]);
                int n4 = (int)(fArray[i + 1] - fArray[i + 5]);
                try {
                    graphicsContext.setFill((Paint)color);
                    graphicsContext.fillRect((double)n, (double)n2, (double)n3, (double)n4);
                    button.setGraphic((Node)new JavaFXImageIcon((ButtonBase)button, (PdfObject)formObject, (Image)canvas.snapshot(snapshotParameters, null), 0));
                    continue;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return button;
    }

    private Button createAnnotationFreeText(FormObject formObject) {
        Button button = this.setupAnnotationButton(formObject);
        button.setText(formObject.getTextStreamValue(1216184967));
        return button;
    }

    private Button createAnnotationText(FormObject formObject) {
        Button button = this.setupAnnotationButton(formObject);
        String string = formObject.getTextStreamValue(506543413);
        BufferedImage bufferedImage = this.getAnnotationTextIcon(formObject, string);
        float[] fArray = formObject.getFloatArray(573911876);
        fArray[1] = fArray[3] - (float)bufferedImage.getHeight();
        fArray[2] = fArray[0] + (float)bufferedImage.getWidth();
        formObject.setFloatArray(573911876, fArray);
        button.setGraphic((Node)new JavaFXImageIcon((ButtonBase)button, (PdfObject)formObject, bufferedImage, 0));
        return button;
    }

    private Pane createAnnotationPopup(FormObject formObject) {
        Pane pane = (Pane)this.getPopupComponent(formObject, this.pageData.getCropBoxWidth(formObject.getPageNumber()));
        formObject.setGUIComponent(pane, 5);
        pane.setVisible(formObject.getBoolean(524301630));
        return pane;
    }

    private Button createAnnotationUnderline(FormObject formObject) {
        Button button = this.setupAnnotationButton(formObject);
        Color color = JavaFXFormFactory.getAnnotationColor(formObject);
        float[] fArray = formObject.getFloatArray(1785890247);
        if (fArray == null) {
            fArray = formObject.getFloatArray(573911876);
        }
        Canvas canvas = new Canvas((double)formObject.getBoundingRectangle().width, (double)formObject.getBoundingRectangle().height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        snapshotParameters.setFill((Paint)Color.TRANSPARENT);
        if (fArray.length >= 8) {
            for (int i = 0; i != fArray.length; i += 8) {
                int n = (int)fArray[i] - formObject.getBoundingRectangle().x;
                int n2 = (int)fArray[i + 5] - formObject.getBoundingRectangle().y;
                n2 = formObject.getBoundingRectangle().height - n2 - (int)(fArray[i + 1] - fArray[i + 5]);
                int n3 = (int)(fArray[i + 2] - fArray[i]);
                int n4 = (int)(fArray[i + 1] - fArray[i + 5]);
                try {
                    graphicsContext.setFill((Paint)new Color(0.0, 0.0, 0.0, 0.0));
                    graphicsContext.fillRect((double)n, (double)n2, (double)n3, (double)n4);
                    graphicsContext.setFill((Paint)color);
                    graphicsContext.fillRect((double)n, (double)(n2 + n4 - 1), (double)n3, 1.0);
                    button.setGraphic((Node)new JavaFXImageIcon((ButtonBase)button, (PdfObject)formObject, (Image)canvas.snapshot(snapshotParameters, null), 0));
                    continue;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return button;
    }

    private Button createAnnotationInk(FormObject formObject) {
        Button button = this.setupAnnotationButton(formObject);
        button.setTooltip(new Tooltip(formObject.getTextStreamValue(1216184967)));
        Object[] objectArray = formObject.getObjectArray(475169151);
        float[] fArray = JavaFXFormFactory.scanInkListTree(objectArray, formObject, null);
        formObject.setFloatArray(573911876, new float[]{fArray[0], fArray[1], fArray[2], fArray[3]});
        Canvas canvas = new Canvas((double)formObject.getBoundingRectangle().width, (double)formObject.getBoundingRectangle().height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        snapshotParameters.setFill((Paint)Color.TRANSPARENT);
        JavaFXFormFactory.scanInkListTree(objectArray, formObject, graphicsContext);
        button.setGraphic((Node)new JavaFXImageIcon((ButtonBase)button, (PdfObject)formObject, (Image)canvas.snapshot(snapshotParameters, null), 0));
        return button;
    }

    private Button createAnnotationStrikeOut(FormObject formObject) {
        Button button = this.setupAnnotationButton(formObject);
        Color color = JavaFXFormFactory.getAnnotationColor(formObject);
        float[] fArray = formObject.getFloatArray(1785890247);
        if (fArray == null) {
            fArray = formObject.getFloatArray(573911876);
        }
        Canvas canvas = new Canvas((double)formObject.getBoundingRectangle().width, (double)formObject.getBoundingRectangle().height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        SnapshotParameters snapshotParameters = new SnapshotParameters();
        snapshotParameters.setFill((Paint)Color.TRANSPARENT);
        if (fArray.length >= 8) {
            for (int i = 0; i != fArray.length; i += 8) {
                int n = (int)fArray[i] - formObject.getBoundingRectangle().x;
                int n2 = (int)fArray[i + 5] - formObject.getBoundingRectangle().y;
                n2 = formObject.getBoundingRectangle().height - n2 - (int)(fArray[i + 1] - fArray[i + 5]);
                int n3 = (int)(fArray[i + 2] - fArray[i]);
                int n4 = (int)(fArray[i + 1] - fArray[i + 5]);
                try {
                    graphicsContext.setFill((Paint)Color.TRANSPARENT);
                    graphicsContext.fillRect(0.0, 0.0, (double)n3, (double)n4);
                    graphicsContext.setFill((Paint)color);
                    graphicsContext.fillRect((double)n, (double)(n2 + n4 / 2), (double)n3, 1.0);
                    button.setGraphic((Node)new JavaFXImageIcon((ButtonBase)button, (PdfObject)formObject, (Image)canvas.snapshot(snapshotParameters, null), 0));
                    continue;
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return button;
    }

    private static Color getAnnotationColor(FormObject formObject) {
        float[] fArray = formObject.getFloatArray(19);
        Color color = Color.TRANSPARENT;
        if (fArray != null) {
            switch (fArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    color = new Color((double)fArray[0], (double)fArray[0], (double)fArray[0], 1.0);
                    break;
                }
                case 3: {
                    color = new Color((double)fArray[0], (double)fArray[1], (double)fArray[2], 1.0);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace deviceCMYKColorSpace = new DeviceCMYKColorSpace();
                    deviceCMYKColorSpace.setColor(fArray, 4);
                    int n = deviceCMYKColorSpace.getColor().getRGB();
                    int n2 = n >> 16 & 0xFF;
                    int n3 = n >> 8 & 0xFF;
                    int n4 = n & 0xFF;
                    color = new Color((double)n2, (double)n3, (double)n4, 1.0);
                    break;
                }
            }
        }
        return color;
    }

    private BufferedImage getAnnotationTextIcon(FormObject formObject, String string) {
        BufferedImage bufferedImage = null;
        if (string == null) {
            string = "Note";
        }
        try {
            bufferedImage = string.equals("Comment") ? ImageIO.read(this.getClass().getResource("/org/jpedal/objects/acroforms/res/comment.png")) : ImageIO.read(this.getClass().getResource("/org/jpedal/objects/acroforms/res/note.png"));
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        float[] fArray = formObject.getFloatArray(19);
        if (fArray != null) {
            PdfColor pdfColor = new PdfColor(fArray[0], fArray[1], fArray[2]);
            int n = pdfColor.getRGB();
            for (int i = 0; i != bufferedImage.getWidth(); ++i) {
                for (int j = 0; j != bufferedImage.getHeight(); ++j) {
                    if (bufferedImage.getRGB(i, j) != -256) continue;
                    bufferedImage.setRGB(i, j, n);
                }
            }
        }
        return bufferedImage;
    }

    @Override
    public Object annotationButton(FormObject formObject) {
        int n = formObject.getParameterConstant(1147962727);
        if (n == 1061176672) {
            return this.createAnnotationPopup(formObject);
        }
        if (!formObject.isAppearanceUsed()) {
            switch (n) {
                case 607471684: {
                    return this.createAnnotationText(formObject);
                }
                case 980909433: {
                    return this.createAnnotationFreeText(formObject);
                }
                case 1919840408: {
                    return this.createAnntoationHighlight(formObject);
                }
                case 2053993372: {
                    return this.createAnnotationUnderline(formObject);
                }
                case 1654331: {
                    return this.createAnnotationInk(formObject);
                }
                case 2036432546: {
                    return this.createAnnotationStrikeOut(formObject);
                }
            }
        }
        return this.setupAnnotationButton(formObject);
    }

    static float[] curveInk(float[] fArray) {
        int n = 0;
        float[] fArray2 = new float[(fArray.length - 2) / 2 * 8];
        for (int i = 0; i < fArray.length; i += 2) {
            double[] dArray;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            if (i == 0) {
                d8 = fArray[i];
                d7 = fArray[i + 1];
                d6 = fArray[i];
                d5 = fArray[i + 1];
                d4 = fArray[i + 2];
                d3 = fArray[i + 3];
                d2 = fArray[i + 4];
                d = fArray[i + 5];
                dArray = JavaFXFormFactory.findControlPoint(d8, d7, d6, d5, d4, d3, d2, d, 1.0);
                fArray2[n] = (float)d6;
                fArray2[++n] = (float)d5;
                fArray2[++n] = (float)dArray[0];
                fArray2[++n] = (float)dArray[1];
                fArray2[++n] = (float)dArray[2];
                fArray2[++n] = (float)dArray[3];
                fArray2[++n] = (float)d4;
                fArray2[++n] = (float)d3;
                ++n;
            }
            if (i + 6 >= fArray.length) {
                d8 = fArray[i];
                d7 = fArray[i + 1];
                d6 = fArray[i + 2];
                d5 = fArray[i + 3];
                d4 = fArray[i + 4];
                d3 = fArray[i + 5];
                d2 = fArray[i + 4];
                d = fArray[i + 5];
                dArray = JavaFXFormFactory.findControlPoint(d8, d7, d6, d5, d4, d3, d2, d, 1.0);
                fArray2[n] = (float)d6;
                fArray2[++n] = (float)d5;
                fArray2[++n] = (float)dArray[0];
                fArray2[++n] = (float)dArray[1];
                fArray2[++n] = (float)dArray[2];
                fArray2[++n] = (float)dArray[3];
                fArray2[++n] = (float)d4;
                fArray2[++n] = (float)d3;
                break;
            }
            d8 = fArray[i];
            d7 = fArray[i + 1];
            d6 = fArray[i + 2];
            d5 = fArray[i + 3];
            d4 = fArray[i + 4];
            d3 = fArray[i + 5];
            d2 = fArray[i + 6];
            d = fArray[i + 7];
            dArray = JavaFXFormFactory.findControlPoint(d8, d7, d6, d5, d4, d3, d2, d, 1.0);
            fArray2[n] = (float)d6;
            fArray2[++n] = (float)d5;
            fArray2[++n] = (float)dArray[0];
            fArray2[++n] = (float)dArray[1];
            fArray2[++n] = (float)dArray[2];
            fArray2[++n] = (float)dArray[3];
            fArray2[++n] = (float)d4;
            fArray2[++n] = (float)d3;
            ++n;
        }
        return fArray2;
    }

    private static double[] findControlPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = (d + d3) / 2.0;
        double d11 = (d2 + d4) / 2.0;
        double d12 = (d3 + d5) / 2.0;
        double d13 = (d4 + d6) / 2.0;
        double d14 = (d5 + d7) / 2.0;
        double d15 = (d6 + d8) / 2.0;
        double d16 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        double d17 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
        double d18 = Math.sqrt((d7 - d5) * (d7 - d5) + (d8 - d6) * (d8 - d6));
        double d19 = d16 / (d16 + d17);
        double d20 = d17 / (d17 + d18);
        double d21 = d10 + (d12 - d10) * d19;
        double d22 = d11 + (d13 - d11) * d19;
        double d23 = d12 + (d14 - d12) * d20;
        double d24 = d13 + (d15 - d13) * d20;
        double d25 = d21 + (d12 - d21) * d9 + d3 - d21;
        double d26 = d22 + (d13 - d22) * d9 + d4 - d22;
        double d27 = d23 + (d12 - d23) * d9 + d5 - d23;
        double d28 = d24 + (d13 - d24) * d9 + d6 - d24;
        return new double[]{d25, d26, d27, d28};
    }

    private static float[] scanInkListTree(Object[] objectArray, FormObject formObject, GraphicsContext graphicsContext) {
        float f;
        int n;
        float f2 = 0.0f;
        Object object = 0.0f;
        float f3 = 0.0f;
        Object object2 = 0.0f;
        float[] fArray = null;
        if (objectArray != null) {
            Object object3;
            Object object4;
            int n2 = objectArray.length;
            n = 1;
            if (graphicsContext != null) {
                float[] fArray2 = formObject.getFloatArray(19);
                object4 = Color.TRANSPARENT;
                if (fArray2 != null) {
                    switch (fArray2.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            object4 = new Color((double)fArray2[0], (double)fArray2[0], (double)fArray2[0], 1.0);
                            break;
                        }
                        case 3: {
                            object4 = new Color((double)fArray2[0], (double)fArray2[1], (double)fArray2[2], 1.0);
                            break;
                        }
                        case 4: {
                            object3 = new DeviceCMYKColorSpace();
                            ((DeviceCMYKColorSpace)object3).setColor(fArray2, 4);
                            int n3 = ((GenericColorSpace)object3).getColor().getRGB();
                            int n4 = n3 >> 16 & 0xFF;
                            int n5 = n3 >> 8 & 0xFF;
                            int n6 = n3 & 0xFF;
                            object4 = new Color((double)n4, (double)n5, (double)n6, 1.0);
                            break;
                        }
                    }
                }
                graphicsContext.setFill((Paint)Color.TRANSPARENT);
                graphicsContext.fillRect(0.0, 0.0, (double)formObject.getBoundingRectangle().width, (double)formObject.getBoundingRectangle().height);
                graphicsContext.setStroke((Paint)object4);
            }
            for (int i = 0; i < n2; ++i) {
                if (objectArray[i] instanceof byte[]) {
                    object4 = (byte[])objectArray[i];
                    if (fArray == null) {
                        fArray = new float[n2];
                    }
                    if (object4 == null) continue;
                    object3 = new String((byte[])object4);
                    float f4 = Float.parseFloat((String)object3);
                    switch (i % 2) {
                        case 0: {
                            float f5;
                            if (n != 0) {
                                f2 = f4;
                                f3 = f4;
                            } else {
                                if (f4 < f2) {
                                    f2 = f4;
                                }
                                if (f4 > f3) {
                                    f3 = f4;
                                }
                            }
                            fArray[i] = f5 = f4 - (float)formObject.getBoundingRectangle().x;
                            break;
                        }
                        case 1: {
                            if (n != 0) {
                                object = f4;
                                object2 = f4;
                                n = 0;
                            } else {
                                if (f4 < object) {
                                    object = f4;
                                }
                                if (f4 > object2) {
                                    object2 = f4;
                                }
                            }
                            fArray[i] = f = (float)formObject.getBoundingRectangle().height - (f4 - (float)formObject.getBoundingRectangle().y);
                        }
                    }
                    continue;
                }
                object4 = JavaFXFormFactory.scanInkListTree((Object[])objectArray[i], formObject, graphicsContext);
                if (n != 0) {
                    f2 = (float)object4[0];
                    f3 = (float)object4[2];
                    object = object4[1];
                    object2 = object4[3];
                    continue;
                }
                if (object4[0] < f2) {
                    f2 = (float)object4[0];
                }
                if (object4[2] > f3) {
                    f3 = (float)object4[2];
                }
                if (object4[1] < object) {
                    object = object4[1];
                }
                if (!(object4[3] > object2)) continue;
                object2 = object4[3];
            }
        }
        if (fArray != null) {
            float[] fArray3 = JavaFXFormFactory.curveInk(fArray);
            for (int i = 0; i < fArray3.length; ++i) {
                if (i % 2 == 0) {
                    if (fArray3[i] < f2) {
                        f2 = fArray3[i];
                    }
                    if (!(fArray3[i] > f3)) continue;
                    f3 = fArray3[i];
                    continue;
                }
                if (fArray3[i] < object) {
                    object = fArray3[i];
                }
                if (!(fArray3[i] > object2)) continue;
                object2 = fArray3[i];
            }
            float f6 = 0.0f;
            f = 0.0f;
            if (f2 < 0.0f) {
                f6 = Math.abs(f2);
            }
            if (object < 0.0f) {
                f = Math.abs(object);
            }
            f2 += f6;
            f3 += f6;
            object += f;
            object2 += f;
            if (graphicsContext != null) {
                graphicsContext.setLineWidth((double)1.52f);
                graphicsContext.setLineCap(StrokeLineCap.ROUND);
                graphicsContext.setLineJoin(StrokeLineJoin.ROUND);
                for (n = 0; n < fArray3.length; n += 8) {
                    graphicsContext.beginPath();
                    graphicsContext.moveTo((double)(fArray3[n] + f6), (double)(fArray3[n + 1] + f));
                    graphicsContext.bezierCurveTo((double)(fArray3[n + 2] + f6), (double)(fArray3[n + 3] + f), (double)(fArray3[n + 4] + f6), (double)(fArray3[n + 5] + f), (double)(fArray3[n + 6] + f6), (double)(fArray3[n + 7] + f));
                    graphicsContext.fill();
                    graphicsContext.stroke();
                    graphicsContext.closePath();
                }
            }
        }
        return new float[]{f2, object, f3, object2};
    }

    @Override
    public Object comboBox(FormObject formObject) {
        ObservableList observableList = formObject.getItemsList() == null ? null : FXCollections.observableArrayList((Object[])formObject.getItemsList());
        StringBuilder stringBuilder = new StringBuilder(200);
        final ComboBox comboBox = observableList == null ? new ComboBox() : new ComboBox(observableList);
        boolean bl = false;
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)comboBox);
        boolean[] blArray = formObject.getFieldFlags();
        comboBox.setEditable(true);
        if (!blArray[19]) {
            comboBox.getEditor().setEditable(false);
            comboBox.getEditor().setCursor(Cursor.DEFAULT);
            bl = true;
        }
        if (blArray[1]) {
            comboBox.setDisable(true);
            comboBox.getEditor().setEditable(false);
            comboBox.getEditor().setCursor(Cursor.DEFAULT);
            bl = true;
        }
        String string = formObject.getSelectedItem();
        if (formObject.getValuesMap(true) != null) {
            comboBox.getSelectionModel().select((Object)string);
        } else {
            comboBox.getSelectionModel().select((Object)string);
        }
        int n = comboBox.getSelectionModel().getSelectedIndex();
        Object object = comboBox.getSelectionModel().getSelectedItem();
        formObject.setSelection(new Object[]{object}, object != null ? object.toString() : null, new int[]{n}, n);
        this.setupUniversalFeatures((Control)comboBox, formObject, stringBuilder, javaFXControlListener);
        JavaFXFormFactory.setBorder(formObject, stringBuilder);
        this.addFont(formObject, false, false, stringBuilder);
        comboBox.getStyleClass().add((Object)"formsComboBox");
        comboBox.setStyle(stringBuilder.toString());
        final boolean bl2 = bl;
        comboBox.getEditor().setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){
            boolean toggle;

            public void handle(MouseEvent mouseEvent) {
                if (bl2) {
                    if (this.toggle) {
                        comboBox.hide();
                    } else {
                        comboBox.show();
                    }
                    this.toggle = !this.toggle;
                }
            }
        });
        int[] nArray = FormsCSSHelper.getTextColor(formObject);
        if (nArray != null) {
            final String string2 = String.format("-fx-text-fill:rgb(%d, %d, %d);", nArray[0], nArray[1], nArray[2]);
            comboBox.getEditor().setStyle(string2);
            comboBox.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> listView) {
                    return new ListCell<String>(){

                        public void updateItem(String string, boolean bl) {
                            super.updateItem((Object)string, bl);
                            this.setStyle(string2);
                            this.setText(string);
                        }
                    };
                }
            });
        }
        comboBox.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new JavaFXComboListener(comboBox, formObject));
        return comboBox;
    }

    @Override
    public Object checkBoxBut(FormObject formObject) {
        ToggleButton toggleButton = new ToggleButton();
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)toggleButton);
        StringBuilder stringBuilder = new StringBuilder(200);
        toggleButton.setUserData((Object)CHECKBOXBUTTON);
        this.setupUniversalFeatures((Control)toggleButton, formObject, stringBuilder, javaFXControlListener);
        this.setupButton((ButtonBase)toggleButton, formObject, javaFXControlListener);
        this.setupToggleGroup(formObject, toggleButton);
        this.addFont(formObject, false, false, stringBuilder);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            toggleButton.setDisable(true);
        }
        stringBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;");
        toggleButton.setStyle(stringBuilder.toString());
        return toggleButton;
    }

    @Override
    public Object listField(FormObject formObject) {
        ObservableList observableList = FXCollections.observableArrayList((Object[])formObject.getItemsList());
        ListView listView = observableList == null ? new ListView() : new ListView(observableList);
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)listView);
        StringBuilder stringBuilder = new StringBuilder(200);
        if (!formObject.getFieldFlags()[22]) {
            listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        }
        if (formObject.getSelectionIndices() != null) {
            listView.getSelectionModel().selectFirst();
        } else if (formObject.getValuesMap(true) != null) {
            listView.getSelectionModel().select(formObject.getValuesMap(true).get(formObject.getSelectedItem()));
        } else {
            listView.getSelectionModel().select((Object)formObject.getSelectedItem());
        }
        int n = listView.getSelectionModel().getSelectedIndex();
        formObject.setSelection(new Object[]{listView.getSelectionModel().getSelectedItem()}, listView.getSelectionModel().getSelectedItem().toString(), new int[]{n}, n);
        this.setupUniversalFeatures((Control)listView, formObject, stringBuilder, javaFXControlListener);
        JavaFXFormFactory.setBorder(formObject, stringBuilder);
        this.addFont(formObject, true, true, stringBuilder);
        listView.getStyleClass().add((Object)"formsListBox");
        listView.setStyle(stringBuilder.toString());
        listView.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new JavaFXListListener(listView, formObject));
        return listView;
    }

    @Override
    public Object multiLinePassword(FormObject formObject) {
        boolean[] blArray;
        final PasswordField passwordField = new PasswordField();
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)passwordField);
        String string = formObject.getTextString();
        StringBuilder stringBuilder = new StringBuilder(200);
        final int n = formObject.getInt(1209815663);
        if (n != -1) {
            passwordField.setText(string);
            passwordField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                    if (string2.length() >= n) {
                        passwordField.setText(string);
                    }
                }
            });
        }
        if ((blArray = formObject.getFieldFlags()) != null && blArray[1]) {
            passwordField.setEditable(false);
        }
        this.setupUniversalFeatures((Control)passwordField, formObject, stringBuilder, javaFXControlListener);
        JavaFXFormFactory.setBorder(formObject, stringBuilder);
        this.addFont(formObject, true, true, stringBuilder);
        JavaFXFormFactory.setupTextFeatures((TextField)passwordField, formObject);
        JavaFXFormFactory.setToolTip(formObject, (Control)passwordField);
        passwordField.getStyleClass().add((Object)"formsMultiLine");
        passwordField.setStyle(stringBuilder.toString());
        return passwordField;
    }

    @Override
    public Object multiLineText(FormObject formObject) {
        boolean[] blArray = formObject.getFieldFlags();
        boolean[] blArray2 = formObject.getCharacteristics();
        TextArea textArea = new TextArea(formObject.getTextString());
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)textArea);
        StringBuilder stringBuilder = new StringBuilder(200);
        if (blArray != null && blArray[1] || blArray2 != null && blArray2[9]) {
            if (formObject.isXFAObject()) {
                JavaFXFormFactory.setToolTip(formObject, (Control)textArea);
                textArea.setEditable(false);
            } else {
                JavaFXFormFactory.setToolTip(formObject, (Control)textArea);
                textArea.setEditable(false);
            }
        } else {
            JavaFXFormFactory.setToolTip(formObject, (Control)textArea);
        }
        textArea.setWrapText(true);
        this.setupUniversalFeatures((Control)textArea, formObject, stringBuilder, javaFXControlListener);
        JavaFXFormFactory.setBorder(formObject, stringBuilder);
        this.addFont(formObject, true, true, stringBuilder);
        textArea.getStyleClass().add((Object)"formsMultiLine");
        textArea.setStyle(stringBuilder.toString());
        return textArea;
    }

    @Override
    public Object signature(FormObject formObject) {
        StringBuilder stringBuilder = new StringBuilder(200);
        Button button = new Button();
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)button);
        String string = !formObject.isAppearanceUsed() ? "rgb(221, 228, 255,0.7)" : "transparent";
        this.setupUniversalFeatures((Control)button, formObject, stringBuilder, javaFXControlListener);
        this.setupButton((ButtonBase)button, formObject, javaFXControlListener);
        stringBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:").append(string).append(';');
        button.setStyle(stringBuilder.toString());
        return button;
    }

    @Override
    public Object pushBut(FormObject formObject) {
        Button button = new Button();
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)button);
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            button.setDisable(true);
        }
        this.setupUniversalFeatures((Control)button, formObject, stringBuilder, javaFXControlListener);
        this.setupButton((ButtonBase)button, formObject, javaFXControlListener);
        this.addFont(formObject, false, false, stringBuilder);
        stringBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;");
        button.setStyle(stringBuilder.toString());
        return button;
    }

    @Override
    public Object radioBut(FormObject formObject) {
        ToggleButton toggleButton = new ToggleButton();
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)toggleButton);
        StringBuilder stringBuilder = new StringBuilder(200);
        toggleButton.setUserData((Object)RADIOBUTTON);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            toggleButton.setDisable(true);
        }
        this.setupUniversalFeatures((Control)toggleButton, formObject, stringBuilder, javaFXControlListener);
        this.setupButton((ButtonBase)toggleButton, formObject, javaFXControlListener);
        this.setupToggleGroup(formObject, toggleButton);
        this.addFont(formObject, false, false, stringBuilder);
        stringBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;");
        toggleButton.selectedProperty().addListener((ChangeListener)new JavaFXRadioListener(toggleButton, formObject));
        toggleButton.setStyle(stringBuilder.toString());
        return toggleButton;
    }

    @Override
    public Object singleLinePassword(FormObject formObject) {
        boolean[] blArray;
        final PasswordField passwordField = new PasswordField();
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)passwordField);
        StringBuilder stringBuilder = new StringBuilder(200);
        final int n = formObject.getInt(1209815663);
        if (n != -1) {
            passwordField.getLength();
            passwordField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                    if (string2.length() >= n) {
                        passwordField.setText(string);
                    }
                }
            });
        }
        if ((blArray = formObject.getFieldFlags()) != null && blArray[1]) {
            passwordField.setEditable(false);
        }
        this.setupUniversalFeatures((Control)passwordField, formObject, stringBuilder, javaFXControlListener);
        this.addFont(formObject, false, false, stringBuilder);
        JavaFXFormFactory.setBorder(formObject, stringBuilder);
        JavaFXFormFactory.setToolTip(formObject, (Control)passwordField);
        passwordField.getStyleClass().add((Object)"formsSingleline");
        passwordField.setStyle(stringBuilder.toString());
        return passwordField;
    }

    @Override
    public Object singleLineText(FormObject formObject) {
        boolean[] blArray = formObject.getFieldFlags();
        boolean[] blArray2 = formObject.getCharacteristics();
        TextField textField = new TextField();
        JavaFXControlListener javaFXControlListener = new JavaFXControlListener((Control)textField);
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = this.readAPimagesForText(formObject);
        if (string != null && string.contains("&#")) {
            string = Strip.stripXML(string, true).toString();
        }
        if (string != null && !string.equals(formObject.getTextStreamValue(38))) {
            formObject.setTextStreamValue(38, string);
        }
        textField.setText(formObject.getTextString());
        if (blArray != null && blArray[1] || blArray2 != null && blArray2[9]) {
            textField.setEditable(false);
        }
        this.setupUniversalFeatures((Control)textField, formObject, stringBuilder, javaFXControlListener);
        JavaFXFormFactory.setupTextFeatures(textField, formObject);
        JavaFXFormFactory.setToolTip(formObject, (Control)textField);
        JavaFXFormFactory.setBorder(formObject, stringBuilder);
        this.addFont(formObject, false, false, stringBuilder);
        textField.getStyleClass().add((Object)"formsSingleline");
        textField.setStyle(stringBuilder.toString());
        return textField;
    }

    private static void setupTextFeatures(TextField textField, FormObject formObject) {
        if (formObject.getAlignment() != -1) {
            switch (formObject.getAlignment()) {
                case 0: {
                    textField.setAlignment(Pos.CENTER);
                    break;
                }
                case 2: {
                    textField.setAlignment(Pos.CENTER_LEFT);
                    break;
                }
                case 4: {
                    textField.setAlignment(Pos.CENTER_RIGHT);
                    break;
                }
            }
        }
        textField.setOnAction((EventHandler)new JavaFXDocumentListener(textField, formObject));
    }

    private void setupButton(ButtonBase buttonBase, FormObject formObject, JavaFXControlListener javaFXControlListener) {
        int n;
        String string = formObject.getDictionary(7451).getTextStreamValue(4881);
        buttonBase.setText(string);
        String string2 = formObject.getDictionary(7451).getTextStreamValue(4371);
        String string3 = formObject.getDictionary(7451).getTextStreamValue(8723);
        if (!formObject.isAppearanceUsed() && (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty())) {
            javaFXControlListener.addMouseListener(new JavaFXFormButtonListener(string, string3, string2));
        }
        if (formObject.isAppearanceUsed()) {
            this.setAPImages(formObject, buttonBase, javaFXControlListener);
        }
        if ((n = formObject.getTextPosition()) != -1) {
            switch (n) {
                case 0: {
                    buttonBase.setGraphic(null);
                    buttonBase.setText(string);
                    break;
                }
                case 1: {
                    buttonBase.setText(null);
                    break;
                }
                case 2: {
                    buttonBase.setContentDisplay(ContentDisplay.TOP);
                    break;
                }
                case 3: {
                    buttonBase.setContentDisplay(ContentDisplay.BOTTOM);
                    break;
                }
                case 4: {
                    buttonBase.setContentDisplay(ContentDisplay.LEFT);
                    break;
                }
                case 5: {
                    buttonBase.setContentDisplay(ContentDisplay.RIGHT);
                    break;
                }
                case 6: {
                    buttonBase.setText(null);
                }
            }
        }
        javaFXControlListener.addMouseListener((EventHandler<MouseEvent>)((EventHandler)this.formsActionHandler.setHoverCursor()));
    }

    private void setupToggleGroup(FormObject formObject, ToggleButton toggleButton) {
        ToggleGroup toggleGroup;
        String string = formObject.getTextStreamValue(36);
        if (string == null) {
            string = "";
        }
        if ((toggleGroup = (ToggleGroup)this.groups.get(string)) == null) {
            toggleGroup = new ToggleGroup();
            this.groups.put(string, toggleGroup);
            this.firstButtons.put(string, toggleButton);
            final ToggleGroup toggleGroup2 = toggleGroup;
            toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observableValue, Toggle toggle, Toggle toggle2) {
                    int n = toggleGroup2.getToggles().indexOf((Object)toggle2);
                    int n2 = toggleGroup2.getToggles().indexOf((Object)toggle);
                    if (n2 > -1 && n == -1 && toggle.getUserData().equals(FormFactory.RADIOBUTTON)) {
                        toggle.setSelected(true);
                    }
                }
            });
        } else {
            ToggleButton toggleButton2 = (ToggleButton)this.firstButtons.get(string);
            if (toggleButton2 != null) {
                this.firstButtons.remove(string);
                toggleGroup.getToggles().add((Object)toggleButton2);
            }
            toggleGroup.getToggles().add((Object)toggleButton);
        }
    }

    private void setAPImages(FormObject formObject, ButtonBase buttonBase, JavaFXControlListener javaFXControlListener) {
        PdfObject pdfObject;
        Map map;
        JavaFXImageIcon javaFXImageIcon = null;
        JavaFXImageIcon javaFXImageIcon2 = null;
        JavaFXImageIcon javaFXImageIcon3 = null;
        JavaFXImageIcon javaFXImageIcon4 = null;
        JavaFXImageIcon javaFXImageIcon5 = null;
        PdfObject pdfObject2 = formObject.getDictionary(4384).getDictionary(30);
        PdfObject pdfObject3 = formObject.getDictionary(4384).getDictionary(20);
        PdfObject pdfObject4 = formObject.getDictionary(4384).getDictionary(34);
        PdfObject pdfObject5 = null;
        PdfObject pdfObject6 = null;
        PdfObject pdfObject7 = null;
        PdfObject pdfObject8 = null;
        PdfObject pdfObject9 = null;
        PdfObject pdfObject10 = null;
        int n = 0;
        int n2 = formObject.getParameterConstant(1147962727);
        if (pdfObject2 != null || formObject.getDictionary(7451).getDictionary(25) != null) {
            if (pdfObject2.getDictionary(2045494) != null) {
                pdfObject5 = pdfObject2.getDictionary(2045494);
            } else if (formObject.getDictionary(7451).getDictionary(25) != null && formObject.getDictionary(7451).getDictionary(6422) == null) {
                pdfObject5 = formObject.getDictionary(7451).getDictionary(25);
            } else if (pdfObject2.getDecodedStream() != null) {
                pdfObject5 = pdfObject2;
            }
            if (pdfObject5 != null) {
                buttonBase.setText(null);
                javaFXImageIcon = new JavaFXImageIcon(buttonBase, formObject, pdfObject5, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0);
            }
            if (pdfObject2.getDictionary(7998) != null) {
                pdfObject6 = pdfObject2.getDictionary(7998);
                formObject.setNormalOnState("On");
            } else {
                map = pdfObject2.getOtherDictionaries();
                if (map != null && !map.isEmpty()) {
                    for (String string : map.keySet()) {
                        pdfObject6 = pdfObject = (PdfObject)map.get(string);
                        formObject.setNormalOnState(string);
                    }
                }
            }
            if (pdfObject6 != null) {
                buttonBase.setText(null);
                javaFXImageIcon2 = new JavaFXImageIcon(buttonBase, formObject, pdfObject6, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0);
                if (javaFXImageIcon == null) {
                    javaFXImageIcon = new JavaFXImageIcon(buttonBase, (PdfObject)formObject, (Image)null, formObject.getDictionary(7451).getInt(34));
                }
            }
        }
        if (!formObject.hasNoDownIcon()) {
            if (formObject.hasOffsetDownIcon()) {
                n = 1;
            } else if (formObject.hasInvertDownIcon()) {
                n = 2;
            }
            if (n != 0) {
                if (pdfObject5 != null) {
                    if (pdfObject6 != null) {
                        pdfObject7 = pdfObject5;
                        pdfObject8 = pdfObject6;
                    } else {
                        pdfObject7 = pdfObject5;
                    }
                } else if (pdfObject6 != null) {
                    pdfObject7 = pdfObject6;
                }
            }
            if (pdfObject3 != null) {
                if (pdfObject3.getDecodedStream() != null) {
                    pdfObject7 = pdfObject3;
                } else if (pdfObject3.getDictionary(2045494) != null) {
                    pdfObject7 = pdfObject3.getDictionary(2045494);
                }
                if (pdfObject3.getDictionary(7998) != null) {
                    pdfObject8 = pdfObject3.getDictionary(7998);
                } else {
                    map = pdfObject3.getOtherDictionaries();
                    if (map != null && !map.isEmpty()) {
                        for (String string : map.keySet()) {
                            pdfObject8 = pdfObject = (PdfObject)map.get(string);
                        }
                    }
                }
            }
            if (pdfObject7 == null || pdfObject8 == null) {
                if (pdfObject7 != null) {
                    javaFXImageIcon5 = new JavaFXImageIcon(buttonBase, formObject, pdfObject7, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, n);
                } else if (pdfObject8 != null) {
                    javaFXImageIcon5 = new JavaFXImageIcon(buttonBase, formObject, pdfObject8, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, n);
                }
            } else {
                javaFXImageIcon5 = new JavaFXImageIcon(buttonBase, formObject, pdfObject8, pdfObject7, formObject.getDictionary(7451).getInt(34), buttonBase.isPressed() ? 1 : 0, this.currentPdfFile, n2, n);
            }
        }
        if (pdfObject4 != null) {
            if (pdfObject4.getDecodedStream() != null) {
                pdfObject9 = pdfObject4;
            } else if (pdfObject4.getDictionary(2045494) != null) {
                pdfObject9 = pdfObject4.getDictionary(2045494);
            }
            if (pdfObject9 != null) {
                javaFXImageIcon3 = new JavaFXImageIcon(buttonBase, formObject, pdfObject9, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0);
            }
            if (pdfObject4.getDictionary(7998) != null) {
                pdfObject10 = pdfObject4.getDictionary(7998);
            } else {
                map = pdfObject4.getOtherDictionaries();
                if (map != null && !map.isEmpty()) {
                    for (String string : map.keySet()) {
                        pdfObject10 = pdfObject = (PdfObject)map.get(string);
                    }
                }
            }
            if (pdfObject10 != null) {
                javaFXImageIcon4 = new JavaFXImageIcon(buttonBase, formObject, pdfObject10, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0);
                if (javaFXImageIcon3 == null) {
                    javaFXImageIcon3 = new JavaFXImageIcon(buttonBase, (PdfObject)formObject, (Image)null, formObject.getDictionary(7451).getInt(34));
                }
            }
        }
        if (formObject.isSelected() && javaFXImageIcon5 != null && buttonBase instanceof ToggleButton) {
            ((ToggleButton)buttonBase).setSelected(true);
            javaFXImageIcon5.swapImage(true);
        }
        JavaFXFormFactory.createListener(buttonBase, javaFXImageIcon, javaFXImageIcon5, javaFXImageIcon2, javaFXImageIcon3, javaFXImageIcon4, javaFXControlListener);
    }

    private static void createListener(final ButtonBase buttonBase, final JavaFXImageIcon javaFXImageIcon, final JavaFXImageIcon javaFXImageIcon2, final JavaFXImageIcon javaFXImageIcon3, final JavaFXImageIcon javaFXImageIcon4, final JavaFXImageIcon javaFXImageIcon5, JavaFXControlListener javaFXControlListener) {
        final boolean bl = buttonBase instanceof ToggleButton;
        buttonBase.setGraphic((Node)javaFXImageIcon);
        if (javaFXImageIcon2 != null) {
            javaFXControlListener.addOnMousePressedListener(new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    buttonBase.setText(null);
                    buttonBase.setGraphic((Node)javaFXImageIcon2);
                }
            });
            javaFXControlListener.addOnMouseReleasedListener(new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    JavaFXFormFactory.resetToDefault(bl, javaFXImageIcon3, javaFXImageIcon, buttonBase);
                }
            });
            javaFXControlListener.addOnTouchPressedListener(new EventHandler<TouchEvent>(){

                public void handle(TouchEvent touchEvent) {
                    buttonBase.setText(null);
                    buttonBase.setGraphic((Node)javaFXImageIcon2);
                }
            });
            javaFXControlListener.addOnTouchReleasedListener(new EventHandler<TouchEvent>(){

                public void handle(TouchEvent touchEvent) {
                    JavaFXFormFactory.resetToDefault(bl, javaFXImageIcon3, javaFXImageIcon, buttonBase);
                }
            });
        }
        javaFXControlListener.addOnMouseExitedListener(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXFormFactory.resetToDefault(bl, javaFXImageIcon3, javaFXImageIcon, buttonBase);
            }
        });
        if (javaFXImageIcon4 != null) {
            javaFXControlListener.addOnMouseEnteredListener(new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    buttonBase.setText(null);
                    if (bl && ((ToggleButton)buttonBase).isSelected() && javaFXImageIcon5 != null) {
                        buttonBase.setGraphic((Node)javaFXImageIcon5);
                    } else {
                        buttonBase.setGraphic((Node)javaFXImageIcon4);
                    }
                }
            });
        }
        if (bl) {
            ToggleButton toggleButton = (ToggleButton)buttonBase;
            if (toggleButton.isSelected()) {
                toggleButton.setGraphic((Node)javaFXImageIcon3);
            }
            toggleButton.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl3, Boolean bl2) {
                    if (javaFXImageIcon2 != null) {
                        javaFXImageIcon2.swapImage(bl2);
                    }
                    javaFXImageIcon3.swapImage(bl2);
                    JavaFXFormFactory.resetToDefault(bl, javaFXImageIcon3, javaFXImageIcon, buttonBase);
                }
            });
        }
    }

    private static void resetToDefault(boolean bl, JavaFXImageIcon javaFXImageIcon, JavaFXImageIcon javaFXImageIcon2, ButtonBase buttonBase) {
        buttonBase.setText(null);
        if (bl && ((ToggleButton)buttonBase).isSelected() && javaFXImageIcon != null) {
            buttonBase.setGraphic((Node)javaFXImageIcon);
        } else {
            buttonBase.setGraphic((Node)javaFXImageIcon2);
        }
    }

    private void setupUniversalFeatures(Control control, FormObject formObject, StringBuilder stringBuilder, JavaFXControlListener javaFXControlListener) {
        int[] nArray = FormsCSSHelper.getTextColor(formObject);
        if (nArray == null) {
            stringBuilder.append("-fx-text-fill:rgb(0, 0, 0);");
        } else {
            stringBuilder.append(String.format("-fx-text-fill:rgb(%d, %d, %d);", nArray[0], nArray[1], nArray[2]));
        }
        int[] nArray2 = FormsCSSHelper.getBackgroundColor(formObject);
        if (nArray2 == null) {
            stringBuilder.append("-fx-background-color:transparent;");
        } else {
            stringBuilder.append(String.format("-fx-background-color:rgb(%d, %d, %d);", nArray2[0], nArray2[1], nArray2[2]));
        }
        if (javaFXControlListener != null) {
            this.setupMouseListener(control, formObject, javaFXControlListener);
        }
    }

    private void addFont(FormObject formObject, boolean bl, boolean bl2, StringBuilder stringBuilder) {
        String string = FormsCSSHelper.addFont(formObject, bl, bl2, this.pageData, formObject.getPageNumber(), 1.0f);
        if (formObject.isAppearanceUsed() && formObject.getFormType() == FormFactory.RADIOBUTTON.intValue()) {
            stringBuilder.append("-fx-text-fill:transparent;");
        } else {
            stringBuilder.append("-fx-font:").append(string).append(';');
        }
    }

    private void setupMouseListener(Control control, FormObject formObject, JavaFXControlListener javaFXControlListener) {
        String string;
        boolean[] blArray = formObject.getCharacteristics();
        if (blArray[0] || blArray[1] || blArray[5]) {
            control.setVisible(false);
        }
        JavaFXFormsListener javaFXFormsListener = new JavaFXFormsListener(formObject, this.formsActionHandler);
        javaFXControlListener.addMouseListener(javaFXFormsListener.getMouseHandler());
        javaFXControlListener.addKeyListener(javaFXFormsListener.getKeyHandler());
        javaFXControlListener.addFocusEvent(javaFXFormsListener.getFocusHandler());
        PdfObject pdfObject = formObject.getDictionary(17);
        if (!(pdfObject == null || pdfObject.getNameAsConstant(35) != 2433561 || (string = System.getProperty("org.jpedal.noURLaccess")) != null && string.equals("true"))) {
            String string2 = pdfObject.getTextStreamValue(2433561);
            control.setTooltip(new Tooltip(string2));
        }
    }

    private static void setToolTip(FormObject formObject, Control control) {
        String string = formObject.getTextStreamValue(9253);
        if (string != null && !string.isEmpty()) {
            control.setTooltip(new Tooltip(string));
        }
    }

    @Override
    public GUIData getCustomCompData() {
        return new JavaFXData();
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void setAnnotOrder(Map<String, String> map) {
    }

    public Object getPopupComponent(FormObject formObject, int n) {
        return new PdfJavaFXPopup(formObject, n);
    }

    private static void setBorder(FormObject formObject, StringBuilder stringBuilder) {
        int[] nArray = FormsCSSHelper.getBorderColor(formObject);
        int[] nArray2 = new int[]{255, 255, 255};
        int n = FormsCSSHelper.getBorderWidth(formObject);
        if (nArray == null && formObject.isXFAObject()) {
            nArray = new int[]{0, 0, 0};
        }
        if (nArray == null || n == 0) {
            return;
        }
        String string = String.format("rgb(%d,%d,%d) ", nArray[0], nArray[1], nArray[2]);
        String string2 = String.format("rgb(%d,%d,%d) ", nArray2[0], nArray2[1], nArray2[2]);
        String string3 = "-fx-border-color:" + string + ';';
        String string4 = "-fx-border-style:solid;";
        String string5 = "-fx-border-width:" + n + "px;";
        int n2 = 35;
        PdfObject pdfObject = formObject.getDictionary(4643);
        if (pdfObject != null && (n2 = pdfObject.getNameAsConstant(35)) == -1) {
            n2 = 35;
        }
        if (formObject.isXFAObject()) {
            int[] nArray3 = formObject.getMatteBorderDetails();
            string5 = String.format("-fx-border-width:%d %d %d %d;", nArray3[0], nArray3[1], nArray3[2], nArray3[3]);
        } else {
            switch (n2) {
                case 37: {
                    string5 = "-fx-border-width:0 0 " + n + "px 0;";
                    break;
                }
                case 25: {
                    string3 = "-fx-border-color:" + string + string2 + string2 + string + ';';
                    break;
                }
                case 18: {
                    string3 = "-fx-border-color:" + string2 + string + string + string2 + ';';
                    break;
                }
                case 35: {
                    break;
                }
                case 20: {
                    string4 = "-fx-border-style:dashed;";
                }
            }
        }
        stringBuilder.append(string3).append(string4).append(string5);
    }
}

