/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import java.awt.image.BufferedImage;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Transform;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;

public class JavaFXImageIcon
extends ImageView {
    PdfObject formObject;
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int selected = -1;
    private static final int UNSELECTEDICON = 0;
    private static final int SELECTEDICON = 1;
    private Image rootImageSelected;
    private Image rootImageUnselected;
    private Image imageSelected;
    private Image imageUnselected;
    private PdfObject selObj;
    private PdfObject unSelObj;
    private PdfObjectReader currentpdffile;
    private int subtype;
    private int offsetImage;
    protected static final float MAXSCALEFACTOR = 1.5f;
    protected static final int iconWidth = -1;
    protected static final int iconHeight = -1;
    private final SimpleDoubleProperty xScale;
    private final SimpleDoubleProperty yScale;
    protected int iconRotation;
    protected int iconOpp = 180;
    protected int pageRotate;
    protected boolean displaySingle;

    JavaFXImageIcon(ButtonBase buttonBase, PdfObject pdfObject, PdfObject pdfObject2, int n, PdfObjectReader pdfObjectReader, int n2, int n3) {
        this.formObject = pdfObject;
        this.selObj = pdfObject2;
        this.selected = -1;
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
        this.currentpdffile = pdfObjectReader;
        this.subtype = n2;
        this.offsetImage = n3;
        this.setupButton(buttonBase);
    }

    JavaFXImageIcon(ButtonBase buttonBase, PdfObject pdfObject, BufferedImage bufferedImage, int n) {
        this(buttonBase, pdfObject, (Image)(bufferedImage == null ? null : SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null)), n);
    }

    JavaFXImageIcon(ButtonBase buttonBase, PdfObject pdfObject, Image image, int n) {
        this.iconRotation = n;
        this.formObject = pdfObject;
        this.imageSelected = image != null ? image : SwingFXUtils.toFXImage((BufferedImage)FormObject.getOpaqueImage(), null);
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
        this.selected = -1;
        this.setupButton(buttonBase);
    }

    JavaFXImageIcon(ButtonBase buttonBase, PdfObject pdfObject, PdfObject pdfObject2, PdfObject pdfObject3, int n, int n2, PdfObjectReader pdfObjectReader, int n3, int n4) {
        this.formObject = pdfObject;
        this.selObj = pdfObject2;
        this.unSelObj = pdfObject3;
        this.selected = n2;
        this.currentpdffile = pdfObjectReader;
        this.subtype = n3;
        this.offsetImage = n4;
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
        this.setupButton(buttonBase);
    }

    private JavaFXImageIcon() {
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
    }

    private void setupButton(ButtonBase buttonBase) {
        this.fitWidthProperty().bind((ObservableValue)buttonBase.prefWidthProperty());
        this.fitHeightProperty().bind((ObservableValue)buttonBase.prefHeightProperty());
        ListChangeListener<Transform> listChangeListener = new ListChangeListener<Transform>(){

            public void onChanged(ListChangeListener.Change<? extends Transform> change) {
                change.next();
                if (change.wasAdded()) {
                    Transform transform = (Transform)change.getAddedSubList().get(0);
                    JavaFXImageIcon.this.xScale.set(Math.abs(transform.getMxx()));
                    JavaFXImageIcon.this.yScale.set(Math.abs(transform.getMyy()));
                    JavaFXImageIcon.this.setSelectedImage();
                }
            }
        };
        ChangeListener<Parent> changeListener = new ChangeListener<Parent>((ListChangeListener)listChangeListener){
            final /* synthetic */ ListChangeListener val$transListener;
            {
                this.val$transListener = listChangeListener;
            }

            public void changed(ObservableValue<? extends Parent> observableValue, Parent parent, Parent parent2) {
                if (parent != null) {
                    parent.getTransforms().removeListener(this.val$transListener);
                }
                if (parent2 != null) {
                    parent2.getTransforms().addListener(this.val$transListener);
                }
            }
        };
        buttonBase.parentProperty().addListener((ChangeListener)changeListener);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int n = (int)(this.getFitWidth() * this.xScale.get());
        int n2 = (int)(this.getFitHeight() * this.yScale.get());
        if (this.currentlyPrinting) {
            n = -1 * this.printMultiplier;
            n2 = -1 * this.printMultiplier;
        }
        switch (this.selected) {
            case 0: {
                if (!(this.rootImageUnselected == null || (double)n > this.rootImageUnselected.getWidth() || (double)n2 > this.rootImageUnselected.getHeight() || (double)n < this.rootImageUnselected.getWidth() / 1.5) && !((double)n2 < this.rootImageUnselected.getHeight() / 1.5)) break;
                BufferedImage bufferedImage = FormStream.decode(this.formObject, this.currentpdffile, this.unSelObj, this.subtype, n, n2, this.offsetImage, 1.0f);
                BufferedImage bufferedImage2 = FormStream.rotate(bufferedImage, this.iconRotation);
                this.rootImageUnselected = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
                this.imageUnselected = SwingFXUtils.toFXImage((BufferedImage)bufferedImage2, null);
                break;
            }
            default: {
                if (!(this.rootImageSelected == null || (double)n > this.rootImageSelected.getWidth() || (double)n2 > this.rootImageSelected.getHeight() || (double)n < this.rootImageSelected.getWidth() / 1.5) && !((double)n2 < this.rootImageSelected.getHeight() / 1.5)) break;
                BufferedImage bufferedImage = FormStream.decode(this.formObject, this.currentpdffile, this.selObj, this.subtype, n, n2, this.offsetImage, 1.0f);
                BufferedImage bufferedImage3 = FormStream.rotate(bufferedImage, this.iconRotation);
                if (bufferedImage != null) {
                    this.rootImageSelected = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
                }
                if (bufferedImage3 == null) break;
                this.imageSelected = SwingFXUtils.toFXImage((BufferedImage)bufferedImage3, null);
            }
        }
    }

    public void swapImage(boolean bl) {
        if (this.selected == -1) {
            return;
        }
        this.selected = bl ? 1 : 0;
        this.setSelectedImage();
    }

    public void setPrinting(boolean bl, int n) {
        this.currentlyPrinting = bl;
        this.printMultiplier = n;
        this.checkAndCreateimage();
    }

    private void setSelectedImage() {
        Image image;
        this.checkAndCreateimage();
        switch (this.selected) {
            case 0: {
                image = this.imageUnselected;
                break;
            }
            default: {
                image = this.imageSelected;
            }
        }
        this.setImage(image);
    }

    public Image getSelectedImage() {
        Image image;
        this.checkAndCreateimage();
        switch (this.selected) {
            case 0: {
                image = this.imageUnselected;
                break;
            }
            default: {
                image = this.imageSelected;
            }
        }
        return image;
    }
}

