/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.jpedal.objects.acroforms.javafx.CertificateHolderFX;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class JavaFXSummary
extends Pane {
    private final Stage frame;
    private final PdfObject sigObject;
    private static TextField signedByBox = new TextField();
    private static TextField reasonBox = new TextField();
    private static TextField dateBox = new TextField();
    private static TextField locationBox = new TextField();

    public void setValues(String string, String string2, String string3) {
        signedByBox.setText(string);
        reasonBox.setText(string2);
        String string4 = this.sigObject.getTextStreamValue(29);
        StringBuilder stringBuilder = new StringBuilder(string4);
        stringBuilder.delete(0, 2);
        stringBuilder.insert(4, '/');
        stringBuilder.insert(7, '/');
        stringBuilder.insert(10, ' ');
        stringBuilder.insert(13, ':');
        stringBuilder.insert(16, ':');
        stringBuilder.insert(19, ' ');
        dateBox.setText(stringBuilder.toString());
        locationBox.setText(string3);
    }

    public JavaFXSummary(Stage stage, PdfObject pdfObject) {
        this.frame = stage;
        this.sigObject = pdfObject;
        this.initComponents();
    }

    private void initComponents() {
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        Button button = new Button();
        Button button2 = new Button();
        locationBox = new TextField();
        signedByBox = new TextField();
        reasonBox = new TextField();
        dateBox = new TextField();
        label.setText("Location: ");
        label2.setText("Signed by: ");
        label3.setText("Reason: ");
        label4.setText("Date: ");
        button2.setText("Close");
        button.setText("Show Certificate...");
        locationBox.setEditable(false);
        reasonBox.setEditable(false);
        dateBox.setEditable(false);
        signedByBox.setEditable(false);
        reasonBox.setPrefWidth(400.0);
        byte[] byArray = this.sigObject.getTextStreamValueAsByte(322257476);
        if (byArray == null) {
            button.setDisable(true);
        } else {
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    JavaFXSummary.this.showCertificate();
                }
            });
        }
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                JavaFXSummary.this.frame.close();
            }
        });
        VBox vBox = new VBox(20.0);
        vBox.getChildren().addAll((Object[])new Node[]{label2, label3, label4, label});
        VBox vBox2 = new VBox(8.0);
        vBox2.getChildren().addAll((Object[])new Node[]{signedByBox, reasonBox, dateBox, locationBox});
        vBox2.setPadding(new Insets(3.0, 0.0, 3.0, 0.0));
        HBox hBox = new HBox();
        hBox.getChildren().addAll((Object[])new Node[]{label, locationBox});
        locationBox.setAlignment(Pos.BOTTOM_CENTER);
        hBox.setAlignment(Pos.BOTTOM_CENTER);
        hBox.setPadding(new Insets(0.0, 0.0, 3.0, 0.0));
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Object[])new Node[]{button, button2});
        StackPane.setAlignment((Node)button2, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setAlignment((Node)button, (Pos)Pos.TOP_RIGHT);
        HBox hBox2 = new HBox(3.0);
        hBox2.getChildren().addAll((Object[])new Node[]{vBox, vBox2, hBox, stackPane});
        this.getChildren().add((Object)hBox2);
    }

    private void showCertificate() {
        Stage stage = new Stage();
        CertificateHolderFX certificateHolderFX = new CertificateHolderFX(stage);
        try {
            byte[] byArray = this.sigObject.getTextStreamValueAsByte(322257476);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).close();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
            Date date = x509Certificate.getNotBefore();
            Date date2 = x509Certificate.getNotAfter();
            String string = JavaFXSummary.byteToHex(x509Certificate.getPublicKey().getEncoded());
            String string2 = JavaFXSummary.byteToHex(x509Certificate.getEncoded());
            String string3 = JavaFXSummary.byteToHex(JavaFXSummary.getDigest(byArray, "SHA1"));
            String string4 = JavaFXSummary.byteToHex(JavaFXSummary.getDigest(byArray, "MD5"));
            String string5 = x509Certificate.getPublicKey().toString();
            int n = string5.indexOf(10);
            if (n != -1) {
                string5 = string5.substring(0, n);
            }
            certificateHolderFX.setValues(this.sigObject.getTextStreamValue(506543413), x509Certificate.getVersion(), x509Certificate.getSigAlgName(), x509Certificate.getSubjectX500Principal().toString(), x509Certificate.getIssuerX500Principal().toString(), x509Certificate.getSerialNumber(), simpleDateFormat.format(date), simpleDateFormat.format(date2), string5, string, string2, string3, string4);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
    }

    private static byte[] getDigest(byte[] byArray, String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    private static String byteToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by);
            if (string.startsWith("ffffff")) {
                string = string.substring(6, string.length());
            } else if (string.length() == 1) {
                string = '0' + string;
            }
            string = string.toUpperCase();
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString();
    }
}

