/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.jpedal.objects.raw.FormObject;

public class PdfJavaFXPopup
extends Pane {
    private final FormObject form;
    private VBox content;
    private Rectangle dragBar;
    private double offX;
    private double offY;

    PdfJavaFXPopup(FormObject formObject, int n) {
        this.form = formObject;
        this.createContent();
        this.setupListeners();
        this.getChildren().add((Object)this.content);
    }

    private void createContent() {
        String string;
        String string2;
        this.content = new VBox();
        this.content.getStyleClass().add((Object)"popupAnnot");
        String string3 = "";
        if (this.form.getParentPdfObj() != null) {
            string2 = PdfJavaFXPopup.checkString(this.form.getParentPdfObj().getTextStreamValue(1216184967));
            string3 = PdfJavaFXPopup.formatDate(this.form);
            string = PdfJavaFXPopup.checkString(this.form.getParentPdfObj().getTextStreamValue(36));
        } else {
            string2 = PdfJavaFXPopup.checkString(this.form.getTextStreamValue(1216184967));
            string = PdfJavaFXPopup.checkString(this.form.getTextStreamValue(36));
        }
        this.content.setPrefWidth(200.0);
        this.content.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.dragBar = new Rectangle();
        Label label = new Label(string);
        Label label2 = new Label(string3);
        TextArea textArea = new TextArea(string2);
        this.dragBar.setHeight(15.0);
        this.dragBar.widthProperty().bind((ObservableValue)this.content.prefWidthProperty());
        this.dragBar.getStyleClass().add((Object)"dragbar");
        VBox.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        label.setWrapText(true);
        label2.setWrapText(true);
        textArea.setWrapText(true);
        label.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)16.0));
        float[] fArray = this.form.getFloatArray(19);
        String string4 = fArray != null ? (fArray[0] > 1.0f || fArray[1] > 1.0f || fArray[2] > 1.0f ? "rgb(" + fArray[0] + ", " + fArray[1] + ", " + fArray[2] + ')' : "rgb(" + fArray[0] * 255.0f + ", " + fArray[1] * 255.0f + ", " + fArray[2] * 255.0f + ')') : "rgb(255,255,0)";
        this.content.setStyle("-fx-border-color:" + string4 + ';');
        this.dragBar.setStyle("-fx-fill:" + string4 + ';');
        this.content.getChildren().addAll((Object[])new Node[]{this.dragBar, label, label2, textArea});
    }

    private static String formatDate(FormObject formObject) {
        String string = formObject.getParentPdfObj().getTextStreamValue(29);
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.delete(0, 2);
            stringBuilder.insert(10, ':');
            stringBuilder.insert(13, ':');
            stringBuilder.delete(16, stringBuilder.length());
            stringBuilder.insert(16, " GMT");
            String string2 = stringBuilder.substring(0, 4);
            String string3 = stringBuilder.substring(6, 8);
            stringBuilder.delete(6, 8);
            stringBuilder.delete(0, 4);
            stringBuilder.insert(0, string3);
            stringBuilder.insert(4, string2);
            stringBuilder.insert(2, '/');
            stringBuilder.insert(5, '/');
            stringBuilder.insert(10, ' ');
            string = stringBuilder.toString();
        } else {
            string = "";
        }
        return string;
    }

    private static String checkString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private void setupListeners() {
        this.dragBar.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PdfJavaFXPopup.this.setVisible(false);
                }
            }
        });
        this.dragBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                PdfJavaFXPopup.this.offX = mouseEvent.getX();
                PdfJavaFXPopup.this.offY = mouseEvent.getY();
                PdfJavaFXPopup.this.toFront();
            }
        });
        this.dragBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                double d = PdfJavaFXPopup.this.getTranslateX() + mouseEvent.getX() - PdfJavaFXPopup.this.offX;
                double d2 = PdfJavaFXPopup.this.getTranslateY() - mouseEvent.getY() + PdfJavaFXPopup.this.offY;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d - PdfJavaFXPopup.this.offX - PdfJavaFXPopup.this.content.getWidth() > PdfJavaFXPopup.this.getScene().getWidth()) {
                    d = PdfJavaFXPopup.this.getScene().getWidth() + PdfJavaFXPopup.this.content.getWidth();
                }
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                PdfJavaFXPopup.this.setTranslateX(d);
                PdfJavaFXPopup.this.setTranslateY(d2);
                mouseEvent.consume();
            }
        });
        this.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (bl2.booleanValue()) {
                    PdfJavaFXPopup.this.toFront();
                }
            }
        });
    }
}

