/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.SwingUtilities;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.javascript.JSApp;
import org.jpedal.objects.javascript.jsobjects.JSConsole;
import org.jpedal.objects.javascript.jsobjects.JSDoc;
import org.jpedal.objects.javascript.jsobjects.JSField;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;

public class GenericParser
implements ExpressionEngine {
    private static final String[] engineOrder = new String[]{"nashorn", "rhino"};
    private AcroRenderer acroRenderer;
    private ScriptEngine engine;
    private final ScriptContext context;
    private JSDoc docObject;
    private final Javascript jsObject;
    private static final boolean debugEngine = false;
    private static ArrayList<String> erroredCode;

    public GenericParser(Javascript javascript) throws Exception {
        this.jsObject = javascript;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        for (int i = 0; this.engine == null && i < engineOrder.length; ++i) {
            this.engine = scriptEngineManager.getEngineByName(engineOrder[i]);
        }
        if (this.engine == null) {
            throw new Exception("Could not load a suitable ScriptEngine for parsing JavaScript, are you using a fully fledged JVM?");
        }
        this.context = this.engine.getContext();
    }

    public void setupPDFObjects(Javascript javascript) {
        try {
            this.docObject = new JSDoc();
            this.docObject.setAcroRenderer(this.acroRenderer);
            this.context.setAttribute("JSDoc", this.docObject, 100);
            this.context.setAttribute("app", new JSApp(), 100);
            JSConsole jSConsole = new JSConsole();
            this.context.setAttribute("console", jSConsole, 100);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/jpedal/objects/javascript/jsobjects/JSObjects.js")));
            this.engine.eval(bufferedReader);
            this.engine.eval("var event = new Event();");
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/org/jpedal/objects/javascript/aform.js")));
            this.engine.eval(bufferedReader2);
            String string = GenericParser.preParseJS(javascript.getJavaScript(null), true);
            if (string != null && !string.isEmpty()) {
                try {
                    this.engine.eval(string);
                }
                catch (ScriptException scriptException) {
                    scriptException.printStackTrace();
                }
            }
        }
        catch (ScriptException scriptException) {
            scriptException.printStackTrace();
        }
    }

    @Override
    public int execute(FormObject formObject, int n, Object object, int n2, char c) {
        if (c == '\uffff') {
            return 0;
        }
        if (object instanceof String) {
            object = GenericParser.preParseJS((String)object, false);
            try {
                this.engine.eval("var event = new Event(" + n + ");");
                this.engine.eval("event.target = JSDoc.getFieldByRef('" + formObject.getObjectRefAsString() + "');");
                this.engine.eval("event.value = '" + formObject.getValue() + "';");
            }
            catch (ScriptException scriptException) {
                Logger.getLogger(GenericParser.class.getName()).log(Level.SEVERE, null, scriptException);
            }
            try {
                Object object2;
                Object object3 = this.engine.eval((String)object, this.context);
                Object object4 = this.engine.eval("event.target");
                Object object5 = this.engine.eval("event.value");
                if (object4 != null && n2 == 6) {
                    object2 = (JSField)object4;
                    ((JSField)object2).value = object5;
                    ((JSField)object2).syncToGUI(false);
                }
                if (object3 != null) {
                    // empty if block
                }
                object2 = this.engine.eval("event");
                Object object6 = this.engine.eval("event.name");
                if (object2 != null && object6 != null && object6.equals("Format")) {
                    this.calcualteEvent();
                }
            }
            catch (ScriptException scriptException) {
                scriptException.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public void closeFile() {
        this.flush();
    }

    @Override
    public boolean reportError(int n, Object[] objectArray) {
        return false;
    }

    @Override
    public int addCode(String string) {
        final String string2 = string = GenericParser.preParseJS(string, true);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    GenericParser.this.engine.eval(string2, GenericParser.this.context);
                }
                catch (ScriptException scriptException) {
                    scriptException.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
        return 0;
    }

    @Override
    public void executeFunctions(String string, FormObject formObject) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setAcroRenderer(AcroRenderer acroRenderer) {
        this.acroRenderer = acroRenderer;
        this.docObject.setAcroRenderer(acroRenderer);
    }

    private void flush() {
        this.docObject.flush();
    }

    private void calcualteEvent() {
        FormObject[] formObjectArray;
        for (FormObject formObject : formObjectArray = this.docObject.getFormObjects()) {
            String string = formObject.getObjectRefAsString();
            String string2 = formObject.getTextStreamValue(36);
            String string3 = (String)this.jsObject.getJavascriptCommand(string2 != null ? string2 : string, 4866);
            if (string3 == null) continue;
            string3 = GenericParser.preParseJS(string3, false);
            try {
                this.engine.eval("var event = new Event(4866);", this.context);
                this.engine.eval("event.target = JSDoc.getFieldByRef('" + string + "');", this.context);
                this.engine.eval(string3, this.context);
                JSField jSField = (JSField)this.engine.eval("event.target", this.context);
                Boolean bl = (Boolean)this.engine.eval("event.rc", this.context);
                if (jSField == null || !bl.booleanValue()) continue;
                Object object = this.engine.eval("event.value", this.context);
                jSField.value = object != null ? object.toString() : null;
                jSField.syncToGUI(false);
            }
            catch (ScriptException scriptException) {
                scriptException.printStackTrace();
            }
        }
    }

    private static String preParseJS(String string, boolean bl) {
        string = GenericParser.addMethodstoObject(GenericParser.makeGlobalVars(string));
        string = GenericParser.fixGetFields(string);
        if (bl) {
            string = "(function() {" + string + "}).call(Doc);";
        }
        return string;
    }

    private static String fixGetFields(String string) {
        Pattern pattern = Pattern.compile("[^.]getField\\(");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            string = string.replace(string2, string2.charAt(0) + "Doc.getField(");
        }
        string = string.replace("this.getField(", "Doc.getField(");
        return string;
    }

    private static String addMethodstoObject(String string) {
        String string2;
        Pattern pattern = Pattern.compile("function\\s\\w+\\((\\w+)?\\)");
        Matcher matcher = pattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            string2 = matcher.group();
            String string3 = string.substring(matcher.start() + 9, matcher.end());
            int n = string3.indexOf(40);
            String string4 = string3.substring(0, n);
            String string5 = "this." + string4 + " = " + "function" + string3.substring(n);
            hashMap.put(string2, string5);
        }
        string2 = string;
        for (String string6 : hashMap.keySet()) {
            string2 = string2.replace(string6, (CharSequence)hashMap.get(string6));
        }
        return string2;
    }

    private static String makeGlobalVars(String string) {
        String string2;
        String string3 = GenericParser.trimToGlobal(string);
        Pattern pattern = Pattern.compile("var\\s\\w+\\s?=\\s?");
        Matcher matcher = pattern.matcher(string3);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            int n;
            string2 = matcher.group();
            String string4 = string3.substring(matcher.start() + 4, matcher.end());
            for (n = 0; string4.charAt(n) != ' ' && string4.charAt(n) != '=' && n < string4.length(); ++n) {
            }
            String string5 = string4.substring(0, n);
            hashMap.put(string2.substring(0, 4 + string5.length()), "this." + string5);
        }
        string2 = string;
        for (String string6 : hashMap.keySet()) {
            string2 = string2.replace(string6, (CharSequence)hashMap.get(string6));
        }
        return string2;
    }

    private static String trimToGlobal(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!bl4) {
                if (c == '\"') {
                    bl4 = true;
                    continue;
                }
                if (!bl3) {
                    if (c == '\'') {
                        bl3 = true;
                        continue;
                    }
                    if (!bl) {
                        if (c == '{') {
                            bl = true;
                            continue;
                        }
                        if (!bl2) {
                            if (c == '(') {
                                bl2 = true;
                                continue;
                            }
                            if (c == ')' || c == '}') continue;
                            stringBuilder.append(c);
                            continue;
                        }
                        if (c != ')') continue;
                        bl2 = false;
                        continue;
                    }
                    if (c != '}') continue;
                    bl = false;
                    continue;
                }
                if (c != '\'') continue;
                bl3 = false;
                continue;
            }
            if (c != '\"') continue;
            bl4 = false;
        }
        string = stringBuilder.toString();
        return string;
    }

    public static void debugLog(String string) {
        File file = new File("JSErrorLog.txt");
        try {
            if (file.createNewFile()) {
                System.err.println("Javascript error log file created: " + file.getAbsolutePath());
            }
            if (erroredCode == null) {
                erroredCode = new ArrayList();
            }
            if (erroredCode.contains(string)) {
                return;
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));
            bufferedWriter.write(string);
            bufferedWriter.close();
            erroredCode.add(string);
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception: " + iOException.getMessage());
        }
    }
}

