/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.layers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.layers.Layer;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;

public class PdfLayerList {
    private static boolean debug;
    private int OCpageNumber = -1;
    private String padding = "";
    public static final char deliminator = '\uffff';
    private final Map layerNames = new LinkedHashMap();
    private final Map streamToName = new HashMap();
    private final Map layersEnabled = new HashMap();
    private Map jsCommands;
    private final Map metaData = new HashMap();
    private final Map layersTested = new HashMap();
    private final Map layerLocks = new HashMap();
    private boolean changesMade;
    private Map propertyMap;
    private Map refToPropertyID;
    private Map refTolayerName;
    private Map RBconstraints;
    private final Map minScale = new HashMap();
    private final Map maxScale = new HashMap();
    private int layerCount;
    private Object[] order;
    private PdfObjectReader currentPdfFile;
    private Layer[] layers;

    public void init(PdfObject pdfObject, PdfObject pdfObject2, PdfObjectReader pdfObjectReader, int n) {
        String string;
        Object object2;
        PdfObject pdfObject3;
        this.OCpageNumber = n;
        this.propertyMap = new HashMap();
        this.refToPropertyID = new HashMap();
        this.refTolayerName = new HashMap();
        this.RBconstraints = new HashMap();
        this.currentPdfFile = pdfObjectReader;
        if (pdfObject2 != null) {
            this.setupOCMaps(pdfObject2, pdfObjectReader);
        }
        if ((pdfObject3 = pdfObject.getDictionary(20)) == null) {
            return;
        }
        int n2 = pdfObject3.getNameAsConstant(1970567530);
        if (n2 == -1) {
            n2 = 7966;
        }
        this.order = pdfObject3.getObjectArray(1110717793);
        if (debug) {
            System.out.println("PropertiesObj=" + pdfObject2);
            System.out.println("layerDict=" + pdfObject3);
            System.out.println("propertyMap=" + this.propertyMap);
            System.out.println("propertyMap=" + this.propertyMap);
            System.out.println("refToPropertyID=" + this.refToPropertyID);
            System.out.println("refTolayerName=" + this.refTolayerName);
            System.out.println("OCBaseState=" + n2 + " (ON=" + 7966 + ')');
            System.out.println("order=" + Arrays.toString(this.order));
            PdfLayerList.showValues("ON=", 7966, pdfObject3);
            PdfLayerList.showValues("OFF=", 0x1F1616, pdfObject3);
            PdfLayerList.showValues("RBGroups=", 1633113989, pdfObject3);
        }
        this.addLayer(n2, this.order, null);
        if (n2 != 7966) {
            this.addLayer(7966, pdfObject3.getKeyArray(7966), null);
        }
        if (n2 != 0x1F1616) {
            this.addLayer(0x1F1616, pdfObject3.getKeyArray(0x1F1616), null);
        }
        if (n2 == 7966) {
            for (Object object2 : this.refToPropertyID.keySet()) {
                Object v = this.refToPropertyID.get(object2);
                this.refTolayerName.put(object2, v);
                if (this.layersTested.containsKey(v)) continue;
                this.layersTested.put(v, "x");
                this.layersEnabled.put(v, "x");
            }
        }
        this.setLocks(pdfObjectReader, pdfObject3.getKeyArray(859525491));
        this.setConstraints(pdfObject3.getKeyArray(1633113989));
        this.setAS(pdfObject3.getKeyArray(4387), pdfObjectReader);
        Object object3 = new int[]{506543413, 827818359};
        object2 = new String[]{"Name", "Creator"};
        int n3 = ((Object)object3).length;
        for (int i = 0; i < n3; ++i) {
            string = pdfObject3.getTextStreamValue((int)object3[i]);
            if (string == null) continue;
            this.metaData.put(object2[i], string);
        }
        string = pdfObject3.getName(964196217);
        if (string != null) {
            this.metaData.put("ListMode", string);
        }
    }

    private static void showValues(String string, int n, PdfObject pdfObject) {
        byte[][] byArray = pdfObject.getKeyArray(n);
        if (byArray != null) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (byte[] byArray2 : byArray) {
                if (byArray2 == null) {
                    stringBuilder.append("null ");
                    continue;
                }
                stringBuilder.append(new String(byArray2)).append(' ');
            }
            System.out.println(stringBuilder);
        }
    }

    public void setChangesMade(boolean bl) {
        this.changesMade = bl;
    }

    private void setConstraints(byte[][] byArray) {
        CharSequence charSequence;
        int n;
        if (byArray == null) {
            return;
        }
        int n2 = byArray.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            charSequence = new String(byArray[n]);
            stringArray[n] = (String)this.refTolayerName.get(charSequence);
        }
        for (n = 0; n < n2; ++n) {
            if (!this.isLayerName(stringArray[n])) continue;
            charSequence = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                if (n == i) continue;
                ((StringBuilder)charSequence).append(stringArray[i]).append(',');
            }
            this.RBconstraints.put(stringArray[n], ((StringBuilder)charSequence).toString());
        }
    }

    private void setupOCMaps(PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        PdfKeyPairsIterator pdfKeyPairsIterator = pdfObject.getKeyPairsIterator();
        while (pdfKeyPairsIterator.hasMorePairs()) {
            String string = pdfKeyPairsIterator.getNextKeyAsString();
            PdfObject pdfObject2 = pdfKeyPairsIterator.getNextValueAsDictionary();
            String string2 = pdfObject2.getObjectRefAsString();
            pdfObjectReader.checkResolved(pdfObject2);
            byte[][] byArray = pdfObject2.getKeyArray(521344835);
            if (byArray != null) {
                this.setupchildOCMaps(byArray, string, pdfObjectReader);
            } else {
                this.propertyMap.put(string2, pdfObject2);
                String string3 = (String)this.refToPropertyID.get(string2);
                if (string3 == null) {
                    this.refToPropertyID.put(string2, string);
                } else {
                    this.refToPropertyID.put(string2, string3 + ',' + string);
                }
            }
            pdfKeyPairsIterator.nextPair();
        }
    }

    private void setupchildOCMaps(byte[][] byArray, String string, PdfObjectReader pdfObjectReader) {
        for (byte[] byArray2 : byArray) {
            String string2 = new String(byArray2);
            OCObject oCObject = new OCObject(string2);
            pdfObjectReader.readObject(oCObject);
            pdfObjectReader.checkResolved(oCObject);
            byte[][] byArray3 = ((PdfObject)oCObject).getKeyArray(521344835);
            if (byArray3 != null) {
                this.setupchildOCMaps(byArray3, string, pdfObjectReader);
                continue;
            }
            this.propertyMap.put(string2, oCObject);
            String string3 = (String)this.refToPropertyID.get(string2);
            if (string3 == null) {
                this.refToPropertyID.put(string2, string);
                continue;
            }
            this.refToPropertyID.put(string2, string3 + ',' + string);
        }
    }

    private void addLayer(int n, Object[] objectArray, String string) {
        int n2;
        if (objectArray == null) {
            return;
        }
        if (debug) {
            this.padding = this.padding + "   ";
        }
        int n3 = objectArray.length;
        String string2 = null;
        for (n2 = 0; n2 < n3; ++n2) {
            if (objectArray[n2] instanceof String) continue;
            if (objectArray[n2] instanceof byte[]) {
                Object object;
                byte[] byArray = (byte[])objectArray[n2];
                String string3 = new String(byArray);
                String string4 = (String)this.refToPropertyID.get(string3);
                PdfObject pdfObject = (PdfObject)this.propertyMap.get(string3);
                if (pdfObject == null) {
                    if (byArray != null && byArray.length > 1 && byArray[byArray.length - 1] == 82) {
                        pdfObject = new OCObject(string3);
                        this.currentPdfFile.readObject(pdfObject);
                        string4 = string3;
                    } else {
                        string = string == null ? string3 : string3 + '\uffff' + string;
                    }
                }
                if (pdfObject == null) continue;
                ++this.layerCount;
                string2 = pdfObject.getTextStreamValue(506543413);
                if (string != null) {
                    string2 = string2 + '\uffff' + string;
                }
                if (debug) {
                    System.out.println(this.padding + "[layer1] add layer=" + string2 + " ref=" + string3 + " parent=" + string + " refToLayerName=" + this.refTolayerName.get(string3) + " ref=" + string3);
                }
                this.refTolayerName.put(string3, string2);
                objectArray[n2] = string2;
                this.layerNames.put(string2, n);
                if (string4.indexOf(44) == -1) {
                    object = (String)this.streamToName.get(string4);
                    if (object == null) {
                        this.streamToName.put(string4, string2);
                    } else {
                        this.streamToName.put(string4, (String)object + ',' + string2);
                    }
                } else {
                    object = new StringTokenizer(string4, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string4 = ((StringTokenizer)object).nextToken();
                        String string5 = (String)this.streamToName.get(string4);
                        if (string5 == null) {
                            this.streamToName.put(string4, string2);
                            continue;
                        }
                        this.streamToName.put(string4, string5 + ',' + string2);
                    }
                }
                if (n == 7966) {
                    this.layersEnabled.put(string2, "x");
                    continue;
                }
                this.layersEnabled.remove(string2);
                continue;
            }
            this.addLayer(n, (Object[])objectArray[n2], string2);
        }
        if (debug && (n2 = this.padding.length()) > 3) {
            this.padding = this.padding.substring(0, n2 - 3);
        }
    }

    private void addLayer(int n, byte[][] byArray, String string) {
        if (byArray == null) {
            return;
        }
        for (byte[] byArray2 : byArray) {
            Object object;
            String string2 = new String(byArray2);
            String string3 = (String)this.refToPropertyID.get(string2);
            PdfObject pdfObject = (PdfObject)this.propertyMap.get(string2);
            if (pdfObject == null) continue;
            ++this.layerCount;
            String string4 = pdfObject.getTextStreamValue(506543413);
            if (string != null) {
                string4 = string4 + '\uffff' + string;
            }
            if ((n == 7966 || n == 0x1F1616) && (object = (String)this.refTolayerName.get(string2)) != null) {
                string4 = object;
            }
            if (debug) {
                System.out.println(this.padding + "[layer0] add layer=" + string4 + " ref=" + string2 + " parent=" + string + " refToLayerName=" + this.refTolayerName.get(string2) + " status=" + n);
            }
            if (this.refTolayerName.get(string2) == null) {
                this.refTolayerName.put(string2, string4);
                this.layerNames.put(string4, n);
            }
            if (this.streamToName.get(string3) == null) {
                if (string3.indexOf(44) == -1) {
                    object = (String)this.streamToName.get(string3);
                    if (object == null) {
                        this.streamToName.put(string3, string4);
                    } else {
                        this.streamToName.put(string3, (String)object + ',' + string4);
                    }
                } else {
                    object = new StringTokenizer(string3, ",");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string3 = ((StringTokenizer)object).nextToken();
                        String string5 = (String)this.streamToName.get(string3);
                        if (string5 == null) {
                            this.streamToName.put(string3, string4);
                            continue;
                        }
                        this.streamToName.put(string3, string5 + ',' + string4);
                    }
                }
            }
            if (n == 7966) {
                this.layersEnabled.put(string4, "x");
            } else {
                this.layersEnabled.remove(string4);
            }
            this.layersTested.put(string4, "x");
        }
    }

    private void setAS(byte[][] byArray, PdfObjectReader pdfObjectReader) {
        if (byArray == null) {
            return;
        }
        for (byte[] byArray2 : byArray) {
            byte[][] byArray3;
            if (byArray2 == null) continue;
            String string = new String(byArray2);
            OCObject oCObject = new OCObject(string);
            if (byArray2[0] == 60) {
                oCObject.setStatus(2);
            } else {
                oCObject.setStatus(1);
            }
            oCObject.setUnresolvedData(byArray2, 4387);
            pdfObjectReader.checkResolved(oCObject);
            int n = ((PdfObject)oCObject).getParameterConstant(1177894489);
            if (oCObject == null || n != 641283399 || (byArray3 = ((PdfObject)oCObject).getKeyArray(521344835)) == null) continue;
            for (byte[] byArray4 : byArray3) {
                float f;
                PdfObject pdfObject;
                string = new String(byArray4);
                oCObject = new OCObject(string);
                if (byArray4[0] == 60) {
                    oCObject.setStatus(2);
                } else {
                    oCObject.setStatus(1);
                }
                oCObject.setUnresolvedData(byArray4, 521344835);
                pdfObjectReader.checkResolved(oCObject);
                String string2 = ((PdfObject)oCObject).getTextStreamValue(506543413);
                String string3 = (String)this.refToPropertyID.get(string);
                this.streamToName.put(string3, string2);
                PdfObject pdfObject2 = ((PdfObject)oCObject).getDictionary(1127298906);
                if (pdfObject2 == null || (pdfObject = pdfObject2.getDictionary(708788029)) == null) continue;
                float f2 = pdfObject.getFloatNumber(4012350);
                if (f2 != 0.0f) {
                    this.minScale.put(string2, Float.valueOf(f2));
                }
                if ((f = pdfObject.getFloatNumber(4010312)) == 0.0f) continue;
                this.maxScale.put(string2, Float.valueOf(f));
            }
        }
    }

    private void setLocks(PdfObjectReader pdfObjectReader, byte[][] byArray) {
        if (byArray == null) {
            return;
        }
        for (byte[] byArray2 : byArray) {
            String string = new String(byArray2);
            OCObject oCObject = new OCObject(string);
            pdfObjectReader.readObject(oCObject);
            String string2 = ((PdfObject)oCObject).getTextStreamValue(506543413);
            this.layerLocks.put(string2, "x");
        }
    }

    public Map getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public Object[] getDisplayTree() {
        if (this.order != null) {
            return this.order;
        }
        return this.getNames();
    }

    private String[] getNames() {
        int n = this.layerNames.size();
        String[] stringArray = new String[n];
        Iterator iterator = this.layerNames.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = iterator.next().toString();
            ++n2;
        }
        return stringArray;
    }

    public void setVisibleLayers(String[] stringArray) {
        this.layersEnabled.clear();
        if (stringArray != null) {
            for (String string : stringArray) {
                this.layersEnabled.put(string, "x");
            }
        }
        this.changesMade = true;
    }

    public boolean decodeLayer(String string, boolean bl) {
        String string2;
        boolean bl2;
        block7: {
            Object object;
            block6: {
                if (this.layerCount == 0) {
                    return true;
                }
                bl2 = false;
                string2 = string;
                if (bl && (object = (String)this.streamToName.get(string)) != null) {
                    string2 = object;
                }
                if (string2 == null) {
                    return false;
                }
                if (string2.indexOf(44) != -1) break block6;
                bl2 = this.layersEnabled.containsKey(string2);
                if (!bl2) break block7;
                bl2 = this.hiddenByParent(bl2, string2);
                break block7;
            }
            object = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                bl2 = this.layersEnabled.containsKey(string3);
                if (bl2) {
                    bl2 = this.hiddenByParent(bl2, string3);
                }
                if (!bl2) continue;
                break;
            }
        }
        if (debug) {
            System.out.println("[isVisible] " + string + " decode=" + bl2 + " enabled=" + this.layersEnabled + " layerName=" + string2 + " isEnabled=" + this.layersEnabled);
        }
        return bl2;
    }

    private boolean hiddenByParent(boolean bl, String string) {
        int n = string.indexOf(65535);
        if (bl && n != -1) {
            String string2 = string.substring(n + 1, string.length());
            while (string2 != null && bl && this.isLayerName(string2)) {
                bl = this.decodeLayer(string2, false);
                string = string2;
                n = string.indexOf(65535);
                if (n == -1) {
                    string2 = null;
                    continue;
                }
                string2 = string.substring(n + 1, string.length());
            }
        }
        return bl;
    }

    public boolean setZoom(float f) {
        Object object;
        String string;
        Iterator iterator = this.minScale.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = (Float)this.minScale.get(string);
            if (object == null) continue;
            if (f < ((Float)object).floatValue()) {
                this.layersEnabled.remove(string);
                this.changesMade = true;
                continue;
            }
            if (this.layersEnabled.containsKey(string)) continue;
            this.layersEnabled.put(string, "x");
            this.changesMade = true;
        }
        object = this.maxScale.keySet().iterator();
        while (object.hasNext()) {
            string = (String)iterator.next();
            Float f2 = (Float)this.maxScale.get(string);
            if (f2 == null) continue;
            if (f > f2.floatValue()) {
                this.layersEnabled.remove(string);
                this.changesMade = true;
                continue;
            }
            if (this.layersEnabled.containsKey(string)) continue;
            this.layersEnabled.put(string, "x");
            this.changesMade = true;
        }
        return this.changesMade;
    }

    public boolean isVisible(String string) {
        return this.layersEnabled.containsKey(string);
    }

    public void setVisiblity(String string, boolean bl) {
        if (debug) {
            System.out.println("[layer] setVisiblity=" + string + " isVisible=" + bl);
        }
        if (bl) {
            this.layersEnabled.put(string, "x");
            String string2 = (String)this.RBconstraints.get(string);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.layersEnabled.remove(stringTokenizer.nextToken());
                }
            }
        } else {
            this.layersEnabled.remove(string);
        }
        this.changesMade = true;
    }

    public boolean isVisible(PdfObject pdfObject) {
        boolean bl = true;
        PdfObject pdfObject2 = pdfObject.getDictionary(7955);
        if (pdfObject2 != null) {
            String string = null;
            PdfObject pdfObject3 = pdfObject2.getDictionary(521344835);
            if (pdfObject3 != null) {
                PdfObject pdfObject4;
                PdfObject pdfObject5 = pdfObject3.getDictionary(1127298906);
                if (pdfObject5 != null && (pdfObject4 = pdfObject5.getDictionary(641283399)) != null) {
                    bl = pdfObject4.getNameAsConstant(2103872382) == 7966;
                }
            } else {
                byte[][] byArray = pdfObject2.getKeyArray(521344835);
                if (byArray != null) {
                    for (byte[] byArray2 : byArray) {
                        String string2 = new String(byArray2);
                        string = this.getNameFromRef(string2);
                    }
                }
                if (string == null) {
                    string = pdfObject2.getTextStreamValue(506543413);
                }
                if (string != null && this.isLayerName(string)) {
                    bl = this.isVisible(string);
                }
            }
        }
        return bl;
    }

    public boolean isLocked(String string) {
        return this.layerLocks.containsKey(string);
    }

    public boolean getChangesMade() {
        return this.changesMade;
    }

    public boolean isLayerName(String string) {
        return this.layerNames.containsKey(string);
    }

    public int getLayersCount() {
        return this.layerCount;
    }

    public String getNameFromRef(String string) {
        return (String)this.refTolayerName.get(string);
    }

    public Object[] getOCGs() {
        if (this.layers != null) {
            return this.layers;
        }
        int n = this.layerNames.size();
        Object[] objectArray = new Layer[n];
        Iterator iterator = this.layerNames.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            objectArray[n2] = new Layer(string, this);
            ++n2;
        }
        return objectArray;
    }

    public void addJScommand(String string, String string2) {
        if (this.jsCommands == null) {
            this.jsCommands = new HashMap();
        }
        this.jsCommands.put(string, string2);
    }

    public Iterator getJSCommands() {
        if (this.jsCommands != null) {
            Iterator iterator = this.jsCommands.keySet().iterator();
            HashMap hashMap = new HashMap();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.isVisible(string)) continue;
                hashMap.put(this.jsCommands.get(string), "x");
            }
            return hashMap.keySet().iterator();
        }
        return null;
    }

    public int getOCpageNumber() {
        return this.OCpageNumber;
    }
}

