/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.glyph.JavaFXSupport;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.javascript.defaultactions.DisplayJavascriptActions;
import org.jpedal.objects.raw.MKObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ObjectCloneFactory;
import org.jpedal.utils.StringUtils;

public class FormObject
extends PdfObject {
    private static final JavaFXSupport fxSupport = ExternalHandlers.getFXHandler();
    private int formType = -1;
    private String fontName = "Arial";
    Object guiComp;
    private int guiType;
    private int rawRotation;
    Point currentLocation;
    float currentScaling = -1.0f;
    private String EOPROPtype;
    private String Filter;
    private String Location;
    private String M;
    private String Reason;
    private String SubFilter;
    private byte[] rawEOPROPtype;
    private byte[] rawFilter;
    private byte[] rawLocation;
    private byte[] rawM;
    private byte[] rawReason;
    private byte[] rawSubFilter;
    private Color cColor;
    private String contents;
    private boolean show;
    private Map OptValues;
    private String validValue;
    private int[] matteDetails = new int[]{0, 0, 0, 0};
    public static final int READONLY_ID = 1;
    public static final int REQUIRED_ID = 2;
    public static final int NOEXPORT_ID = 3;
    public static final int MULTILINE_ID = 13;
    public static final int PASSWORD_ID = 14;
    public static final int NOTOGGLETOOFF_ID = 15;
    public static final int RADIO_ID = 16;
    public static final int PUSHBUTTON_ID = 17;
    public static final int COMBO_ID = 18;
    public static final int EDIT_ID = 19;
    public static final int SORT_ID = 20;
    public static final int FILESELECT_ID = 21;
    public static final int MULTISELECT_ID = 22;
    public static final int DONOTSPELLCHECK_ID = 23;
    public static final int DONOTSCROLL_ID = 24;
    public static final int COMB_ID = 25;
    public static final int RICHTEXT_ID = 26;
    public static final int RADIOINUNISON_ID = 26;
    public static final int COMMITONSELCHANGE_ID = 27;
    private static final int READONLY_BIT = 1;
    private static final int REQUIRED_BIT = 2;
    private static final int NOEXPORT_BIT = 4;
    private static final int MULTILINE_BIT = 4096;
    private static final int PASSWORD_BIT = 8192;
    private static final int NOTOGGLETOOFF_BIT = 16384;
    private static final int RADIO_BIT = 32768;
    private static final int PUSHBUTTON_BIT = 65536;
    private static final int COMBO_BIT = 131072;
    private static final int EDIT_BIT = 262144;
    private static final int SORT_BIT = 524288;
    private static final int FILESELECT_BIT = 0x100000;
    private static final int MULTISELECT_BIT = 0x200000;
    private static final int DONOTSPELLCHECK_BIT = 0x400000;
    private static final int DONOTSCROLL_BIT = 0x800000;
    private static final int COMB_BIT = 0x1000000;
    private static final int RADIOINUNISON_BIT = 0x2000000;
    private static final int RICHTEXT_BIT = 0x2000000;
    private static final int COMMITONSELCHANGE_BIT = 0x4000000;
    private int rotationOriginX;
    private int rotationOriginY;
    private int elemRotationDegree;
    protected String[] OptString;
    protected boolean isXFAObject;
    private String parentRef;
    private PdfObject parentPdfObj;
    private String selectedItem;
    private Object[] selectedValues;
    private float[] textColor;
    private Font textFont;
    private int textSize = -1;
    private String textString;
    private String lastTextString;
    private boolean lastIsSelected;
    private boolean isSelected;
    private int selectionIndex = -1;
    private boolean appearancesUsed;
    private boolean offsetDownIcon;
    private boolean noDownIcon;
    private boolean invertDownIcon;
    private String normalOnState;
    private BufferedImage normalOffImage;
    private BufferedImage normalOnImage;
    private BufferedImage rolloverOffImage;
    private BufferedImage rolloverOnImage;
    private BufferedImage downOffImage;
    private BufferedImage downOnImage;
    public static final int POPUP = 1;
    private String layerName;
    private boolean[] Farray;
    protected Rectangle BBox;
    protected float[] C;
    protected float[] QuadPoints;
    protected float[] RD;
    protected float[] Rect;
    protected boolean[] flags;
    boolean Open;
    boolean H_Boolean = true;
    boolean NeedAppearances;
    protected int F = -1;
    protected int Ff = -1;
    protected int MaxLen = -1;
    protected int W = -1;
    protected int Q = -1;
    int SigFlags = -1;
    int StructParent = -1;
    protected int TI = -1;
    protected PdfObject A;
    private int popupFlag;
    protected PdfObject AA;
    protected PdfObject AP;
    protected PdfObject Cdict;
    private PdfObject BI;
    protected PdfObject BS;
    protected PdfObject D;
    protected PdfObject IF;
    protected PdfObject IRT;
    protected PdfObject RichMediaContent;
    protected int Flags;
    private PdfObject MK;
    private PdfObject DC;
    private PdfObject DP;
    private PdfObject DR;
    private PdfObject DS;
    private PdfObject E;
    private PdfObject Fdict;
    private PdfObject Fo;
    private PdfObject FS;
    private PdfObject JS;
    private PdfObject K;
    private PdfObject Nobj;
    private PdfObject Next;
    private PdfObject O;
    private PdfObject PC;
    private PdfObject PI;
    private PdfObject PO;
    private PdfObject Popup;
    private PdfObject PV;
    private PdfObject R;
    private PdfObject Sig;
    private PdfObject Sound;
    private PdfObject U;
    private PdfObject V;
    private PdfObject Win;
    private PdfObject WP;
    private PdfObject WS;
    private PdfObject X;
    protected int[] ByteRange;
    protected int[] selectionIndices;
    protected byte[] rawAS;
    protected byte[] rawCert;
    protected byte[] rawContactInfo;
    protected byte[] rawContents;
    protected byte[] rawDstring;
    protected byte[] rawDA;
    protected byte[] rawDV;
    protected byte[] rawFstring;
    protected byte[] rawJS;
    protected byte[] rawH;
    protected byte[] rawN;
    protected byte[] rawNM;
    protected byte[] rawPstring;
    protected byte[] rawRC;
    protected byte[] rawRT;
    protected byte[] rawS;
    protected byte[] rawSubj;
    protected byte[] rawT;
    protected byte[] rawTM;
    protected byte[] rawTU;
    protected byte[] rawURI;
    protected byte[] rawV;
    protected byte[] rawX;
    protected int FT = -1;
    protected String AS;
    protected String Cert;
    protected String ContactInfo;
    protected String Contents;
    protected String Dstring;
    protected String DA;
    protected String DV;
    protected String Fstring;
    protected String JSString;
    protected String H;
    protected String N;
    protected String NM;
    protected String Pstring;
    protected String RC;
    protected String S;
    protected String Subj;
    protected String T;
    protected String TM;
    protected String TU;
    protected String URI;
    protected String Vstring;
    private byte[][] Border;
    private byte[][] DmixedArray;
    private byte[][] Fields;
    private byte[][] State;
    private byte[][] rawXFAasArray;
    protected PdfObject Bl;
    protected PdfObject OC;
    protected PdfObject Off;
    protected PdfObject On;
    protected PdfObject P;
    private PdfObject XFAasStream;
    protected Object[] CO;
    protected Object[] InkList;
    protected Object[] Opt;
    protected Object[] Reference;
    protected byte[][] Kids;
    private String htmlName;
    private static final float baseFontSize = 12.0f;

    public void setHTMLName(String string) {
        this.htmlName = string;
    }

    public String getHTMLName() {
        return this.htmlName;
    }

    public FormObject(String string) {
        super(string);
        this.objType = 373244477;
    }

    public FormObject(String string, boolean bl) {
        super(string);
        this.objType = 373244477;
        this.includeParent = bl;
    }

    public FormObject(int n, int n2) {
        super(n, n2);
        this.objType = 373244477;
    }

    public FormObject(int n) {
        super(n);
        this.objType = 373244477;
    }

    public FormObject() {
        this.objType = 373244477;
    }

    public FormObject(String string, int n) {
        super(string);
        this.objType = 373244477;
        this.parentType = n;
    }

    @Override
    public boolean getBoolean(int n) {
        switch (n) {
            case 24: {
                return this.H_Boolean;
            }
            case -1483477783: {
                return this.NeedAppearances;
            }
            case 524301630: {
                return this.Open;
            }
        }
        return super.getBoolean(n);
    }

    @Override
    public void setBoolean(int n, boolean bl) {
        switch (n) {
            case 24: {
                this.H_Boolean = bl;
                break;
            }
            case -1483477783: {
                this.NeedAppearances = bl;
                break;
            }
            case 524301630: {
                this.Open = bl;
                break;
            }
            default: {
                super.setBoolean(n, bl);
            }
        }
    }

    public void setActionFlag(int n) {
        this.popupFlag = n;
    }

    public int getActionFlag() {
        return this.popupFlag;
    }

    @Override
    public PdfObject getDictionary(int n) {
        switch (n) {
            case 17: {
                return this.A;
            }
            case 4369: {
                return this.AA;
            }
            case 4384: {
                if (this.AP == null) {
                    this.AP = new FormObject();
                }
                return this.AP;
            }
            case 4633: {
                return this.BI;
            }
            case 4668: {
                return this.Bl;
            }
            case 4643: {
                if (this.BS == null) {
                    PdfObject pdfObject;
                    if (this.parentPdfObj != null && (pdfObject = this.parentPdfObj.getDictionary(4643)) != null) {
                        return (PdfObject)pdfObject.clone();
                    }
                    this.BS = new FormObject();
                }
                return this.BS;
            }
            case 19: {
                return this.Cdict;
            }
            case 20: {
                return this.D;
            }
            case 5139: {
                return this.DC;
            }
            case 5152: {
                return this.DP;
            }
            case 5154: {
                return this.DR;
            }
            case 5155: {
                return this.DS;
            }
            case 21: {
                return this.E;
            }
            case 22: {
                return this.Fdict;
            }
            case 5695: {
                return this.Fo;
            }
            case 5667: {
                return this.FS;
            }
            case 6691: {
                return this.JS;
            }
            case 6422: {
                return this.IF;
            }
            case 1647140: {
                return this.IRT;
            }
            case 27: {
                return this.K;
            }
            case 7451: {
                if (this.MK == null) {
                    PdfObject pdfObject;
                    if (this.parentPdfObj != null && (pdfObject = this.parentPdfObj.getDictionary(7451)) != null) {
                        return (PdfObject)pdfObject.clone();
                    }
                    this.MK = new MKObject();
                }
                return this.MK;
            }
            case 30: {
                return this.Nobj;
            }
            case 506808388: {
                return this.Next;
            }
            case 31: {
                return this.O;
            }
            case 7955: {
                return this.OC;
            }
            case 2045494: {
                return this.Off;
            }
            case 7998: {
                return this.On;
            }
            case 32: {
                return this.P;
            }
            case 8211: {
                return this.PC;
            }
            case 8217: {
                return this.PI;
            }
            case 8223: {
                return this.PO;
            }
            case 1061176672: {
                return this.Popup;
            }
            case 8230: {
                return this.PV;
            }
            case 34: {
                return this.R;
            }
            case -1263082253: {
                return this.RichMediaContent;
            }
            case 2308407: {
                return this.Sig;
            }
            case 1061502534: {
                return this.Sound;
            }
            case 37: {
                return this.U;
            }
            case 38: {
                return this.V;
            }
            case 2570558: {
                return this.Win;
            }
            case 10016: {
                return this.WP;
            }
            case 10019: {
                return this.WS;
            }
            case 40: {
                return this.X;
            }
            case 2627089: {
                return this.XFAasStream;
            }
        }
        return super.getDictionary(n);
    }

    @Override
    public void setIntNumber(int n, int n2) {
        block0 : switch (n) {
            case 22: {
                this.F = n2;
                break;
            }
            case 5686: {
                this.Ff = n2;
                this.commandFf(this.Ff);
                break;
            }
            case 33: {
                switch (n2) {
                    case 0: {
                        this.Q = 2;
                        break block0;
                    }
                    case 1: {
                        this.Q = 0;
                        break block0;
                    }
                    case 2: {
                        this.Q = 4;
                        break block0;
                    }
                }
                this.Q = 2;
                break;
            }
            case 1209815663: {
                this.MaxLen = n2;
                break;
            }
            case 1144088180: {
                if (this.MK == null) {
                    this.MK = new MKObject();
                }
                if (this.rawRotation == 0) {
                    this.MK.setIntNumber(34, n2);
                    break;
                }
                int n3 = this.rawRotation - n2;
                if (n3 < 0) {
                    n3 = 360 + n3;
                }
                this.MK.setIntNumber(34, n3);
                break;
            }
            case 1600810585: {
                this.SigFlags = n2;
                break;
            }
            case -1732403014: {
                this.StructParent = n2;
                break;
            }
            case 9241: {
                this.TI = n2;
                break;
            }
            case 39: {
                this.W = n2;
                break;
            }
            case 1009858393: {
                this.Flags = n2;
                break;
            }
            default: {
                super.setIntNumber(n, n2);
            }
        }
    }

    @Override
    public int getInt(int n) {
        switch (n) {
            case 22: {
                return this.F;
            }
            case 5686: {
                return this.Ff;
            }
            case 1209815663: {
                return this.MaxLen;
            }
            case 33: {
                return this.Q;
            }
            case 1600810585: {
                return this.SigFlags;
            }
            case -1732403014: {
                return this.StructParent;
            }
            case 9241: {
                return this.TI;
            }
            case 39: {
                return this.W;
            }
            case 1009858393: {
                return this.Flags;
            }
        }
        return super.getInt(n);
    }

    @Override
    public void setDictionary(int n, PdfObject pdfObject) {
        pdfObject.setID(n);
        if (this.currentKey != null) {
            this.setOtherValues(pdfObject);
            return;
        }
        switch (n) {
            case 17: {
                this.A = pdfObject;
                break;
            }
            case 4369: {
                this.AA = pdfObject;
                break;
            }
            case 4384: {
                this.AP = pdfObject;
                if (this.MK != null || this.AP == null || this.AP.getDictionary(30) == null) break;
                this.MK = this.AP.getDictionary(30).getDictionary(7451);
                break;
            }
            case 4633: {
                this.BI = pdfObject;
                break;
            }
            case 4668: {
                this.Bl = pdfObject;
                break;
            }
            case 4643: {
                this.BS = pdfObject;
                break;
            }
            case 19: {
                this.Cdict = pdfObject;
                break;
            }
            case 20: {
                this.D = pdfObject;
                break;
            }
            case 5139: {
                this.DC = pdfObject;
                break;
            }
            case 5152: {
                this.DP = pdfObject;
                break;
            }
            case 5154: {
                this.DR = pdfObject;
                break;
            }
            case 5155: {
                this.DS = pdfObject;
                break;
            }
            case 21: {
                this.E = pdfObject;
                break;
            }
            case 22: {
                this.Fdict = pdfObject;
                break;
            }
            case 5695: {
                this.Fo = pdfObject;
                break;
            }
            case 5667: {
                this.FS = pdfObject;
                break;
            }
            case 6422: {
                this.IF = pdfObject;
                break;
            }
            case 1647140: {
                this.IRT = pdfObject;
                break;
            }
            case 6691: {
                this.JS = pdfObject;
                break;
            }
            case 27: {
                this.K = pdfObject;
                break;
            }
            case 7451: {
                this.MK = pdfObject;
                break;
            }
            case 30: {
                this.Nobj = pdfObject;
                break;
            }
            case 506808388: {
                this.Next = pdfObject;
                break;
            }
            case 31: {
                this.O = pdfObject;
                break;
            }
            case 7955: {
                this.OC = pdfObject;
                break;
            }
            case 2045494: {
                this.Off = pdfObject;
                break;
            }
            case 7998: {
                this.On = pdfObject;
                break;
            }
            case 32: {
                this.P = pdfObject;
                break;
            }
            case 8211: {
                this.PC = pdfObject;
                break;
            }
            case 8217: {
                this.PI = pdfObject;
                break;
            }
            case 8223: {
                this.PO = pdfObject;
                break;
            }
            case 1061176672: {
                this.Popup = pdfObject;
                break;
            }
            case 8230: {
                this.PV = pdfObject;
                break;
            }
            case 34: {
                this.R = pdfObject;
                break;
            }
            case -1263082253: {
                this.RichMediaContent = pdfObject;
                break;
            }
            case 2308407: {
                this.Sig = pdfObject;
                break;
            }
            case 1061502534: {
                this.Sound = pdfObject;
                break;
            }
            case 37: {
                this.U = pdfObject;
                break;
            }
            case 38: {
                this.V = pdfObject;
                break;
            }
            case 2570558: {
                this.Win = pdfObject;
                break;
            }
            case 10016: {
                this.WP = pdfObject;
                break;
            }
            case 10019: {
                this.WS = pdfObject;
                break;
            }
            case 40: {
                this.X = pdfObject;
                break;
            }
            case 2627089: {
                this.XFAasStream = pdfObject;
                break;
            }
            default: {
                super.setDictionary(n, pdfObject);
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setConstant(int n, int n2, int n3, byte[] byArray) {
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        try {
            for (int i = n3 - 1; i > -1; n5 += (n7 -= 48) << n6, n6 += 8, --i) {
                int n7 = byArray[n2 + i];
            }
            switch (n5) {
                default: 
            }
            n4 = super.setConstant(n, n5);
            if (n4 != -1) {
                // empty if block
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        switch (n) {
            default: 
        }
        super.setConstant(n, n5);
        return n4;
    }

    @Override
    public int getNameAsConstant(int n) {
        byte[] byArray;
        switch (n) {
            case 5668: {
                return this.FT;
            }
            case 24: {
                byArray = this.rawH;
                break;
            }
            case 30: {
                byArray = this.rawN;
                break;
            }
            case 8740: {
                byArray = this.rawRT;
                break;
            }
            case 35: {
                byArray = this.rawS;
                break;
            }
            case 40: {
                byArray = this.rawX;
                break;
            }
            default: {
                return super.getNameAsConstant(n);
            }
        }
        if (byArray == null) {
            return super.getNameAsConstant(n);
        }
        return PdfDictionary.generateChecksum(0, byArray.length, byArray);
    }

    @Override
    public int getParameterConstant(int n) {
        switch (n) {
            case 1147962727: {
                if (this.FT != -1) {
                    return this.FT;
                }
                return super.getParameterConstant(n);
            }
        }
        return super.getParameterConstant(n);
    }

    @Override
    public PdfArrayIterator getMixedArray(int n) {
        switch (n) {
            case 1110722433: {
                return new PdfArrayIterator(this.Border);
            }
            case 20: {
                return new PdfArrayIterator(this.DmixedArray);
            }
            case 339034948: {
                return new PdfArrayIterator(this.DmixedArray);
            }
            case 893143676: {
                return new PdfArrayIterator(this.Fields);
            }
            case 1144079448: {
                return new PdfArrayIterator(this.State);
            }
            case 2627089: {
                return new PdfArrayIterator(this.rawXFAasArray);
            }
        }
        return super.getMixedArray(n);
    }

    @Override
    public byte[] getTextStreamValueAsByte(int n) {
        switch (n) {
            case 322257476: {
                return this.rawCert;
            }
            case 1568843969: {
                return this.rawContactInfo;
            }
            case 1216184967: {
                return this.rawContents;
            }
            case 5137: {
                return this.rawDA;
            }
        }
        return super.getTextStreamValueAsByte(n);
    }

    @Override
    public double[] getDoubleArray(int n) {
        switch (n) {
            default: 
        }
        return super.getDoubleArray(n);
    }

    @Override
    public void setDoubleArray(int n, double[] dArray) {
        switch (n) {
            default: 
        }
        super.setDoubleArray(n, dArray);
    }

    @Override
    public int[] getIntArray(int n) {
        switch (n) {
            case 25: {
                return FormObject.deepCopy(this.selectionIndices);
            }
            case 2055367785: {
                return FormObject.deepCopy(this.ByteRange);
            }
        }
        return super.getIntArray(n);
    }

    @Override
    public void setIntArray(int n, int[] nArray) {
        switch (n) {
            case 25: {
                this.selectionIndices = nArray;
                break;
            }
            case 2055367785: {
                this.ByteRange = nArray;
                break;
            }
            default: {
                super.setIntArray(n, nArray);
            }
        }
    }

    @Override
    public void setMixedArray(int n, byte[][] byArray) {
        switch (n) {
            case 1110722433: {
                this.Border = byArray;
                break;
            }
            case 339034948: {
                this.DmixedArray = byArray;
                break;
            }
            case 893143676: {
                this.Fields = byArray;
                break;
            }
            case 1144079448: {
                this.State = byArray;
                break;
            }
            case 2627089: {
                this.rawXFAasArray = byArray;
                break;
            }
            default: {
                super.setMixedArray(n, byArray);
            }
        }
    }

    @Override
    public float[] getFloatArray(int n) {
        switch (n) {
            case 19: {
                return this.C;
            }
            case 1785890247: {
                return this.QuadPoints;
            }
            case 573911876: {
                return this.Rect;
            }
            case 8724: {
                return this.RD;
            }
        }
        return super.getFloatArray(n);
    }

    @Override
    public void setFloatArray(int n, float[] fArray) {
        switch (n) {
            case 19: {
                this.C = fArray;
                break;
            }
            case 1785890247: {
                this.QuadPoints = fArray;
                break;
            }
            case 8724: {
                this.RD = fArray;
                break;
            }
            case 573911876: {
                this.Rect = fArray;
                break;
            }
            default: {
                super.setFloatArray(n, fArray);
            }
        }
    }

    @Override
    public void setName(int n, byte[] byArray) {
        switch (n) {
            case 4387: {
                this.rawAS = byArray;
                break;
            }
            case 5158: {
                this.rawDV = byArray;
                break;
            }
            case 1011108731: {
                this.rawFilter = byArray;
                break;
            }
            case -2122953826: {
                this.rawSubFilter = byArray;
                break;
            }
            case 5668: {
                this.FT = PdfDictionary.generateChecksum(0, byArray.length, byArray);
                break;
            }
            case 24: {
                this.rawH = byArray;
                break;
            }
            case 30: {
                this.rawN = byArray;
                break;
            }
            case 8740: {
                this.rawRT = byArray;
                break;
            }
            case 35: {
                this.rawS = byArray;
                break;
            }
            case 40: {
                this.rawX = byArray;
                break;
            }
            default: {
                super.setName(n, byArray);
            }
        }
    }

    @Override
    public void setObjectArray(int n, Object[] objectArray) {
        switch (n) {
            case 4895: {
                this.CO = objectArray;
                break;
            }
            case 475169151: {
                this.InkList = objectArray;
                break;
            }
            case 2048068: {
                this.Opt = objectArray;
                break;
            }
            case 1786013849: {
                this.Reference = objectArray;
                break;
            }
            default: {
                super.setObjectArray(n, objectArray);
            }
        }
    }

    @Override
    public Object[] getObjectArray(int n) {
        switch (n) {
            case 4895: {
                return this.CO;
            }
            case 475169151: {
                return this.InkList;
            }
            case 2048068: {
                return this.Opt;
            }
            case 1786013849: {
                return this.Reference;
            }
        }
        return super.getObjectArray(n);
    }

    @Override
    public byte[][] getStringArray(int n) {
        switch (n) {
            default: 
        }
        return super.getStringArray(n);
    }

    @Override
    public void setStringArray(int n, byte[][] byArray) {
        switch (n) {
            default: 
        }
        super.setStringArray(n, byArray);
    }

    @Override
    public void setTextStreamValue(int n, byte[] byArray) {
        switch (n) {
            case 322257476: {
                this.rawCert = byArray;
                break;
            }
            case 1568843969: {
                this.rawContactInfo = byArray;
                break;
            }
            case 1216184967: {
                this.rawContents = byArray;
                break;
            }
            case 20: {
                this.rawDstring = byArray;
                break;
            }
            case 5137: {
                this.rawDA = byArray;
                break;
            }
            case 5158: {
                this.rawDV = byArray;
                break;
            }
            case 1684763764: {
                this.rawEOPROPtype = byArray;
                break;
            }
            case 22: {
                this.rawFstring = byArray;
                break;
            }
            case 6691: {
                this.rawJS = byArray;
                break;
            }
            case 1618506351: {
                this.rawLocation = byArray;
                break;
            }
            case 29: {
                this.rawM = byArray;
                break;
            }
            case 32: {
                this.rawPstring = byArray;
                break;
            }
            case 8723: {
                this.rawRC = byArray;
                break;
            }
            case 826499443: {
                this.rawReason = byArray;
                break;
            }
            case 7709: {
                this.rawNM = byArray;
                break;
            }
            case 591737402: {
                this.rawSubj = byArray;
                break;
            }
            case 36: {
                this.rawT = byArray;
                this.T = null;
                break;
            }
            case 9245: {
                this.rawTM = byArray;
                break;
            }
            case 9253: {
                this.rawTU = byArray;
                break;
            }
            case 2433561: {
                this.rawURI = byArray;
                break;
            }
            case 38: {
                this.rawV = byArray;
                this.Vstring = null;
                break;
            }
            default: {
                super.setTextStreamValue(n, byArray);
            }
        }
    }

    @Override
    public void setTextStreamValue(int n, String string) {
        switch (n) {
            case 38: {
                this.Vstring = string;
                break;
            }
            case 36: {
                this.setTextStreamValue(n, StringUtils.toBytes(string));
                break;
            }
            default: {
                super.setTextStreamValue(n, string);
            }
        }
    }

    @Override
    public String getName(int n) {
        switch (n) {
            case 4387: {
                if (this.AS == null && this.rawAS != null) {
                    this.AS = new String(this.rawAS);
                }
                return this.AS;
            }
            case 5668: {
                return null;
            }
            case 24: {
                if (this.H == null && this.rawH != null) {
                    this.H = new String(this.rawH);
                }
                return this.H;
            }
            case 1011108731: {
                if (this.Filter == null && this.rawFilter != null) {
                    this.Filter = new String(this.rawFilter);
                }
                return this.Filter;
            }
            case -2122953826: {
                if (this.SubFilter == null && this.rawSubFilter != null) {
                    this.SubFilter = new String(this.rawSubFilter);
                }
                return this.SubFilter;
            }
            case 30: {
                if (this.N == null && this.rawN != null) {
                    this.N = new String(this.rawN);
                }
                return this.N;
            }
            case 8740: {
                if (this.rawRT != null) {
                    return new String(this.rawRT);
                }
            }
            case 35: {
                if (this.S == null && this.rawS != null) {
                    this.S = new String(this.rawS);
                }
                return this.S;
            }
            case 40: {
                if (this.rawX == null) break;
                return new String(this.rawX);
            }
        }
        return super.getName(n);
    }

    @Override
    public String getTextStreamValue(int n) {
        switch (n) {
            case 322257476: {
                if (this.Cert == null && this.rawCert != null) {
                    this.Cert = StringUtils.getTextString(this.rawCert, false);
                }
                return this.Cert;
            }
            case 1568843969: {
                if (this.ContactInfo == null && this.rawContactInfo != null) {
                    this.ContactInfo = StringUtils.getTextString(this.rawContactInfo, false);
                }
                return this.ContactInfo;
            }
            case 1216184967: {
                if (this.Contents == null && this.rawContents != null) {
                    this.Contents = StringUtils.getTextString(this.rawContents, true);
                }
                return this.Contents;
            }
            case 20: {
                if (this.Dstring == null && this.rawDstring != null) {
                    this.Dstring = StringUtils.getTextString(this.rawDstring, false);
                }
                return this.Dstring;
            }
            case 5137: {
                if (this.DA == null && this.rawDA != null) {
                    this.DA = StringUtils.getTextString(this.rawDA, false);
                }
                return this.DA;
            }
            case 5158: {
                if (this.DV == null && this.rawDV != null) {
                    this.DV = StringUtils.getTextString(this.rawDV, true);
                }
                return this.DV;
            }
            case 1684763764: {
                if (this.EOPROPtype == null && this.rawEOPROPtype != null) {
                    this.EOPROPtype = new String(this.rawEOPROPtype);
                }
                return this.EOPROPtype;
            }
            case 22: {
                if (this.Fstring == null && this.rawFstring != null) {
                    this.Fstring = StringUtils.getTextString(this.rawFstring, false);
                }
                return this.Fstring;
            }
            case 6691: {
                if (this.JSString == null && this.rawJS != null) {
                    this.JSString = StringUtils.getTextString(this.rawJS, true);
                }
                return this.JSString;
            }
            case 7709: {
                if (this.NM == null && this.rawNM != null) {
                    this.NM = StringUtils.getTextString(this.rawNM, false);
                }
                return this.NM;
            }
            case 1618506351: {
                if (this.Location == null && this.rawLocation != null) {
                    this.Location = new String(this.rawLocation);
                }
                return this.Location;
            }
            case 29: {
                if (this.M == null && this.rawM != null) {
                    this.M = new String(this.rawM);
                }
                return this.M;
            }
            case 32: {
                if (this.Pstring == null && this.rawPstring != null) {
                    this.Pstring = StringUtils.getTextString(this.rawPstring, false);
                }
                return this.Pstring;
            }
            case 8723: {
                if (this.RC == null && this.rawRC != null) {
                    this.RC = new String(this.rawRC);
                }
                return this.RC;
            }
            case 826499443: {
                if (this.Reason == null && this.rawReason != null) {
                    this.Reason = new String(this.rawReason);
                }
                return this.Reason;
            }
            case 591737402: {
                if (this.Subj == null && this.rawSubj != null) {
                    this.Subj = StringUtils.getTextString(this.rawSubj, false);
                }
                return this.Subj;
            }
            case 36: {
                if (this.T == null && this.rawT != null) {
                    this.T = StringUtils.getTextString(this.rawT, false);
                }
                if (this.T == null && this.parentPdfObj != null) {
                    return this.parentPdfObj.getTextStreamValue(36);
                }
                return this.T;
            }
            case 9245: {
                if (this.TM == null && this.rawTM != null) {
                    this.TM = StringUtils.getTextString(this.rawTM, false);
                }
                return this.TM;
            }
            case 9253: {
                if (this.TU == null && this.rawTU != null) {
                    this.TU = StringUtils.getTextString(this.rawTU, false);
                }
                return this.TU;
            }
            case 2433561: {
                if (this.URI == null && this.rawURI != null) {
                    this.URI = StringUtils.getTextString(this.rawURI, false);
                }
                return this.URI;
            }
            case 38: {
                if (this.Vstring == null && this.rawV != null) {
                    this.Vstring = StringUtils.getTextString(this.rawV, true);
                }
                return this.Vstring;
            }
        }
        return super.getTextStreamValue(n);
    }

    @Override
    public String getStringValue(int n, int n2) {
        byte[] byArray = null;
        switch (n2) {
            case 0: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 1: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 2: {
                if (byArray != null) {
                    int n3 = byArray.length;
                    if (n3 > 6 && byArray[6] == 43) {
                        int n4 = n3 - 7;
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 7, byArray2, 0, n4);
                        return new String(byArray2);
                    }
                    return new String(byArray);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getName(int,mode) in " + this);
    }

    @Override
    public byte[][] getKeyArray(int n) {
        switch (n) {
            case 456733763: {
                return FormObject.deepCopy(this.Kids);
            }
        }
        return super.getKeyArray(n);
    }

    @Override
    public void setKeyArray(int n, byte[][] byArray) {
        switch (n) {
            case 456733763: {
                this.Kids = byArray;
                break;
            }
            default: {
                super.setKeyArray(n, byArray);
            }
        }
    }

    @Override
    public boolean decompressStreamWhenRead() {
        return true;
    }

    protected void commandFf(int n) {
        this.flags = new boolean[32];
        this.flags[1] = (n & 1) == 1;
        this.flags[2] = (n & 2) == 2;
        this.flags[3] = (n & 4) == 4;
        this.flags[13] = (n & 0x1000) == 4096;
        this.flags[14] = (n & 0x2000) == 8192;
        this.flags[15] = (n & 0x4000) == 16384;
        this.flags[16] = (n & 0x8000) == 32768;
        this.flags[17] = (n & 0x10000) == 65536;
        this.flags[18] = (n & 0x20000) == 131072;
        this.flags[19] = (n & 0x40000) == 262144;
        this.flags[20] = (n & 0x80000) == 524288;
        this.flags[21] = (n & 0x100000) == 0x100000;
        this.flags[22] = (n & 0x200000) == 0x200000;
        this.flags[23] = (n & 0x400000) == 0x400000;
        this.flags[24] = (n & 0x800000) == 0x800000;
        this.flags[25] = (n & 0x1000000) == 0x1000000;
        this.flags[26] = (n & 0x2000000) == 0x2000000;
        this.flags[26] = (n & 0x2000000) == 0x2000000;
        this.flags[27] = (n & 0x4000000) == 0x4000000;
    }

    public static Color generateColor(float[] fArray) {
        int n = -1;
        if (fArray != null) {
            n = fArray.length;
        }
        Color color = null;
        if (n == 0) {
            color = new Color(0, 0, 0, 0);
        } else if (n == 1) {
            float f = fArray[0];
            color = f <= 1.0f ? new Color(f, f, f) : new Color((int)f, (int)f, (int)f);
        } else if (n == 3) {
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            color = f <= 1.0f && f2 <= 1.0f && f3 <= 1.0f ? new Color(f, f2, f3) : new Color((int)f, (int)f2, (int)f3);
        } else if (n == 4) {
            DeviceCMYKColorSpace deviceCMYKColorSpace = new DeviceCMYKColorSpace();
            deviceCMYKColorSpace.setColor(new float[]{fArray[3], fArray[2], fArray[1], fArray[0]}, 4);
            color = (Color)((Object)deviceCMYKColorSpace.getColor());
        }
        return color;
    }

    public boolean isXFAObject() {
        return this.isXFAObject;
    }

    @Override
    public PdfObject duplicate() {
        FormObject formObject = new FormObject();
        formObject.AS = this.AS;
        formObject.contents = this.contents;
        formObject.Cert = this.Cert;
        formObject.ContactInfo = this.ContactInfo;
        formObject.contents = this.contents;
        formObject.Contents = this.Contents;
        formObject.DA = this.DA;
        formObject.Dstring = this.Dstring;
        formObject.DV = this.DV;
        formObject.Filter = this.Filter;
        formObject.Fstring = this.Fstring;
        formObject.H = this.H;
        formObject.JSString = this.JSString;
        formObject.layerName = this.layerName;
        formObject.Location = this.Location;
        formObject.M = this.M;
        formObject.N = this.N;
        formObject.NM = this.NM;
        formObject.normalOnState = this.normalOnState;
        formObject.Pstring = this.Pstring;
        formObject.ref = this.ref;
        formObject.RC = this.RC;
        formObject.Reason = this.Reason;
        formObject.S = this.S;
        formObject.selectedItem = this.selectedItem;
        formObject.SubFilter = this.SubFilter;
        formObject.Subj = this.Subj;
        formObject.T = this.T;
        formObject.TM = this.TM;
        formObject.TU = this.TU;
        formObject.textString = this.textString;
        formObject.URI = this.URI;
        formObject.Vstring = this.Vstring;
        formObject.F = this.F;
        formObject.Ff = this.Ff;
        formObject.formType = this.formType;
        formObject.FT = this.FT;
        formObject.MaxLen = this.MaxLen;
        formObject.pageNumber = this.pageNumber;
        formObject.popupFlag = this.popupFlag;
        formObject.Q = this.Q;
        formObject.rawRotation = this.rawRotation;
        formObject.SigFlags = this.SigFlags;
        formObject.StructParent = this.StructParent;
        formObject.textSize = this.textSize;
        formObject.TI = this.TI;
        formObject.W = this.W;
        formObject.appearancesUsed = this.appearancesUsed;
        formObject.offsetDownIcon = this.offsetDownIcon;
        formObject.noDownIcon = this.noDownIcon;
        formObject.invertDownIcon = this.invertDownIcon;
        formObject.show = this.show;
        formObject.H_Boolean = this.H_Boolean;
        formObject.NeedAppearances = this.NeedAppearances;
        formObject.isXFAObject = this.isXFAObject;
        formObject.Open = this.Open;
        formObject.textFont = this.textFont;
        formObject.fontName = this.fontName;
        formObject.cColor = this.cColor;
        formObject.OptString = this.OptString == null ? null : (String[])this.OptString.clone();
        formObject.flags = this.flags == null ? null : (boolean[])this.flags.clone();
        formObject.Farray = this.Farray == null ? null : (boolean[])this.Farray.clone();
        formObject.selectionIndices = this.selectionIndices == null ? null : (int[])this.selectionIndices.clone();
        formObject.C = this.C == null ? null : (float[])this.C.clone();
        formObject.InkList = this.InkList == null ? null : (Object[])this.InkList.clone();
        formObject.QuadPoints = this.QuadPoints == null ? null : (float[])this.QuadPoints.clone();
        formObject.Rect = this.Rect == null ? null : (float[])this.Rect.clone();
        formObject.RD = this.RD == null ? null : (float[])this.RD.clone();
        formObject.textColor = this.textColor == null ? null : (float[])this.textColor.clone();
        formObject.A = this.A.duplicate();
        formObject.AA = this.AA.duplicate();
        formObject.AP = this.AP.duplicate();
        formObject.BS = this.BS.duplicate();
        formObject.BI = this.BI.duplicate();
        formObject.Bl = this.Bl.duplicate();
        formObject.Cdict = this.Cdict.duplicate();
        formObject.D = this.D.duplicate();
        formObject.DC = this.DC.duplicate();
        formObject.DP = this.DP.duplicate();
        formObject.DS = this.DS.duplicate();
        formObject.E = this.E.duplicate();
        formObject.Fdict = this.Fdict.duplicate();
        formObject.Fo = this.Fo.duplicate();
        formObject.FS = this.FS.duplicate();
        formObject.IF = this.IF.duplicate();
        formObject.JS = this.JS.duplicate();
        formObject.K = this.K.duplicate();
        formObject.MK = this.MK.duplicate();
        formObject.Next = this.Next.duplicate();
        formObject.Nobj = this.Nobj.duplicate();
        formObject.O = this.O.duplicate();
        formObject.OC = this.OC.duplicate();
        formObject.Off = this.Off.duplicate();
        formObject.On = this.On.duplicate();
        formObject.P = this.P.duplicate();
        formObject.PC = this.PC.duplicate();
        formObject.PI = this.PI.duplicate();
        formObject.PO = this.PO.duplicate();
        formObject.Popup = this.Popup.duplicate();
        formObject.PV = this.PV.duplicate();
        formObject.R = this.R.duplicate();
        formObject.Sig = this.Sig.duplicate();
        formObject.Sound = this.Sound.duplicate();
        formObject.U = this.U.duplicate();
        formObject.V = this.V.duplicate();
        formObject.Win = this.Win.duplicate();
        formObject.WP = this.WP.duplicate();
        formObject.WS = this.WS.duplicate();
        formObject.X = this.X.duplicate();
        formObject.XFAasStream = this.XFAasStream.duplicate();
        formObject.CO = this.CO == null ? null : (Object[])this.CO.clone();
        formObject.Opt = this.Opt == null ? null : (Object[])this.Opt.clone();
        formObject.Reference = this.Reference == null ? null : (Object[])this.Reference.clone();
        formObject.rawAS = this.rawAS == null ? null : (byte[])this.rawAS.clone();
        formObject.rawCert = this.rawCert == null ? null : (byte[])this.rawCert.clone();
        formObject.rawContactInfo = this.rawContactInfo == null ? null : (byte[])this.rawContactInfo.clone();
        formObject.rawContents = this.rawContents == null ? null : (byte[])this.rawContents.clone();
        formObject.rawDA = this.rawDA == null ? null : (byte[])this.rawDA.clone();
        formObject.rawDstring = this.rawDstring == null ? null : (byte[])this.rawDstring.clone();
        formObject.rawDV = this.rawDV == null ? null : (byte[])this.rawDV.clone();
        formObject.rawEOPROPtype = this.rawEOPROPtype == null ? null : (byte[])this.rawEOPROPtype.clone();
        formObject.rawFilter = this.rawFilter == null ? null : (byte[])this.rawFilter.clone();
        formObject.rawFstring = this.rawFstring == null ? null : (byte[])this.rawFstring.clone();
        formObject.rawH = this.rawH == null ? null : (byte[])this.rawH.clone();
        formObject.rawJS = this.rawJS == null ? null : (byte[])this.rawJS.clone();
        formObject.rawLocation = this.rawLocation == null ? null : (byte[])this.rawLocation.clone();
        formObject.rawM = this.rawM == null ? null : (byte[])this.rawM.clone();
        formObject.rawN = this.rawN == null ? null : (byte[])this.rawN.clone();
        formObject.rawNM = this.rawNM == null ? null : (byte[])this.rawNM.clone();
        formObject.rawPstring = this.rawPstring == null ? null : (byte[])this.rawPstring.clone();
        formObject.rawRC = this.rawRC == null ? null : (byte[])this.rawRC.clone();
        formObject.rawReason = this.rawReason == null ? null : (byte[])this.rawReason.clone();
        formObject.rawS = this.rawS == null ? null : (byte[])this.rawS.clone();
        formObject.rawSubFilter = this.rawSubFilter == null ? null : (byte[])this.rawSubFilter.clone();
        formObject.rawSubj = this.rawSubj == null ? null : (byte[])this.rawSubj.clone();
        formObject.rawT = this.rawT == null ? null : (byte[])this.rawT.clone();
        formObject.rawTM = this.rawTM == null ? null : (byte[])this.rawTM.clone();
        formObject.rawTU = this.rawTU == null ? null : (byte[])this.rawTU.clone();
        formObject.rawURI = this.rawURI == null ? null : (byte[])this.rawURI.clone();
        formObject.rawV = this.rawV == null ? null : (byte[])this.rawV.clone();
        formObject.rawX = this.rawX == null ? null : (byte[])this.rawX.clone();
        formObject.Border = this.Border == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.Border);
        formObject.DmixedArray = this.DmixedArray == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.DmixedArray);
        formObject.Fields = this.Fields == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.Fields);
        formObject.rawXFAasArray = this.rawXFAasArray == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.rawXFAasArray);
        formObject.State = this.State == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.State);
        formObject.normalOffImage = ObjectCloneFactory.deepCopy(this.normalOffImage);
        formObject.normalOnImage = ObjectCloneFactory.deepCopy(this.normalOnImage);
        formObject.rolloverOffImage = ObjectCloneFactory.deepCopy(this.rolloverOffImage);
        formObject.rolloverOnImage = ObjectCloneFactory.deepCopy(this.rolloverOnImage);
        formObject.downOffImage = ObjectCloneFactory.deepCopy(this.downOffImage);
        formObject.downOnImage = ObjectCloneFactory.deepCopy(this.downOnImage);
        formObject.OptValues = ObjectCloneFactory.cloneMap(this.OptValues);
        return formObject;
    }

    public void copyInheritedValuesFromParent(FormObject formObject) {
        if (formObject == null) {
            return;
        }
        if (this.pageNumber == -1 && formObject.pageNumber != -1) {
            this.pageNumber = formObject.pageNumber;
        }
        if (this.rawAS == null) {
            this.rawAS = formObject.rawAS;
        }
        if (this.rawDA == null) {
            this.rawDA = formObject.rawDA;
        }
        if (this.rawDV == null) {
            this.rawDV = formObject.rawDV;
        }
        if (this.rawJS == null) {
            this.rawJS = formObject.rawJS;
        }
        if (this.rawNM == null) {
            this.rawNM = formObject.rawNM;
        }
        if (this.rawTM == null) {
            this.rawTM = formObject.rawTM;
        }
        if (this.rawTU == null) {
            this.rawTU = formObject.rawTU;
        }
        if (this.rawV == null) {
            this.rawV = formObject.rawV;
        }
        if (formObject.T == null && formObject.rawT != null) {
            formObject.T = StringUtils.getTextString(formObject.rawT, false);
        }
        if (formObject.T != null) {
            if (this.T == null && this.rawT != null) {
                this.T = StringUtils.getTextString(this.rawT, false);
            }
            if (this.T != null && !this.T.contains(formObject.T)) {
                this.T = formObject.T + '.' + this.T;
                this.rawT = StringUtils.toBytes(this.T);
            }
        }
        if (this.A == null) {
            this.A = formObject.A;
        }
        if (this.AA == null) {
            this.AA = formObject.AA;
        }
        if (this.AP == null) {
            this.AP = formObject.AP;
        }
        if (this.D == null) {
            this.D = formObject.D;
        }
        if (this.OC == null) {
            this.OC = formObject.OC;
        }
        if (this.C == null) {
            float[] fArray = this.C = formObject.C == null ? null : (float[])formObject.C.clone();
        }
        if (this.QuadPoints == null) {
            float[] fArray = this.QuadPoints = formObject.QuadPoints == null ? null : (float[])formObject.QuadPoints.clone();
        }
        if (this.InkList == null) {
            Object[] objectArray = this.InkList = formObject.InkList == null ? null : (Object[])formObject.InkList.clone();
        }
        if (this.Rect == null) {
            float[] fArray = this.Rect = formObject.Rect == null ? null : (float[])formObject.Rect.clone();
        }
        if (this.F == -1) {
            this.F = formObject.F;
        }
        if (this.Ff == -1) {
            this.Ff = formObject.Ff;
        }
        if (this.Q == -1) {
            this.Q = formObject.Q;
        }
        if (this.MaxLen == -1) {
            this.MaxLen = formObject.MaxLen;
        }
        if (this.FT == -1) {
            this.FT = formObject.FT;
        }
        if (this.TI == -1) {
            this.TI = formObject.TI;
        }
        if (this.flags == null) {
            boolean[] blArray = this.flags = formObject.flags == null ? null : (boolean[])formObject.flags.clone();
        }
        if (this.Opt == null) {
            Object[] objectArray = this.Opt = formObject.Opt == null ? null : (Object[])formObject.Opt.clone();
        }
        if (this.CO == null) {
            Object[] objectArray = this.CO = formObject.CO == null ? null : (Object[])formObject.CO.clone();
        }
        if (this.textString == null) {
            this.textString = formObject.textString;
        }
        if (this.OptString == null) {
            this.OptString = formObject.OptString;
        }
        if (this.selectedItem == null) {
            this.selectedItem = formObject.selectedItem;
        }
    }

    public int getAlignment() {
        if (this.Q == -1) {
            this.Q = 2;
        }
        return this.Q;
    }

    public void setTextColor(float[] fArray) {
        if (fArray.length > 0 && Float.isNaN(fArray[0])) {
            float[] fArray2 = new float[fArray.length - 1];
            System.arraycopy(fArray, 1, fArray2, 0, fArray.length - 1);
            fArray = fArray2;
        }
        this.textColor = fArray;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public void setTextSize(int n) {
        this.textSize = n;
    }

    public void setTextValue(String string) {
        if (string == null) {
            string = "";
        }
        this.updateValue(string, false, true);
    }

    public void setSelection(Object[] objectArray, String string, int[] nArray, int n) {
        if (n != this.selectionIndex) {
            this.selectedValues = objectArray;
            this.selectedItem = string;
            this.selectionIndex = n;
            this.selectionIndices = nArray;
            if (this.guiComp != null) {
                this.updateCombo();
            }
        }
    }

    public void setFieldName(String string) {
        this.T = null;
        this.setTextStreamValue(36, StringUtils.toBytes(string));
    }

    public void setParent(String string) {
        this.setParent(string, null, false);
    }

    public void setParent(String string, FormObject formObject, boolean bl) {
        if (bl) {
            this.copyInheritedValuesFromParent(formObject);
        }
        this.parentRef = string;
        if (formObject != null) {
            this.parentPdfObj = formObject;
        }
    }

    public PdfObject getParentPdfObj() {
        return this.parentPdfObj;
    }

    public void setParentPdfObj(PdfObject pdfObject) {
        this.parentPdfObj = pdfObject;
    }

    public String getParentRef() {
        if (this.parentRef == null && this.includeParent) {
            return this.getStringKey(1110793845);
        }
        return this.parentRef;
    }

    private static boolean[] calcFarray(int n) {
        if (n == 0) {
            return new boolean[10];
        }
        boolean[] blArray = new boolean[10];
        int[] nArray = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
        for (int i = 1; i < 10; ++i) {
            if ((n & nArray[i]) != nArray[i]) continue;
            blArray[i - 1] = true;
        }
        return blArray;
    }

    public Rectangle2D getBounding2DRectangleForTabbing() {
        float[] fArray = this.getFloatArray(573911876);
        if (fArray != null) {
            float f;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray[3];
            if (f2 > f4) {
                f = f2;
                f2 = f4;
                f4 = f;
            }
            if (f3 > f5) {
                f = f3;
                f3 = f5;
                f5 = f;
            }
            double d = f2;
            double d2 = f3;
            double d3 = f4 + (float)(f4 - f4 > 0.0f ? 1 : 0);
            double d4 = f5 + (float)(f5 - f5 > 0.0f ? 1 : 0);
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
        if (this.currentLocation != null) {
            this.BBox.x += this.currentLocation.x;
            this.BBox.y += -this.currentLocation.y;
        }
        return this.BBox;
    }

    public Rectangle getBoundingRectangle() {
        float[] fArray = this.getFloatArray(573911876);
        if (fArray != null) {
            float f;
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = fArray[3];
            if (f2 > f4) {
                f = f2;
                f2 = f4;
                f4 = f;
            }
            if (f3 > f5) {
                f = f3;
                f3 = f5;
                f5 = f;
            }
            int n = (int)f2;
            int n2 = (int)f3;
            int n3 = (int)f4 + (f4 - (float)((int)f4) > 0.0f ? 1 : 0);
            int n4 = (int)f5 + (f5 - (float)((int)f5) > 0.0f ? 1 : 0);
            this.BBox = new Rectangle(n, n2, n3 - n, n4 - n2);
        }
        if (this.currentLocation != null) {
            this.BBox.x += this.currentLocation.x;
            this.BBox.y += -this.currentLocation.y;
        }
        return this.BBox;
    }

    public void setType(int n, boolean bl) {
        if (bl) {
            this.FT = n;
        }
    }

    public void setFlag(int n, boolean bl) {
        if (this.flags == null) {
            this.flags = new boolean[32];
        }
        this.flags[n] = bl;
    }

    public boolean[] getFieldFlags() {
        if (this.flags == null) {
            this.flags = new boolean[32];
        }
        return this.flags;
    }

    public void setNormalOnState(String string) {
        this.normalOnState = string;
    }

    public boolean isAppearanceUsed() {
        return this.appearancesUsed;
    }

    public void setAppreancesUsed(boolean bl) {
        this.appearancesUsed = bl;
    }

    public void setAppearanceImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            bufferedImage = FormObject.getOpaqueImage();
        }
        switch (n) {
            case 20: {
                if (n2 == 7998) {
                    this.downOnImage = bufferedImage;
                    break;
                }
                if (n2 == 2045494) {
                    this.downOffImage = bufferedImage;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            case 30: {
                if (n2 == 7998) {
                    this.normalOnImage = bufferedImage;
                    break;
                }
                if (n2 == 2045494) {
                    this.normalOffImage = bufferedImage;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            case 34: {
                if (n2 == 7998) {
                    this.rolloverOnImage = bufferedImage;
                    break;
                }
                if (n2 == 2045494) {
                    this.rolloverOffImage = bufferedImage;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            default: {
                throw new RuntimeException("Unknown type use PdfDictionary.D, PdfDictionary.N or PdfDictionary.R");
            }
        }
        this.appearancesUsed = true;
    }

    public void setBorderColor(String string) {
        if (string != null) {
            this.getDictionary(7451).setFloatArray(4627, FormObject.generateFloatFromString(string));
        }
    }

    public void setBackgroundColor(String string) {
        if (string != null) {
            this.getDictionary(7451).setFloatArray(4631, FormObject.generateFloatFromString(string));
        }
    }

    private static float[] generateFloatFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[()] ,");
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            fArray[n] = Float.parseFloat(string2);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return fArray;
    }

    public void setNormalCaption(String string) {
        if (string != null) {
            this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(string));
        }
    }

    protected void setOffsetDownApp() {
        this.offsetDownIcon = true;
    }

    protected void setNoDownIcon() {
        this.noDownIcon = true;
    }

    protected void setInvertForDownIcon() {
        this.invertDownIcon = true;
    }

    public boolean hasNormalOff() {
        return this.normalOffImage != null;
    }

    public boolean hasRolloverOff() {
        return this.rolloverOffImage != null;
    }

    public boolean hasDownOff() {
        return this.downOffImage != null;
    }

    public boolean hasDownImage() {
        return this.downOnImage != null || this.hasDownOff();
    }

    public void overwriteWith(FormObject formObject) {
        if (formObject == null) {
            return;
        }
        if (formObject.parentRef != null) {
            this.parentRef = formObject.parentRef;
        }
        if (formObject.flags != null) {
            this.flags = (boolean[])formObject.flags.clone();
        }
        if (formObject.selectionIndices != null) {
            this.selectionIndices = (int[])formObject.selectionIndices.clone();
        }
        if (formObject.selectedItem != null) {
            this.selectedItem = formObject.selectedItem;
        }
        if (formObject.ref != null) {
            this.ref = formObject.ref;
        }
        if (formObject.textColor != null) {
            this.textColor = (float[])formObject.textColor.clone();
        }
        if (formObject.textFont != null) {
            this.textFont = formObject.textFont;
        }
        if (formObject.textSize != -1) {
            this.textSize = formObject.textSize;
        }
        if (formObject.textString != null) {
            this.textString = formObject.textString;
        }
        if (formObject.appearancesUsed) {
            this.appearancesUsed = formObject.appearancesUsed;
        }
        if (formObject.offsetDownIcon) {
            this.offsetDownIcon = formObject.offsetDownIcon;
        }
        if (formObject.noDownIcon) {
            this.noDownIcon = formObject.noDownIcon;
        }
        if (formObject.invertDownIcon) {
            this.invertDownIcon = formObject.invertDownIcon;
        }
        if (formObject.normalOffImage != null) {
            this.normalOffImage = formObject.normalOffImage;
        }
        if (formObject.normalOnImage != null) {
            this.normalOnImage = formObject.normalOnImage;
        }
        if (formObject.rolloverOffImage != null) {
            this.rolloverOffImage = formObject.rolloverOffImage;
        }
        if (formObject.rolloverOnImage != null) {
            this.rolloverOnImage = formObject.rolloverOnImage;
        }
        if (formObject.downOffImage != null) {
            this.downOffImage = formObject.downOffImage;
        }
        if (formObject.downOnImage != null) {
            this.downOnImage = formObject.downOnImage;
        }
        if (formObject.pageNumber != -1) {
            this.pageNumber = formObject.pageNumber;
        }
        if (formObject.cColor != null) {
            this.cColor = formObject.cColor;
        }
        if (formObject.contents != null) {
            this.contents = formObject.contents;
        }
        if (formObject.show) {
            this.show = formObject.show;
        }
        this.AA = formObject.AA;
        this.AP = formObject.AP;
        this.BS = formObject.BS;
        this.D = formObject.D;
        this.OC = formObject.OC;
        this.C = formObject.C == null ? null : (float[])formObject.C.clone();
        this.QuadPoints = formObject.QuadPoints == null ? null : (float[])formObject.QuadPoints.clone();
        this.InkList = formObject.InkList == null ? null : (Object[])formObject.InkList.clone();
        this.F = formObject.F;
        this.Ff = formObject.Ff;
        this.CO = formObject.CO == null ? null : (Object[])formObject.CO.clone();
        this.Opt = formObject.Opt == null ? null : (Object[])formObject.Opt.clone();
        this.Q = formObject.Q;
        this.MaxLen = formObject.MaxLen;
        this.FT = formObject.FT;
        this.rawAS = formObject.rawAS == null ? null : (byte[])formObject.rawAS.clone();
        this.rawDA = formObject.rawDA == null ? null : (byte[])formObject.rawDA.clone();
        this.rawDV = formObject.rawDV == null ? null : (byte[])formObject.rawDV.clone();
        this.rawJS = formObject.rawJS == null ? null : (byte[])formObject.rawJS.clone();
        this.rawNM = formObject.rawNM == null ? null : (byte[])formObject.rawNM.clone();
        this.rawTM = formObject.rawTM == null ? null : (byte[])formObject.rawTM.clone();
        this.rawTU = formObject.rawTU == null ? null : (byte[])formObject.rawTU.clone();
        this.rawV = formObject.rawV == null ? null : (byte[])formObject.rawV.clone();
        this.T = formObject.T;
        this.rawT = formObject.rawT == null ? null : (byte[])formObject.rawT.clone();
        this.Rect = formObject.Rect == null ? null : (float[])formObject.Rect.clone();
        this.TI = formObject.TI;
        this.MK = formObject.MK == null ? null : (PdfObject)formObject.MK.clone();
        this.setSelected(formObject.isSelected);
    }

    public boolean[] getCharacteristics() {
        if (this.Farray == null) {
            this.Farray = this.F == -1 ? new boolean[10] : FormObject.calcFarray(this.F);
        }
        return this.Farray;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public Map getValuesMap(boolean bl) {
        Object[] objectArray;
        if (this.Opt != null && this.OptValues == null && (objectArray = this.getObjectArray(2048068)) != null) {
            for (Object object : objectArray) {
                String string;
                String string2;
                if (!(object instanceof Object[])) continue;
                Object[] objectArray2 = (Object[])object;
                if (bl) {
                    string2 = StringUtils.getTextString((byte[])objectArray2[0], false);
                    string = StringUtils.getTextString((byte[])objectArray2[1], false);
                } else {
                    string2 = StringUtils.getTextString((byte[])objectArray2[1], false);
                    string = StringUtils.getTextString((byte[])objectArray2[0], false);
                }
                if (this.OptValues == null) {
                    this.OptValues = new HashMap();
                }
                this.OptValues.put(string2, string);
            }
        }
        if (this.OptValues == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.OptValues);
    }

    public String[] getItemsList() {
        Object[] objectArray;
        if (this.OptString == null && (objectArray = this.getObjectArray(2048068)) != null) {
            int n = objectArray.length;
            this.OptString = new String[n];
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] instanceof Object[]) {
                    Object[] objectArray2 = (Object[])objectArray[i];
                    this.OptString[i] = StringUtils.getTextString((byte[])objectArray2[1], false);
                    continue;
                }
                if (!(objectArray[i] instanceof byte[])) continue;
                this.OptString[i] = StringUtils.getTextString((byte[])objectArray[i], false);
            }
        }
        return this.OptString;
    }

    public String getSelectedItem() {
        if (this.selectedItem == null) {
            this.selectedItem = this.getTextStreamValue(38);
        }
        if (this.selectedItem == null && this.selectionIndices != null) {
            String[] stringArray = this.getItemsList();
            int n = this.selectionIndices[0];
            if (stringArray != null && n > -1 && n < stringArray.length) {
                this.selectedItem = stringArray[n];
            }
        }
        return this.selectedItem;
    }

    public int[] getSelectionIndices() {
        if (this.selectionIndices == null && this.TI != -1) {
            this.selectionIndices = new int[1];
            this.selectionIndices[0] = this.TI;
            this.selectionIndex = this.TI;
        }
        return this.selectionIndices;
    }

    public String getTextString() {
        if (this.textString == null) {
            this.textString = this.getTextStreamValue(38);
        }
        if (this.textString == null && this.getTextStreamValue(5158) != null) {
            return this.getTextStreamValue(5158);
        }
        this.textString = this.textString != null ? this.textString.replaceAll("\r", "\n").trim() : "";
        return this.textString;
    }

    public int getTextPosition() {
        return this.getDictionary(7451).getInt(9248);
    }

    public String getNormalOnState() {
        return this.normalOnState;
    }

    public BufferedImage getNormalOffImage() {
        return this.normalOffImage;
    }

    public BufferedImage getNormalOnImage() {
        return this.normalOnImage;
    }

    public BufferedImage getAPImage(int n, int n2) {
        BufferedImage bufferedImage = null;
        block0 : switch (n) {
            case 7998: {
                switch (n2) {
                    case 20: {
                        bufferedImage = this.downOnImage;
                        break;
                    }
                    case 30: {
                        bufferedImage = this.normalOnImage;
                        break;
                    }
                    case 34: {
                        bufferedImage = this.rolloverOnImage;
                    }
                }
                break;
            }
            case 2045494: {
                switch (n2) {
                    case 20: {
                        bufferedImage = this.downOffImage;
                        break block0;
                    }
                    case 30: {
                        bufferedImage = this.normalOffImage;
                        break block0;
                    }
                    case 34: {
                        bufferedImage = this.rolloverOffImage;
                    }
                }
            }
        }
        return bufferedImage;
    }

    public boolean hasNoDownIcon() {
        return this.noDownIcon;
    }

    public boolean hasOffsetDownIcon() {
        return this.offsetDownIcon;
    }

    public boolean hasInvertDownIcon() {
        return this.invertDownIcon;
    }

    public BufferedImage getDownOffImage() {
        return this.downOffImage;
    }

    public BufferedImage getDownOnImage() {
        return this.downOnImage;
    }

    public BufferedImage getRolloverOffImage() {
        return this.rolloverOffImage;
    }

    public BufferedImage getRolloverOnImage() {
        return this.rolloverOnImage;
    }

    public Font getTextFont() {
        if (this.textFont == null) {
            this.textFont = new Font("Arial", 0, 8);
        }
        return this.textFont;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Color getTextColor() {
        return FormObject.generateColor(this.textColor);
    }

    public String getLayerName() {
        PdfObject pdfObject;
        if (this.layerName == null && (pdfObject = this.getDictionary(7955)) != null) {
            this.layerName = pdfObject.getName(506543413);
        }
        return this.layerName;
    }

    public String getValue() {
        int n = this.getParameterConstant(1147962727);
        switch (n) {
            case 9288: {
                return this.getTextString();
            }
            case 4920: {
                if (this.selectedItem == null) {
                    this.selectedItem = this.getTextStreamValue(38);
                }
                return this.selectedItem;
            }
            case 1197118: {
                return this.getDictionary(7451).getTextStreamValue(4881);
            }
            case 2308407: {
                return this.getDictionary(7451).getTextStreamValue(4881);
            }
        }
        return this.getDictionary(7451).getTextStreamValue(4881);
    }

    public void setValue(String string) {
        int n = this.getParameterConstant(1147962727);
        switch (n) {
            case 9288: {
                String string2 = this.getTextStreamValue(38);
                if (string2 != null && string2.equals(string) || this.textString != null && this.textString.equals(string)) break;
                if (string == null) {
                    string = "";
                }
                this.textString = string;
                break;
            }
            case 4920: {
                if (this.selectedItem == null) {
                    this.selectedItem = this.getTextStreamValue(38);
                }
                if (this.selectedItem != null && this.selectedItem.equals(string)) break;
                this.selectedItem = string;
                break;
            }
            case 1197118: {
                String string3 = this.getDictionary(7451).getTextStreamValue(4881);
                if (string3 != null && string3.equals(string)) break;
                this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(string));
                break;
            }
            default: {
                String string4 = this.getDictionary(7451).getTextStreamValue(4881);
                if (string4 != null && string4.equals(string)) break;
                this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(string));
            }
        }
    }

    public void setLineWidth(int n) {
        if (this.BS == null) {
            this.BS = new FormObject();
        }
        this.BS.setIntNumber(39, n);
    }

    public void setBorderWidth(int n) {
        this.setLineWidth(n);
    }

    public void setUserSetOffset(Point point) {
        if (this.currentLocation == null) {
            this.currentLocation = new Point();
        }
        this.currentLocation.x = (int)((float)point.x / this.currentScaling);
        this.currentLocation.y = (int)((float)point.y / this.currentScaling);
    }

    public void setCurrentScaling(float f) {
        this.currentScaling = f;
    }

    public float getCurrentScaling() {
        return this.currentScaling;
    }

    public String buttonGetCaption() {
        return this.buttonGetCaption(0);
    }

    public String buttonGetCaption(int n) {
        switch (n) {
            case 1: {
                return this.getDictionary(7451).getTextStreamValue(4371);
            }
            case 2: {
                return this.getDictionary(7451).getTextStreamValue(8723);
            }
        }
        return this.getDictionary(7451).getTextStreamValue(4881);
    }

    public void buttonSetCaption(String string) {
        this.buttonSetCaption(string, 0);
    }

    public void buttonSetCaption(String string, int n) {
        switch (n) {
            case 1: {
                this.getDictionary(7451).setTextStreamValue(4371, StringUtils.toBytes(string));
                break;
            }
            case 2: {
                this.getDictionary(7451).setTextStreamValue(8723, StringUtils.toBytes(string));
                break;
            }
            default: {
                this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(string));
            }
        }
    }

    public Object getfillColor() {
        return FormObject.generateColor(this.getDictionary(7451).getFloatArray(4631));
    }

    public void setfillColor(float[] fArray) {
        if (fArray != null) {
            if (fArray.length > 0 && Float.isNaN(fArray[0])) {
                float[] fArray2 = new float[fArray.length - 1];
                System.arraycopy(fArray, 1, fArray2, 0, fArray.length - 1);
                fArray = fArray2;
            }
            this.getDictionary(7451).setFloatArray(4631, fArray);
        }
    }

    public void setfillColor(Object object) {
        if (object != null) {
            float[] fArray = DisplayJavascriptActions.convertToColorFloatArray((String)object);
            this.getDictionary(7451).setFloatArray(4631, fArray);
        }
    }

    public void setFormType(int n) {
        this.formType = n;
    }

    public int getFormType() {
        return this.formType;
    }

    public static BufferedImage getOpaqueImage() {
        return new BufferedImage(20, 20, 2);
    }

    public void setGUIComponent(Object object, int n) {
        this.guiComp = object;
        this.guiType = n;
    }

    public Object getGUIComponent() {
        return this.guiComp;
    }

    public boolean isReadOnly() {
        boolean bl = false;
        boolean[] blArray = this.getFieldFlags();
        boolean[] blArray2 = this.getCharacteristics();
        if (blArray != null && blArray[1] || blArray2 != null && blArray2[9]) {
            bl = true;
        }
        return bl;
    }

    public void updateValue(Object object, boolean bl, boolean bl2) {
        if (this.isReadOnly()) {
            return;
        }
        if (GenericFormFactory.isTextForm(this.formType)) {
            this.textString = (String)object;
            if (this.textString != null && this.textString.equals(this.lastTextString)) {
                bl2 = false;
            }
            this.lastTextString = this.textString;
        } else {
            this.textString = (String)object;
            this.isSelected = bl;
            if (bl != this.lastIsSelected && this.lastTextString != null && this.textString != null && this.textString.equals(this.lastTextString)) {
                bl2 = false;
            }
            this.lastTextString = this.textString;
            this.lastIsSelected = bl;
        }
        if (bl2 && this.guiType != 2 && this.guiComp != null) {
            this.syncGUI(object);
        }
    }

    private void syncGUI(final Object object) {
        if (this.guiType == 1) {
            if (SwingUtilities.isEventDispatchThread()) {
                FormObject.setGUI(this.formType, object, this.guiComp, this.guiType);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FormObject.setGUI(FormObject.this.formType, object, FormObject.this.guiComp, FormObject.this.guiType);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else if (this.guiType == 5) {
            FormObject.setGUI(this.formType, object, this.guiComp, this.guiType);
        }
    }

    private static void setGUI(int n, Object object, Object object2, int n2) {
        try {
            if (n2 == 5) {
                if (fxSupport != null) {
                    fxSupport.renderGUIComponent(n, object, object2, n2);
                }
            } else if (n2 == 1) {
                if (GenericFormFactory.isTextForm(n)) {
                    ((JTextComponent)object2).setText((String)object);
                } else if (n == 9) {
                    ((JCheckBox)object2).setSelected(Boolean.valueOf((String)object));
                } else if (GenericFormFactory.isButtonForm(n)) {
                    ((JRadioButton)object2).setText((String)object);
                    ((JRadioButton)object2).setSelected(Boolean.valueOf((String)object));
                } else if (n == 10 && object2 instanceof JButton) {
                    ((JButton)object2).setSelected(Boolean.valueOf((String)object));
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception);
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        if (this.guiComp != null) {
            this.syncGUI(bl);
        }
    }

    public int getSelectedIndex() {
        return this.selectionIndex;
    }

    public void setSelectedIndex(int n) {
        if (n != this.selectionIndex) {
            this.selectionIndex = n;
            this.selectionIndices = new int[1];
            this.selectionIndices[0] = n;
            if (this.guiComp != null) {
                if (this.guiType == 5) {
                    if (fxSupport != null) {
                        this.selectedItem = JavaFXSupport.getSelectedItem(this.guiComp, this.formType);
                    }
                } else if (SwingUtilities.isEventDispatchThread()) {
                    if (this.formType == 2) {
                        ((JComboBox)this.guiComp).setSelectedIndex(this.selectionIndex);
                        this.selectedItem = (String)((JComboBox)this.guiComp).getSelectedItem();
                    } else {
                        ((JList)this.guiComp).setSelectedIndex(this.selectionIndex);
                        this.selectedItem = (String)((JList)this.guiComp).getSelectedValue();
                    }
                } else {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (FormObject.this.formType == 2) {
                                ((JComboBox)FormObject.this.guiComp).setSelectedIndex(FormObject.this.selectionIndex);
                                FormObject.this.selectedItem = (String)((JComboBox)FormObject.this.guiComp).getSelectedItem();
                            } else {
                                ((JList)FormObject.this.guiComp).setSelectedIndex(FormObject.this.selectionIndex);
                                FormObject.this.selectedItem = (String)((JList)FormObject.this.guiComp).getSelectedValue();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
    }

    public void setSelectedItem(String string) {
        this.selectedItem = string;
        if (this.guiComp != null) {
            this.updateCombo();
        }
    }

    private void updateCombo() {
        if (this.formType == 2 || this.formType == 1) {
            if (this.guiType == 5) {
                if (fxSupport != null) {
                    JavaFXSupport.select(this.guiComp, this.selectedItem, this.formType);
                }
            } else if (SwingUtilities.isEventDispatchThread()) {
                if (this.formType == 2) {
                    ((JComboBox)this.guiComp).setSelectedItem(this.selectedItem);
                } else {
                    ((JList)this.guiComp).setSelectedValue(this.selectedItem, true);
                }
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (FormObject.this.formType == 2) {
                            ((JComboBox)FormObject.this.guiComp).setSelectedItem(FormObject.this.selectedItem);
                        } else {
                            ((JList)FormObject.this.guiComp).setSelectedValue(FormObject.this.selectedItem, true);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        } else {
            throw new RuntimeException("Unexpected type must be FormFactory.combobox or FormFactory.list");
        }
    }

    public float getFontSize() {
        return 12.0f;
    }

    public Object getFormValue() {
        Object object;
        switch (this.formType) {
            case 9: {
                object = this.isSelected;
                break;
            }
            case 2: {
                object = this.isSelected;
                break;
            }
            case 1: {
                object = this.selectedValues;
                break;
            }
            case 8: {
                object = this.isSelected;
                break;
            }
            default: {
                object = this.getTextString();
            }
        }
        return object;
    }

    public String getLastValidValue() {
        return this.validValue;
    }

    public void setLastValidValue(String string) {
        this.validValue = string;
    }

    public void setPageRotation(int n) {
        this.rawRotation = n;
    }

    public void setVisible(boolean bl) {
        if (this.guiComp != null) {
            if (this.guiType == 5) {
                if (fxSupport != null) {
                    JavaFXSupport.setVisible(this.guiComp, bl);
                }
            } else {
                ((JComponent)this.guiComp).setVisible(bl);
            }
        }
    }

    public int getRotationOriginX() {
        return this.rotationOriginX;
    }

    public void setRotationOriginX(int n) {
        this.rotationOriginX = n;
    }

    public int getRotationOriginY() {
        return this.rotationOriginY;
    }

    public void setRotationOriginY(int n) {
        this.rotationOriginY = n;
    }

    public int getElemRotationDegree() {
        return this.elemRotationDegree;
    }

    public void setElemRotationDegree(int n) {
        this.elemRotationDegree = n;
    }

    public void setMatteBorderDetails(int[] nArray) {
        this.matteDetails = nArray;
    }

    public int[] getMatteBorderDetails() {
        return this.matteDetails;
    }
}

