/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.Shape;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class PdfObject
implements Cloneable {
    protected boolean maybeIndirect;
    protected boolean isFullyResolved = true;
    protected boolean isDataExternal;
    private boolean streamMayBeCorrupt;
    Shape clip;
    byte[] convertedData;
    public static final int DECODED = 0;
    public static final int UNDECODED_REF = 1;
    public static final int UNDECODED_DIRECT = 2;
    private int status;
    byte[] unresolvedData;
    final Map otherValues = new HashMap();
    protected int pageNumber = -1;
    int PDFkeyInt = -1;
    int objType = -1;
    private int id = -1;
    protected int colorspace = -1;
    protected int subtype = -1;
    protected int type = -1;
    private int BitsPerComponent = -1;
    private int BitsPerCoordinate = -1;
    private int BitsPerFlag = -1;
    private int Count;
    private int FormType = -1;
    private int Length = -1;
    private int Length1 = -1;
    private int Length2 = -1;
    private int Length3 = -1;
    private int Rotate = -1;
    private int verticesPerRow = -1;
    private float[] ArtBox;
    private float[] BBox;
    private float[] BleedBox;
    private float[] CropBox;
    private float[] Decode;
    private float[] Domain;
    private float[] Matrix;
    private float[] Matte;
    private float[] MediaBox;
    private float[] Range;
    private float[] TrimBox;
    protected PdfObject ColorSpace;
    protected PdfObject DecodeParms;
    protected PdfObject Encoding;
    protected PdfObject Function;
    protected PdfObject Resources;
    protected PdfObject Shading;
    protected PdfObject SMask;
    private boolean ignoreRecursion;
    private boolean ignoreStream;
    protected boolean isZapfDingbats;
    protected boolean isSymbol;
    private boolean isCompressedStream;
    protected int generalType = -1;
    private String generalTypeAsString;
    protected boolean includeParent;
    private String Creator;
    private String Parent;
    private String Name;
    private String S;
    private String Title;
    private byte[] rawCreator;
    private byte[] rawParent;
    private byte[] rawName;
    private byte[] rawS;
    private byte[] rawTitle;
    public static final boolean debug = false;
    protected String ref;
    int intRef;
    int gen;
    protected boolean hasStream;
    public byte[] stream;
    private byte[] DecodedStream;
    private long startStreamOnDisk = -1L;
    private PdfFileReader objReader;
    private String cacheName;
    private byte[][] Filter;
    private byte[][] TR;
    private byte[][] keys;
    private byte[][] values;
    private Object[] DecodeParmsAsArray;
    private PdfObject[] objs;
    protected Object currentKey;
    protected int parentType = -1;
    private boolean isInCompressedStream;
    private static int newXFAFormID = 1;

    protected void setInternalReference() {
        this.ref = newXFAFormID++ + " 0 X";
    }

    protected PdfObject() {
    }

    public PdfObject(int n, int n2) {
        this.setRef(n, n2);
    }

    public void setRef(int n, int n2) {
        this.intRef = n;
        this.gen = n2;
        this.ref = null;
    }

    public String getCacheName(PdfFileReader pdfFileReader) {
        if (this.isCached()) {
            this.cacheName = null;
            this.getCachedStreamFile(pdfFileReader);
        }
        return this.cacheName;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public PdfObject(String string) {
        this.ref = string;
    }

    public PdfObject(int n) {
        this.generalType = n;
    }

    protected static boolean[] deepCopy(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, n);
        return blArray2;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getUnresolvedData() {
        return this.unresolvedData;
    }

    public int getPDFkeyInt() {
        return this.PDFkeyInt;
    }

    public void setUnresolvedData(byte[] byArray, int n) {
        this.unresolvedData = byArray;
        this.PDFkeyInt = n;
    }

    public void setStatus(int n) {
        this.status = n;
        this.unresolvedData = null;
    }

    protected static float[] deepCopy(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        return fArray2;
    }

    protected static double[] deepCopy(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    protected static int[] deepCopy(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    protected static byte[][] deepCopy(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][] byArrayArray = new byte[n][];
        System.arraycopy(byArray, 0, byArrayArray, 0, n);
        return byArrayArray;
    }

    public PdfObject getDictionary(int n) {
        switch (n) {
            case 2087749783: {
                return this.ColorSpace;
            }
            case 1888135062: {
                return this.DecodeParms;
            }
            case 1518239089: {
                return this.Function;
            }
            case 2004251818: {
                return this.Resources;
            }
            case 878474856: {
                return this.Shading;
            }
            case 489767774: {
                return this.SMask;
            }
        }
        return null;
    }

    public int getGeneralType(int n) {
        if (n == 1232564598 && this.isZapfDingbats) {
            return 5;
        }
        if (n == 1232564598 && this.isSymbol) {
            return 4;
        }
        if (n == 608780341) {
            return this.objType;
        }
        return this.generalType;
    }

    public String getGeneralStringValue() {
        return this.generalTypeAsString;
    }

    public void setGeneralStringValue(String string) {
        this.generalTypeAsString = string;
    }

    public void setIntNumber(int n, int n2) {
        switch (n) {
            case -1344207655: {
                this.BitsPerComponent = n2;
                break;
            }
            case -335950113: {
                this.BitsPerCoordinate = n2;
                break;
            }
            case 1500422077: {
                this.BitsPerFlag = n2;
                break;
            }
            case 1061502502: {
                this.Count = n2;
                break;
            }
            case 982024818: {
                this.FormType = n2;
                break;
            }
            case 1043816557: {
                this.Length = n2;
                break;
            }
            case 929066303: {
                this.Length1 = n2;
                break;
            }
            case 929066304: {
                this.Length2 = n2;
                break;
            }
            case 929066305: {
                this.Length3 = n2;
                break;
            }
            case 1144088180: {
                this.Rotate = n2;
                break;
            }
            case -1180057884: {
                this.verticesPerRow = n2;
                break;
            }
        }
    }

    public void setFloatNumber(int n, float f) {
        switch (n) {
            default: 
        }
    }

    public int getInt(int n) {
        switch (n) {
            case -1344207655: {
                return this.BitsPerComponent;
            }
            case -335950113: {
                return this.BitsPerCoordinate;
            }
            case 1500422077: {
                return this.BitsPerFlag;
            }
            case 1061502502: {
                return this.Count;
            }
            case 982024818: {
                return this.FormType;
            }
            case 1043816557: {
                return this.Length;
            }
            case 929066303: {
                return this.Length1;
            }
            case 929066304: {
                return this.Length2;
            }
            case 929066305: {
                return this.Length3;
            }
            case 1144088180: {
                return this.Rotate;
            }
            case -1180057884: {
                return this.verticesPerRow;
            }
        }
        return -1;
    }

    public float getFloatNumber(int n) {
        switch (n) {
            default: 
        }
        return -1.0f;
    }

    public boolean getBoolean(int n) {
        switch (n) {
            default: 
        }
        return false;
    }

    public void setBoolean(int n, boolean bl) {
        switch (n) {
            default: 
        }
    }

    public void setDictionary(int n, PdfObject pdfObject) {
        if (pdfObject != null) {
            pdfObject.id = n;
        }
        switch (n) {
            case 2087749783: {
                this.ColorSpace = pdfObject;
                break;
            }
            case 1888135062: {
                this.DecodeParms = pdfObject;
                break;
            }
            case 1518239089: {
                this.Function = pdfObject;
                break;
            }
            case 2004251818: {
                this.Resources = pdfObject;
                break;
            }
            case 878474856: {
                this.Shading = pdfObject;
                break;
            }
            case 489767774: {
                this.SMask = pdfObject;
                break;
            }
            default: {
                this.setOtherValues(pdfObject);
            }
        }
    }

    protected void setOtherValues(PdfObject pdfObject) {
        if (this.objType == 373244477 || this.objType == 487790868 || this.currentKey != null) {
            this.otherValues.put(this.currentKey, pdfObject);
            this.currentKey = null;
        }
    }

    public void setID(int n) {
        this.id = n;
    }

    public int getID() {
        return this.id;
    }

    public int getParentID() {
        return this.parentType;
    }

    public boolean hasStream() {
        return this.hasStream;
    }

    public int setConstant(int n, int n2, int n3, byte[] byArray) {
        int n4 = 0;
        int n5 = 0;
        try {
            for (int i = n3 - 1; i > -1; --i) {
                int n6 = byArray[n2 + i];
                n4 += (n6 -= 48) << n5;
                n5 += 8;
            }
            switch (n4) {
                default: 
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        return n4;
    }

    public int getParameterConstant(int n) {
        switch (n) {
            case 2087749783: {
                return this.colorspace;
            }
            case 1147962727: {
                return this.subtype;
            }
            case 608780341: {
                return this.type;
            }
        }
        return -1;
    }

    public int setConstant(int n, int n2) {
        int n3 = n2;
        switch (n2) {
            case -1044665361: {
                n3 = 373243460;
            }
        }
        switch (n) {
            case 2087749783: {
                this.colorspace = n3;
                break;
            }
            case 1147962727: {
                this.subtype = n3;
                break;
            }
            case 608780341: {
                this.type = n3;
            }
        }
        return n3;
    }

    public float[] getFloatArray(int n) {
        float[] fArray = null;
        switch (n) {
            case 1142050954: {
                return PdfObject.deepCopy(this.ArtBox);
            }
            case 303185736: {
                return PdfObject.deepCopy(this.BBox);
            }
            case 1179546749: {
                return PdfObject.deepCopy(this.BleedBox);
            }
            case 1076199815: {
                return PdfObject.deepCopy(this.CropBox);
            }
            case 859785322: {
                return PdfObject.deepCopy(this.Decode);
            }
            case 1026641277: {
                return PdfObject.deepCopy(this.Domain);
            }
            case 1145198201: {
                return PdfObject.deepCopy(this.Matrix);
            }
            case 826557522: {
                return PdfObject.deepCopy(this.Matte);
            }
            case 1313305473: {
                return PdfObject.deepCopy(this.MediaBox);
            }
            case 826160983: {
                return PdfObject.deepCopy(this.Range);
            }
            case 1026982273: {
                return PdfObject.deepCopy(this.TrimBox);
            }
        }
        return PdfObject.deepCopy(fArray);
    }

    public byte[][] getKeyArray(int n) {
        switch (n) {
            default: 
        }
        return null;
    }

    public double[] getDoubleArray(int n) {
        double[] dArray = null;
        switch (n) {
            default: 
        }
        return PdfObject.deepCopy(dArray);
    }

    public boolean[] getBooleanArray(int n) {
        boolean[] blArray = null;
        switch (n) {
            default: 
        }
        return PdfObject.deepCopy(blArray);
    }

    public int[] getIntArray(int n) {
        int[] nArray = null;
        switch (n) {
            default: 
        }
        return PdfObject.deepCopy(nArray);
    }

    public void setFloatArray(int n, float[] fArray) {
        switch (n) {
            case 1142050954: {
                this.ArtBox = fArray;
                break;
            }
            case 303185736: {
                this.BBox = fArray;
                break;
            }
            case 1179546749: {
                this.BleedBox = fArray;
                break;
            }
            case 1076199815: {
                this.CropBox = fArray;
                break;
            }
            case 859785322: {
                this.Decode = PdfObject.ignoreIdentity(fArray);
                break;
            }
            case 1026641277: {
                this.Domain = fArray;
                break;
            }
            case 1145198201: {
                this.Matrix = fArray;
                break;
            }
            case 826557522: {
                this.Matte = fArray;
                break;
            }
            case 1313305473: {
                this.MediaBox = fArray;
                break;
            }
            case 826160983: {
                this.Range = fArray;
                break;
            }
            case 1026982273: {
                this.TrimBox = fArray;
                break;
            }
        }
    }

    private static float[] ignoreIdentity(float[] fArray) {
        boolean bl = true;
        if (fArray != null) {
            int n = fArray.length;
            for (int i = 0; i < n; i += 2) {
                if (fArray[i] == 0.0f && fArray[i + 1] == 1.0f) continue;
                bl = false;
                i = n;
            }
        }
        if (bl) {
            return null;
        }
        return fArray;
    }

    public void setIntArray(int n, int[] nArray) {
        switch (n) {
            default: 
        }
    }

    public void setBooleanArray(int n, boolean[] blArray) {
        switch (n) {
            default: 
        }
    }

    public void setDoubleArray(int n, double[] dArray) {
        switch (n) {
            default: 
        }
    }

    public void setMixedArray(int n, byte[][] byArray) {
        switch (n) {
            case 1011108731: {
                this.Filter = byArray;
                break;
            }
        }
    }

    public String getStringValue(int n, int n2) {
        byte[] byArray = null;
        switch (n) {
            case 506543413: {
                byArray = this.rawName;
            }
        }
        switch (n2) {
            case 0: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 1: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 2: {
                if (byArray != null) {
                    int n3 = byArray.length;
                    if (n3 > 6 && byArray[6] == 43) {
                        int n4 = n3 - 7;
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 7, byArray2, 0, n4);
                        return new String(byArray2);
                    }
                    return new String(byArray);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getName(int,mode)");
    }

    public int getNameAsConstant(int n) {
        return -1;
    }

    public String getName(int n) {
        String string = null;
        switch (n) {
            case 506543413: {
                if (this.Name == null && this.rawName != null) {
                    this.Name = new String(this.rawName);
                }
                return this.Name;
            }
            case 35: {
                if (this.S == null && this.rawS != null) {
                    this.S = new String(this.rawS);
                }
                return this.S;
            }
        }
        return string;
    }

    public String getStringKey(int n) {
        String string = null;
        switch (n) {
            case 1110793845: {
                if (this.Parent == null && this.rawParent != null) {
                    this.Parent = new String(this.rawParent);
                }
                return this.Parent;
            }
        }
        return string;
    }

    public String getTextStreamValue(int n) {
        String string = null;
        switch (n) {
            case 827818359: {
                if (this.Creator == null && this.rawCreator != null) {
                    this.Creator = StringUtils.getTextString(this.rawCreator, false);
                }
                return this.Creator;
            }
            case 506543413: {
                if (this.Name == null && this.rawName != null) {
                    this.Name = StringUtils.getTextString(this.rawName, false);
                }
                return this.Name;
            }
            case 960773209: {
                if (this.Title == null && this.rawTitle != null) {
                    this.Title = StringUtils.getTextString(this.rawTitle, false);
                }
                return this.Title;
            }
        }
        return string;
    }

    public void setName(int n, byte[] byArray) {
        switch (n) {
            case 506543413: {
                this.rawName = byArray;
                break;
            }
            case 35: {
                this.rawS = byArray;
                break;
            }
            case 1110793845: {
                if (!this.includeParent) break;
                this.rawParent = byArray;
                break;
            }
            default: {
                if (this.objType != 487790868) break;
                this.otherValues.put(this.currentKey, byArray);
            }
        }
    }

    public void setName(Object object, String string) {
        this.otherValues.put(object, string);
    }

    public void setStringKey(int n, byte[] byArray) {
        switch (n) {
            case 1110793845: {
                this.rawParent = byArray;
                break;
            }
        }
    }

    public void setTextStreamValue(int n, byte[] byArray) {
        switch (n) {
            case 827818359: {
                this.rawCreator = byArray;
                break;
            }
            case 506543413: {
                this.rawName = byArray;
                break;
            }
            case 960773209: {
                this.rawTitle = byArray;
                break;
            }
        }
    }

    public byte[] getDecodedStream() {
        if (this.isCached()) {
            byte[] byArray = null;
            try {
                File file = new File(this.getCachedStreamFile(this.objReader));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = new byte[(int)file.length()];
                bufferedInputStream.read(byArray);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            return byArray;
        }
        return this.DecodedStream;
    }

    public void setStream(byte[] byArray) {
        this.stream = byArray;
        if (this.getObjectType() == 2087749783) {
            this.hasStream = true;
        }
    }

    public void setDecodedStream(byte[] byArray) {
        this.DecodedStream = byArray;
    }

    public String getObjectRefAsString() {
        if (this.ref == null) {
            this.ref = this.intRef + " " + this.gen + " R";
        }
        return this.ref;
    }

    public int getObjectRefID() {
        if (this.intRef == 0 && this.ref != null && !this.ref.contains("[")) {
            try {
                byte[] byArray = this.ref.getBytes();
                int n = 0;
                while (byArray[n] == 91 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                    ++n;
                }
                int n2 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                this.intRef = NumberUtils.parseInt(n2, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                    ++n;
                }
                n2 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                this.gen = NumberUtils.parseInt(n2, n, byArray);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        return this.intRef;
    }

    public int getObjectRefGeneration() {
        return this.gen;
    }

    public PdfArrayIterator getMixedArray(int n) {
        switch (n) {
            case 1011108731: {
                return new PdfArrayIterator(this.Filter);
            }
        }
        return null;
    }

    public void setDictionaryPairs(byte[][] byArray, byte[][] byArray2, PdfObject[] pdfObjectArray) {
        this.keys = byArray;
        this.values = byArray2;
        this.objs = pdfObjectArray;
    }

    public PdfKeyPairsIterator getKeyPairsIterator() {
        return new PdfKeyPairsIterator(this.keys, this.values, this.objs);
    }

    public void setKeyArray(int n, byte[][] byArray) {
        switch (n) {
            default: 
        }
    }

    public void setStringArray(int n, byte[][] byArray) {
        switch (n) {
            case 9250: {
                this.TR = byArray;
                break;
            }
        }
    }

    public byte[][] getStringArray(int n) {
        switch (n) {
            case 9250: {
                return PdfObject.deepCopy(this.TR);
            }
        }
        return null;
    }

    public Object[] getObjectArray(int n) {
        switch (n) {
            case 1888135062: {
                return this.DecodeParmsAsArray;
            }
        }
        return null;
    }

    public void setObjectArray(int n, Object[] objectArray) {
        switch (n) {
            case 1888135062: {
                this.DecodeParmsAsArray = objectArray;
                break;
            }
        }
    }

    public PdfObject duplicate() {
        return new PdfObject();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            LogWriter.writeLog("Exception: " + cloneNotSupportedException.getMessage());
        }
        return object;
    }

    public boolean decompressStreamWhenRead() {
        return false;
    }

    public int getObjectType() {
        return this.objType;
    }

    public int getRawObjectType() {
        return this.objType;
    }

    public byte[] getStringValueAsByte(int n) {
        return null;
    }

    public boolean isCompressedStream() {
        return this.isCompressedStream;
    }

    public void setCompressedStream(boolean bl) {
        this.isCompressedStream = bl;
    }

    public boolean ignoreRecursion() {
        return this.ignoreRecursion;
    }

    public void ignoreRecursion(boolean bl) {
        this.ignoreRecursion = bl;
    }

    public byte[] getTextStreamValueAsByte(int n) {
        return null;
    }

    public byte[][] getByteArray(int n) {
        return null;
    }

    public void setTextStreamValue(int n, String string) {
    }

    public Map getOtherDictionaries() {
        return Collections.unmodifiableMap(this.otherValues);
    }

    public void setCurrentKey(Object object) {
        this.currentKey = object;
    }

    public String toString(float[] fArray, boolean bl) {
        if (fArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(this.pageNumber);
            stringBuilder.append(' ');
        }
        for (float f : fArray) {
            stringBuilder.append(f);
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public void setCache(long l, PdfFileReader pdfFileReader) {
        this.startStreamOnDisk = l;
        this.objReader = pdfFileReader;
    }

    public boolean isCached() {
        return this.startStreamOnDisk != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedStreamFile(PdfFileReader pdfFileReader) {
        File file = null;
        if (this.startStreamOnDisk != -1L) {
            try {
                file = File.createTempFile("jpedal-", ".bin", new File(ObjectStore.temp_dir));
                file.deleteOnExit();
                int n = this.getInt(1043816557);
                if (n == -1) {
                    pdfFileReader.spoolStreamDataToDisk(file, this.startStreamOnDisk);
                } else {
                    pdfFileReader.spoolStreamDataToDisk(file, this.startStreamOnDisk, n);
                }
                this.cacheName = file.getAbsolutePath();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            finally {
                if (file != null) {
                    file.deleteOnExit();
                }
            }
        }
        if (this.getObjectType() != 979194486) {
            pdfFileReader.readStream(this, true, true, false, this.getObjectType() == 1365674082, this.isCompressedStream, this.cacheName);
        }
        return this.cacheName;
    }

    public void setInCompressedStream(boolean bl) {
        this.isInCompressedStream = bl;
    }

    public boolean isInCompressedStream() {
        return this.isInCompressedStream;
    }

    public void maybeIndirect(boolean bl) {
        this.maybeIndirect = bl;
    }

    public boolean maybeIndirect() {
        return this.maybeIndirect;
    }

    public boolean isFullyResolved() {
        return this.isFullyResolved;
    }

    public void setFullyResolved(boolean bl) {
        this.isFullyResolved = bl;
    }

    public boolean isDataExternal() {
        return this.isDataExternal;
    }

    public void isDataExternal(boolean bl) {
        this.isDataExternal = bl;
    }

    public boolean ignoreStream() {
        return this.ignoreStream;
    }

    public void ignoreStream(boolean bl) {
        this.ignoreStream = bl;
    }

    public void setStreamMayBeCorrupt(boolean bl) {
        this.streamMayBeCorrupt = bl;
    }

    public boolean streamMayBeCorrupt() {
        return this.streamMayBeCorrupt;
    }

    public void moveCacheValues(PdfObject pdfObject) {
        this.startStreamOnDisk = pdfObject.startStreamOnDisk;
        pdfObject.startStreamOnDisk = -1L;
        this.cacheName = pdfObject.cacheName;
        pdfObject.cacheName = null;
    }

    public void setClip(Shape shape) {
        this.clip = shape;
    }

    public Shape getClip() {
        return this.clip;
    }

    public byte[] getConvertedData() {
        return this.convertedData;
    }

    public void setConvertedData(byte[] byArray) {
        this.convertedData = byArray;
    }
}

