/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.MCObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MarkedContentGenerator {
    private PdfObjectReader currentPdfFile;
    private DocumentBuilder db;
    private Document doc;
    private Element root;
    private final Map pageStreams = new HashMap();
    private PdfResources res;
    private PdfLayerList layers;
    private PdfPageData pdfPageData;
    private boolean isDecoding;
    static boolean debug;
    static String indent;
    final Map reverseLookup = new HashMap();
    boolean isHTML;

    public Document getMarkedContentTree(PdfResources pdfResources, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader) {
        PdfObject pdfObject = pdfResources.getPdfObject(3);
        this.res = pdfResources;
        this.layers = pdfResources.getPdfLayerList();
        this.pdfPageData = pdfPageData;
        this.currentPdfFile = pdfObjectReader;
        this.currentPdfFile.checkResolved(pdfObject);
        if (!this.isHTML) {
            boolean bl;
            this.setupTree();
            boolean bl2 = bl = pdfObject != null && pdfObject.getDictionary(1719112618) != null;
            if (debug) {
                System.out.println("hastree=" + bl);
            }
            if (bl) {
                this.buildTree(pdfObject);
                this.pageStreams.clear();
            } else {
                try {
                    this.decodePageForMarkedContent(1, null, this.doc);
                }
                catch (Exception exception) {
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return this.doc;
    }

    private void setupTree() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.db = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogWriter.writeLog("Exception: " + parserConfigurationException.getMessage());
        }
        this.doc = this.db.newDocument();
        this.doc.appendChild(this.doc.createComment(" Created from JPedal "));
        this.doc.appendChild(this.doc.createComment(" http://www.idrsolutions.com "));
    }

    private void buildTree(PdfObject pdfObject) {
        this.root = this.doc.createElement("TaggedPDF-doc");
        this.doc.appendChild(this.root);
        this.traverseContentTree(pdfObject, null);
    }

    public void traverseContentTree(PdfObject pdfObject, PdfStreamDecoder pdfStreamDecoder) {
        PdfObject pdfObject2 = pdfObject.getDictionary(27);
        if (pdfObject2 == null) {
            byte[][] byArray = pdfObject.getStringArray(27);
            if (debug) {
                System.out.println("Karray=");
            }
            this.readKarray(byArray, this.root, null, null, "");
            if (debug) {
                System.out.println("Karray read");
            }
        } else {
            if (debug) {
                System.out.println("read child=" + pdfObject2.getObjectRefAsString());
            }
            this.readChildNode(pdfObject2, this.root, null, "");
        }
    }

    private void readChildNode(PdfObject pdfObject, Element element, Map hashMap, String string) {
        PdfObject pdfObject2;
        if (debug) {
            indent = indent + "   ";
            System.out.println(indent + "read child node " + pdfObject.getObjectRefAsString() + ' ' + pdfObject.getInt(27));
        }
        byte[][] byArray = pdfObject.getStringArray(27);
        int n = pdfObject.getInt(27);
        PdfObject pdfObject3 = pdfObject.getDictionary(27);
        String string2 = pdfObject.getTextStreamValue(472989239);
        String string3 = pdfObject.getName(35);
        string = string + '.' + string3;
        Element element2 = null;
        if (debug) {
            System.out.println(indent + "S= " + string3 + ' ');
            if (string3 == null) {
                System.out.println("S is null in " + pdfObject.getObjectRefAsString());
            }
        }
        if (string3 != null) {
            if (string3.equals("Span")) {
                element2 = element;
            } else {
                if (this.doc != null) {
                    element2 = this.doc.createElement(MarkedContentGenerator.cleanName(string3));
                }
                if (string2 != null) {
                    element2.setAttribute("xml:lang", string2);
                }
                if (element != null) {
                    element.appendChild(element2);
                }
            }
        }
        if ((pdfObject2 = pdfObject.getDictionary(8247)) != null && hashMap == null && !this.isHTML) {
            if (debug) {
                System.out.println(indent + "decode page ");
            }
            hashMap = new HashMap();
            try {
                this.decodePageForMarkedContent(-1, pdfObject2, hashMap);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        if (debug) {
            System.out.println(indent + "page decoded karray" + Arrays.toString((Object[])byArray) + " Kdict=" + pdfObject3 + " kint=" + n);
        }
        if (byArray != null) {
            this.readKarray(byArray, element2, hashMap, string3, string);
        } else if (pdfObject3 != null) {
            this.readChildNode(pdfObject3, element2, hashMap, string);
        } else if (n != -1 && !this.isHTML) {
            this.addContentToNode(hashMap, String.valueOf(n), element2, string3, string);
        } else if (pdfObject.getTextStreamValue(36) == null && debug) {
            System.out.println("unimplemented " + pdfObject.getObjectRefAsString());
        }
        if (debug) {
            System.out.println(indent + "child node read " + pdfObject.getObjectRefAsString());
            indent = indent.substring(0, indent.length() - 3);
        }
    }

    private void addContentToNode(Map map, String string, Element element, String string2, String string3) {
        if (!this.isHTML) {
            String string4 = (String)map.get(string);
            if (string4 != null) {
                string4 = MarkedContentGenerator.handleXMLCharacters(string4);
                if (this.doc != null) {
                    Text text = this.doc.createTextNode(string4);
                    element.appendChild(text);
                }
            }
            if (debug) {
                System.out.println(indent + " added " + string4);
            }
        }
    }

    private static String handleXMLCharacters(String string) {
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&gt;", ">");
        return string;
    }

    private void readKarray(byte[][] byArray, Element element, Map map, String string, String string2) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = new String(byArray[i]);
            if (debug) {
                System.out.println(indent + "aK value=" + string3);
            }
            if (n - i >= 3) {
                byte[] byArray2 = byArray[i + 2];
                if (byArray2[0] == 82) {
                    MCObject mCObject = new MCObject(string3 + ' ' + new String(byArray[i + 1]) + " R");
                    this.currentPdfFile.readObject(mCObject);
                    this.readChildNode(mCObject, element, map, string2);
                    i += 2;
                    continue;
                }
                this.addContentToNode(map, string3, element, string, string2);
                continue;
            }
            if (this.isHTML && !this.reverseLookup.containsKey(string3)) {
                this.reverseLookup.put(string3, string2);
            }
            this.addContentToNode(map, string3, element, string, string2);
        }
    }

    private static String cleanName(String string) {
        StringBuilder stringBuilder = new StringBuilder(10);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            if (n2 == 35) {
                StringBuilder stringBuilder2 = new StringBuilder(2);
                for (int j = 0; j < 2; ++j) {
                    stringBuilder2.append(string.charAt(++i));
                }
                n2 = (char)Integer.parseInt(stringBuilder2.toString(), 16);
                if (!Character.isLetterOrDigit((char)n2)) {
                    n2 = 45;
                }
            }
            if (n2 == 32) {
                stringBuilder.append('-');
                continue;
            }
            if (n2 == 45) {
                stringBuilder.append((char)n2);
                continue;
            }
            if (n2 == 95) {
                stringBuilder.append((char)n2);
                continue;
            }
            if (!Character.isLetterOrDigit((char)n2)) continue;
            stringBuilder.append((char)n2);
        }
        string = stringBuilder.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void decodePageForMarkedContent(int n, PdfObject pdfObject, Object object) throws Exception {
        if (this.isDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already");
        } else {
            Object object2;
            if (pdfObject == null) {
                object2 = this.currentPdfFile.getReferenceforPage(n);
                pdfObject = new PageObject((String)object2);
                this.currentPdfFile.readObject(pdfObject);
            } else {
                n = this.currentPdfFile.convertObjectToPageNumber(new String(pdfObject.getUnresolvedData()));
                this.currentPdfFile.checkResolved(pdfObject);
            }
            try {
                this.isDecoding = true;
                object2 = new ObjectStore();
                PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, false, this.layers);
                pdfStreamDecoder.setParameters(true, false, 0, 7, false, false);
                pdfStreamDecoder.setXMLExtraction(false);
                pdfStreamDecoder.setObjectValue(-9, "markedContent");
                pdfStreamDecoder.setObjectValue(-8, object2);
                pdfStreamDecoder.setObjectValue(-3, null);
                pdfStreamDecoder.setObjectValue(-18, this.pdfPageData);
                pdfStreamDecoder.setIntValue(-10, n);
                pdfStreamDecoder.setRenderer(new SwingDisplay(n, (ObjectStore)object2, false));
                this.res.setupResources(pdfStreamDecoder, false, pdfObject.getDictionary(2004251818), n, this.currentPdfFile);
                pdfStreamDecoder.setObjectValue(-5, object);
                if (debug) {
                    System.out.println(indent + " about to decode page " + pdfObject.getObjectRefAsString());
                }
                pdfStreamDecoder.decodePageContent(pdfObject);
                ((ObjectStore)object2).flush();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            finally {
                this.isDecoding = false;
            }
        }
    }

    static {
        indent = "";
    }
}

