/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalHelper;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.Tj;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public class DecoderOptions {
    public static float javaVersion;
    public static float highlightComposite;
    public static boolean showMouseBox;
    public static boolean showErrorMessages;
    public static boolean isRunningOnMac;
    public static boolean isRunningOnWindows;
    public static boolean isRunningOnAIX;
    public static boolean isRunningOnLinux;
    public static boolean embedWidthData;
    public static JPedalHelper Helper;
    public static boolean hires;
    public int scrollInterval = 10;
    private int alignment = 1;
    public int insetW;
    public int insetH;
    private boolean useHiResImageForDisplay = true;
    private boolean useAcceleration = true;
    private PageOffsets currentOffset;
    private boolean renderPage;
    private int pageMode = 1;
    public static Color highlightColor;
    public static Color backgroundColor;
    Color nonDrawnPageColor = Color.WHITE;
    private int displayView = 1;
    public Color altPageColor = Color.WHITE;
    public Color altTextColor;
    public Color altDisplayBackground;
    public int altColorThreshold = 255;
    boolean changeTextAndLine;
    private Integer instance_bestQualityMaxScaling;
    private int[] instance_formsNoPrint;
    private static int[] formsNoPrint;
    private static String[] extactionPageSize;
    private String[] instance_extactionPageSize;
    private static Boolean overridePageSize;
    private Boolean instance_overridePageSize;
    private Boolean instance_allowPagesSmallerThanPageSize = Boolean.FALSE;
    private boolean isXMLExtraction = true;

    public boolean isXMLExtraction() {
        return this.isXMLExtraction;
    }

    public void setXMLExtraction(boolean bl) {
        this.isXMLExtraction = bl;
    }

    public void setPageMode(int n) {
        this.pageMode = n;
    }

    public int getPageMode() {
        return this.pageMode;
    }

    public int getInsetH() {
        return this.insetH;
    }

    public int getInsetW() {
        return this.insetW;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int n) {
        this.scrollInterval = n;
    }

    public final void setInset(int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
    }

    public void useXMLExtraction() {
        this.isXMLExtraction = true;
    }

    public PdfGroupingAlgorithms getGroupingObject(int n, PdfData pdfData, PdfPageData pdfPageData) throws PdfException {
        if (n == -1) {
            throw new RuntimeException("No pages decoded - call decodePage(pageNumber) first");
        }
        if (pdfData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData, pdfPageData, this.isXMLExtraction);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject(PdfData pdfData, PdfPageData pdfPageData) {
        if (pdfData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(pdfData, pdfPageData, this.isXMLExtraction);
    }

    public void set(Map map) throws PdfException {
        for (Object k : map.keySet()) {
            if (k instanceof Integer) {
                Integer n = (Integer)k;
                Object v = map.get(n);
                if (n.equals(JPedalSettings.UNDRAWN_PAGE_COLOR)) {
                    if (v instanceof Integer) {
                        this.nonDrawnPageColor = new Color((Integer)v);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.UNDRAWN_PAGE_COLOR expects a Integer value");
                }
                if (n.equals(JPedalSettings.PAGE_COLOR)) {
                    if (v instanceof Integer) {
                        this.altPageColor = new Color((Integer)v);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.PAGE_COLOR expects a Integer value");
                }
                if (n.equals(JPedalSettings.TEXT_COLOR)) {
                    if (v instanceof Integer) {
                        this.altTextColor = new Color((Integer)v);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
                }
                if (n.equals(JPedalSettings.REPLACEMENT_COLOR_THRESHOLD)) {
                    if (v instanceof Integer) {
                        this.altColorThreshold = (Integer)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
                }
                if (n.equals(JPedalSettings.DISPLAY_BACKGROUND)) {
                    if (v instanceof Integer) {
                        this.altDisplayBackground = new Color((Integer)v);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
                }
                if (n.equals(JPedalSettings.CHANGE_LINEART)) {
                    if (v instanceof Boolean) {
                        this.changeTextAndLine = (Boolean)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.CHANGE_LINEART expects a Boolean value");
                }
                if (n.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
                    if (v instanceof Integer) {
                        this.instance_bestQualityMaxScaling = (Integer)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
                }
                if (n.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
                    if (v instanceof String[]) {
                        this.instance_extactionPageSize = (String[])v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
                }
                if (n.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
                    if (v instanceof int[]) {
                        this.instance_formsNoPrint = (int[])v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
                }
                if (n.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
                    if (v instanceof Boolean) {
                        this.instance_overridePageSize = (Boolean)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
                }
                if (n.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) {
                    if (v instanceof Boolean) {
                        this.instance_allowPagesSmallerThanPageSize = (Boolean)v;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
                }
                DecoderOptions.setParameter(map, k);
                continue;
            }
            throw new PdfException("Unknown or unsupported key (not Integer) " + k);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setParameter(Map map, Object object) throws PdfException {
        if (!(object instanceof Integer)) throw new PdfException("Unknown or unsupported key (not Integer) " + object);
        Integer n = (Integer)object;
        Object v = map.get(n);
        if (n.equals(JPedalSettings.INVERT_HIGHLIGHT)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.INVERT_HIGHLIGHT expects an Boolean value");
            SwingDisplay.invertHighlight = (Boolean)v;
            return;
        } else if (n.equals(JPedalSettings.TEXT_INVERTED_COLOUR)) {
            if (!(v instanceof Color)) throw new PdfException("JPedalSettings.TEXT_INVERTED_COLOUR expects a Color value");
            backgroundColor = (Color)v;
            return;
        } else if (n.equals(JPedalSettings.TEXT_HIGHLIGHT_COLOUR)) {
            if (!(v instanceof Color)) throw new PdfException("JPedalSettings.TEXT_HIGHLIGHT_COLOUR expects a Color value");
            highlightColor = (Color)v;
            return;
        } else if (n.equals(JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS expects a Boolean value");
            PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts = (Boolean)v;
            return;
        } else if (n.equals(JPedalSettings.DISPLAY_INVISIBLE_TEXT)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.DISPLAY_INVISIBLE_TEXT expects a Boolean value");
            Tj.showInvisibleText = (Boolean)v;
            return;
        } else if (n.equals(JPedalSettings.CACHE_LARGE_FONTS)) {
            if (!(v instanceof Integer)) throw new PdfException("JPedalSettings.CACHE_LARGE_FONTS expects an Integer value");
            FontData.maxSizeAllowedInMemory = (Integer)v;
            return;
        } else if (n.equals(JPedalSettings.IMAGE_HIRES)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.IMAGE_HIRES expects a Boolean value");
            hires = (Boolean)v;
            return;
        } else if (n.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
            if (!(v instanceof Integer)) throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
            PDFtoImageConvertor.bestQualityMaxScaling = (Integer)v;
            return;
        } else if (n.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
            if (!(v instanceof String[])) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
            extactionPageSize = (String[])v;
            return;
        } else if (n.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
            overridePageSize = (Boolean)v;
            return;
        } else if (n.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
            if (!(v instanceof int[])) throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
            formsNoPrint = (int[])v;
            return;
        } else {
            if (!n.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) throw new PdfException("Unknown or unsupported key " + n);
            if (!(v instanceof Boolean)) throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
            PDFtoImageConvertor.allowPagesSmallerThanPageSize = (Boolean)v;
        }
    }

    public static void modifyJPedalParameters(Map map) throws PdfException {
        for (Object k : map.keySet()) {
            DecoderOptions.setParameter(map, k);
        }
    }

    public Color getPageColor() {
        return this.altPageColor;
    }

    public Color getTextColor() {
        return this.altTextColor;
    }

    public int getReplacementColorThreshold() {
        return this.altColorThreshold;
    }

    public Color getDisplayBackgroundColor() {
        return this.altDisplayBackground;
    }

    public boolean getChangeTextAndLine() {
        return this.changeTextAndLine;
    }

    public Paint getNonDrawnPageColor() {
        return this.nonDrawnPageColor;
    }

    public Boolean getInstance_allowPagesSmallerThanPageSize() {
        return this.instance_allowPagesSmallerThanPageSize;
    }

    public Integer getInstance_bestQualityMaxScaling() {
        return this.instance_bestQualityMaxScaling;
    }

    public static int[] getFormsNoPrint() {
        return formsNoPrint;
    }

    public int[] getInstance_FormsNoPrint() {
        return this.instance_formsNoPrint;
    }

    public Boolean getPageSizeToUse() {
        Boolean bl = Boolean.FALSE;
        if (this.instance_overridePageSize != null) {
            bl = this.instance_overridePageSize;
        } else if (overridePageSize != null) {
            bl = overridePageSize;
        }
        return bl;
    }

    public float getImageDimensions(int n, PdfPageData pdfPageData) {
        String string;
        float f = -2.0f;
        String string2 = System.getProperty("org.jpedal.pageSizeOverridesImage");
        if (string2 != null) {
            if (this.instance_overridePageSize != null) {
                this.instance_overridePageSize = Boolean.parseBoolean(string2);
            } else {
                overridePageSize = Boolean.parseBoolean(string2);
            }
        }
        if ((string = System.getProperty("org.jpedal.pageMaxScaling")) != null) {
            try {
                if (this.instance_bestQualityMaxScaling != null) {
                    this.instance_bestQualityMaxScaling = Integer.parseInt(string);
                } else {
                    PDFtoImageConvertor.bestQualityMaxScaling = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        String[] stringArray = null;
        String string3 = System.getProperty("org.jpedal.pageSize");
        if (string3 != null) {
            stringArray = string3.split("x");
        }
        if (stringArray == null) {
            stringArray = this.instance_extactionPageSize != null ? this.instance_extactionPageSize : extactionPageSize;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (stringArray != null) {
            if (stringArray.length == 2) {
                if (pdfPageData.getRotation(n) == 90 || pdfPageData.getRotation(n) == 270) {
                    f2 = Float.parseFloat(stringArray[1]);
                    f3 = Float.parseFloat(stringArray[0]);
                } else {
                    f2 = Float.parseFloat(stringArray[0]);
                    f3 = Float.parseFloat(stringArray[1]);
                }
            } else {
                throw new RuntimeException("Invalid parameters in JVM option -DpageSize ");
            }
        }
        float f4 = 0.0f;
        if (stringArray != null) {
            float f5 = pdfPageData.getCropBoxWidth2D(n);
            float f6 = pdfPageData.getCropBoxHeight2D(n);
            float f7 = f3 / f6;
            if (f7 < (f4 = f2 / f5)) {
                f4 = f7;
            }
        }
        Boolean bl = this.getPageSizeToUse();
        if (stringArray != null && bl.booleanValue()) {
            f = f4;
        }
        return f;
    }

    public boolean getRenderPage() {
        return this.renderPage;
    }

    public void setRenderPage(boolean bl) {
        this.renderPage = bl;
    }

    public boolean useHardwareAcceleration() {
        return this.useAcceleration;
    }

    public void useHardwareAcceleration(boolean bl) {
        this.useAcceleration = bl;
    }

    public boolean useHiResImageForDisplay() {
        return this.useHiResImageForDisplay;
    }

    public void useHiResImageForDisplay(boolean bl) {
        this.useHiResImageForDisplay = bl;
    }

    public int getPageAlignment() {
        return this.alignment;
    }

    public void setPageAlignment(int n) {
        this.alignment = n;
    }

    public void setDisplayView(int n) {
        this.displayView = n;
    }

    public int getDisplayView() {
        return this.displayView;
    }

    public PageOffsets getCurrentOffsets() {
        return this.currentOffset;
    }

    public void setCurrentOffsets(PageOffsets pageOffsets) {
        this.currentOffset = pageOffsets;
    }

    static {
        highlightComposite = 0.35f;
        hires = true;
        try {
            String string = System.getProperty("os.name");
            if (string.equals("Mac OS X")) {
                isRunningOnMac = true;
            } else if (string.startsWith("Windows")) {
                isRunningOnWindows = true;
            } else if (string.startsWith("AIX")) {
                isRunningOnAIX = true;
            } else if (string.equals("Linux")) {
                isRunningOnLinux = true;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
        }
        highlightColor = new Color(10, 100, 170);
    }
}

