/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jpedal.display.GUIModes;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.PdfStreamDecoderForSampling;
import org.jpedal.parser.swing.PDFtoImageConvertorSwing;
import org.jpedal.render.DynamicVectorRenderer;

public abstract class PDFtoImageConvertor {
    private final Integer instance_bestQualityMaxScaling;
    final Boolean instance_allowPagesSmallerThanPageSize;
    final DecoderOptions options;
    public float multiplyer = 1.0f;
    public static Boolean allowPagesSmallerThanPageSize = Boolean.FALSE;
    public static Integer bestQualityMaxScaling;
    public DynamicVectorRenderer imageDisplay;
    public AffineTransform imageScaling;
    public int mediaH;
    public int w;
    public int h;
    public int rotation;
    public float crw;
    public float crh;
    public float crx;
    public float cry;
    public boolean rotated;
    protected boolean isFX;

    public PDFtoImageConvertor(float f, DecoderOptions decoderOptions) {
        this.multiplyer = f;
        this.instance_allowPagesSmallerThanPageSize = decoderOptions.getInstance_allowPagesSmallerThanPageSize();
        this.instance_bestQualityMaxScaling = decoderOptions.getInstance_bestQualityMaxScaling();
        this.options = decoderOptions;
    }

    public BufferedImage convert(DecoderResults decoderResults, int n, PdfResources pdfResources, ExternalHandlers externalHandlers, int n2, PdfPageData pdfPageData, AcroRenderer acroRenderer, float f, PdfObjectReader pdfObjectReader, int n3, boolean bl, String string) throws PdfException {
        Object object;
        ObjectStore objectStore = new ObjectStore();
        PageObject pageObject = new PageObject(string);
        pdfObjectReader.readObject(pageObject);
        pdfObjectReader.checkParentForResources(pageObject);
        pageObject.setPageNumber(n3);
        PdfObject pdfObject = ((PdfObject)pageObject).getDictionary(2004251818);
        this.imageDisplay = this.getDisplay(n3, objectStore, bl);
        if (!this.imageDisplay.isHTMLorSVG()) {
            if (this.options.getPageColor() != null) {
                this.imageDisplay.setValue(1, this.options.getPageColor().getRGB());
            }
            if (this.options.getTextColor() != null) {
                this.imageDisplay.setValue(2, this.options.getTextColor().getRGB());
                if (this.options.getChangeTextAndLine()) {
                    this.imageDisplay.setValue(3, 1);
                } else {
                    this.imageDisplay.setValue(3, 0);
                }
                this.imageDisplay.setValue(4, this.options.getReplacementColorThreshold());
            }
        }
        PdfStreamDecoder pdfStreamDecoder = acroRenderer.getStreamDecoder(pdfObjectReader, true, null, true);
        pdfStreamDecoder.setParameters(true, true, n2, 1, false, externalHandlers.getMode().equals((Object)GUIModes.JAVAFX));
        externalHandlers.addHandlers(pdfStreamDecoder);
        pdfStreamDecoder.setObjectValue(-8, objectStore);
        pdfStreamDecoder.setMultiplyer(this.multiplyer);
        pdfStreamDecoder.setObjectValue(-18, pdfPageData);
        pdfStreamDecoder.setIntValue(-10, n3);
        pdfStreamDecoder.setRenderer(this.imageDisplay);
        externalHandlers.addHandlers(pdfStreamDecoder);
        pdfResources.setupResources(pdfStreamDecoder, true, pdfObject, n3, pdfObjectReader);
        if (this.multiplyer == -2.0f) {
            this.multiplyer = -1.0f;
            pdfStreamDecoder.setMultiplyer(this.multiplyer);
            object = new PdfStreamDecoderForSampling(pdfObjectReader);
            ((PdfStreamDecoder)object).setParameters(true, true, n2, 0, false, externalHandlers.getMode().equals((Object)GUIModes.JAVAFX));
            ((PdfStreamDecoder)object).setObjectValue(-8, objectStore);
            ((BaseDecoder)object).setMultiplyer(this.multiplyer);
            ((PdfStreamDecoder)object).setObjectValue(-18, pdfPageData);
            ((PdfStreamDecoder)object).setIntValue(-10, n3);
            ((BaseDecoder)object).setRenderer(this.imageDisplay);
            pdfResources.setupResources((PdfStreamDecoder)object, true, pdfObject, n3, pdfObjectReader);
            externalHandlers.addHandlers((PdfStreamDecoder)object);
            this.multiplyer = ((PdfStreamDecoderForSampling)object).decodePageContentForImageSampling(pageObject);
            int n4 = 0;
            if (this.instance_bestQualityMaxScaling != null) {
                n4 = this.instance_bestQualityMaxScaling;
            } else if (bestQualityMaxScaling != null) {
                n4 = bestQualityMaxScaling;
            }
            if (n4 > 0 && this.multiplyer > (float)n4) {
                this.multiplyer = n4;
            }
            ((BaseDecoder)object).setMultiplyer(this.multiplyer);
            pdfStreamDecoder.setMultiplyer(this.multiplyer);
        }
        if (!allowPagesSmallerThanPageSize.booleanValue() && !this.instance_allowPagesSmallerThanPageSize.booleanValue() && this.multiplyer < 1.0f && this.multiplyer > 0.0f) {
            this.multiplyer = 1.0f;
        }
        if (this.multiplyer == -1.0f) {
            this.multiplyer = 1.0f;
        }
        this.imageScaling = PDFtoImageConvertorSwing.setPageParametersForImage(f * this.multiplyer, n3, pdfPageData);
        this.setParams(f, pdfPageData, n3);
        object = this.pageToImage(bl, pdfStreamDecoder, f, pageObject, acroRenderer);
        decoderResults.update(pdfStreamDecoder, false);
        if (acroRenderer != null && acroRenderer.hasFormsOnPage(n3) && !acroRenderer.ignoreForms()) {
            decoderResults.resetColorSpaces();
            if (!acroRenderer.getCompData().hasformsOnPageDecoded(n3)) {
                acroRenderer.createDisplayComponentsForPage(n3, pdfStreamDecoder);
            }
            if (!this.isFX) {
                if (!acroRenderer.getCompData().formsRasterizedForDisplay()) {
                    if (!acroRenderer.useXFA()) {
                        List[] listArray = acroRenderer.getCompData().getFormList(true);
                        for (Object e : listArray[n3]) {
                            if (e == null) continue;
                            acroRenderer.getFormFlattener().drawFlattenedForm(pdfStreamDecoder, (FormObject)e, false, (PdfObject)acroRenderer.getFormResources()[0]);
                        }
                    } else {
                        acroRenderer.getCompData().renderFormsOntoG2(((BufferedImage)object).getGraphics(), n3, 0, n, null, null, pdfPageData.getMediaBoxHeight(n3));
                    }
                } else {
                    List[] listArray = acroRenderer.getCompData().getFormList(true);
                    for (Object e : listArray[n3]) {
                        if (e == null) continue;
                        acroRenderer.getFormFlattener().drawFlattenedForm(pdfStreamDecoder, (FormObject)e, false, (PdfObject)acroRenderer.getFormResources()[0]);
                    }
                }
            }
        }
        if (pdfStreamDecoder != null) {
            pdfStreamDecoder.dispose();
        }
        objectStore.flush();
        return object;
    }

    public float getMultiplyer() {
        return this.multiplyer;
    }

    public DynamicVectorRenderer getDisplay(int n, ObjectStore objectStore, boolean bl) {
        throw new UnsupportedOperationException(this + " Code should never be called ");
    }

    public BufferedImage pageToImage(boolean bl, PdfStreamDecoder pdfStreamDecoder, float f, PdfObject pdfObject, AcroRenderer acroRenderer) throws PdfException {
        throw new UnsupportedOperationException(this + " Code should never be called ");
    }

    public void setParams(float f, PdfPageData pdfPageData, int n) {
        this.mediaH = (int)(f * (float)pdfPageData.getMediaBoxHeight(n));
        this.rotation = pdfPageData.getRotation(n);
        this.crw = f * pdfPageData.getCropBoxWidth2D(n);
        this.crh = f * pdfPageData.getCropBoxHeight2D(n);
        this.crx = f * (float)pdfPageData.getCropBoxX(n);
        this.cry = f * (float)pdfPageData.getCropBoxY(n);
        if (this.rotation == 90 || this.rotation == 270) {
            this.h = (int)(this.crw * this.multiplyer);
            this.w = (int)(this.crh * this.multiplyer);
            this.rotated = true;
        } else {
            this.w = (int)(this.crw * this.multiplyer);
            this.h = (int)(this.crh * this.multiplyer);
        }
    }
}

