/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.ImageHandler;
import org.jpedal.external.ShapeTracker;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.JavaFXSupport;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.DefaultErrorTracker;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.SwingShape;
import org.jpedal.objects.TextState;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FontResolver;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.T3Decoder;
import org.jpedal.parser.XFormDecoder;
import org.jpedal.parser.color.CS;
import org.jpedal.parser.color.G;
import org.jpedal.parser.color.K;
import org.jpedal.parser.color.RG;
import org.jpedal.parser.color.SCN;
import org.jpedal.parser.gs.CM;
import org.jpedal.parser.gs.Q;
import org.jpedal.parser.image.DO;
import org.jpedal.parser.image.ID;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.shape.B;
import org.jpedal.parser.shape.D;
import org.jpedal.parser.shape.F;
import org.jpedal.parser.shape.J;
import org.jpedal.parser.shape.N;
import org.jpedal.parser.shape.S;
import org.jpedal.parser.shape.SH;
import org.jpedal.parser.text.BDC;
import org.jpedal.parser.text.EMC;
import org.jpedal.parser.text.TD;
import org.jpedal.parser.text.TR;
import org.jpedal.parser.text.Tj;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class PdfStreamDecoder
extends BaseDecoder {
    private static boolean showFXShadingMessage;
    int formLevel;
    private int BDCDepth = -1;
    PdfObjectCache cache;
    PdfPageData pageData;
    ErrorTracker errorTracker;
    PdfObjectReader currentPdfFile;
    protected GraphicsState newGS;
    protected byte[] pageStream;
    PdfLayerList layers;
    protected boolean getSamplingOnly;
    private final Map shadingColorspacesObjects = new HashMap(50);
    private boolean isTTHintingRequired;
    final Vector_Int textDirections = new Vector_Int();
    final Vector_Rectangle_Int textAreas = new Vector_Rectangle_Int();
    public boolean ignoreColors;
    int imageCount;
    float[] BBox;
    String lastTextValue = "";
    int lastDataPointer = -1;
    private T3Decoder t3Decoder;
    private boolean removeRenderImages;
    private boolean multipleTJs;
    private boolean textColorExtracted;
    private boolean textExtracted = true;
    private boolean renderText;
    private int tokenNumber;
    String imagesInFile;
    public static final float currentThreshold = 0.595f;
    protected ImageHandler customImageHandler;
    private PdfFontFactory pdfFontFactory;
    boolean isXMLExtraction;
    public static final boolean showCommands = false;
    private StatusBar statusBar;
    final PdfData pdfData = new PdfData();
    final PdfImageData pdfImages = new PdfImageData();
    protected static String indent;
    protected boolean isDataValid = true;
    private PdfFont currentFontData;
    protected boolean useHiResImageForDisplay;
    protected ObjectStore objectStoreStreamRef;
    String formName = "";
    protected boolean isType3Font;
    public static boolean useTextPrintingForNonEmbeddedFonts;
    private static int maxShapesAllowed;
    private int currentBlendMode = 1111314299;
    boolean isPrinting;

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader) {
        this.init(pdfObjectReader);
    }

    public PdfStreamDecoder(PdfObjectReader pdfObjectReader, boolean bl, PdfLayerList pdfLayerList) {
        if (pdfLayerList != null) {
            this.layers = pdfLayerList;
        }
        this.useHiResImageForDisplay = bl;
        this.init(pdfObjectReader);
    }

    private void init(PdfObjectReader pdfObjectReader) {
        this.cache = new PdfObjectCache();
        this.gs = new GraphicsState();
        this.errorTracker = new DefaultErrorTracker();
        this.pageData = new PdfPageData();
        StandardFonts.checkLoaded(1);
        StandardFonts.checkLoaded(0);
        this.currentPdfFile = pdfObjectReader;
        this.pdfFontFactory = new PdfFontFactory(pdfObjectReader);
    }

    public T3Size decodePageContent(PdfObject pdfObject) throws PdfException {
        try {
            this.parserOptions.imagesProcessedFully = true;
            this.parserOptions.tooManyShapes = false;
            this.imageCount = 0;
            this.parserOptions.setPdfLayerList(this.layers);
            this.imagesInFile = null;
            if (!this.parserOptions.renderDirectly() && this.statusBar != null) {
                this.statusBar.percentageDone = 0.0f;
            }
            this.gs = this.newGS != null ? this.newGS : new GraphicsState(0, 0);
            if (this.parserOptions.isRenderPage()) {
                if (this.current == null) {
                    throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
                }
                this.current.drawClip(this.gs, this.parserOptions.defaultClip, false);
                int n = this.parserOptions.getPageNumber();
                this.current.paintBackground(new Rectangle(this.pageData.getCropBoxX(n), this.pageData.getCropBoxY(n), this.pageData.getCropBoxWidth(n), this.pageData.getCropBoxHeight(n)));
            }
            byte[][] byArray = null;
            if (pdfObject != null) {
                byArray = pdfObject.getKeyArray(1216184967);
                this.isDataValid = pdfObject.streamMayBeCorrupt();
            }
            byte[] byArray2 = pdfObject != null && byArray == null ? this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader())) : (this.pageStream != null ? this.pageStream : this.currentPdfFile.getObjectReader().readPageIntoStream(pdfObject));
            this.lastDataPointer = -1;
            if (byArray2 != null && byArray2.length > 0) {
                this.decodeStreamIntoObjects(byArray2, false);
            }
            if (!this.isType3Font) {
                this.cache.resetFonts();
            }
            T3Size t3Size = new T3Size();
            if (this.t3Decoder != null) {
                t3Size.x = this.t3Decoder.T3maxWidth;
                t3Size.y = this.t3Decoder.T3maxHeight;
                this.ignoreColors = this.t3Decoder.ignoreColors;
                this.t3Decoder = null;
            }
            return t3Size;
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error);
            if (ExternalHandlers.throwMissingCIDError && error.getMessage() != null && error.getMessage().contains("kochi")) {
                throw error;
            }
            this.errorTracker.addPageFailureMessage("Problem decoding page " + error);
            return null;
        }
    }

    public void setObjectValue(int n, Object object) {
        switch (n) {
            case -9: {
                this.parserOptions.setName((String)object);
                break;
            }
            case -18: {
                this.pageData = (PdfPageData)object;
                if (!this.textColorExtracted) break;
                this.pdfData.enableTextColorDataExtraction();
                break;
            }
            case -3: {
                this.statusBar = (StatusBar)object;
                break;
            }
            case -4: {
                this.layers = (PdfLayerList)object;
                break;
            }
            case -6: {
                this.customImageHandler = (ImageHandler)object;
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            case -7: {
                this.current.setIsRenderingToImage(true);
                this.parserOptions.setRenderDirectly(true);
                if (object == null) break;
                Graphics2D graphics2D = (Graphics2D)object;
                this.parserOptions.defaultClip = graphics2D.getClip();
                break;
            }
            case -8: {
                this.objectStoreStreamRef = (ObjectStore)object;
                if (this.current == null) break;
                this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            case 31: {
                this.errorTracker = (ErrorTracker)object;
                break;
            }
            case 13: {
                this.parserOptions.setCustomShapeTracker((ShapeTracker)object);
            }
        }
    }

    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 21: {
                this.parserOptions.setGenerateGlyphOnRender(bl);
            }
        }
    }

    public void setDefaultColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
        this.gs.strokeColorSpace.setColor(pdfPaint);
        this.gs.nonstrokeColorSpace.setColor(pdfPaint2);
        this.gs.setStrokeColor(pdfPaint);
        this.gs.setNonstrokeColor(pdfPaint2);
    }

    public Object getObjectValue(int n) {
        switch (n) {
            case -19: {
                if (DecoderOptions.embedWidthData) {
                    this.pdfData.widthIsEmbedded();
                }
                return this.pdfData;
            }
            case -20: {
                return this.pdfImages;
            }
            case -21: {
                return this.textAreas;
            }
            case 22: {
                return this.textDirections;
            }
            case 23: {
                return this.current;
            }
            case 373243460: {
                return this.pdfFontFactory.getFontsInFile();
            }
            case 1026635598: {
                return this.imagesInFile;
            }
            case 4: {
                return this.pdfFontFactory.getnonEmbeddedCIDFonts();
            }
            case 1: {
                return this.cache.iterator(1);
            }
        }
        return null;
    }

    public final void readResources(PdfObject pdfObject, boolean bl) throws PdfException {
        if (bl) {
            this.pdfFontFactory.resetfontsInFile();
        }
        this.currentPdfFile.checkResolved(pdfObject);
        this.cache.readResources(pdfObject, bl);
    }

    public String decodeStreamIntoObjects(byte[] byArray, boolean bl) {
        Object object;
        if (byArray.length == 0) {
            return null;
        }
        int n = 0;
        CommandParser commandParser = new CommandParser(byArray);
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = "";
        Object object2 = "";
        PdfShape pdfShape = null;
        if (this.parserOptions.useJavaFX()) {
            object = ExternalHandlers.getFXHandler();
            if (object != null) {
                pdfShape = ((JavaFXSupport)object).getFXShape();
            }
        } else {
            pdfShape = new SwingShape();
        }
        if (this.parserOptions.hasContentHandler()) {
            object = new Tj(this.parserOptions, this.textAreas, this.textDirections, this.current, this.errorTracker);
        } else {
            object = new Tj(this.parserOptions, this.pdfData, this.isXMLExtraction, this.textAreas, this.textDirections, this.current, this.errorTracker);
            ((Tj)object).setReturnText(bl);
        }
        ((BaseDecoder)object).setStreamType(this.streamType);
        if (this.statusBar != null && !this.parserOptions.renderDirectly()) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        while (!this.errorTracker.checkForExitRequest(n3, n2)) {
            if (this.statusBar != null && !this.parserOptions.renderDirectly()) {
                this.statusBar.percentageDone = 90 * n3 / n2;
            }
            n3 = commandParser.getCommandValues(n3, n2, this.tokenNumber);
            int n6 = commandParser.getCommandID();
            if (n3 < 0) {
                n3 = -n3;
                try {
                    int n7 = Cmd.getCommandType(n6);
                    block1 : switch (n7) {
                        case 0: {
                            if (n6 != 4541763 && !this.parserOptions.isLayerVisible() || this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            n3 = this.processTextToken((Tj)object, commandParser, n6, n4, n3);
                            break;
                        }
                        case 2: {
                            if (this.getSamplingOnly) break;
                            this.processShapeCommands(commandParser, pdfShape, n6);
                            if (maxShapesAllowed <= 0 || ++n5 <= maxShapesAllowed) break;
                            Object object3 = "[PDF] Shapes on page exceed limit set by JVM flag org.jpedal.maxShapeCount - value " + maxShapesAllowed;
                            this.parserOptions.tooManyShapes = true;
                            throw new PdfException((String)object3);
                        }
                        case 3: {
                            if (System.getProperty("testsDisableImages") != null || this.getSamplingOnly || !this.parserOptions.isRenderPage()) break;
                            if (this.parserOptions.useJavaFX) {
                                if (showFXShadingMessage) break;
                                System.out.println("SH not implemented in JavaFX yet");
                                showFXShadingMessage = true;
                                break;
                            }
                            SH.execute(commandParser.generateOpAsString(0, true), this.cache, this.gs, this.isPrinting, this.shadingColorspacesObjects, this.parserOptions.getPageNumber(), this.currentPdfFile, this.pageData, this.current);
                            break;
                        }
                        case 1: {
                            Object object3;
                            if (this.getSamplingOnly) break;
                            if (n6 != 5456718 && n6 != 7562094 && n6 != 21315 && n6 != 29539) {
                                this.current.resetOnColorspaceChange();
                            }
                            switch (n6) {
                                case 25459: {
                                    object3 = commandParser.generateOpAsString(0, true);
                                    boolean bl2 = ((String)object3).equals(object2);
                                    string = object3;
                                    CS.execute(true, (String)object3, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.parserOptions.getPageNumber(), this.pageData, bl2);
                                    break block1;
                                }
                                case 17235: {
                                    object3 = commandParser.generateOpAsString(0, true);
                                    boolean bl3 = ((String)object3).equals(string);
                                    object2 = object3;
                                    CS.execute(false, (String)object3, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.parserOptions.getPageNumber(), this.pageData, bl3);
                                    break block1;
                                }
                                case 29287: {
                                    RG.execute(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 21063: {
                                    RG.execute(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 5456718: {
                                    SCN.execute(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 7562094: {
                                    SCN.execute(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 21315: {
                                    SCN.execute(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 29539: {
                                    SCN.execute(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 103: {
                                    G.execute(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 71: {
                                    G.execute(false, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 107: {
                                    K.execute(true, this.gs, commandParser, this.cache);
                                    break block1;
                                }
                                case 75: {
                                    K.execute(false, this.gs, commandParser, this.cache);
                                }
                            }
                            break;
                        }
                        case 4: {
                            this.processGScommands(commandParser, n6);
                            if (n6 != 25453 || object == null) break;
                            this.multipleTJs = false;
                            break;
                        }
                        case 5: {
                            if (n6 == 16969) {
                                n = n3;
                                break;
                            }
                            Object object3 = null;
                            int n8 = 1;
                            if (n6 == 17519) {
                                String string2 = commandParser.generateOpAsString(0, true);
                                object3 = this.cache.getXObjects(string2);
                                if (object3 != null) {
                                    this.currentPdfFile.checkResolved((PdfObject)object3);
                                    n8 = ((PdfObject)object3).getParameterConstant(1147962727);
                                }
                                if (n8 == 373244477 && (this.formLevel <= 100 || n3 != this.lastDataPointer)) {
                                    this.lastDataPointer = n3;
                                    if (this.parserOptions.isLayerVisible() && (this.layers == null || this.layers.isVisible((PdfObject)object3)) && object3 != null) {
                                        XFormDecoder.processXForm(this, n3, (PdfObject)object3, this.parserOptions.defaultClip, commandParser);
                                    }
                                }
                            }
                            if (n8 != 373244477) {
                                ImageDecoder imageDecoder = n6 != 17519 ? new ID(this.imageCount, this.currentPdfFile, this.errorTracker, this.customImageHandler, this.objectStoreStreamRef, this.pdfImages, this.formLevel, this.pageData, this.imagesInFile, this.formName) : new DO(this.imageCount, this.currentPdfFile, this.errorTracker, this.customImageHandler, this.objectStoreStreamRef, this.pdfImages, this.formLevel, this.pageData, this.imagesInFile, this.formName);
                                imageDecoder.setRes(this.cache);
                                imageDecoder.setGS(this.gs);
                                imageDecoder.setSamplingOnly(this.getSamplingOnly);
                                imageDecoder.setStreamType(this.streamType);
                                imageDecoder.setMultiplyer(this.multiplyer);
                                imageDecoder.setRenderer(this.current);
                                imageDecoder.setParameters(this.parserOptions.isRenderPage(), this.parserOptions.getRenderMode(), this.parserOptions.getExtractionMode(), this.isPrinting, this.isType3Font, this.useHiResImageForDisplay);
                                imageDecoder.setParams(this.parserOptions);
                                if (n6 == 17519) {
                                    if (!(object3 == null || !this.parserOptions.isLayerVisible() || this.layers != null && !this.layers.isVisible((PdfObject)object3) || this.gs.CTM != null && this.gs.CTM[1][1] == 0.0f && this.gs.CTM[1][0] != 0.0f && (double)Math.abs(this.gs.CTM[1][0]) < 0.2)) {
                                        n3 = imageDecoder.processImage(commandParser.generateOpAsString(0, true), n3, (PdfObject)object3);
                                    }
                                } else if (this.parserOptions.isLayerVisible()) {
                                    n3 = imageDecoder.processImage(n3, n, commandParser.getStream(), this.tokenNumber);
                                }
                                ++this.imageCount;
                                this.imagesInFile = imageDecoder.getImagesInFile();
                            }
                            break;
                        }
                        case 6: {
                            if (this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                            if (this.t3Decoder == null) {
                                this.t3Decoder = new T3Decoder();
                            }
                            this.t3Decoder.setCommands(commandParser);
                            this.t3Decoder.setCommands(commandParser);
                            this.t3Decoder.processToken(n6);
                        }
                    }
                }
                catch (Exception exception) {
                    LogWriter.writeLog("[PDF] " + exception + " Processing token >" + Cmd.getCommandAsString(n6) + "<>" + this.parserOptions.getFileName() + " <" + this.parserOptions.getPageNumber());
                    if (!this.isDataValid) {
                        n3 = n2;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.errorTracker.addPageFailureMessage("Memory error decoding token stream " + outOfMemoryError);
                    LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                }
                n4 = n3;
                commandParser.reset();
                ++this.tokenNumber;
            }
            if (n2 > n3) continue;
            break;
        }
        if (!this.parserOptions.renderDirectly() && this.statusBar != null) {
            this.statusBar.percentageDone = 100.0f;
        }
        this.isTTHintingRequired = ((Tj)object).isTTHintingRequired();
        if (bl) {
            return this.lastTextValue;
        }
        return "";
    }

    private void processGScommands(CommandParser commandParser, int n) {
        switch (n) {
            case 25453: {
                CM.execute(this.gs, commandParser);
                break;
            }
            case 113: {
                this.gs = Q.execute(this.gs, true, this.graphicsStates, this.current);
                break;
            }
            case 81: {
                this.gs = Q.execute(this.gs, false, this.graphicsStates, this.current);
                break;
            }
            case 26483: {
                if (this.getSamplingOnly) break;
                PdfObject pdfObject = (PdfObject)this.cache.GraphicsStates.get(commandParser.generateOpAsString(0, true));
                this.currentPdfFile.checkResolved(pdfObject);
                this.gs.setMode(pdfObject);
                int n2 = this.gs.getBMValue();
                this.current.setGraphicsState(2, this.gs.getAlpha(2), n2);
                this.current.setGraphicsState(1, this.gs.getAlpha(1), n2);
                this.currentBlendMode = n2;
            }
        }
    }

    private void processShapeCommands(CommandParser commandParser, PdfShape pdfShape, int n) {
        switch (n) {
            case 66: {
                ShapeTracker shapeTracker;
                Shape shape;
                if (this.removeRenderImages || (shape = B.execute(false, false, this.gs, this.formLevel, pdfShape, this.current, this.parserOptions)) == null || (shapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                shapeTracker.addShape(this.tokenNumber, 66, shape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 98: {
                ShapeTracker shapeTracker;
                Shape shape;
                if (this.removeRenderImages || (shape = B.execute(false, true, this.gs, this.formLevel, pdfShape, this.current, this.parserOptions)) == null || (shapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                shapeTracker.addShape(this.tokenNumber, 98, shape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 25130: {
                ShapeTracker shapeTracker;
                Shape shape;
                if (this.removeRenderImages || (shape = B.execute(true, true, this.gs, this.formLevel, pdfShape, this.current, this.parserOptions)) == null || (shapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                shapeTracker.addShape(this.tokenNumber, 25130, shape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 16938: {
                ShapeTracker shapeTracker;
                Shape shape;
                if (this.removeRenderImages || (shape = B.execute(true, false, this.gs, this.formLevel, pdfShape, this.current, this.parserOptions)) == null || (shapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                shapeTracker.addShape(this.tokenNumber, 16938, shape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 99: {
                float f = commandParser.parseFloat(1);
                float f2 = commandParser.parseFloat(0);
                float f3 = commandParser.parseFloat(3);
                float f4 = commandParser.parseFloat(2);
                float f5 = commandParser.parseFloat(5);
                float f6 = commandParser.parseFloat(4);
                pdfShape.addBezierCurveC(f5, f6, f3, f4, f, f2);
                break;
            }
            case 100: {
                D.execute(commandParser, this.gs);
                break;
            }
            case 70: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, false, this.formLevel, pdfShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 102: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, false, this.formLevel, pdfShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 17962: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, true, this.formLevel, pdfShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 26154: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, true, this.formLevel, pdfShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 104: {
                pdfShape.closeShape();
                break;
            }
            case 74: {
                J.execute(false, commandParser.parseInt(), this.gs);
                break;
            }
            case 106: {
                J.execute(true, commandParser.parseInt(), this.gs);
                break;
            }
            case 108: {
                pdfShape.lineTo(commandParser.parseFloat(1), commandParser.parseFloat(0));
                break;
            }
            case 77: {
                this.gs.setMitreLimit((int)commandParser.parseFloat(0));
                break;
            }
            case 109: {
                pdfShape.setClip(false);
                pdfShape.moveTo(commandParser.parseFloat(1), commandParser.parseFloat(0));
                break;
            }
            case 110: {
                N.execute(pdfShape, this.gs, this.formLevel, this.parserOptions.defaultClip, this.parserOptions, this.current, this.pageData);
                break;
            }
            case 29285: {
                pdfShape.appendRectangle(commandParser.parseFloat(3), commandParser.parseFloat(2), commandParser.parseFloat(1), commandParser.parseFloat(0));
                break;
            }
            case 83: {
                ShapeTracker shapeTracker;
                Shape shape;
                if (this.removeRenderImages || (shape = S.execute(false, this.gs, pdfShape, this.current, this.parserOptions)) == null || (shapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                shapeTracker.addShape(this.tokenNumber, 83, shape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 115: {
                ShapeTracker shapeTracker;
                Shape shape;
                if (this.removeRenderImages || (shape = S.execute(true, this.gs, pdfShape, this.current, this.parserOptions)) == null || (shapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                shapeTracker.addShape(this.tokenNumber, 115, shape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 118: {
                pdfShape.addBezierCurveV(commandParser.parseFloat(3), commandParser.parseFloat(2), commandParser.parseFloat(1), commandParser.parseFloat(0));
                break;
            }
            case 119: {
                this.gs.setLineWidth(commandParser.parseFloat(0));
                break;
            }
            case 22314: {
                pdfShape.setEVENODDWindingRule();
                pdfShape.setClip(true);
                break;
            }
            case 87: {
                pdfShape.setNONZEROWindingRule();
                pdfShape.setClip(true);
                break;
            }
            case 121: {
                pdfShape.addBezierCurveY(commandParser.parseFloat(3), commandParser.parseFloat(2), commandParser.parseFloat(1), commandParser.parseFloat(0));
            }
        }
    }

    public boolean getBooleanValue(int n) {
        switch (n) {
            case -1: {
                return this.pdfFontFactory.hasEmbeddedFonts();
            }
            case 1: {
                return this.errorTracker.ispageSuccessful();
            }
            case 4: {
                return this.pdfFontFactory.hasNonEmbeddedCIDFonts();
            }
            case 2: {
                return this.parserOptions.imagesProcessedFully;
            }
            case 64: {
                return this.parserOptions.tooManyShapes;
            }
            case 8: {
                return this.parserOptions.hasYCCKimages;
            }
            case 32: {
                return this.isTTHintingRequired;
            }
        }
        throw new RuntimeException("Unknown value " + n);
    }

    public void dispose() {
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
    }

    public void setIntValue(int n, int n2) {
        switch (n) {
            case -10: {
                this.parserOptions.setPageNumber(n2);
                break;
            }
            case -15: {
                this.parserOptions.setTextPrint(n2);
            }
        }
    }

    public void setXMLExtraction(boolean bl) {
        this.isXMLExtraction = bl;
    }

    public void setParameters(boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
        this.parserOptions.init(bl, bl2, n, n2, bl3, bl4);
        this.renderText = bl2 && (n & 1) == 1;
        this.textExtracted = (n2 & 1) == 1;
        this.textColorExtracted = (n2 & 0x40) == 64;
        this.removeRenderImages = bl2 && (n & 0x10) == 16;
    }

    public void setFormLevel(int n) {
        this.formLevel = n;
    }

    private int processTextToken(Tj tj, CommandParser commandParser, int n, int n2, int n3) {
        Object object;
        Object object2;
        tj.setGS(this.gs);
        TextState textState = this.gs.getTextState();
        if (n == 16980 && this.parserOptions.isRenderPage()) {
            this.current.drawClip(this.gs, this.parserOptions.defaultClip, true);
            this.current.drawTR(2);
        }
        if (n == 21610 || n == 21578 || n == 39 || n == 34) {
            this.current.flagCommand(21610, this.tokenNumber);
            if (textState.hasFontChanged() && textState.getTfs() != 0.0f && (object2 = (Object)FontResolver.resolveFont(this.gs, this, (String)(object = textState.getFontID()), this.pdfFontFactory, this.cache)) != null) {
                this.currentFontData = object2;
                this.current.drawFontBounds(this.currentFontData.getBoundingBox());
            }
            if (this.currentFontData == null) {
                this.currentFontData = new PdfFont(this.currentPdfFile);
                this.currentFontData.getGlyphData().logicalfontName = StandardFonts.expandName(textState.getFontID());
            }
            if (textState.hasFontChanged()) {
                textState.setFontChanged(false);
            }
        }
        switch (n) {
            case 4345155: {
                this.parserOptions.setLayerLevel(this.parserOptions.getLayerLevel() + 1);
                if (!this.parserOptions.isLayerVisible()) break;
                this.parserOptions.getLayerVisibility().add(this.parserOptions.getLayerLevel());
                break;
            }
            case 0x424443: {
                object = BDC.execute(n2, n3, commandParser.getStream(), commandParser.generateOpAsString(0, false), this.gs, this.currentPdfFile, this.current, this.parserOptions);
                this.BDCDepth = ((PdfObject)object).getClip() != null ? this.graphicsStates.getDepth() : -1;
                tj.setActualText(((PdfObject)object).getTextStreamValue(1752861363));
                break;
            }
            case 16980: {
                textState.resetTm();
                break;
            }
            case 4541763: {
                tj.setActualText(null);
                if (this.parserOptions.getLayerLevel() == 1 && this.BDCDepth != -1 && this.BDCDepth != this.graphicsStates.getDepth()) {
                    this.graphicsStates.correctDepth(0, this.gs, this.current);
                }
                this.BDCDepth = -1;
                EMC.execute(this.current, this.gs, this.parserOptions);
                break;
            }
            case 17748: {
                this.current.resetOnColorspaceChange();
                if (this.gs.getTextRenderType() != 7) break;
                this.current.drawClip(this.gs, null, false);
                break;
            }
            case 17488: {
                break;
            }
            case 21606: {
                textState.TF(commandParser.parseFloat(0), commandParser.generateOpAsString(1, true));
                break;
            }
            case 21603: {
                textState.setCharacterSpacing(commandParser.parseFloat(0));
                break;
            }
            case 21572: {
                TD.execute(false, commandParser.parseFloat(1), commandParser.parseFloat(0), textState);
                this.multipleTJs = false;
                break;
            }
            case 21604: {
                TD.execute(true, commandParser.parseFloat(1), commandParser.parseFloat(0), textState);
                this.multipleTJs = false;
                break;
            }
            case 21610: {
                if (textState.getTfs() != 0.0f) {
                    this.lastTextValue = tj.TJ(textState, this.currentFontData, commandParser.getStream(), n2, n3, this.multipleTJs);
                }
                this.multipleTJs = true;
                break;
            }
            case 21578: {
                this.lastTextValue = tj.TJ(textState, this.currentFontData, commandParser.getStream(), n2, n3, this.multipleTJs);
                this.multipleTJs = true;
                break;
            }
            case 39: {
                TD.relativeMove(0.0f, -textState.getLeading(), textState);
                this.multipleTJs = false;
                this.lastTextValue = tj.TJ(textState, this.currentFontData, commandParser.getStream(), n2, n3, this.multipleTJs);
                this.multipleTJs = true;
                break;
            }
            case 34: {
                object2 = commandParser.getStream();
                textState.setCharacterSpacing(commandParser.parseFloat(1));
                textState.setWordSpacing(commandParser.parseFloat(2));
                TD.relativeMove(0.0f, -textState.getLeading(), textState);
                this.multipleTJs = false;
                while (object2[n2] != 40 && object2[n2] != 60 && object2[n2] != 91) {
                    ++n2;
                }
                this.lastTextValue = tj.TJ(textState, this.currentFontData, (byte[])object2, n2, n3, this.multipleTJs);
                this.multipleTJs = true;
                break;
            }
            case 21613: {
                textState.Tm[0][0] = commandParser.parseFloat(5);
                textState.Tm[0][1] = commandParser.parseFloat(4);
                textState.Tm[0][2] = 0.0f;
                textState.Tm[1][0] = commandParser.parseFloat(3);
                textState.Tm[1][1] = commandParser.parseFloat(2);
                textState.Tm[1][2] = 0.0f;
                textState.Tm[2][0] = commandParser.parseFloat(1);
                textState.Tm[2][1] = commandParser.parseFloat(0);
                textState.Tm[2][2] = 1.0f;
                textState.setTMAtLineStart();
                this.multipleTJs = false;
                break;
            }
            case 21546: {
                TD.relativeMove(0.0f, -textState.getLeading(), textState);
                this.multipleTJs = false;
                break;
            }
            case 21618: {
                int n4 = TR.execute(commandParser.parseInt(), this.gs);
                if (!this.parserOptions.isRenderPage() || this.parserOptions.renderDirectly()) break;
                this.current.drawTR(n4);
                break;
            }
            case 21619: {
                textState.setTextRise(commandParser.parseFloat(0));
                break;
            }
            case 21623: {
                textState.setWordSpacing(commandParser.parseFloat(0));
                break;
            }
            case 21626: {
                textState.setHorizontalScaling(commandParser.parseFloat(0) / 100.0f);
                break;
            }
            case 21580: {
                textState.setLeading(commandParser.parseFloat(0));
            }
        }
        return n3;
    }

    public PdfObjectCache getObjectCache() {
        return this.cache;
    }

    public void setBBox(float[] fArray) {
        this.BBox = fArray;
    }

    public int getBlendMode() {
        return this.currentBlendMode;
    }

    static {
        indent = "";
        maxShapesAllowed = -1;
        SamplingFactory.setDownsampleMode(null);
        String string = System.getProperty("org.jpedal.maxShapeCount");
        if (string != null) {
            try {
                maxShapesAllowed = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new RuntimeException("Your setting (" + string + ")for org.jpedal.maxShapeCount is not a valid number " + exception);
            }
        }
    }
}

