/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.MaskUtils;
import org.jpedal.parser.image.XForm;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class XFormDecoder {
    static void processXForm(PdfStreamDecoder pdfStreamDecoder, int n, PdfObject pdfObject, Shape shape, CommandParser commandParser) {
        String string = pdfStreamDecoder.formName;
        String string2 = commandParser.generateOpAsString(0, true);
        try {
            if (ImageCommands.trackImages) {
                pdfStreamDecoder.imagesInFile = pdfStreamDecoder.imagesInFile == null ? string2 + " Form" : string2 + " Form\n" + pdfStreamDecoder.imagesInFile;
            }
            commandParser.reset();
            byte[] byArray = pdfStreamDecoder.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(pdfStreamDecoder.currentPdfFile.getObjectReader()));
            if (byArray != null) {
                Object object;
                boolean bl;
                String string3 = PdfStreamDecoder.indent;
                PdfStreamDecoder.indent = PdfStreamDecoder.indent + "   ";
                float[] fArray = new float[6];
                float[] fArray2 = pdfObject.getFloatArray(1145198201);
                float[] fArray3 = pdfObject.getFloatArray(303185736);
                if (fArray2 != null && pdfStreamDecoder.BBox != null && fArray3 != null) {
                    float f;
                    float f2;
                    if (pdfStreamDecoder.parserOptions.isFlattenedForm()) {
                        f2 = pdfStreamDecoder.BBox[2] - pdfStreamDecoder.BBox[0];
                        f = pdfStreamDecoder.BBox[3] - pdfStreamDecoder.BBox[1];
                    } else {
                        f2 = (pdfStreamDecoder.BBox[2] - pdfStreamDecoder.BBox[0]) / fArray2[0];
                        f = (pdfStreamDecoder.BBox[3] - pdfStreamDecoder.BBox[1]) / fArray2[3];
                    }
                    if (f2 == fArray3[2] - fArray3[0] && f == fArray3[3] - fArray3[1] && fArray2[4] == 0.0f && fArray2[5] == 0.0f) {
                        fArray2 = null;
                    }
                }
                boolean bl2 = bl = fArray2 == null || XForm.isIdentity(fArray2);
                if (fArray2 != null) {
                    fArray = fArray2;
                }
                int n2 = pdfStreamDecoder.graphicsStates.getDepth();
                float f = -1.0f;
                float[][] fArray4 = new float[3][3];
                for (int i = 0; i < 3; ++i) {
                    System.arraycopy(pdfStreamDecoder.gs.CTM[i], 0, fArray4[i], 0, 3);
                }
                float[][] fArray5 = fArray4;
                float[][] fArray6 = pdfStreamDecoder.gs.CTM;
                Object object2 = pdfStreamDecoder.gs.scaleFactor;
                if (fArray2 != null && !bl) {
                    object = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
                    object2 = object;
                    pdfStreamDecoder.gs.CTM = Matrix.multiply((float[][])object, fArray6);
                    f = fArray[0] * pdfStreamDecoder.gs.getLineWidth();
                    if (f == 0.0f) {
                        f = fArray[1] * pdfStreamDecoder.gs.getLineWidth();
                    }
                    if (f < 0.0f) {
                        f = -f;
                    }
                }
                ++pdfStreamDecoder.formLevel;
                if (pdfStreamDecoder.formLevel == 1) {
                    pdfStreamDecoder.formName = string2;
                } else if (pdfStreamDecoder.formLevel < 20) {
                    pdfStreamDecoder.formName = pdfStreamDecoder.formName + '_' + string2;
                }
                object = (GenericColorSpace)pdfStreamDecoder.gs.strokeColorSpace.clone();
                GenericColorSpace genericColorSpace = (GenericColorSpace)pdfStreamDecoder.gs.nonstrokeColorSpace.clone();
                if (f > 0.0f) {
                    pdfStreamDecoder.gs.setLineWidth(f);
                }
                float f3 = pdfStreamDecoder.gs.getAlphaMax(1);
                float f4 = pdfStreamDecoder.gs.getAlphaMax(2);
                float f5 = pdfStreamDecoder.gs.getAlpha(2);
                pdfStreamDecoder.gs.setMaxAlpha(1, pdfStreamDecoder.gs.getAlpha(1));
                if (pdfStreamDecoder.formLevel < 3 && f5 < f4) {
                    pdfStreamDecoder.gs.setMaxAlpha(2, f5);
                }
                PdfObjectCache pdfObjectCache = pdfStreamDecoder.cache.copy();
                pdfStreamDecoder.cache.reset(pdfObjectCache);
                PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
                pdfStreamDecoder.readResources(pdfObject2, false);
                pdfStreamDecoder.cache.groupObj = pdfObject.getDictionary(1111442775);
                pdfStreamDecoder.currentPdfFile.checkResolved(pdfStreamDecoder.cache.groupObj);
                float[] fArray7 = pdfObject.getFloatArray(303185736);
                Area area = null;
                boolean bl3 = false;
                if (fArray7 != null && fArray7[2] > 1.0f && fArray7[3] > 1.0f && pdfStreamDecoder.gs.getClippingShape() == null && pdfStreamDecoder.gs.CTM[0][1] == 0.0f && pdfStreamDecoder.gs.CTM[1][0] == 0.0f && pdfStreamDecoder.gs.CTM[2][1] != 0.0f && pdfStreamDecoder.gs.CTM[2][0] < 0.0f) {
                    area = XForm.setClip(shape, fArray7, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    bl3 = true;
                } else if (fArray7 != null && fArray7[0] == 0.0f && fArray7[1] == 0.0f && fArray7[2] > 1.0f && fArray7[3] > 1.0f && fArray7[2] != fArray7[3] && ((double)pdfStreamDecoder.gs.CTM[0][0] > 0.99 || pdfStreamDecoder.gs.CTM[2][1] < -1.0f) && (pdfStreamDecoder.gs.CTM[2][0] < -1.0f || pdfStreamDecoder.gs.CTM[2][0] > 1.0f) && pdfStreamDecoder.gs.CTM[2][1] != 0.0f) {
                    area = XForm.setClip(shape, fArray7, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    bl3 = true;
                } else if (fArray7 != null && fArray7[0] == 0.0f && fArray7[1] == 0.0f && fArray7[2] > 1.0f && fArray7[3] > 1.0f && !(pdfStreamDecoder.gs.CTM[2][0] < 0.0f) && (pdfStreamDecoder.formLevel > 0 || pdfStreamDecoder.gs.getClippingShape() != null)) {
                    area = XForm.setClip(shape, fArray7, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    bl3 = true;
                } else if (pdfStreamDecoder.formLevel > 1 && fArray7 != null && fArray7[0] > 50.0f && fArray7[1] > 50.0f && pdfStreamDecoder.gs.getClippingShape() != null && fArray7[0] - 1.0f > (float)pdfStreamDecoder.gs.getClippingShape().getBounds().x && fArray7[1] - 1.0f > (float)pdfStreamDecoder.gs.getClippingShape().getBounds().y) {
                    area = XForm.setClip(shape, fArray7, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    bl3 = true;
                } else if (fArray7 != null && fArray7[2] > 1.0f && fArray7[3] > 1.0f && pdfStreamDecoder.gs.getClippingShape() == null && pdfStreamDecoder.gs.CTM[0][1] > 0.0f && pdfStreamDecoder.gs.CTM[1][0] < 0.0f && pdfStreamDecoder.gs.CTM[0][0] == 0.0f && pdfStreamDecoder.gs.CTM[1][1] == 0.0f) {
                    area = XForm.setClip(shape, fArray7, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                    bl3 = true;
                }
                if (byArray.length > 0) {
                    PdfObject pdfObject3 = XForm.getSMask(fArray7, pdfStreamDecoder.gs, pdfStreamDecoder.currentPdfFile);
                    int n3 = pdfStreamDecoder.gs.getBMValue();
                    if ((pdfStreamDecoder.parserOptions.getExtractionMode() & 0x400) == 1024) {
                        XFormDecoder.processXFormAsImage(pdfObject, pdfStreamDecoder);
                    }
                    if (pdfObject3 != null || n3 != 1111314299) {
                        XFormDecoder.processXFormWithMaskOrBlend(false, pdfObject3, pdfStreamDecoder, n3, pdfObject, string2);
                    } else {
                        int n4 = pdfStreamDecoder.gs.getBMValue();
                        pdfStreamDecoder.decodeStreamIntoObjects(byArray, false);
                        pdfStreamDecoder.current.setGraphicsState(1, pdfStreamDecoder.gs.getAlpha(1), n4);
                        pdfStreamDecoder.current.setGraphicsState(2, pdfStreamDecoder.gs.getAlpha(2), n4);
                    }
                }
                if (bl3) {
                    pdfStreamDecoder.gs.setClippingShape(area);
                    pdfStreamDecoder.current.drawClip(pdfStreamDecoder.gs, area, false);
                }
                --pdfStreamDecoder.formLevel;
                pdfStreamDecoder.graphicsStates.correctDepth(n2, pdfStreamDecoder.gs, pdfStreamDecoder.current);
                if (fArray5 != null) {
                    pdfStreamDecoder.gs.CTM = fArray5;
                } else if (pdfStreamDecoder.gs.CTM[0][0] == 1.0f && pdfStreamDecoder.gs.CTM[1][1] == 1.0f) {
                    pdfStreamDecoder.gs.CTM = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                }
                pdfStreamDecoder.gs.scaleFactor = object2;
                pdfStreamDecoder.gs.strokeColorSpace = object;
                pdfStreamDecoder.gs.nonstrokeColorSpace = genericColorSpace;
                pdfStreamDecoder.cache.restore(pdfObjectCache);
                pdfStreamDecoder.gs.setMaxAlpha(1, f3);
                pdfStreamDecoder.gs.setMaxAlpha(2, f4);
                PdfStreamDecoder.indent = string3;
            }
        }
        catch (Error error) {
            LogWriter.writeLog("Exception: " + error.getMessage());
            pdfStreamDecoder.parserOptions.imagesProcessedFully = false;
            pdfStreamDecoder.errorTracker.addPageFailureMessage("Error " + error + " in DO");
            if (ExternalHandlers.throwMissingCIDError && error.getMessage() != null && error.getMessage().contains("kochi")) {
                throw error;
            }
        }
        catch (PdfException pdfException) {
            LogWriter.writeLog("Exception " + pdfException);
            pdfStreamDecoder.parserOptions.imagesProcessedFully = false;
            pdfStreamDecoder.errorTracker.addPageFailureMessage("Error " + pdfException + " in DO");
        }
        pdfStreamDecoder.formName = string;
    }

    static void processXFormWithMaskOrBlend(boolean bl, PdfObject pdfObject, PdfStreamDecoder pdfStreamDecoder, int n, PdfObject pdfObject2, String string) {
        if (bl) {
            System.out.println("createMaskForm " + pdfObject);
        }
        if (pdfObject == null) {
            pdfStreamDecoder.current.setGraphicsState(1, pdfStreamDecoder.gs.getAlpha(1), 1111314299);
            pdfStreamDecoder.current.setGraphicsState(2, pdfStreamDecoder.gs.getAlpha(2), 1111314299);
        }
        boolean bl2 = pdfObject != null || n != 1111314299 || pdfStreamDecoder.gs.getAlpha(2) == 1.0f;
        MaskUtils.createMaskForm(pdfObject2, string, pdfObject, pdfStreamDecoder.gs, pdfStreamDecoder.current, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.parserOptions, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer, bl2);
        if (pdfObject == null) {
            pdfStreamDecoder.current.setGraphicsState(1, pdfStreamDecoder.gs.getAlpha(1), n);
            pdfStreamDecoder.current.setGraphicsState(2, pdfStreamDecoder.gs.getAlpha(2), n);
        }
    }

    static void processXFormAsImage(PdfObject pdfObject, PdfStreamDecoder pdfStreamDecoder) {
        float[] fArray = pdfObject.getFloatArray(303185736);
        int n = (int)fArray[0];
        int n2 = (int)fArray[1];
        int n3 = (int)fArray[2];
        int n4 = (int)fArray[3];
        if (n < 0) {
            n = 0;
        }
        BufferedImage bufferedImage = MaskUtils.createTransparentForm(pdfObject, n, n2, n3, n4, pdfStreamDecoder.currentPdfFile, pdfStreamDecoder.parserOptions, pdfStreamDecoder.formLevel, pdfStreamDecoder.multiplyer);
        String string = 'R' + pdfStreamDecoder.formName;
        pdfStreamDecoder.pdfImages.setImageInfo(string, pdfStreamDecoder.parserOptions.getPageNumber(), pdfStreamDecoder.gs.CTM[2][0], pdfStreamDecoder.gs.CTM[2][1], n3, n4);
        pdfStreamDecoder.objectStoreStreamRef.saveStoredImage('R' + string, bufferedImage, false, false, "jpg");
        pdfStreamDecoder.objectStoreStreamRef.saveStoredImage(string, bufferedImage, false, false, "jpg");
    }
}

