/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.MaskDataDecoder;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class MaskDecoder {
    static byte[] applyMask(ImageData imageData, GenericColorSpace genericColorSpace, PdfObject pdfObject, PdfObject pdfObject2, byte[] byArray) {
        int[] nArray = pdfObject.getIntArray(489767739);
        if (nArray != null) {
            nArray = MaskDecoder.convertToRGB(nArray, genericColorSpace);
        }
        byte[] byArray2 = imageData.getObjectData();
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = imageData.getDepth();
        byArray2 = MaskDataDecoder.convertData(genericColorSpace, byArray2, n, n2, imageData, n3, 1, null);
        pdfObject2.setIntNumber(-1344207655, 8);
        byArray2 = nArray != null ? MaskDecoder.applyMaskArray(n, n2, byArray2, nArray) : MaskDecoder.applyMaskStream(byArray2, byArray, imageData, pdfObject, pdfObject2);
        return byArray2;
    }

    private static byte[] applyMaskArray(int n, int n2, byte[] byArray, int[] nArray) {
        int n3;
        int n4 = n * n2 * 4;
        int n5 = 0;
        byte[] byArray2 = new byte[n * n2 * 4];
        int n6 = byArray.length;
        float[] fArray = new float[3];
        if (nArray != null) {
            for (n3 = 0; n3 < 3; ++n3) {
                fArray[n3] = nArray[1] - nArray[0];
                if (!(fArray[n3] > 1.0f)) continue;
                int n7 = n3;
                fArray[n7] = fArray[n7] / 255.0f;
            }
        }
        try {
            for (n3 = 0; n3 < n4; n3 += 4) {
                if (n5 + 3 <= n6 && byArray[n5] == -1 && byArray[n5 + 1] == -1 && byArray[n5 + 2] == -1) {
                    n5 += 3;
                    byArray2[n3] = -1;
                    byArray2[n3 + 1] = -1;
                    byArray2[n3 + 2] = -1;
                    byArray2[n3 + 3] = 0;
                    continue;
                }
                if (n5 + 3 <= n6 && byArray[n5] == 0 && byArray[n5 + 1] == 0 && byArray[n5 + 2] == 0) {
                    n5 += 3;
                    byArray2[n3] = -1;
                    byArray2[n3 + 1] = 0;
                    byArray2[n3 + 2] = 0;
                    byArray2[n3 + 3] = 0;
                    continue;
                }
                for (int i = 0; i < 3; ++i) {
                    if (n5 < n6) {
                        byArray2[n3 + i] = byArray[n5];
                    }
                    ++n5;
                }
                byArray2[n3 + 3] = -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    static byte[] applyMaskStream(byte[] byArray, byte[] byArray2, ImageData imageData, PdfObject pdfObject, PdfObject pdfObject2) {
        float f;
        float[] fArray;
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = pdfObject.getInt(959726687);
        int n4 = pdfObject.getInt(959926393);
        int n5 = pdfObject.getInt(-1344207655);
        boolean bl = pdfObject.getBoolean(1516403337);
        if (bl) {
            n5 = 1;
        }
        if (n5 != 8) {
            byArray2 = ColorSpaceConvertor.normaliseTo8Bit(n5, n3, n4, byArray2);
        }
        if ((fArray = pdfObject.getFloatArray(859785322)) != null && (f = fArray[1] - fArray[0]) == -1.0f) {
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
            }
        }
        if (n == n3 && n2 == n4) {
            byArray = MaskDecoder.buildUnscaledByteArray(n, n2, byArray, byArray2);
        } else if (n < n3) {
            byArray = MaskDecoder.upScaleImageToMask(n, n2, n3, n4, byArray, byArray2);
            pdfObject2.setIntNumber(959726687, n3);
            pdfObject2.setIntNumber(959926393, n4);
        } else {
            byArray = MaskDecoder.upScaleMaskToImage(n, n2, n3, n4, byArray, byArray2);
        }
        pdfObject2.setIntNumber(-1344207655, 8);
        return byArray;
    }

    static BufferedImage createMaskImage(boolean bl, boolean bl2, GraphicsState graphicsState, boolean bl3, DynamicVectorRenderer dynamicVectorRenderer, byte[] byArray, BufferedImage bufferedImage, int n, int n2, ImageData imageData, boolean bl4, int n3, GenericColorSpace genericColorSpace, byte[] byArray2, String string) {
        if (bl) {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            int[] nArray = new int[]{0, 1, 2, 3};
            bufferedImage = new BufferedImage(n, n2, 2);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 4, 4, nArray, null);
            bufferedImage.setData(writableRaster);
        } else {
            boolean bl5 = true;
            if (n2 >= 20 || imageData.getMode() != 0) {
                bl5 = dynamicVectorRenderer.hasObjectsBehind(graphicsState.CTM);
            }
            boolean bl6 = false;
            boolean bl7 = false;
            if (bl4 && n3 == 1 && genericColorSpace.getID() == 1785221209 && byArray2[0] == 0 && byArray2[1] == 0 && byArray2[2] == 0) {
                bl6 = true;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == -1) continue;
                    bl6 = false;
                    i = byArray.length;
                }
                if (bl2 && (imageData.getMode() == 0 || bl3 || n3 == 1)) {
                    WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, 1, null);
                    bufferedImage = new BufferedImage(n, n2, 12);
                    bufferedImage.setData(writableRaster);
                    bl7 = true;
                } else if (bl6) {
                    bufferedImage = null;
                    imageData.setRemoved(true);
                } else {
                    byte[] byArray3 = new byte[]{byArray2[0], byArray2[1], byArray2[2], -1, -1, -1};
                    bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(n3, n, n2, byArray, byArray3, true, true);
                }
            }
            if (!bl6) {
                if (!(bl2 || byArray2[0] != 0 || byArray2[1] != 0 || byArray2[2] != 0 || bl5 || bl3 || genericColorSpace.getID() == 1785221209)) {
                    if (n3 == 1) {
                        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, 1, null);
                        bufferedImage = new BufferedImage(n, n2, 12);
                        bufferedImage.setData(writableRaster);
                    } else {
                        int[] nArray = new int[]{0};
                        WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n, 1, nArray, null);
                        bufferedImage = new BufferedImage(n, n2, 10);
                        bufferedImage.setData(writableRaster);
                    }
                } else if (!bl7) {
                    if (n3 == 8 && bl) {
                        byte[] byArray4 = new byte[]{byArray2[0], byArray2[1], byArray2[2], -1, -1, -1};
                        bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(n3, n, n2, byArray, byArray4, true, true);
                    } else if (n < 4000 && n2 < 4000 || bl5) {
                        byte[] byArray5 = new byte[]{byArray2[0], byArray2[1], byArray2[2], -1, -1, -1};
                        bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(1, n, n2, byArray, byArray5, true, false);
                    } else {
                        LogWriter.writeLog("Image too big " + n + ' ' + n2 + ' ' + string);
                    }
                }
            }
        }
        return bufferedImage;
    }

    private static byte[] buildUnscaledByteArray(int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3 = n * n2 * 4;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray3 = new byte[n * n2 * 4];
        int n6 = byArray.length;
        try {
            for (int i = 0; i < n3; i += 4) {
                int n7;
                if (byArray2[n5] == -1) {
                    for (n7 = 0; n7 < 3; ++n7) {
                        if (n4 < n6) {
                            byArray3[i + n7] = -1;
                        }
                        ++n4;
                    }
                    byArray3[i + 3] = 0;
                } else {
                    for (n7 = 0; n7 < 3; ++n7) {
                        if (n4 < n6) {
                            byArray3[i + n7] = byArray[n4];
                        }
                        ++n4;
                    }
                    byArray3[i + 3] = -1;
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    private static byte[] upScaleMaskToImage(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = 0;
        int n6 = 0;
        float f = (float)n3 / (float)n;
        float f2 = (float)n4 / (float)n2;
        byte[] byArray3 = new byte[n * n2 * 4];
        int n7 = byArray.length;
        try {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n8;
                    int n9 = (int)((float)j * f) + (int)((float)i * f2) * n;
                    if (byArray2[n9] == -1) {
                        for (n8 = 0; n8 < 3; ++n8) {
                            if (n5 < n7) {
                                byArray3[n6 + n8] = -1;
                            }
                            ++n5;
                        }
                        byArray3[n6 + 3] = 0;
                    } else {
                        for (n8 = 0; n8 < 3; ++n8) {
                            if (n5 < n7) {
                                byArray3[n6 + n8] = byArray[n5];
                            }
                            ++n5;
                        }
                        byArray3[n6 + 3] = -1;
                    }
                    n6 += 4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    private static byte[] upScaleImageToMask(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = 0;
        int n6 = 0;
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        byte[] byArray3 = new byte[n3 * n4 * 4];
        int n7 = byArray.length;
        try {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n8;
                    int n9 = (int)((float)j * f) * 3 + (int)((float)i * f2) * n * 3;
                    if (byArray2[n5] == -1) {
                        for (n8 = 0; n8 < 3; ++n8) {
                            if (n9 < n7) {
                                byArray3[n6 + n8] = -1;
                            }
                            ++n9;
                        }
                        byArray3[n6 + 3] = 0;
                    } else {
                        for (n8 = 0; n8 < 3; ++n8) {
                            if (n9 < n7) {
                                byArray3[n6 + n8] = byArray[n9];
                            }
                            ++n9;
                        }
                        byArray3[n6 + 3] = -1;
                    }
                    ++n5;
                    n6 += 4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    private static int[] convertToRGB(int[] nArray, GenericColorSpace genericColorSpace) {
        int n;
        int[] nArray2;
        byte[] byArray = genericColorSpace.getIndexedMap();
        if (byArray != null) {
            byArray = genericColorSpace.convertIndexToRGB(byArray);
            nArray2 = nArray;
            nArray = new int[6];
            for (int i = 0; i < 2; ++i) {
                n = nArray2[i];
                nArray[0 + 3 * i] = (byte)(byArray[0 + 3 * n] & 0xFF);
                nArray[1 + 3 * i] = (byte)(byArray[1 + 3 * n] & 0xFF);
                nArray[2 + 3 * i] = (byte)(byArray[2 + 3 * n] & 0xFF);
            }
        }
        n = nArray.length / 2;
        nArray2 = new int[6];
        float[] fArray = new float[n];
        for (int i = 0; i < 2; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                fArray[n2] = nArray[n2 * 2];
                if (fArray[n2] > 1.0f) {
                    int n3 = n2;
                    fArray[n3] = fArray[n3] / 255.0f;
                }
                genericColorSpace.setColor(fArray, n);
            }
            n2 = genericColorSpace.getColor().getRGB();
            for (int j = 0; j < n; ++j) {
                nArray2[0 + 3 * i] = (byte)(n2 >> 16 & 0xFF);
                nArray2[1 + 3 * i] = (byte)(n2 >> 8 & 0xFF);
                nArray2[2 + 3 * i] = (byte)(n2 & 0xFF);
            }
        }
        return nArray2;
    }
}

