/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.JPeg2000ImageDecoder;
import org.jpedal.parser.image.MaskDataDecoder;
import org.jpedal.parser.image.data.ImageData;

class SMaskDecoder {
    SMaskDecoder() {
    }

    public static byte[] applyJPX_JBIG_Smask(ImageData imageData, ImageData imageData2, byte[] byArray, PdfObject pdfObject, PdfObject pdfObject2, GenericColorSpace genericColorSpace, GenericColorSpace genericColorSpace2) {
        byte[] byArray2;
        byte[] byArray3 = imageData.getObjectData();
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = imageData.getDepth();
        float[] fArray = pdfObject2.getFloatArray(826557522);
        imageData2.getFilter(pdfObject2);
        if (imageData2.isDCT()) {
            byArray = JPEGDecoder.getBytesFromJPEG(byArray, genericColorSpace2, pdfObject2);
            pdfObject2.setMixedArray(1011108731, null);
            pdfObject2.setDecodedStream(byArray);
        } else if (imageData2.isJPX()) {
            byArray = JPeg2000ImageDecoder.getBytesFromJPEG2000(byArray, genericColorSpace2, pdfObject2);
            pdfObject2.setMixedArray(1011108731, null);
            pdfObject2.setDecodedStream(byArray);
        } else {
            byArray3 = ColorSpaceConvertor.normaliseTo8Bit(n3, n, n2, byArray3);
        }
        int n4 = imageData2.getWidth();
        int n5 = imageData2.getHeight();
        int n6 = imageData2.getDepth();
        float[] fArray2 = pdfObject2.getFloatArray(859785322);
        if (fArray2 != null && fArray2[0] == 1.0f && fArray2[1] == 0.0f) {
            int n7 = 0;
            while (n7 < byArray.length) {
                int n8 = n7++;
                byArray[n8] = (byte)(byArray[n8] ^ 0xFF);
            }
        }
        if ((byArray2 = genericColorSpace.getIndexedMap()) != null) {
            byArray2 = genericColorSpace.convertIndexToRGB(byArray2);
            byArray3 = ColorSpaceConvertor.convertIndexToRGBByte(byArray2, n, n2, imageData.getCompCount(), n3, byArray3, false, false);
        } else if (!(imageData.isDCT() || imageData.isJPX() || imageData.isJBIG())) {
            if (genericColorSpace.getID() == 1568372915) {
                byArray3 = genericColorSpace.dataToRGBByteArray(byArray3, n, n2, false);
                if (fArray != null) {
                    fArray = new float[]{fArray[0], fArray[0], fArray[0]};
                }
            } else if (genericColorSpace.getID() != 1008872003 && genericColorSpace.getID() != 1785221209) {
                byArray3 = genericColorSpace.dataToRGBByteArray(byArray3, n, n2, false);
            }
        }
        byArray = ColorSpaceConvertor.normaliseTo8Bit(n6, n4, n5, byArray);
        int n9 = n * n2;
        int n10 = n4 * n5;
        if (n9 > n10) {
            byArray = SMaskDecoder.getScaledBytes(byArray, n4, n5, n, n2);
        } else if (n10 > n9) {
            byArray3 = SMaskDecoder.getScaledBytes(byArray3, n, n2, n4, n5);
            n9 = n10;
            n = n4;
            n2 = n5;
        }
        int n11 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n * n2 * 4);
        if (n9 == byArray3.length) {
            int n12 = 0;
            for (int i = 0; i < n9; ++i) {
                byte by = byArray3[i];
                for (int j = 0; j < 3; ++j) {
                    byteBuffer.put(by);
                }
                byteBuffer.put(byArray[n12++]);
            }
        } else if (fArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                int n13 = byArray[i] & 0xFF;
                int n14 = byArray3[n11++] & 0xFF;
                int n15 = byArray3[n11++] & 0xFF;
                int n16 = byArray3[n11++] & 0xFF;
                if (n13 != 0) {
                    double d = 255.0 / (double)n13;
                    n14 = (int)((double)((float)n14 - fArray[0]) * d + (double)fArray[0]);
                    n15 = (int)((double)((float)n15 - fArray[1]) * d + (double)fArray[1]);
                    n16 = (int)((double)((float)n16 - fArray[2]) * d + (double)fArray[2]);
                    int n17 = n14 < 0 ? 0 : (n14 = n14 > 255 ? 255 : n14);
                    int n18 = n15 < 0 ? 0 : (n15 = n15 > 255 ? 255 : n15);
                    n16 = n16 < 0 ? 0 : (n16 > 255 ? 255 : n16);
                }
                byte[] byArray4 = new byte[]{(byte)n14, (byte)n15, (byte)n16, (byte)n13};
                byteBuffer.put(byArray4);
            }
        } else {
            int n19 = n9 * 3;
            if (byArray3.length < n19) {
                byte[] byArray5 = new byte[n19];
                System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
                byArray3 = byArray5;
            }
            int n20 = Math.min(byArray.length, n * n2);
            for (int i = 0; i < n20; ++i) {
                byteBuffer.put(new byte[]{byArray3[n11++], byArray3[n11++], byArray3[n11++], byArray[i]});
            }
        }
        pdfObject.setIntNumber(959726687, n);
        pdfObject.setIntNumber(959926393, n2);
        pdfObject.setIntNumber(-1344207655, 8);
        return byteBuffer.array();
    }

    private static byte[] getScaledBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        if (byArray.length == n * n2) {
            return SMaskDecoder.rescaleComponent(byArray, n, n2, n3, n4);
        }
        int n5 = n * n2;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = new byte[n5];
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            byArray2[i] = byArray[n6++];
            byArray3[i] = byArray[n6++];
            byArray4[i] = byArray[n6++];
        }
        byArray2 = SMaskDecoder.rescaleComponent(byArray2, n, n2, n3, n4);
        byArray3 = SMaskDecoder.rescaleComponent(byArray3, n, n2, n3, n4);
        byArray4 = SMaskDecoder.rescaleComponent(byArray4, n, n2, n3, n4);
        n6 = 0;
        n5 = n3 * n4;
        byte[] byArray5 = new byte[n5 * 3];
        for (int i = 0; i < n5; ++i) {
            byArray5[n6++] = byArray2[i];
            byArray5[n6++] = byArray3[i];
            byArray5[n6++] = byArray4[i];
        }
        return byArray5;
    }

    private static byte[] rescaleComponent(byte[] byArray, int n, int n2, int n3, int n4) {
        if (byArray.length == 1) {
            byte by = byArray[0];
            byArray = new byte[n3 * n4];
            Arrays.fill(byArray, by);
            return byArray;
        }
        if (n2 == 1) {
            byte[] byArray2 = new byte[2 * n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            System.arraycopy(byArray, 0, byArray2, n, n);
            n2 = 2;
            byArray = byArray2;
        }
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        byte[] byArray3 = new byte[n3 * n4];
        int n5 = byArray.length;
        int n6 = 0;
        try {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n7 = (int)((float)j * f) + (int)((float)i * f2) * n;
                    if (n7 < n5) {
                        byArray3[n6] = byArray[n7];
                    }
                    ++n6;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    static byte[] applySMask(byte[] byArray, ImageData imageData, GenericColorSpace genericColorSpace, PdfObject pdfObject, PdfObject pdfObject2) {
        byte[] byArray2 = imageData.getObjectData();
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = imageData.getDepth();
        int n4 = pdfObject.getInt(959726687);
        int n5 = pdfObject.getInt(959926393);
        int n6 = pdfObject.getInt(-1344207655);
        byArray2 = MaskDataDecoder.convertSmaskData(genericColorSpace, byArray2, n, n2, imageData, n3, n6, byArray, pdfObject);
        if (n6 != 8) {
            byArray = ColorSpaceConvertor.normaliseTo8Bit(n6, n4, n5, byArray);
        }
        if (n == n4 && n2 == n5) {
            byArray2 = SMaskDecoder.buildUnscaledByteArray(n, n2, byArray2, byArray);
        } else if (n < n4) {
            byArray2 = SMaskDecoder.upScaleImageToMask(n, n2, n4, n5, byArray2, byArray);
            pdfObject2.setIntNumber(959726687, n4);
            pdfObject2.setIntNumber(959926393, n5);
        } else {
            byArray2 = SMaskDecoder.upScaleMaskToImage(n, n2, n4, n5, byArray2, byArray);
        }
        pdfObject2.setIntNumber(-1344207655, 8);
        return byArray2;
    }

    static void check4BitData(byte[] byArray) {
        int n = byArray.length;
        boolean bl = true;
        for (byte by : byArray) {
            if (by >= 0 && by <= 15) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(byArray[i] << 4);
            }
        }
    }

    private static byte[] upScaleMaskToImage(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = 0;
        int n6 = 0;
        float f = (float)n3 / (float)n;
        float f2 = (float)n4 / (float)n2;
        byte[] byArray3 = new byte[n * n2 * 4];
        int n7 = byArray.length;
        try {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        if (n5 < n7) {
                            byArray3[n6 + k] = byArray[n5];
                        }
                        ++n5;
                    }
                    int n8 = (int)((float)j * f) + (int)((float)i * f2) * n;
                    byArray3[n6 + 3] = byArray2[n8];
                    n6 += 4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    private static byte[] upScaleImageToMask(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = 0;
        int n6 = 0;
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        byte[] byArray3 = new byte[n3 * n4 * 4];
        int n7 = byArray.length;
        int n8 = byArray2.length;
        try {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n9 = (int)((float)j * f) * 3 + (int)((float)i * f2) * n * 3;
                    for (int k = 0; k < 3; ++k) {
                        if (n9 < n7) {
                            byArray3[n6 + k] = byArray[n9];
                        }
                        ++n9;
                    }
                    if (n5 < n8) {
                        byArray3[n6 + 3] = byArray2[n5];
                        ++n5;
                    }
                    n6 += 4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    static byte[] getSMaskData(byte[] byArray, ImageData imageData, PdfObject pdfObject, GenericColorSpace genericColorSpace) {
        imageData.getFilter(pdfObject);
        if (imageData.isDCT()) {
            byArray = JPEGDecoder.getBytesFromJPEG(byArray, genericColorSpace, pdfObject);
            pdfObject.setMixedArray(1011108731, null);
            pdfObject.setDecodedStream(byArray);
        } else if (imageData.isJPX()) {
            byArray = JPeg2000ImageDecoder.getBytesFromJPEG2000(byArray, genericColorSpace, pdfObject);
            pdfObject.setMixedArray(1011108731, null);
            pdfObject.setDecodedStream(byArray);
        }
        return byArray;
    }

    private static byte[] buildUnscaledByteArray(int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3 = n * n2 * 4;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray3 = new byte[n * n2 * 4];
        int n6 = byArray.length;
        int n7 = byArray2.length;
        try {
            for (int i = 0; i < n3; i += 4) {
                for (int j = 0; j < 3; ++j) {
                    if (n4 < n6) {
                        byArray3[i + j] = byArray[n4];
                    }
                    ++n4;
                }
                if (n5 >= n7) continue;
                byArray3[i + 3] = byArray2[n5];
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }
}

