/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.utils;

import java.awt.image.BufferedImage;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.external.ErrorTracker;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

public class JPegImageDecoder {
    public static BufferedImage decode(String string, int n, int n2, boolean bl, GenericColorSpace genericColorSpace, byte[] byArray, float[] fArray, ImageData imageData, PdfObject pdfObject, ErrorTracker errorTracker, ParserOptions parserOptions) {
        GenericColorSpace genericColorSpace2 = genericColorSpace;
        BufferedImage bufferedImage = null;
        LogWriter.writeLog("JPeg Image " + string + ' ' + n + "W * " + n2 + 'H' + " arrayInverted=" + bl);
        boolean bl2 = false;
        if (genericColorSpace.getID() == 1247168582) {
            int n3 = genericColorSpace.getAlternateColorSpace();
            GenericColorSpace genericColorSpace3 = null;
            if (n3 == 1785221209) {
                genericColorSpace3 = new DeviceRGBColorSpace();
            } else if (n3 == 1498837125) {
                genericColorSpace3 = new DeviceCMYKColorSpace();
            }
            if (genericColorSpace3 != null) {
                try {
                    bufferedImage = genericColorSpace3.JPEGToRGBImage(byArray, n, n2, fArray, imageData.getpX(), imageData.getpY(), bl, pdfObject);
                    if (bufferedImage != null) {
                        bl2 = true;
                        genericColorSpace2 = genericColorSpace3;
                        if (genericColorSpace2.isImageYCCK()) {
                            parserOptions.hasYCCKimages = true;
                        }
                    }
                }
                catch (Exception exception) {
                    errorTracker.addPageFailureMessage("Unable to use alt colorspace with " + string + " to JPEG");
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                    bufferedImage = null;
                }
            }
        }
        if (!bl2) {
            try {
                bufferedImage = genericColorSpace2.JPEGToRGBImage(byArray, n, n2, fArray, imageData.getpX(), imageData.getpY(), bl, pdfObject);
                if (genericColorSpace2.isImageYCCK()) {
                    parserOptions.hasYCCKimages = true;
                }
            }
            catch (Exception exception) {
                errorTracker.addPageFailureMessage("Problem converting " + string + " to JPEG");
                LogWriter.writeLog("Exception: " + exception.getMessage());
                bufferedImage.flush();
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }
}

