/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;
import org.jpedal.render.DynamicVectorRenderer;

class EscapedTextUtils {
    EscapedTextUtils() {
    }

    static int getEscapedValue(int n, byte[] byArray, GlyphData glyphData, PdfFont pdfFont, int n2, ParserOptions parserOptions, DynamicVectorRenderer dynamicVectorRenderer) {
        String string;
        int n3;
        glyphData.setLastChar(glyphData.getRawChar());
        if (n2 > ++n + 2 && Character.isDigit((char)byArray[n])) {
            n3 = 1;
            if (Character.isDigit((char)byArray[n + 1])) {
                ++n3;
                if (Character.isDigit((char)byArray[n + 2])) {
                    ++n3;
                }
            }
            int n4 = TD.readEscapeValue(n, n3, 8, byArray);
            n = n + n3 - 1;
            if (n4 > 255) {
                n4 -= 256;
            }
            glyphData.setRawChar((char)n4);
            glyphData.setRawInt(n4);
            glyphData.setDisplayValue(pdfFont.getGlyphValue(n4));
            if (parserOptions.isTextExtracted()) {
                int n5;
                glyphData.setUnicodeValue(pdfFont.getUnicodeValue(glyphData.getDisplayValue(), n4));
                if (glyphData.getUnicodeValue().length() > 1 && (n5 = StandardFonts.getAdobeMap(glyphData.getUnicodeValue())) != -1) {
                    glyphData.setUnicodeValue(String.valueOf((char)n5));
                }
            }
            if (glyphData.getRawChar() == '\\') {
                glyphData.setRawChar('x');
            }
        } else {
            n3 = byArray[n] & 0xFF;
            glyphData.setRawChar((char)n3);
            if (glyphData.getRawChar() == 'u') {
                n3 = TD.readEscapeValue(n + 1, 4, 16, byArray);
                n += 4;
                glyphData.setDisplayValue(pdfFont.getGlyphValue(n3));
                if (parserOptions.isTextExtracted()) {
                    glyphData.setUnicodeValue(pdfFont.getUnicodeValue(glyphData.getDisplayValue(), n3));
                }
            } else {
                char c = glyphData.getRawChar();
                if (c == 'n') {
                    n3 = 10;
                    glyphData.setRawChar('\n');
                } else if (c == 'b') {
                    n3 = 8;
                    glyphData.setRawChar('\b');
                } else if (c == 't') {
                    n3 = 9;
                    glyphData.setRawChar('\t');
                } else if (c == 'r') {
                    n3 = 13;
                    glyphData.setRawChar('\r');
                } else if (c == 'f') {
                    n3 = 12;
                    glyphData.setRawChar('\f');
                }
                glyphData.setDisplayValue(pdfFont.getGlyphValue(n3));
                if (parserOptions.isTextExtracted()) {
                    glyphData.setUnicodeValue(pdfFont.getUnicodeValue(glyphData.getDisplayValue(), n3));
                }
                if (!glyphData.getDisplayValue().isEmpty()) {
                    glyphData.setRawChar(glyphData.getDisplayValue().charAt(0));
                }
            }
            glyphData.setRawInt(n3);
        }
        if (pdfFont.getFontType() == 1228944677 && dynamicVectorRenderer.isHTMLorSVG() && (string = pdfFont.getMappedChar(glyphData.getRawInt(), true)) != null && string.length() == 1 && string.equalsIgnoreCase(glyphData.getUnicodeValue().toLowerCase())) {
            glyphData.set(string);
        }
        return n;
    }
}

