/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.GlyphTracker;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.MarkerGlyph;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.UnrendererGlyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.text.CIDTextUtils;
import org.jpedal.parser.text.CharReader;
import org.jpedal.parser.text.EscapedTextUtils;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.HTMLTextUtils;
import org.jpedal.parser.text.HexTextUtils;
import org.jpedal.parser.text.JavaTextRenderer;
import org.jpedal.parser.text.Leading;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class Tj
extends BaseDecoder {
    public static boolean showInvisibleText;
    private PdfData pdfData;
    private PdfFont currentFontData;
    private final Vector_Rectangle_Int textAreas;
    private final Vector_Int textDirections;
    private TextState currentTextState = new TextState();
    private final GlyphData glyphData = new GlyphData();
    private GlyphTracker customGlyphTracker;
    private StructuredContentHandler contentHandler;
    private boolean ttHintingRequired;
    private String tjTextValue = "";
    static final String[] hex;
    private float charSpacing;
    private final GlyphFactory factory;
    private PdfJavaGlyphs glyphs;
    private float[][] Trm;
    private boolean returnText;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float lastWidth;
    private float currentWidth;
    private String actualText;
    private final DynamicVectorRenderer current;
    private int streamLength;
    private float[][] TrmBeforeSpace = new float[3][3];
    private boolean isTabRemapped;
    private boolean isCRRemapped;
    private boolean isReturnRemapped;
    private final ErrorTracker errorTracker;

    public Tj(ParserOptions parserOptions, PdfData pdfData, boolean bl, Vector_Rectangle_Int vector_Rectangle_Int, Vector_Int vector_Int, DynamicVectorRenderer dynamicVectorRenderer, ErrorTracker errorTracker) {
        this.parserOptions = parserOptions;
        this.pdfData = pdfData;
        this.glyphData.setXMLExtraction(bl);
        this.textAreas = vector_Rectangle_Int;
        this.textDirections = vector_Int;
        this.current = dynamicVectorRenderer;
        this.errorTracker = errorTracker;
        this.factory = new T1GlyphFactory(parserOptions.useJavaFX());
    }

    public Tj(ParserOptions parserOptions, Vector_Rectangle_Int vector_Rectangle_Int, Vector_Int vector_Int, DynamicVectorRenderer dynamicVectorRenderer, ErrorTracker errorTracker) {
        this.parserOptions = parserOptions;
        this.factory = new T1GlyphFactory(parserOptions.useJavaFX());
        this.textAreas = vector_Rectangle_Int;
        this.textDirections = vector_Int;
        this.current = dynamicVectorRenderer;
        this.errorTracker = errorTracker;
    }

    private void calcCoordinates(float f, float[][] fArray, float f2) {
        float[][] fArray2 = new float[3][3];
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(fArray[i], 0, fArray2[i], 0, 3);
        }
        this.x1 = f;
        this.x2 = fArray2[2][0] - f2 * fArray2[0][0];
        if (this.glyphData.isHorizontal()) {
            if (fArray2[1][0] < 0.0f) {
                this.x1 = f + fArray2[1][0] - f2 * fArray2[0][0];
                this.x2 = fArray2[2][0];
            } else if (fArray2[1][0] > 0.0f) {
                this.x1 = f;
                this.x2 = fArray2[2][0];
            }
        } else if (fArray2[1][0] > 0.0f) {
            this.x1 = fArray2[2][0];
            this.x2 = f + fArray2[1][0] - f2 * fArray2[0][0];
        } else if (fArray2[1][0] < 0.0f) {
            this.x2 = fArray2[2][0];
            this.x1 = f + fArray2[1][0] - f2 * fArray2[0][0];
        }
    }

    public String TJ(TextState textState, PdfFont pdfFont, byte[] byArray, int n, int n2, boolean bl) {
        this.currentTextState = textState;
        this.currentFontData = pdfFont;
        this.customGlyphTracker = this.parserOptions.getCustomGlyphTracker();
        this.contentHandler = this.parserOptions.getContentHandler();
        this.isTabRemapped = pdfFont.getDiffMapping(9) != null;
        this.isCRRemapped = pdfFont.getDiffMapping(10) != null;
        this.isReturnRemapped = pdfFont.getDiffMapping(13) != null;
        this.streamLength = byArray.length;
        this.glyphs = pdfFont.getGlyphData();
        if (this.parserOptions.isRenderText() && this.gs.getTextRenderType() != 4) {
            this.gs.setStrokeColor(this.gs.strokeColorSpace.getColor());
            this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
        }
        StringBuffer stringBuffer = this.processTextArray(byArray, n, n2, this.multiplyer, bl);
        int n3 = this.glyphData.getFontSize();
        if (n3 == 0) {
            n3 = (int)textState.getTfs();
        }
        if (n3 < 0) {
            n3 = -n3;
        }
        if (stringBuffer != null && this.parserOptions.isPageContent()) {
            String string = null;
            if (this.parserOptions.isTextColorExtracted()) {
                string = (this.gs.getTextRenderType() & 2) == 2 ? this.gs.nonstrokeColorSpace.getXMLColorToken() : this.gs.strokeColorSpace.getXMLColorToken();
            }
            if (this.contentHandler != null) {
                this.contentHandler.setText(stringBuffer, this.x1, this.y1, this.x2, this.y2);
            } else if (this.parserOptions.isTextExtracted()) {
                this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, textState.writingMode, Fonts.createFontToken(pdfFont.getFontName(), n3), pdfFont.getCurrentFontSpaceWidth(), n3, this.x1, this.y1, this.x2, this.y2, stringBuffer, this.glyphData.getTextLength(), string, this.glyphData.isXMLExtraction());
            }
        }
        return this.tjTextValue;
    }

    private void resetValues(GlyphData glyphData) {
        glyphData.reset();
        this.TrmBeforeSpace = new float[3][3];
        this.lastWidth = 0.0f;
        this.currentWidth = 0.0f;
        this.Trm = Matrix.multiply(this.currentTextState.Tm, this.gs.CTM);
    }

    /*
     * WARNING - void declaration
     */
    private StringBuffer processTextArray(byte[] byArray, int n, int n2, float f, boolean bl) {
        Serializable serializable;
        float f2;
        this.isHTML = this.current.isHTMLorSVG();
        this.resetValues(this.glyphData);
        int n3 = this.gs.getTextRenderType();
        boolean bl2 = false;
        boolean bl3 = false;
        char c = 'x';
        float f3 = f2 = this.currentTextState.getTfs();
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        int n4 = this.currentFontData.getFontType();
        float f4 = this.currentFontData.getCurrentFontSpaceWidth();
        StringBuffer stringBuffer = null;
        if (this.parserOptions.isTextExtracted()) {
            stringBuffer = new StringBuffer(50);
        }
        boolean bl4 = false;
        while (byArray[n] == 91 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
            if (byArray[n] == 91) {
                bl3 = true;
            }
            ++n;
        }
        this.glyphData.setDefaultCharSize(this.currentFontData);
        this.charSpacing = this.currentTextState.getCharacterSpacing() / f2;
        float f5 = this.currentTextState.getWordSpacing() / f2;
        if (bl) {
            this.Trm[2][0] = this.currentTextState.Tm[2][0];
            this.Trm[2][1] = this.currentTextState.Tm[2][1];
        }
        float[][] fArray = new float[3][3];
        fArray[0][0] = f3 * this.currentTextState.getHorizontalScaling();
        fArray[1][1] = f3;
        fArray[2][1] = this.currentTextState.getTextRise();
        fArray[2][2] = 1.0f;
        this.Trm = Matrix.multiply(fArray, this.Trm);
        if (bl3 && byArray[n] != 60 && byArray[n] != 40 && byArray[n] != 93) {
            float f6 = 0.0f;
            while (byArray[n] != 40 && byArray[n] != 60 && byArray[n] != 93) {
                serializable = new StringBuilder(10);
                while (byArray[n] != 60 && byArray[n] != 40 && byArray[n] != 93 && byArray[n] != 32) {
                    ((StringBuilder)serializable).append((char)byArray[n]);
                    ++n;
                }
                f6 += Float.parseFloat(((StringBuilder)serializable).toString());
                while (byArray[n] == 32) {
                    ++n;
                }
            }
            if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] != 0.0f && this.Trm[1][0] != 0.0f) {
                f6 = this.Trm[0][1] * f6 / 1000.0f;
                float[] fArray2 = this.Trm[2];
                fArray2[1] = fArray2[1] - f6;
            } else {
                f6 = this.Trm[0][0] * f6 / 1000.0f;
                float[] fArray3 = this.Trm[2];
                fArray3[0] = fArray3[0] - f6;
            }
        }
        int n5 = Tj.calcFontSize(this.glyphData, this.currentTextState, this.Trm);
        serializable = null;
        int n6 = this.parserOptions.getTextPrint();
        if (n6 == 3 && StandardFonts.isStandardFont(this.currentFontData.getFontName(), true) && this.parserOptions.isPrinting()) {
            serializable = this.currentFontData.getJavaFontX(n5);
        } else if (this.currentFontData.isFontEmbedded && !this.currentFontData.isFontSubstituted()) {
            serializable = null;
        } else if ((PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts || n6 != 0) && this.parserOptions.isPrinting()) {
            serializable = this.currentFontData.getJavaFontX(n5);
        }
        float f7 = this.Trm[2][0];
        if (this.Trm[1][0] < 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][0] == 0.0f) {
            bl4 = true;
        }
        int n7 = n;
        StringBuffer stringBuffer2 = null;
        if (this.returnText) {
            stringBuffer2 = new StringBuffer(this.streamLength);
        }
        boolean bl5 = true;
        boolean bl6 = this.currentFontData.isCIDFont();
        while (n7 < n2) {
            this.glyphData.setActualWidth(-1.0f);
            n7 = CharReader.getNextValue(n7, byArray, this.glyphData, bl6);
            if (this.glyphData.isText()) {
                float f8;
                int n8;
                int n9;
                c = this.glyphData.getRawChar();
                if (this.glyphData.getOpenChar() == '<') {
                    n7 = bl6 && !this.currentFontData.isFontSubstituted() && this.currentFontData.isFontEmbedded && byArray[n7] != 48 ? HexTextUtils.getHexCIDValue(byArray, n7, this.glyphData, this.currentFontData, this.parserOptions) : HexTextUtils.getHexValue(byArray, n7, this.glyphData, this.currentFontData, this.parserOptions);
                } else if (c == '\\' && !bl6) {
                    n7 = EscapedTextUtils.getEscapedValue(n7, byArray, this.glyphData, this.currentFontData, this.streamLength, this.parserOptions, this.current);
                } else if (bl6) {
                    n7 = CIDTextUtils.getCIDCharValues(n7, byArray, this.streamLength, this.glyphData, this.currentFontData, this.parserOptions);
                } else {
                    c = Tj.getValue(c, this.glyphData, this.currentFontData, this.current, this.parserOptions);
                }
                if (this.isHTML && !this.currentFontData.hasToUnicode() && this.currentFontData.getFontType() == -1684566726 && this.currentFontData.getGlyphData().isIdentity()) {
                    n9 = this.glyphData.getRawChar();
                    n8 = this.glyphData.getValueForHTML();
                    if (n8 != -1) {
                        n9 = n8;
                        this.glyphData.setValueForHTML(-1);
                    }
                    int bl7 = StandardFonts.mapCIDToValidUnicode(this.currentFontData.getBaseFontName(), n9);
                    this.glyphData.setUnicodeValue(String.valueOf((char)bl7));
                }
                if (!this.isTabRemapped && this.glyphData.getRawInt() == 9 && this.currentFontData.isFontSubstituted()) {
                    this.glyphData.setRawInt(32);
                    this.glyphData.set(" ");
                }
                fArray[0][0] = 1.0f;
                fArray[0][1] = 0.0f;
                fArray[0][2] = 0.0f;
                fArray[1][0] = 0.0f;
                fArray[1][1] = 1.0f;
                fArray[1][2] = 0.0f;
                if (this.currentFontData.isFontVertical()) {
                    fArray[2][1] = -(this.currentWidth + this.glyphData.getLeading());
                    fArray[2][0] = 0.0f;
                } else {
                    fArray[2][0] = this.currentWidth + this.glyphData.getLeading();
                    fArray[2][1] = 0.0f;
                }
                fArray[2][2] = 1.0f;
                this.Trm = Matrix.multiply(fArray, this.Trm);
                if (this.glyphData.getRawChar() == ' ' && this.glyphData.getLastChar() != ' ') {
                    this.TrmBeforeSpace = this.Trm;
                }
                this.glyphData.setLeading(0.0f);
                if (this.currentFontData.isCIDFont() && this.glyphs.is1C() && !this.glyphs.isIdentity() && (n9 = this.glyphs.getCMAPValue(this.glyphData.getRawInt())) > 0) {
                    this.glyphData.setRawInt(n9);
                }
                n9 = this.glyphData.getRawInt();
                if (!this.glyphs.isCorrupted()) {
                    if (this.currentFontData.isCIDFont() && !this.glyphs.isIdentity() && !this.glyphs.hasGIDtoCID()) {
                        n8 = this.glyphs.getConvertedGlyph(n9);
                        if (n8 != -1) {
                            n9 = n8;
                        }
                    } else if (this.currentFontData.getFontType() != 1228944679 && (n8 = this.currentFontData.getDiffChar(n9)) > 0) {
                        this.glyphData.setRawInt(n8);
                    }
                }
                this.currentWidth = (f8 = this.glyphData.getActualWidth()) > 0.0f ? f8 : this.currentFontData.getWidth(n9);
                if (this.currentWidth == 0.0f && this.parserOptions.isXFA()) {
                    Float f9 = StandardFonts.getStandardWidth("Arial", this.currentFontData.getMappedChar(this.glyphData.getRawInt(), false));
                    this.currentWidth = f9 != null ? f9.floatValue() : 0.0f;
                    this.currentFontData.setLastWidth(this.currentWidth);
                }
                if (this.isHTML && !this.currentFontData.isFontSubsetted() && this.currentFontData.getFontEncoding(true) == 2 && this.glyphData.getUnicodeValue().charAt(0) - n9 == 32) {
                    this.glyphData.setUnicodeValue(String.valueOf((char)n9));
                }
                if (this.currentWidth == 0.0f && this.parserOptions.isXFA()) {
                    void var29_36;
                    int n10 = this.glyphData.getRawInt();
                    if (n10 > 255) {
                        String string = String.valueOf(n10);
                    } else {
                        String string = StandardFonts.getUnicodeChar(2, n10);
                    }
                    this.currentWidth = this.currentFontData.getGlyphWidth((String)var29_36, n10, this.glyphData.getDisplayValue());
                }
                if (this.returnText) {
                    stringBuffer2.append(this.glyphData.getDisplayValue());
                }
                this.currentTextState.setLastKerningAdded(this.glyphData.getSpacingAdded());
                this.glyphData.setSpacingAdded(0.0f);
                if (this.parserOptions.isRenderText() && (n3 != 4 || this.isHTML) || n3 == 7 && this.parserOptions.isRenderClipText()) {
                    if (serializable != null && this.parserOptions.isPrinting() && (n6 == 3 || n6 == 2 || PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted()))) {
                        if (n3 == 7) {
                            boolean bl7 = DecoderOptions.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName(), false);
                            Area area = this.glyphs.getStandardGlyph(this.Trm, this.glyphData.getRawInt(), this.glyphData.getDisplayValue(), this.currentWidth, bl7);
                            if (area != null) {
                                this.gs.addClip(area);
                            }
                            this.current.drawClip(this.gs, null, true);
                        }
                        if (this.glyphData.getDisplayValue() != null && !this.glyphData.getDisplayValue().startsWith("&#")) {
                            if (this.isHTML || this.current.getType() == 7) {
                                this.current.drawEmbeddedText(this.Trm, n5, null, null, 1, this.gs, null, this.glyphData.getDisplayValue(), this.currentFontData, -100.0f);
                            } else {
                                this.current.drawText(this.Trm, this.glyphData.getDisplayValue(), this.gs, this.Trm[2][0], -this.Trm[2][1], (Font)serializable);
                            }
                        }
                    } else if (!((n6 != 1 || serializable == null) && this.currentFontData.isFontEmbedded && this.currentFontData.isFontSubstituted() && (this.glyphData.getRawInt() == 9 && !this.isTabRemapped || this.glyphData.getRawInt() == 10 && !this.isCRRemapped || this.glyphData.getRawInt() == 13 && !this.isReturnRemapped) || (n6 != 1 || serializable == null) && this.currentFontData.isFontSubstituted() && this.currentWidth == 0.0f && this.glyphData.getDisplayValue().charAt(0) == '\r')) {
                        if ((n6 != 1 || serializable == null) && this.currentFontData.isFontEmbedded) {
                            this.renderText(this.currentWidth, n4, n3, f, bl4);
                        } else if (!this.glyphData.getDisplayValue().isEmpty() && !this.glyphData.getDisplayValue().startsWith("&#")) {
                            JavaTextRenderer.renderTextWithJavaFonts(this.gs, this.current, this.streamType, this.parserOptions, this.currentFontData, this.glyphData, n3, this.currentWidth, bl4, this.glyphs, this.Trm);
                        }
                    }
                }
                this.currentWidth += this.charSpacing;
                if (this.glyphData.getRawChar() == ' ') {
                    this.currentWidth += f5;
                }
                float f10 = this.glyphData.getWidth() + this.charSpacing - this.lastWidth;
                String string = "";
                if (f10 > 0.0f && this.lastWidth > 0.0f) {
                    String string2 = PdfFont.getSpaces(f10, f4, 0.595f);
                }
                this.glyphData.addToWidth(this.currentWidth);
                this.lastWidth = this.glyphData.getWidth();
                if (this.customGlyphTracker != null) {
                    this.customGlyphTracker.addGlyph(this.Trm, this.glyphData.getRawInt(), this.glyphData.getDisplayValue(), this.glyphData.getUnicodeValue());
                }
                if (this.parserOptions.isTextExtracted()) {
                    void string3;
                    bl2 = Tj.writeOutText(this.glyphData, this.Trm, bl2, this.currentWidth, stringBuffer, (String)string3);
                }
            } else if (this.glyphData.getRawChar() == '(' || this.glyphData.getRawChar() == '<') {
                this.glyphData.setText(true);
                this.glyphData.setOpenChar(this.glyphData.getRawChar());
            } else if (this.glyphData.getRawChar() == ')' || this.glyphData.getRawChar() == '>' && this.glyphData.getOpenChar() == '<' || !this.glyphData.isText() && (this.glyphData.getRawChar() == '-' || this.glyphData.getRawChar() >= '0' && this.glyphData.getRawChar() <= '9')) {
                n7 = Leading.readLeading(n7, byArray, this.glyphData);
            }
            if (this.parserOptions.isTextExtracted()) {
                bl5 = this.setExtractedText(this.currentWidth, bl5);
            }
            ++n7;
        }
        if (this.returnText) {
            this.tjTextValue = !this.tjTextValue.isEmpty() ? this.tjTextValue + ' ' + stringBuffer2.toString() : stringBuffer2.toString();
        }
        this.Trm = Tj.updateMatrixPosition(this.Trm, this.glyphData.getLeading(), this.currentWidth, this.currentTextState);
        if (this.parserOptions.isTextExtracted()) {
            return this.setExtractedText(c, f7, stringBuffer, bl2);
        }
        return null;
    }

    static float[][] updateMatrixPosition(float[][] fArray, float f, float f2, TextState textState) {
        float[][] fArray2 = new float[3][3];
        fArray2[0][0] = 1.0f;
        fArray2[0][1] = 0.0f;
        fArray2[0][2] = 0.0f;
        fArray2[1][0] = 0.0f;
        fArray2[1][1] = 1.0f;
        fArray2[1][2] = 0.0f;
        fArray2[2][0] = f < 0.0f ? f2 : f2 + f;
        fArray2[2][1] = 0.0f;
        fArray2[2][2] = 1.0f;
        fArray = Matrix.multiply(fArray2, fArray);
        textState.Tm[2][0] = fArray[2][0];
        textState.Tm[2][1] = fArray[2][1] - textState.getTextRise();
        return fArray;
    }

    private StringBuffer setExtractedText(char c, float f, StringBuffer stringBuffer, boolean bl) {
        if (c == ' ') {
            this.Trm = this.TrmBeforeSpace;
        }
        this.calcCoordinates(f, this.Trm, this.charSpacing);
        if (stringBuffer != null && this.actualText != null) {
            int n = stringBuffer.indexOf(PdfData.marker, 2);
            if (n > 0) {
                n = stringBuffer.indexOf(PdfData.marker, n + 1);
            }
            if (n > 0) {
                stringBuffer.setLength(n + 1);
                stringBuffer.append(this.actualText);
            }
            this.actualText = null;
        }
        if (stringBuffer.length() == 0 || !bl) {
            stringBuffer = null;
        }
        return stringBuffer;
    }

    private void renderText(float f, int n, int n2, float f2, boolean bl) throws RuntimeException {
        String string = "notdef";
        int n3 = this.glyphData.getRawInt();
        try {
            PdfGlyph pdfGlyph;
            if (!this.currentFontData.isCIDFont()) {
                string = this.currentFontData.getMappedChar(n3, false);
            }
            if (this.parserOptions.generateGlyphOnRender() && !this.parserOptions.renderDirectly()) {
                if (this.glyphData.isfirstTime()) {
                    pdfGlyph = new MarkerGlyph(this.Trm[0][0], this.Trm[0][1], this.Trm[1][0], this.Trm[1][1], this.currentFontData.getBaseFontName());
                    this.current.checkFontSaved(pdfGlyph, this.currentFontData.getBaseFontName(), this.currentFontData);
                    this.glyphData.setFirstTime(false);
                }
                this.currentFontData.setValuesForGlyph(n3, string, this.glyphData.getDisplayValue(), this.currentFontData.getEmbeddedChar(n3));
                pdfGlyph = new UnrendererGlyph(this.Trm[2][0], this.Trm[2][1], n3, f);
            } else {
                pdfGlyph = this.glyphs.getEmbeddedGlyph(this.factory, string, this.Trm, n3, this.glyphData.getDisplayValue(), f, this.currentFontData.getEmbeddedChar(n3));
                if (pdfGlyph instanceof TTGlyph) {
                    if (pdfGlyph.containsBrokenData()) {
                        if (this.glyphData.getDisplayValue() != null && !this.glyphData.getDisplayValue().startsWith("&#")) {
                            if (this.current.isHTMLorSVG()) {
                                this.current.drawEmbeddedText(this.Trm, this.glyphData.getFontSize(), null, null, 1, this.gs, null, this.glyphData.getDisplayValue(), this.currentFontData, -100.0f);
                            } else {
                                this.current.drawText(this.Trm, this.glyphData.getDisplayValue(), this.gs, this.Trm[2][0], -this.Trm[2][1], this.currentFontData.getJavaFontX(this.glyphData.getFontSize()));
                            }
                        }
                        pdfGlyph = null;
                    } else {
                        boolean bl2 = this.ttHintingRequired = this.ttHintingRequired || ((TTGlyph)pdfGlyph).isTTHintingRequired();
                    }
                }
            }
            if (n == 1228944679) {
                if (pdfGlyph != null && pdfGlyph.getmaxWidth() == 0.0f) {
                    pdfGlyph = null;
                } else if (pdfGlyph != null && pdfGlyph.ignoreColors()) {
                    pdfGlyph.setT3Colors(this.gs.getNonstrokeColor(), this.gs.getNonstrokeColor(), true);
                }
            }
            if (pdfGlyph != null || this.isHTML) {
                float f3;
                if (pdfGlyph != null && n == 1228944677) {
                    pdfGlyph.setWidth(f * 1000.0f);
                }
                Object object = new float[][]{{this.Trm[0][0], this.Trm[0][1], 0.0f}, {this.Trm[1][0], this.Trm[1][1], 0.0f}, {this.Trm[2][0], this.Trm[2][1], 1.0f}};
                float[][] fArrayArray = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                object = Matrix.multiply(object, fArrayArray);
                object[2][0] = this.Trm[2][0];
                object[2][1] = this.Trm[2][1];
                if (object[1][0] < 0.0f && object[0][1] < 0.0f) {
                    object[1][0] = -object[1][0];
                    object[0][1] = -object[0][1];
                }
                AffineTransform affineTransform = new AffineTransform(object[0][0], object[0][1], object[1][0], object[1][1], object[2][0], object[2][1]);
                int n4 = 5;
                if (n == 6) {
                    n4 = 5;
                    f3 = 1000.0f / pdfGlyph.getmaxWidth();
                    affineTransform.scale(f * f3, 1.0);
                } else if (n == 1217103210 || n == -1684566724 || this.currentFontData.isFontSubstituted() && n != 1228944677) {
                    n4 = 4;
                } else if (n == 1228944679) {
                    n4 = 6;
                }
                if (this.parserOptions.generateGlyphOnRender()) {
                    n4 = -n4;
                }
                if (n2 == 7) {
                    if (pdfGlyph != null && !this.parserOptions.useJavaFX() && pdfGlyph.getShape() != null) {
                        Area area = (Area)pdfGlyph.getShape().clone();
                        if (TTGlyph.useHinting && pdfGlyph instanceof TTGlyph) {
                            area.transform(AffineTransform.getScaleInstance(0.01, 0.01));
                        }
                        area.transform(affineTransform);
                        if (area.getBounds().getWidth() > 0.0 && area.getBounds().getHeight() > 0.0) {
                            this.gs.addClip(area);
                        }
                    }
                } else {
                    f3 = this.gs.getLineWidth();
                    float f4 = 0.0f;
                    if (f2 > 0.0f) {
                        f4 = f3 / f2;
                    }
                    double[] dArray = new double[6];
                    affineTransform.getMatrix(dArray);
                    this.gs.setLineWidth((float)((double)f4 / dArray[0]));
                    if (bl) {
                        this.current.drawEmbeddedText(this.Trm, -this.glyphData.getFontSize(), pdfGlyph, null, n4, this.gs, dArray, this.glyphData.getUnicodeValue(), this.currentFontData, -100.0f);
                    } else {
                        this.current.drawEmbeddedText(this.Trm, this.glyphData.getFontSize(), pdfGlyph, null, n4, this.gs, dArray, this.glyphData.getUnicodeValue(), this.currentFontData, -100.0f);
                    }
                    this.gs.setLineWidth(f3);
                }
            } else {
                this.glyphData.set(" ");
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception: " + exception.getMessage());
            this.errorTracker.addPageFailureMessage("Exception " + exception + " on embedded font renderer");
        }
    }

    static char getValue(char c, GlyphData glyphData, PdfFont pdfFont, DynamicVectorRenderer dynamicVectorRenderer, ParserOptions parserOptions) {
        String string;
        int n;
        String string2 = pdfFont.getGlyphValue(glyphData.getRawInt());
        glyphData.setDisplayValue(string2);
        boolean bl = false;
        if ((string2.isEmpty() || !string2.isEmpty() && string2.charAt(0) < ' ') && dynamicVectorRenderer.isHTMLorSVG() && !pdfFont.isCIDFont()) {
            bl = HTMLTextUtils.remapGlyph(pdfFont, glyphData);
        }
        if ((n = glyphData.getRawInt()) == 32 && !glyphData.getDisplayValue().equals(" ")) {
            c = (char)90;
        }
        if (!bl && parserOptions.isTextExtracted()) {
            glyphData.setUnicodeValue(pdfFont.getUnicodeValue(glyphData.getDisplayValue(), n));
        }
        if (pdfFont.getFontType() == 1228944677 && dynamicVectorRenderer.isHTMLorSVG() && (string = pdfFont.getMappedChar(n, true)) != null && string.length() == 1 && string.equalsIgnoreCase(glyphData.getUnicodeValue().toLowerCase())) {
            glyphData.set(string);
        }
        return c;
    }

    static int calcFontSize(GlyphData glyphData, TextState textState, float[][] fArray) throws RuntimeException {
        int n;
        if (fArray[1][1] != 0.0f) {
            glyphData.setHorizontal(true);
            textState.writingMode = 0;
            n = fArray[1][1] < 0.0f ? (int)(fArray[1][1] - 0.5f) : (int)(fArray[1][1] + 0.5f);
            if (n == 0) {
                n = fArray[0][1] < 0.0f ? (int)(fArray[0][1] - 0.5f) : (int)(fArray[0][1] + 0.5f);
            }
            glyphData.setFontScale(fArray[0][0]);
            if (fArray[0][0] == 0.0f && fArray[0][1] > 0.0f && fArray[1][0] < 0.0f && fArray[1][1] > 0.0f) {
                textState.writingMode = 3;
            }
        } else {
            glyphData.setHorizontal(false);
            n = fArray[1][0] < 0.0f ? (int)(fArray[1][0] - 0.5f) : (int)(fArray[1][0] + 0.5f);
            if (n == 0) {
                n = fArray[0][0] < 0.0f ? (int)(fArray[0][0] - 0.5f) : (int)(fArray[0][0] + 0.5f);
            }
            if (n < 0) {
                n = -n;
                textState.writingMode = 3;
            } else {
                textState.writingMode = 2;
            }
            glyphData.setFontScale(fArray[0][1]);
        }
        if (n == 0) {
            n = 1;
        }
        glyphData.setFontSize(n);
        return n;
    }

    static boolean writeOutText(GlyphData glyphData, float[][] fArray, boolean bl, float f, StringBuffer stringBuffer, String string) {
        String string2 = glyphData.getUnicodeValue();
        float f2 = glyphData.getFontScale();
        if (!string2.isEmpty()) {
            if (DecoderOptions.embedWidthData) {
                float f3 = fArray[2][0];
                float f4 = fArray[2][1];
                stringBuffer.append(string);
                if (glyphData.isHorizontal()) {
                    stringBuffer.append(PdfData.marker);
                    stringBuffer.append(f3);
                    stringBuffer.append(PdfData.marker);
                } else {
                    stringBuffer.append(PdfData.marker);
                    stringBuffer.append(f4);
                    stringBuffer.append(PdfData.marker);
                }
                stringBuffer.append(f * f2);
                stringBuffer.append(PdfData.marker);
            } else {
                stringBuffer.append(string);
            }
            int n = string2.length();
            boolean bl2 = glyphData.isXMLExtraction();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                bl = true;
                if (c == '\t') {
                    c = ' ';
                }
                if (c == '<' && bl2) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c == '>' && bl2) {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c == '\ufb02') {
                    stringBuffer.append("fl");
                    continue;
                }
                if (c > '\u001f') {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(hex[c]);
            }
        } else {
            stringBuffer.append(string);
        }
        return bl;
    }

    public boolean setExtractedText(float f, boolean bl) {
        String string = this.glyphData.getDisplayValue();
        if (!string.isEmpty() && !string.equals(" ")) {
            float f2;
            float f3 = (int)this.Trm[2][0];
            float f4 = (int)this.Trm[2][1];
            float f5 = f * this.glyphData.getFontScale();
            float f6 = this.Trm[1][1];
            if (f6 == 0.0f) {
                f6 = this.Trm[0][1];
            }
            if (this.currentFontData.getFontType() == 1228944679 && f6 != 0.0f && (int)f6 == 0 && this.currentFontData.FontMatrix[3] == -1.0) {
                f6 *= this.currentFontData.FontBBox[3] - this.currentFontData.FontBBox[1];
                f6 = -f6;
            }
            f6 = (int)f6;
            if (f5 < 0.0f) {
                f5 = -f5;
                f3 -= f5;
            }
            if (f6 < 0.0f) {
                f6 = -f6;
                f4 -= f6;
            }
            Rectangle rectangle = this.currentFontData.getBoundingBox();
            if (rectangle.y < 0) {
                rectangle.height -= rectangle.y;
                rectangle.y = 0;
            }
            if ((f2 = (float)rectangle.y) == 0.0f) {
                f2 = 100.0f;
            }
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            float f7 = 1000.0f + f2;
            f7 = 1000.0f / f7;
            switch (this.currentTextState.writingMode) {
                case 0: {
                    float f8 = f6 / f7;
                    f4 -= f8 - f6;
                    f6 = f8;
                    break;
                }
                case 1: {
                    System.out.println("THIS TEXT DIRECTION HAS NOT BEEN IMPLEMENTED YET (Right to Left)");
                    break;
                }
                case 2: {
                    float f9 = f5 / f7;
                    f3 -= f9 - f5;
                    f5 = f9;
                    break;
                }
                case 3: {
                    float f10 = f5 / f7;
                    f3 -= f10;
                    f5 = f10;
                }
            }
            f3 -= 1.0f;
            f5 += 2.0f;
            if (bl) {
                this.y2 = f4;
                this.y1 = f4 + f6;
                bl = false;
            }
            if (f4 < this.y2) {
                this.y2 = f4;
            }
            if (f4 + f6 > this.y1) {
                this.y1 = f4 + f6;
            }
            if (this.textAreas != null && this.parserOptions.isRenderText()) {
                this.textAreas.addElement(new int[]{(int)f3, (int)f4, (int)f5, (int)f6});
                this.textDirections.addElement(this.currentTextState.writingMode);
            }
        }
        return bl;
    }

    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    public void setReturnText(boolean bl) {
        this.returnText = bl;
    }

    public void setActualText(String string) {
        this.actualText = string;
    }

    static {
        hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
    }
}

