/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.sun;

import java.io.IOException;
import java.io.OutputStream;
import org.jpedal.utils.LogWriter;

public class LZWDecoder {
    byte[][] stringTable;
    byte[] data;
    OutputStream uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int nextData;
    int nextBits;
    boolean earlyChange;
    final int[] andTable = new int[]{511, 1023, 2047, 4095};

    public void decode(byte[] byArray, OutputStream outputStream, boolean bl) {
        int n;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new RuntimeException("LZW flavour not supported.");
        }
        this.initializeStringTable();
        this.data = byArray;
        this.uncompData = outputStream;
        this.earlyChange = bl;
        this.bytePointer = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int n2 = 0;
        while ((n = this.getNextCode()) != 257) {
            byte[] byArray2;
            if (n == 256) {
                this.initializeStringTable();
                n = this.getNextCode();
                if (n == 257) break;
                this.writeString(this.stringTable[n]);
                n2 = n;
                continue;
            }
            if (n < this.tableIndex) {
                byArray2 = this.stringTable[n];
                this.writeString(byArray2);
                this.addStringToTable(this.stringTable[n2], byArray2[0]);
                n2 = n;
                continue;
            }
            byArray2 = this.stringTable[n2];
            byArray2 = LZWDecoder.composeString(byArray2, byArray2[0]);
            this.writeString(byArray2);
            this.addStringToTable(byArray2);
            n2 = n;
        }
    }

    public void initializeStringTable() {
        this.stringTable = new byte[8192][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] byArray) {
        try {
            this.uncompData.write(byArray);
        }
        catch (IOException iOException) {
            LogWriter.writeLog("Exception " + iOException + " with LZW decoder");
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        this.addStringToTable(byArray2);
    }

    public void addStringToTable(byte[] byArray) {
        if (this.earlyChange) {
            this.stringTable[this.tableIndex++] = byArray;
        }
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
        if (!this.earlyChange) {
            this.stringTable[this.tableIndex++] = byArray;
        }
    }

    public static byte[] composeString(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int n = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            LogWriter.writeLog("LZW value out of bounds " + arrayIndexOutOfBoundsException);
            return 257;
        }
    }
}

