/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

public class FastMath {
    public static double sqrt(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        double d2 = d;
        while (Math.abs(d2 - d / d2) > 1.0E-15 * d2) {
            d2 = (d / d2 + d2) / 2.0;
        }
        return d2;
    }

    public static final int pow(int n, int n2) {
        if (n2 == 0) {
            return 1;
        }
        int n3 = n;
        for (int i = 1; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public static final float pow(float f, int n) {
        if (n == 0) {
            return 1.0f;
        }
        float f2 = f;
        for (int i = 1; i < n; ++i) {
            f2 *= f;
        }
        return f2;
    }

    public static final double pow(double d, int n) {
        if (n == 0) {
            return 1.0;
        }
        double d2 = d;
        for (int i = 1; i < n; ++i) {
            d2 *= d;
        }
        return d2;
    }
}

