/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import com.sun.javafx.runtime.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.jpedal.utils.LogWriter;

public class JavaFXHelper {
    private static boolean javaFXAvailable = true;
    private static boolean javaFXTested;

    public static boolean isJavaFXAvailable() {
        if (!javaFXTested) {
            try {
                Class.forName("javafx.scene.image.WritableImage");
                javaFXAvailable = true;
            }
            catch (Exception exception) {
                if (JavaFXHelper.tryToLoadFX()) {
                    javaFXAvailable = true;
                } else {
                    LogWriter.writeLog("JavaFX Unavailable. Exception " + exception);
                    javaFXAvailable = false;
                }
            }
            catch (Error error) {
                if (JavaFXHelper.tryToLoadFX()) {
                    javaFXAvailable = true;
                }
                LogWriter.writeLog("JavaFX Unavailable. Exception " + error);
                javaFXAvailable = false;
            }
            javaFXTested = true;
        }
        return javaFXAvailable;
    }

    private static boolean tryToLoadFX() {
        try {
            File file = new File(System.getProperty("java.home") + "/lib/jfxrt.jar");
            if (!file.exists()) {
                throw new Exception("jfxrt.jar not found.");
            }
            URL uRL = file.toURI().toURL();
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> clazz = URLClassLoader.class;
            try {
                Method method = clazz.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)uRLClassLoader, uRL);
            }
            catch (Throwable throwable) {
                throw new IOException("Error, could not add URL to system classloader " + throwable);
            }
            return true;
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception in handling JavaFX " + exception);
            return false;
        }
    }

    public static String getVersion() {
        return VersionInfo.getRuntimeVersion();
    }
}

