/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.jpedal.utils.LogWriter;

public class Messages {
    private static Map<String, String> messages;
    private static Set<String> reportedValueMissing;
    protected static ResourceBundle bundle;
    private static boolean isInitialised;

    public static void setBundle(ResourceBundle resourceBundle) {
        bundle = resourceBundle;
        if (!isInitialised) {
            Messages.init();
        }
    }

    public static String getMessage(String string) {
        String string2 = null;
        try {
            string2 = messages.get(string);
            if (string2 == null) {
                string2 = bundle.getString(string);
            }
        }
        catch (Exception exception) {
            if (LogWriter.isRunningFromIDE && !reportedValueMissing.contains(string)) {
                System.err.println("error resource bundle expected for key " + string);
                reportedValueMissing.add(string);
            }
            LogWriter.writeLog("Exception: " + exception.getMessage() + " key=" + string);
        }
        if (string2 == null) {
            try {
                string2 = messages.get(string);
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        if (string2.isEmpty()) {
            string2 = string + "<<";
        }
        return string2;
    }

    private static void init() {
        isInitialised = true;
        BufferedReader bufferedReader = null;
        try {
            String string;
            String string2;
            messages = new HashMap<String, String>();
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open messages.properties from jar");
            }
            Enumeration<String> enumeration = bundle.getKeys();
            while (enumeration.hasMoreElements() && (string2 = (String)bundle.getObject(string = enumeration.nextElement())) != null) {
                StringBuilder stringBuilder = new StringBuilder();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\\&;", true);
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3;
                    String string4;
                    if (bl) {
                        string4 = "&";
                        bl = false;
                    } else {
                        string4 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens() && string4.equals("\\")) {
                        string3 = stringTokenizer.nextToken();
                        char c = string3.charAt(0);
                        if (c == 'n') {
                            stringBuilder.append('\n');
                        } else if (c == ' ') {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(string3.substring(1));
                        continue;
                    }
                    if (stringTokenizer.hasMoreTokens() && string4.equals("&")) {
                        string3 = stringTokenizer.nextToken();
                        if (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                            if (string5.equals("&")) {
                                stringBuilder.append('&');
                                stringBuilder.append(string3);
                                bl = true;
                                continue;
                            }
                            if (string5.equals(";")) {
                                if (string3.startsWith("#")) {
                                    string3 = string3.substring(1);
                                }
                                char c = (char)Integer.parseInt(string3);
                                stringBuilder.append(c);
                                continue;
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                stringBuilder.append('&');
                            }
                            stringBuilder.append(string3);
                            continue;
                        }
                        stringBuilder.append('&');
                        stringBuilder.append(string3);
                        continue;
                    }
                    stringBuilder.append(string4);
                }
                messages.put(string, stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWriter.writeLog("Exception " + exception + " loading resource bundle.\n" + "Also check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            System.err.println("Exception loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static void dispose() {
        messages = null;
        reportedValueMissing = null;
        bundle = null;
        isInitialised = false;
    }

    static {
        reportedValueMissing = new HashSet<String>();
    }
}

